rule Win32_Ransomware_BKRansomware : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "BKRANSOMWARE"
        description         = "Yara rule that detects BKRansomware ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "BKRansomware"
        tc_detection_factor = 5

    strings:

        $search_files = {
            55 8B EC B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C5 89 45 ?? 53 56 57 68 ?? 
            ?? ?? ?? 8D 85 ?? ?? ?? ?? 8B F9 6A ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8D 85 ?? ?? ?? ?? 
            57 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8D 85 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 
            50 FF 15 ?? ?? ?? ?? 8B D8 83 FB ?? 0F 84 ?? ?? ?? ?? EB ?? 8D A4 24 ?? ?? ?? ?? 90 
            8D 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 0F 85 ?? ?? ?? ?? 
            8B B5 ?? ?? ?? ?? 83 FE ?? 0F 85 ?? ?? ?? ?? B9 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 66 8B 
            10 66 3B 11 75 ?? 66 85 D2 74 ?? 66 8B 50 ?? 66 3B 51 ?? 75 ?? 83 C0 ?? 83 C1 ?? 66 
            85 D2 75 ?? 33 C0 EB ?? 1B C0 83 C8 ?? 85 C0 74 ?? B8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 
            66 8B 11 66 3B 10 75 ?? 66 85 D2 74 ?? 66 8B 51 ?? 66 3B 50 ?? 75 ?? 83 C1 ?? 83 C0 
            ?? 66 85 D2 75 ?? 33 C0 EB ?? 1B C0 83 C8 ?? 85 C0 74 ?? 8D 85 ?? ?? ?? ?? 50 57 8D 
            85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 
            ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 6A ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? EB ?? 83 FE ?? 74 ?? 
            68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 6A ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8D 85 ?? ?? ?? ?? 
            50 57 8D 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8D 8D ?? ?? ?? ?? 
            E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 53 FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 53 
            FF 15 ?? ?? ?? ?? 8B 4D ?? 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3
        }

        $encrypt_files_p1 = {
            55 8B EC B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C5 89 45 ?? 53 57 6A ?? 68 
            ?? ?? ?? ?? 6A ?? 6A ?? 6A ?? 8B F9 68 ?? ?? ?? ?? 57 89 BD ?? ?? ?? ?? FF 15 ?? ?? 
            ?? ?? 8B D8 89 9D ?? ?? ?? ?? 83 FB ?? 0F 84 ?? ?? ?? ?? 56 6A ?? 53 FF 15 ?? ?? ?? 
            ?? 8B F0 68 ?? ?? ?? ?? 57 89 B5 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 0F 85 ?? 
            ?? ?? ?? 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 0F 85 ?? ?? ?? ?? 68 ?? ?? 
            ?? ?? 57 E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 0F 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 57 E8 ?? ?? 
            ?? ?? 83 C4 ?? 85 C0 0F 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 83 C4 ?? 85 
            C0 0F 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 75 ?? 68 ?? ?? 
            ?? ?? 57 E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 75 ?? 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 83 C4 
            ?? 85 C0 75 ?? 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 75 ?? 68 ?? ?? ?? ?? 
            57 E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 75 ?? 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 83 C4 ?? 85 
            C0 75 ?? 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? 
            ?? ?? 8D 85 ?? ?? ?? ?? 6A ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 85 F6 0F 8E ?? ?? ?? ?? 33
        }

        $encrypt_files_p2 = { 
            FF 8D 49 ?? 6A ?? 8D 85 ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 
            8D 85 ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 50 53 FF 15 ?? ?? ?? ?? 8D 8D ?? ?? 
            ?? ?? 33 F6 8D 51 ?? EB ?? 8D 49 ?? 8A 01 41 84 C0 75 ?? 2B CA 74 ?? BB ?? ?? ?? ?? 
            8A 84 35 ?? ?? ?? ?? 3C ?? 7C ?? 3C ?? 7F ?? 0F BE C0 83 E8 ?? 99 F7 FB 80 C2 ?? EB 
            ?? 3C ?? 7C ?? 3C ?? 7F ?? 0F BE C0 83 E8 ?? 99 F7 FB 80 C2 ?? 88 94 35 ?? ?? ?? ?? 
            8D 85 ?? ?? ?? ?? 46 8D 50 ?? 8A 08 40 84 C9 75 ?? 2B C2 3B F0 72 ?? 8B 9D ?? ?? ?? 
            ?? 6A ?? 6A ?? 57 53 FF 15 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 8D 51 ?? 8D 9B ?? ?? ?? ?? 
            8A 01 41 84 C0 75 ?? 6A ?? 8D 85 ?? ?? ?? ?? 2B CA 50 51 8D 85 ?? ?? ?? ?? 50 53 FF 
            15 ?? ?? ?? ?? 03 BD ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? 50 E8 ?? ?? 
            ?? ?? 83 C4 ?? 3B BD ?? ?? ?? ?? 0F 8C ?? ?? ?? ?? 8B BD ?? ?? ?? ?? 53 FF 15 ?? ?? 
            ?? ?? 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 6A ?? 50 E8 ?? ?? ?? ?? 57 8D 85 ?? ?? ?? ?? 
            68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8D 85 ?? ?? ?? ?? 50 57 FF 15 ?? ?? ?? ?? 
            5E 8B 4D ?? 5F 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            $search_files
        ) and 
        (
            all of ($encrypt_files_p*)
        )
}