rule Win32_Ransomware_Afrodita : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "AFRODITA"
        description         = "Yara rule that detects Afrodita ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Afrodita"
        tc_detection_factor = 5

    strings:

        $exclude_directories_and_drop_ransom_note = {
            8D 85 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 74 ?? 8D 8D ?? ?? 
            ?? ?? 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 75 ?? E9 ?? ?? ?? ?? 8D 95 ?? 
            ?? ?? ?? 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 75 ?? E9 ?? ?? ?? ?? 8D 85 
            ?? ?? ?? ?? 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 75 ?? E9 ?? ?? ?? ?? 8D 
            8D ?? ?? ?? ?? 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 75 ?? E9 ?? ?? ?? ?? 
            8D 95 ?? ?? ?? ?? 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 75 ?? E9 ?? ?? ?? 
            ?? 8D 85 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 75 ?? E9 ?? ?? 
            ?? ?? 8D 8D ?? ?? ?? ?? 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 75 ?? E9 ?? 
            ?? ?? ?? 8D 95 ?? ?? ?? ?? 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 75 ?? E9 
            ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 83 E0 ?? 75 ?? E9 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 51 8B 
            55 ?? 52 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 89 85 ?? ?? ?? ?? 8B 8D ?? ?? 
            ?? ?? 89 8D ?? ?? ?? ?? C6 45 ?? ?? 68 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 52 8D 85 ?? ?? 
            ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 89 85 ?? ?? ?? ?? 8B 8D ?? ?? ?? ?? 51 8D 4D ?? E8 
            ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? C6 45 ?? ?? 68 ?? ?? ?? ?? 8B 55 ?? 52 8D 45 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 6A 
            ?? 68 ?? ?? ?? ?? 6A ?? 6A ?? 6A ?? 68 ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 50 FF 15 
            ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 6A ?? 8D 8D ?? ?? ?? ?? 51 68 ?? ?? ?? ?? 68 ?? ?? ?? 
            ?? 8B 95 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8D 
            4D ?? E8 ?? ?? ?? ?? EB ?? B8
        }

        $drop_ransom_note_no_dir_exclusion = {
            8D 95 ?? ?? ?? ?? 52 8B 43 ?? 50 8D 8D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 ?? 89 85 
            ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 89 95 ?? ?? ?? ?? C6 45 ?? ?? 68 ?? ?? ?? ?? 8B 85 ?? 
            ?? ?? ?? 50 8D 8D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 ?? 89 85 ?? ?? ?? ?? 8B 95 ?? 
            ?? ?? ?? 52 8D 4D ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 8D 
            8D ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 33 C0 88 85 ?? ?? ?? ?? 33 C9 88 8D ?? ?? 
            ?? ?? 33 D2 88 95 ?? ?? ?? ?? 0F B6 85 ?? ?? ?? ?? 50 0F B6 8D ?? ?? ?? ?? 51 0F B6 
            95 ?? ?? ?? ?? 52 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8B C8 E8 ?? ?? ?? ?? 
            50 8B 4B ?? 51 8D 55 ?? 52 E8 ?? ?? ?? ?? 83 C4 ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 6A ?? 
            6A ?? 68 ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 
            6A ?? 8D 85 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 8D ?? ?? ?? ?? 51 FF 15 
            ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? EB ?? 8B 
            5D ?? B8 ?? ?? ?? ?? C3 C7 45
        }
        
        $find_files_p1 = {
            8B FF 55 8B EC 81 EC ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C5 89 45 ?? 8B 4D ?? 8B 55 ?? 53 
            57 8B 7D ?? 89 95 ?? ?? ?? ?? 3B CF 74 ?? 8A 01 3C ?? 74 ?? 3C ?? 74 ?? 3C ?? 74 ?? 
            51 57 E8 ?? ?? ?? ?? 59 59 8B C8 3B CF 75 ?? 8B 95 ?? ?? ?? ?? 8A 01 88 85 ?? ?? ?? 
            ?? 3C ?? 75 ?? 8D 47 ?? 3B C8 74 ?? 52 33 DB 53 53 57 E8 ?? ?? ?? ?? 83 C4 ?? E9 ?? 
            ?? ?? ?? 8A 85 ?? ?? ?? ?? 33 DB 3C ?? 74 ?? 3C ?? 74 ?? 3C ?? 8A C3 75 ?? B0 ?? 2B 
            CF 0F B6 C0 41 89 9D ?? ?? ?? ?? F7 D8 89 9D ?? ?? ?? ?? 56 1B C0 89 9D ?? ?? ?? ?? 
            23 C1 89 9D ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 89 9D ?? ?? ?? ?? 88 9D ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 57 E8 ?? ?? ?? ?? 83 C4 ?? 8D 8D ?? ?? ?? ?? F7 D8
        }

        $find_files_p2 = { 
            1B C0 53 53 53 51 F7 D0 23 85 ?? ?? ?? ?? 53 50 FF 15 ?? ?? ?? ?? 8B F0 83 FE ?? 75 
            ?? FF B5 ?? ?? ?? ?? 53 53 57 E8 ?? ?? ?? ?? 83 C4 ?? 8B D8 E9 ?? ?? ?? ?? 8B 85 ?? 
            ?? ?? ?? 8B 48 ?? 2B 08 C1 F9 ?? 89 8D ?? ?? ?? ?? 89 9D ?? ?? ?? ?? 89 9D ?? ?? ?? 
            ?? 89 9D ?? ?? ?? ?? 89 9D ?? ?? ?? ?? 89 9D ?? ?? ?? ?? 88 9D ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 50 8D 85 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? 
            ?? 83 C4 ?? F7 D8 1B C0 F7 D0 23 85 ?? ?? ?? ?? 80 38 ?? 75 ?? 8A 48 ?? 84 C9 74 ?? 
            80 F9 ?? 75 ?? 38 58 ?? 74 ?? FF B5 ?? ?? ?? ?? FF B5 ?? ?? ?? ?? 57 50 E8 ?? ?? ?? 
            ?? 83 C4 ?? 89 85 ?? ?? ?? ?? 85 C0 75 ?? 38 9D ?? ?? ?? ?? 74 ?? FF B5 ?? ?? ?? ?? 
            E8 ?? ?? ?? ?? 59 8D 85 ?? ?? ?? ?? 50 56 FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 
            8B 85 ?? ?? ?? ?? 8B 8D ?? ?? ?? ?? 8B 10 8B 40 ?? 2B C2 C1 F8 ?? 3B C8 74 ?? 68 ?? 
            ?? ?? ?? 2B C1 6A ?? 50 8D 04 8A 50 E8 ?? ?? ?? ?? 83 C4 ?? EB ?? 38 9D ?? ?? ?? ?? 
            74 ?? FF B5 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 59 8B D8 56 FF 15 ?? ?? ?? 
            ?? 80 BD ?? ?? ?? ?? ?? 5E 74 ?? FF B5 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B C3 8B 4D ?? 
            5F 33 CD 5B E8 ?? ?? ?? ?? C9 C3 
        }
        
        $encrypt_files = {
            53 8B DC 83 EC ?? 83 E4 ?? 83 C4 ?? 55 8B 6B ?? 89 6C 24 ?? 8B EC 6A ?? 68 ?? ?? ?? 
            ?? 64 A1 ?? ?? ?? ?? 50 53 81 EC ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C5 89 45 ?? 50 8D 45 
            ?? 64 A3 ?? ?? ?? ?? 89 8D ?? ?? ?? ?? 6A ?? 6A ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 
            C7 45 ?? ?? ?? ?? ?? 6A ?? 8D 45 ?? 50 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4B ?? 51 
            FF 15 ?? ?? ?? ?? 83 E0 ?? 74 ?? 8B 53 ?? 52 FF 15 ?? ?? ?? ?? 83 E0 ?? 50 8B 43 ?? 
            50 FF 15 ?? ?? ?? ?? 8B 4B ?? 51 8B 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 ?? 8B 53 
            ?? 52 8D 45 ?? 50 83 EC ?? 8B CC 89 A5 ?? ?? ?? ?? 51 8B 8D ?? ?? ?? ?? E8 ?? ?? ?? 
            ?? 8B 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? 
            ?? ?? C6 45 ?? ?? 8D 55 ?? 52 8B 43 ?? 50 8D 4D ?? 51 E8 ?? ?? ?? ?? 83 C4 ?? C6 45 
            ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 52 8B 43 ?? 50 8D 
            4D ?? 51 83 EC ?? 8B D4 89 A5 ?? ?? ?? ?? 52 8B 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 8D 
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A ?? 8B 43 ?? 50 8B 8D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 
            C6 45 ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? C7 45 ?? ?? 
            ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D ?? 64 89 0D ?? ?? ?? ?? 59 8B 4D ?? 
            33 CD E8 ?? ?? ?? ?? 8B E5 5D 8B E3 5B C2
        }
        
    condition:
        uint16(0) == 0x5A4D and
        (
            all of ($find_files_p*)
        ) and
        (
            $encrypt_files
        ) and
        (
            (
                $exclude_directories_and_drop_ransom_note
            ) or
            (
                $drop_ransom_note_no_dir_exclusion
            )
        )
}