rule ByteCode_MSIL_Ransomware_Thanos : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "THANOS"
        description         = "Yara rule that detects Thanos ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Thanos"
        tc_detection_factor = 5

    strings:

        $find_files_p1 = {
            6F ?? ?? ?? ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 16 FE 01 2B ?? 16 00 13 ?? 11 ?? 2D ?? DD 
            ?? ?? ?? ?? 08 6F ?? ?? ?? ?? 28 ?? ?? ?? ?? 2C ?? 08 6F ?? ?? ?? ?? 6C 7E ?? ?? ?? ?? 
            28 ?? ?? ?? ?? 23 ?? ?? ?? ?? ?? ?? ?? ?? 5A 23 ?? ?? ?? ?? ?? ?? ?? ?? 5A 35 ?? 7E ?? 
            ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 16 FE 01 2B ?? 17 00 13 ?? 11 ?? 2D ?? 00 06 08 
            6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 00 2B ?? 08 6F ?? ?? ?? ?? 28 ?? ?? ?? ?? 2C ?? 7E ?? 
            ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 16 FE 01 2B ?? 17 00 13 ?? 11 ?? 2D ?? 00 06 08 
            6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 00 00 DE ?? 26 00 00 DE ?? 26 00 00 DE ?? 00 00 00 11 
            ?? 6F ?? ?? ?? ?? 13 ?? 11 ?? 3A ?? ?? ?? ?? DE ?? 11 ?? 14 FE 01 13 ?? 11 ?? 2D ?? 11 
            ?? 6F ?? ?? ?? ?? 00 DC 00 00 07 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 13 ?? 38 
            ?? ?? ?? ?? 11 ?? 6F ?? ?? ?? ?? 0D 00 07 6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 72 ?? ?? ?? ?? 
            6F ?? ?? ?? ?? 2D ?? 07 6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 2D 
            ?? 07 6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 2D ?? 07 6F ?? ?? ?? 
            ?? 6F ?? ?? ?? ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 2D ?? 07 6F ?? ?? ?? ?? 6F
        }

        $find_files_p2 = { 
            72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 2D ?? 07 6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 72 ?? ?? ?? ?? 6F 
            ?? ?? ?? ?? 16 FE 01 2B ?? 16 00 13 ?? 11 ?? 2D ?? 38 ?? ?? ?? ?? 00 00 09 72 ?? ?? ?? 
            ?? 17 6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 13 ?? 38 ?? ?? ?? ?? 11 ?? 6F ?? ?? ?? ?? 0C 00 00 
            08 6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 3A ?? ?? ?? ?? 08 6F ?? 
            ?? ?? ?? 6F ?? ?? ?? ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 3A ?? ?? ?? ?? 08 6F ?? ?? ?? ?? 
            6F ?? ?? ?? ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 3A ?? ?? ?? ?? 08 6F ?? ?? ?? ?? 6F ?? ?? 
            ?? ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 3A
        }

        $find_files_p3 = {
            6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 3A ?? ?? ?? ?? 08 6F ?? ?? 
            ?? ?? 6F ?? ?? ?? ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 3A ?? ?? ?? ?? 08 6F ?? ?? ?? ?? 6F 
            ?? ?? ?? ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 2D ?? 08 6F ?? ?? ?? ?? 72 ?? ?? ?? ?? 00 6F 
            ?? ?? ?? ?? 2D ?? 08 6F ?? ?? ?? ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 2D ?? 08 6F ?? ?? ?? 
            ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 2D ?? 08 6F ?? ?? ?? ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 
            2D ?? 08 6F ?? ?? ?? ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 2D ?? 08 6F ?? ?? ?? ?? 72 ?? ?? 
            ?? ?? 6F ?? ?? ?? ?? 16 FE 01 2B ?? 16 00 13 ?? 11 ?? 2D ?? DD ?? ?? ?? ?? 08 6F ?? ?? 
            ?? ?? 28 ?? ?? ?? ?? 2C ?? 08 6F ?? ?? ?? ?? 6C 7E ?? ?? ?? ?? 28 ?? ?? ?? ?? 23 ?? ?? 
            ?? ?? ?? ?? ?? ?? 5A 23 ?? ?? ?? ?? ?? ?? ?? ?? 5A 35 ?? 7E ?? ?? ?? ?? 72 ?? ?? ?? ?? 
            28 ?? ?? ?? ?? 16 FE 01 2B ?? 17 00 13 ?? 11 ?? 2D ?? 00 06 08 6F ?? ?? ?? ?? 6F ?? ?? 
            ?? ?? 00 00 2B ?? 08 6F ?? ?? ?? ?? 28 ?? ?? ?? ?? 2C ?? 7E ?? ?? ?? ?? 72 ?? ?? ?? ?? 
            28 ?? ?? ?? ?? 16 FE 01 2B ?? 17 00 13 ?? 11 ?? 2D ?? 00 06 08 6F ?? ?? ?? ?? 6F ?? ?? 
            ?? ?? 00 00 00 DE ?? 26 00 00 DE ?? 26 00 00 DE ?? 00 00 00 11 ?? 6F ?? ?? ?? ?? 13 ?? 
            11 ?? 3A ?? ?? ?? ?? DE ?? 11 ?? 14 FE 01 13 ?? 11 ?? 2D ?? 11 ?? 6F ?? ?? ?? ?? 00 DC 
            00 00 DE ?? 26 00 00 DE ?? 26 00 00 DE ?? 00 00 11 ?? 6F ?? ?? ?? ?? 13 ?? 11 ?? 3A ?? 
            ?? ?? ?? DE ?? 11 ?? 14 FE 01 13 ?? 11 ?? 2D ?? 11 ?? 6F ?? ?? ?? ?? 00 DC 00 00 DE ?? 
            26 00 00 DE ?? 26 00 00 DE ?? 26 00 00 DE ?? 26 00 00 DE ?? 00 06 13 ?? 2B ?? 11 ?? 2A
        }

        $encrypt_files = {
            73 ?? ?? ?? ?? 13 ?? 11 ?? 03 7D ?? ?? ?? ?? 11 ?? 04 7D ?? ?? ?? ?? 11 ?? 05 7D ?? ?? 
            ?? ?? 11 ?? 0E ?? 7D ?? ?? ?? ?? 00 28 ?? ?? ?? ?? 11 ?? 7B ?? ?? ?? ?? 6F ?? ?? ?? ?? 
            80 ?? ?? ?? ?? 02 16 9A 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 16 FE 01 13 ?? 11 ?? 2D ?? 00 28 
            ?? ?? ?? ?? 0A 06 8E 69 16 FE 02 16 FE 01 13 ?? 11 ?? 2D ?? 00 16 0B 2B ?? 00 06 07 9A 
            6F ?? ?? ?? ?? 16 FE 01 13 ?? 11 ?? 2D ?? 00 7E ?? ?? ?? ?? 06 07 9A 6F ?? ?? ?? ?? 6F 
            ?? ?? ?? ?? 13 ?? 11 ?? 2D ?? 00 7E ?? ?? ?? ?? 06 07 9A 6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 
            00 00 00 00 07 17 58 0B 07 06 8E 69 FE 04 13 ?? 11 ?? 2D ?? 00 00 2B ?? 00 16 0B 2B ?? 
            00 7E ?? ?? ?? ?? 02 07 9A 6F ?? ?? ?? ?? 13 ?? 11 ?? 2D ?? 00 7E ?? ?? ?? ?? 02 07 9A 
            6F ?? ?? ?? ?? 00 00 00 07 17 58 0B 07 02 8E 69 FE 04 13 ?? 11 ?? 2D ?? 00 7E ?? ?? ?? 
            ?? 72 ?? ?? ?? ?? 00 6F ?? ?? ?? ?? 2C ?? 7E ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 
            16 FE 01 2B ?? 17 00 13 ?? 11 ?? 2D ?? 00 7E ?? ?? ?? ?? 72 ?? ?? ?? ?? 00 6F ?? ?? ?? 
            ?? 26 00 00 7E ?? ?? ?? ?? 6F ?? ?? ?? ?? 13 ?? 38 ?? ?? ?? ?? 14 0D 73 ?? ?? ?? ?? 13 
            ?? 11 ?? 11 ?? 7D ?? ?? ?? ?? 11 ?? 12 ?? 28 ?? ?? ?? ?? 7D ?? ?? ?? ?? 00 7E ?? ?? ?? 
            ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 16 FE 01 13 ?? 11 ?? 2D ?? 00 09 2D ?? 11 ?? FE 06 ?? 
            ?? ?? ?? 73 ?? ?? ?? ?? 0D 2B ?? 09 73 ?? ?? ?? ?? 0C 08 1A 6F ?? ?? ?? ?? 00 08 16 6F 
            ?? ?? ?? ?? 00 08 6F ?? ?? ?? ?? 00 08 6F ?? ?? ?? ?? 00 00 2B ?? 00 11 ?? 7B ?? ?? ?? 
            ?? 11 ?? 7B ?? ?? ?? ?? 11 ?? 7B ?? ?? ?? ?? 11 ?? 7B ?? ?? ?? ?? 11 ?? 7B ?? ?? ?? ?? 
            28 ?? ?? ?? ?? 00 00 00 12 ?? 28 ?? ?? ?? ?? 13 ?? 11 ?? 3A ?? ?? ?? ?? DE ?? 12 ?? FE 
            16 ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 DC 00 00 2A
        }

        $remote_connection = {
            00 00 28 ?? ?? ?? ?? 72 ?? ?? ?? ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 16 19 6F ?? ?? ?? ?? 
            72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 0A 73 ?? ?? ?? ?? 0B 07 02 28 ?? ?? ?? ?? 06 28 ?? ?? ?? 
            ?? 6F ?? ?? ?? ?? 00 28 ?? ?? ?? ?? 06 28 ?? ?? ?? ?? 0C DE ?? 26 00 00 DE ?? 00 7E ?? 
            ?? ?? ?? 0C 2B ?? 00 08 2A 
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            all of ($find_files_p*)
        ) and
        (
            $encrypt_files
        ) and
        (
            $remote_connection
        )
}