rule ByteCode_MSIL_Ransomware_Retis : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "RETIS"
        description         = "Yara rule that detects Retis ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Retis"
        tc_detection_factor = 5

    strings:

        $search_files = {
            00 00 04 6F ?? ?? ?? ?? 0B 38 ?? ?? ?? ?? 12 ?? 28 ?? ?? ?? ?? 0C 00 08 28 ?? ?? ?? ??
            0A 72 ?? ?? ?? ?? 06 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 00 00 03 6F ?? ?? ??
            ?? 0D 38 ?? ?? ?? ?? 12 ?? 28 ?? ?? ?? ?? 13 ?? 00 00 72 ?? ?? ?? ?? 11 ?? 72 ?? ?? ??
            ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 00 06 72 ?? ?? ?? ?? 11 ?? 6F ?? ?? ?? ?? 28 ?? ?? ??
            ?? 17 28 ?? ?? ?? ?? 73 ?? ?? ?? ?? 13 ?? 00 11 ?? 6F ?? ?? ?? ?? 13 ?? 38 ?? ?? ?? ??
            12 ?? 28 ?? ?? ?? ?? 13 07 00 11 ?? 73 ?? ?? ?? ?? 13 ?? 02 11 ?? 28 ?? ?? ?? ?? 16 FE
            ?? 13 ?? 11 ?? 2C ?? 00 02 11 ?? 6F ?? ?? ?? ?? 28 ?? ?? ?? ?? 00 1F ?? 28 ?? ?? ?? ??
            00 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 00 28 ?? ?? ?? ?? 00 11 ?? 6F ?? ?? ?? ?? 28 ?? ?? ??
            ?? 00 00 2B ?? 00 1F ?? 28 ?? ?? ?? ?? 00 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 00 28 ?? ?? ??
            ?? 00 72 ?? ?? ?? ?? 11 ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 00 00 00 12 ??
            28 ?? ?? ?? ?? 3A ?? ?? ?? ?? DE ?? 12 ?? FE ?? ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 DC 00 DE
            ?? 26 00 00 DE ?? 00 12 ?? 28 ?? ?? ?? ?? 3A ?? ?? ?? ?? DE ?? 12 ?? FE ?? ?? ?? ?? ??
            6F ?? ?? ?? ?? 00 DC 00 12 ?? 28 ?? ?? ?? ?? 3A ?? ?? ?? ?? DE ?? 12 ?? FE ?? ?? ?? ??
            ?? 6F ?? ?? ?? ?? 00 DC 2A
        }


        $search_drives = {
            00 28 ?? ?? ?? ?? 0A 73 ?? ?? ?? ?? 0B 00 06 0C 16 0D 2B ?? 08 09 9A 13 ?? 00
            11 ?? 6F ?? ?? ?? ?? 13 ?? 11 ?? 2C ?? 00 07 11 ?? 6F ?? ?? ?? ?? 6F ?? ?? ??
            ?? 6F ?? ?? ?? ?? 00 00 00 09 17 58 0D 09 08 8E 69 32 ?? 07 72 ?? ?? ?? ?? 6F
            ?? ?? ?? ?? 26 00 07 6F ?? ?? ?? ?? 13 ?? 38 ?? ?? ?? ?? 12 ?? 28 ?? ?? ?? ??
            13 ?? 00 28 ?? ?? ?? ?? 00 72 ?? ?? ?? ?? 11 ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ??
            28 ?? ?? ?? ?? 00 28 ?? ?? ?? ?? 00 00 03 6F ?? ?? ?? ?? 13 ?? 38 ?? ?? ?? ??
            12 ?? 28 ?? ?? ?? ?? 13 ?? 00 00 72 ?? ?? ?? ?? 11 ?? 72 ?? ?? ?? ?? 28 ?? ??
            ?? ?? 28 ?? ?? ?? ?? 00 11 ?? 72 ?? ?? ?? ?? 11 ?? 6F ?? ?? ?? ?? 28 ?? ?? ??
            ?? 17 28 ?? ?? ?? ?? 73 ?? ?? ?? ?? 13 ?? 00 11 ?? 6F ?? ?? ?? ?? 13 ?? 2B ??
            12 ?? 28 ?? ?? ?? ?? 13 ?? 00 02 11 ?? 6F ?? ?? ?? ?? 28 ?? ?? ?? ?? 00 1F ??
            28 ?? ?? ?? ?? 00 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 00 28 ?? ?? ?? ?? 00 11 ?? 6F
            ?? ?? ?? ?? 28 ?? ?? ?? ?? 00 00 12 ?? 28 ?? ?? ?? ?? 2D ?? DE ?? 12 ?? FE ??
            ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 DC 00 DE ?? 26 00 00 DE ?? 00 12 ?? 28 ?? ?? ??
            ?? 3A ?? ?? ?? ?? DE ?? 12 ?? FE ?? ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 DC 00 12 ??
            28 ?? ?? ?? ?? 3A ?? ?? ?? ?? DE ?? 12 ?? FE ?? ?? ?? ?? ?? 6F ?? ?? ?? ?? 00
            DC 2A
        }

        $encrypt_files = {
            00 03 19 17 73 ?? ?? ?? ?? 0A 06 6F ?? ?? ?? ?? D4 8D ?? ?? ?? ?? 0B 06 07
            16 07 8E 69 6F ?? ?? ?? ?? 26 06 6F ?? ?? ?? ?? 00 03 18 18 73 ?? ?? ?? ??
            0C 73 ?? ?? ?? ?? 0D 09 28 ?? ?? ?? ?? 02 7B ?? ?? ?? ?? 6F ?? ?? ?? ?? 6F
            ?? ?? ?? ?? 00 09 28 ?? ?? ?? ?? 02 7B ?? ?? ?? ?? 6F ?? ?? ?? ?? 6F ?? ??
            ?? ?? 00 09 6F ?? ?? ?? ?? 13 ?? 08 11 ?? 17 73 ?? ?? ?? ?? 13 ?? 11 ?? 07
            16 07 8E 69 6F ?? ?? ?? ?? 00 11 ?? 6F ?? ?? ?? ?? 00 08 6F ?? ?? ?? ?? 00
            03 03 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 00 2A
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            $search_files and
            $search_drives and
            $encrypt_files
        )
}