rule ByteCode_MSIL_Ransomware_McBurglar : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "MCBURGLAR"
        description         = "Yara rule that detects McBurglar ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "McBurglar"
        tc_detection_factor = 5

    strings:

        $setup_env = {
            00 7E ?? ?? ?? ?? 16 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 7E ?? ?? ?? ?? 1F ?? 28 ?? ?? ??
            ?? 6F ?? ?? ?? ?? 00 7E ?? ?? ?? ?? 1F ?? 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 7E ?? ?? ??
            ?? 1B 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 7E ?? ?? ?? ?? 1F ?? 28 ?? ?? ?? ?? 6F ?? ?? ??
            ?? 00 7E ?? ?? ?? ?? 1F ?? 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 28 ?? ?? ?? ?? 00 28 ?? ??
            ?? ?? 00 2A
        }

        $encrypt_files_p1 = {
            00 00 7E ?? ?? ?? ?? 6F ?? ?? ?? ?? 0A 2B ?? 73 ?? ?? ?? ?? 0B 07 12 ?? 28 ?? ?? ?? ??
            7D ?? ?? ?? ?? 00 07 FE 06 ?? ?? ?? ?? 73 ?? ?? ?? ?? 73 ?? ?? ?? ?? 28 ?? ?? ?? ?? 00
            00 12 ?? 28 ?? ?? ?? ?? 2D ?? DE ?? 12 ?? FE 16 ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 DC 2A
        }

        $encrypt_files_p2 = {
            00 28 ?? ?? ?? ?? 0A 02 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 18 73 ?? ?? ?? ?? 0B 73 ?? ?? ??
            ?? 0C 28 ?? ?? ?? ?? 03 6F ?? ?? ?? ?? 0D 73 ?? ?? ?? ?? 13 ?? 11 ?? 20 ?? ?? ?? ?? 6F
            ?? ?? ?? ?? 00 11 ?? 20 ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 11 ?? 18 6F ?? ?? ?? ?? 00 09 06
            20 ?? ?? ?? ?? 73 ?? ?? ?? ?? 13 ?? 11 ?? 11 ?? 11 ?? 6F ?? ?? ?? ?? 1E 5B 6F ?? ?? ??
            ?? 6F ?? ?? ?? ?? 00 11 ?? 11 ?? 11 ?? 6F ?? ?? ?? ?? 1E 5B 6F ?? ?? ?? ?? 6F ?? ?? ??
            ?? 00 11 ?? 1A 6F ?? ?? ?? ?? 00 07 06 16 06 8E 69 6F ?? ?? ?? ?? 00 07 11 ?? 6F ?? ??
            ?? ?? 17 73 ?? ?? ?? ?? 13 ?? 02 19 73 ?? ?? ?? ?? 13 ?? 20 ?? ?? ?? ?? 8D ?? ?? ?? ??
            13 ?? 00 2B ?? 00 11 ?? 11 ?? 16 11 ?? 6F ?? ?? ?? ?? 00 00 11 ?? 11 ?? 16 11 ?? 8E 69
            6F ?? ?? ?? ?? 25 13 ?? 16 FE 02 13 ?? 11 ?? 2D ?? 11 ?? 6F ?? ?? ?? ?? 00 00 DE ?? 13
            ?? 00 72 ?? ?? ?? ?? 11 ?? 6F ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 00 00 DE ?? DE
            ?? 00 11 ?? 6F ?? ?? ?? ?? 00 07 6F ?? ?? ?? ?? 00 00 DC 2A
        }

        $find_files = {
            00 00 02 28 ?? ?? ?? ?? 0A 00 06 0C 16 0D 2B ?? 08 09 9A 13 ?? 00 11 ?? 28 ?? ?? ?? ??
            00 00 09 17 58 0D 09 08 8E 69 32 ?? 02 28 ?? ?? ?? ?? 0B 00 07 13 ?? 16 13 ?? 2B ?? 11
            ?? 11 ?? 9A 13 ?? 00 11 ?? 28 ?? ?? ?? ?? 00 00 11 ?? 17 58 13 ?? 11 ?? 11 ?? 8E 69 32
            ?? 00 DE ?? 26 00 00 DE ?? 2A
        }

        $generate_salt = {
            00 1F ?? 8D ?? ?? ?? ?? 0A 73 ?? ?? ?? ?? 0B 00 16 0C 2B ?? 00 07 06 6F ?? ?? ?? ?? 00
            00 08 17 58 0C 08 1F ?? FE 04 0D 09 2D ?? 00 DE ?? 07 2C ?? 07 6F ?? ?? ?? ?? 00 DC 06
            13 ?? 2B ?? 11 ?? 2A
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            $setup_env
        ) and
        (
            $find_files
        ) and
        (
            $generate_salt
        ) and
        (
            all of ($encrypt_files_p*)
        )
}