rule Win32_Infostealer_LumarStealer : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "LUMARSTEALER"
        description         = "Yara rule that detects LumarStealer infostealer."

        tc_detection_type   = "Infostealer"
        tc_detection_name   = "LumarStealer"
        tc_detection_factor = 5

    strings:

        $collect_os_information_p1 = {
            55 8B EC 81 EC ?? ?? ?? ?? 53 56 B8 ?? ?? ?? ?? C1 E0 ?? 8B 88 ?? ?? ?? ?? FF D1 66
            A3 ?? ?? ?? ?? BA ?? ?? ?? ?? 66 89 55 ?? B8 ?? ?? ?? ?? 66 89 45 ?? B9 ?? ?? ?? ??
            66 89 4D ?? BA ?? ?? ?? ?? 66 89 55 ?? B8 ?? ?? ?? ?? 66 89 45 ?? B9 ?? ?? ?? ?? 66
            89 4D ?? BA ?? ?? ?? ?? 66 89 55 ?? B8 ?? ?? ?? ?? 66 89 45 ?? B9 ?? ?? ?? ?? 66 89
            4D ?? BA ?? ?? ?? ?? 66 89 55 ?? C6 45 ?? ?? EB ?? 8A 45 ?? 04 ?? 88 45 ?? 0F B6 4D
            ?? 83 F9 ?? 73 ?? 0F B6 55 ?? 0F B7 44 55 ?? 0F B7 0D ?? ?? ?? ?? 3B C1 75 ?? FF 25
            ?? ?? ?? ?? EB ?? C7 45 ?? ?? ?? ?? ?? 33 D2 89 55 ?? 89 55 ?? 89 55 ?? C7 45 ?? ??
            ?? ?? ?? 8D 75 ?? B8 ?? ?? ?? ?? 33 C9 0F A2 89 06 89 5E ?? 89 4E ?? 89 56 ?? B8 ??
            ?? ?? ?? 6B C8 ?? 8B 54 0D ?? 89 55 ?? C7 45 ?? ?? ?? ?? ?? EB ?? 8B 45 ?? 83 C0 ??
            89 45 ?? 8B 4D ?? 3B 4D ?? 77 ?? 8D 75 ?? 8B 45 ?? 33 C9 0F A2 89 06 89 5E ?? 89 4E
            ?? 89 56 ?? 81 7D ?? ?? ?? ?? ?? 75 ?? 6A ?? 8D 55 ?? 52 68 ?? ?? ?? ?? E8 ?? ?? ??
            ?? 83 C4 ?? EB ?? 81 7D ?? ?? ?? ?? ?? 75 ?? 6A ?? 8D 45 ?? 50 68 ?? ?? ?? ?? E8 ??
            ?? ?? ?? 83 C4 ?? EB ?? 81 7D ?? ?? ?? ?? ?? 75 ?? 6A ?? 8D 4D ?? 51 68 ?? ?? ?? ??
            E8 ?? ?? ?? ?? 83 C4 ?? EB ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? C6 80 ?? ?? ??
            ?? ?? 8D 95 ?? ?? ?? ?? 52 B8 ?? ?? ?? ?? C1 E0 ?? 8B 88 ?? ?? ?? ?? FF D1 85 C0 74
            ?? 6A ?? 8D 95 ?? ?? ?? ?? 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 8D 85 ?? ?? ??
            ?? 50 B9 ?? ?? ?? ?? D1 E1 8B 91 ?? ?? ?? ?? FF D2 8B 45 ?? A3 ?? ?? ?? ?? C7 85 ??
            ?? ?? ?? ?? ?? ?? ?? 6A ?? 8D 8D ?? ?? ?? ?? 51 6A ?? 6A ?? BA ?? ?? ?? ?? 6B C2
        }

        $collect_os_information_p2 = {
            8B 88 ?? ?? ?? ?? FF D1 85 C0 74 ?? 68 ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? 52 68 ?? ?? ??
            ?? E8 ?? ?? ?? ?? 83 C4 ?? 8D 45 ?? 50 B9 ?? ?? ?? ?? 6B D1 ?? 8B 82 ?? ?? ?? ?? FF
            D0 85 C0 74 ?? 6A ?? 68 ?? ?? ?? ?? 8B 4D ?? 51 8B 55 ?? 52 E8 ?? ?? ?? ?? A3 ?? ??
            ?? ?? 89 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? FF 15 ?? ?? ?? ?? 6A ??
            FF 15 ?? ?? ?? ?? 89 45 ?? 6A ?? 8B 45 ?? 50 FF 15 ?? ?? ?? ?? 89 45 ?? 8D 4D ?? 51
            6A ?? 8B 55 ?? 52 FF 15 ?? ?? ?? ?? 85 C0 74 ?? 8B 45 ?? A3 ?? ?? ?? ?? 8B 4D ?? 89
            0D ?? ?? ?? ?? 8B 55 ?? 52 FF 15 ?? ?? ?? ?? 8B 45 ?? 50 6A ?? FF 15 ?? ?? ?? ?? 68
            ?? ?? ?? ?? 6A ?? B9 ?? ?? ?? ?? C1 E1 ?? 8B 91 ?? ?? ?? ?? FF D2 C7 45 ?? ?? ?? ??
            ?? EB ?? 8B 45 ?? 83 C0 ?? 89 45 ?? 83 7D ?? ?? 73 ?? 8B 4D ?? 83 C1 ?? 89 4D ?? EB
            ?? 8B 55 ?? 83 C2 ?? 89 55 ?? 83 7D ?? ?? 73 ?? 8B 45 ?? 0F B7 0C 45 ?? ?? ?? ?? 8B
            55 ?? 0F B7 04 55 ?? ?? ?? ?? 3B C8 75 ?? 33 C9 8B 55 ?? 66 89 0C 55 ?? ?? ?? ?? EB
            ?? EB ?? 5E 5B 8B E5 5D C3
        }

        $send_data_to_c2_p1 = {
            55 8B EC 81 EC ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? B9 ?? ?? ?? ?? 6B D1
            ?? 8B 82 ?? ?? ?? ?? FF D0 85 C0 0F 85 ?? ?? ?? ?? B9 ?? ?? ?? ?? 66 89 4D ?? 68 ??
            ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 66 89 45 ?? 6A ?? 6A ?? 0F BF 55 ?? 52 B8 ?? ?? ??
            ?? C1 E0 ?? 8B 88 ?? ?? ?? ?? FF D1 89 45 ?? 83 7D ?? ?? 0F 84 ?? ?? ?? ?? 6A ?? 6A
            ?? 8D 95 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 ?? 6A ?? 6A ?? 8D 45 ?? 50 E8 ?? ?? ??
            ?? 83 C4 ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 6A ??
            6A ?? 6A ?? 68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 ?? C7 45 ?? ??
            ?? ?? ?? EB ?? 8B 55 ?? 83 C2 ?? 89 55 ?? 83 7D ?? ?? 7D ?? 8B 45 ?? 0F B7 8C 45 ??
            ?? ?? ?? 83 F9 ?? 75 ?? 8B 55 ?? 0F B7 84 55 ?? ?? ?? ?? 83 F8 ?? 75 ?? EB ?? EB ??
            8B 4D ?? 0F B7 94 4D ?? ?? ?? ?? 85 D2 74 ?? 8B 45 ?? 8B 4D ?? 8A 94 4D ?? ?? ?? ??
            88 54 05 ?? 8B 45 ?? 0F BE 4C 05 ?? 83 F9 ?? 75 ?? 8B 55 ?? C6 44 15 ?? ?? EB ?? 8D
            45 ?? 50 8D 4D ?? 51 E8 ?? ?? ?? ?? 83 C4 ?? 6A ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8
            ?? ?? ?? ?? 83 C4 ?? 6A ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 0F
            B6 15 ?? ?? ?? ?? 83 FA ?? 75 ?? C7 45 ?? ?? ?? ?? ?? EB ?? C7 45 ?? ?? ?? ?? ?? B8
            ?? ?? ?? ?? C1 E0 ?? 8A 4D ?? 88 88 ?? ?? ?? ?? 0F B6 15 ?? ?? ?? ?? 83 FA ?? 75
        }

        $send_data_to_c2_p2 = {
            C7 45 ?? ?? ?? ?? ?? EB ?? C7 45 ?? ?? ?? ?? ?? B8 ?? ?? ?? ?? 6B C8 ?? 8A 55 ?? 88
            91 ?? ?? ?? ?? 0F B6 05 ?? ?? ?? ?? 83 F8 ?? 75 ?? C7 45 ?? ?? ?? ?? ?? EB ?? C7 45
            ?? ?? ?? ?? ?? B9 ?? ?? ?? ?? 6B D1 ?? 8A 45 ?? 88 82 ?? ?? ?? ?? B9 ?? ?? ?? ?? 6B
            D1 ?? C6 82 ?? ?? ?? ?? ?? B8 ?? ?? ?? ?? 6B C8 ?? 8A 15 ?? ?? ?? ?? 88 91 ?? ?? ??
            ?? B8 ?? ?? ?? ?? 6B C8 ?? C6 81 ?? ?? ?? ?? ?? BA ?? ?? ?? ?? 85 D2 74 ?? 6A ?? 8D
            45 ?? 50 8B 4D ?? 51 BA ?? ?? ?? ?? D1 E2 8B 82 ?? ?? ?? ?? FF D0 83 F8 ?? 74 ?? 6A
            ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 4D ?? 51 BA ?? ?? ?? ?? 6B C2 ?? 8B 88 ?? ?? ??
            ?? FF D1 83 F8 ?? 74 ?? 6A ?? 8B 55 ?? 83 C2 ?? 52 8B 45 ?? 50 8B 4D ?? 51 BA ?? ??
            ?? ?? 6B C2 ?? 8B 88 ?? ?? ?? ?? FF D1 83 F8 ?? 74 ?? EB ?? 68 ?? ?? ?? ?? FF 15 ??
            ?? ?? ?? E9 ?? ?? ?? ?? 8B 55 ?? 52 B8 ?? ?? ?? ?? C1 E0 ?? 8B 88 ?? ?? ?? ?? FF D1
            BA ?? ?? ?? ?? 6B C2 ?? 8B 88 ?? ?? ?? ?? FF D1 B8 ?? ?? ?? ?? EB ?? 33 C0 8B E5 5D
            C3
        }

        $find_files_p1 = {
            55 8B EC 81 EC ?? ?? ?? ?? A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 0F 84 ??
            ?? ?? ?? 68 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 ?? 8D 95 ?? ?? ??
            ?? 52 A1 ?? ?? ?? ?? 50 B9 ?? ?? ?? ?? 6B D1 ?? 8B 82 ?? ?? ?? ?? FF D0 89 45 ?? 8B
            0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 ?? 33 D2 8B 0D ?? ?? ?? ?? 66 89 54 41 ?? 83
            7D ?? ?? 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 89 45 ?? 8B 15 ??
            ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 ?? 66 89 45 ?? 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ??
            83 C4 ?? 0F B7 4D ?? 8D 54 08 ?? 81 FA ?? ?? ?? ?? 72 ?? E9 ?? ?? ?? ?? 8D 85 ?? ??
            ?? ?? 50 8B 0D ?? ?? ?? ?? 51 68 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83
            C4 ?? 8B 85 ?? ?? ?? ?? 83 E0 ?? 74 ?? 68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 51 E8 ?? ??
            ?? ?? 83 C4 ?? 85 C0 74 ?? 68 ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4
            ?? 85 C0 74 ?? E9 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 25 ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? B9
            ?? ?? ?? ?? 66 89 4D ?? BA ?? ?? ?? ?? 66 89 55 ?? B8 ?? ?? ?? ?? 66 89 45 ?? B9 ??
            ?? ?? ?? 66 89 4D ?? 33 D2 66 89 55 ?? B8 ?? ?? ?? ?? 66 89 45 ?? B9 ?? ?? ?? ?? 66
        }

        $find_files_p2 = {
            89 4D ?? BA ?? ?? ?? ?? 66 89 55 ?? B8 ?? ?? ?? ?? 66 89 45 ?? 33 C9 66 89 4D ?? BA
            ?? ?? ?? ?? 66 89 95 ?? ?? ?? ?? B8 ?? ?? ?? ?? 66 89 85 ?? ?? ?? ?? B9 ?? ?? ?? ??
            66 89 4D ?? BA ?? ?? ?? ?? 66 89 55 ?? B8 ?? ?? ?? ?? 66 89 45 ?? B9 ?? ?? ?? ?? 66
            89 4D ?? BA ?? ?? ?? ?? 66 89 55 ?? 33 C0 66 89 45 ?? B9 ?? ?? ?? ?? 66 89 4D ?? BA
            ?? ?? ?? ?? 66 89 55 ?? B8 ?? ?? ?? ?? 66 89 45 ?? B9 ?? ?? ?? ?? 66 89 4D ?? 33 D2
            66 89 55 ?? B8 ?? ?? ?? ?? 66 89 45 ?? B9 ?? ?? ?? ?? 66 89 4D ?? BA ?? ?? ?? ?? 66
            89 55 ?? B8 ?? ?? ?? ?? 66 89 45 ?? 33 C9 66 89 4D ?? BA ?? ?? ?? ?? 66 89 55 ?? B8
            ?? ?? ?? ?? 66 89 45 ?? B9 ?? ?? ?? ?? 66 89 4D ?? BA ?? ?? ?? ?? 66 89 55 ?? 33 C0
            66 89 45 ?? B9 ?? ?? ?? ?? 66 89 4D ?? BA ?? ?? ?? ?? 66 89 55 ?? B8 ?? ?? ?? ?? 66
            89 45 ?? 33 C9 66 89 4D ?? BA ?? ?? ?? ?? 66 89 55 ?? B8 ?? ?? ?? ?? 66 89 45 ?? B9
            ?? ?? ?? ?? 66 89 4D ?? BA ?? ?? ?? ?? 66 89 55 ?? 33 C0 66 89 45 ?? B9 ?? ?? ?? ??
            66 89 4D ?? BA ?? ?? ?? ?? 66 89 55 ?? B8 ?? ?? ?? ?? 66 89 45 ?? B9 ?? ?? ?? ?? 66
            89 4D ?? 33 D2 66 89 55 ?? 8D 45 ?? 50 8D 8D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 ??
            85 C0 0F 85 ?? ?? ?? ?? 8D 55 ?? 52 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 85
        }

        $find_files_p3 = {
            C0 0F 85 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 51 8D 95 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4
            ?? 85 C0 0F 85 ?? ?? ?? ?? 8D 45 ?? 50 8D 8D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 ??
            85 C0 75 ?? 8D 55 ?? 52 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 75 ?? 8D
            4D ?? 51 8D 95 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 75 ?? 8D 45 ?? 50 8D 8D
            ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 75 ?? 8D 55 ?? 52 8D 85 ?? ?? ?? ?? 50
            E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 75 ?? 8D 4D ?? 51 8D 95 ?? ?? ?? ?? 52 E8 ?? ?? ?? ??
            83 C4 ?? 85 C0 74 ?? B8 ?? ?? ?? ?? 66 89 45 ?? B9 ?? ?? ?? ?? 66 89 4D ?? BA ?? ??
            ?? ?? 66 89 55 ?? B8 ?? ?? ?? ?? 66 89 45 ?? 33 C9 66 89 4D ?? 0F B7 15 ?? ?? ?? ??
            A1 ?? ?? ?? ?? 8D 0C 50 51 8D 55 ?? 52 68 ?? ?? ?? ?? 8B 45 ?? 50 E8 ?? ?? ?? ?? 83
            C4 ?? 8B 4D ?? 51 8B 15 ?? ?? ?? ?? 52 8B 45 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8A 0D ??
            ?? ?? ?? 80 C1 ?? 88 0D ?? ?? ?? ?? 0F B7 55 ?? 33 C0 8B 0D ?? ?? ?? ?? 66 89 04 51
            8D 95 ?? ?? ?? ?? 52 8B 45 ?? 50 B9 ?? ?? ?? ?? C1 E1 ?? 8B 91 ?? ?? ?? ?? FF D2 85
            C0 0F 85 ?? ?? ?? ?? 8B 45 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8B E5 5D C2
        }

        $find_crypto_wallets_1 = {
            55 8B EC 81 EC ?? ?? ?? ?? 8B 45 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 0F 84 ?? ?? ??
            ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 89 45 ?? 8B 4D ?? 51 8B 55 ?? 52 E8 ?? ??
            ?? ?? 83 C4 ?? 68 ?? ?? ?? ?? 8B 45 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8D 8D ?? ?? ?? ??
            51 8B 55 ?? 52 B8 ?? ?? ?? ?? 6B C8 ?? 8B 91 ?? ?? ?? ?? FF D2 89 45 ?? 8B 45 ?? 50
            E8 ?? ?? ?? ?? 83 C4 ?? 33 C9 8B 55 ?? 66 89 4C 42 ?? 83 7D ?? ?? 0F 84 ?? ?? ?? ??
            68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 89 45 ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ??
            ?? ?? 8B 45 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 66 89 45 ?? 8D 8D ?? ?? ?? ?? 51 E8 ?? ??
            ?? ?? 83 C4 ?? 0F B7 55 ?? 8D 44 10 ?? 3D ?? ?? ?? ?? 72 ?? E9 ?? ?? ?? ?? 8D 8D ??
            ?? ?? ?? 51 8B 55 ?? 52 68 ?? ?? ?? ?? 8B 45 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8D 8D ??
            ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 ?? 8D 95 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 ?? D1
            E0 50 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 89 45 ?? 8B 8D ?? ?? ?? ?? 83 E1
            ?? 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 ?? 85
            C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 85
            C0 0F 84 ?? ?? ?? ?? 81 7D ?? ?? ?? ?? ?? 0F 85 ?? ?? ?? ?? B9 ?? ?? ?? ?? 66 89 8D
            ?? ?? ?? ?? BA ?? ?? ?? ?? 66 89 95 ?? ?? ?? ?? B8 ?? ?? ?? ?? 66 89 85 ?? ?? ?? ??
            B9 ?? ?? ?? ?? 66 89 8D ?? ?? ?? ?? BA ?? ?? ?? ?? 66 89 95 ?? ?? ?? ?? B8 ?? ?? ??
            ?? 66 89 85 ?? ?? ?? ?? B9 ?? ?? ?? ?? 66 89 4D ?? BA ?? ?? ?? ?? 66 89 55 ?? 33 C0
            66 89 45 ?? 8D 4D ?? 51 6A ?? 8D 95 ?? ?? ?? ?? 52 0F B7 45 ?? 50 8B 4D ?? 51 8B 55
            ?? 52 E8 ?? ?? ?? ?? 83 C4 ?? 83 7D ?? ?? 0F 86 ?? ?? ?? ?? B8 ?? ?? ?? ?? 66 89 85
            ?? ?? ?? ?? B9 ?? ?? ?? ?? 66 89 8D ?? ?? ?? ?? BA ?? ?? ?? ?? 66 89 95
        }

        $find_crypto_wallets_2 = {
            0D ?? ?? ?? ?? 80 C1 ?? 88 0D ?? ?? ?? ?? 83 7D ?? ?? 76 ?? 8A 15 ?? ?? ?? ?? 80 C2
            ?? 88 15 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ??
            ?? ?? ?? E9 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 25 ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 83 3D ??
            ?? ?? ?? ?? 0F 85 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 8D 4D ?? 51 8B 55 ?? 52 E8 ?? ??
            ?? ?? 83 C4 ?? 89 45 ?? 83 7D ?? ?? 0F 84 ?? ?? ?? ?? 83 7D ?? ?? 0F 86 ?? ?? ?? ??
            B8 ?? ?? ?? ?? C1 E0 ?? 8B 4D ?? 0F B6 14 01 83 FA ?? 0F 85 ?? ?? ?? ?? B8 ?? ?? ??
            ?? 6B C8 ?? 8B 55 ?? 0F B6 04 0A 83 F8 ?? 0F 85 ?? ?? ?? ?? B9 ?? ?? ?? ?? 6B D1 ??
            8B 45 ?? 0F B6 0C 10 83 F9 ?? 0F 85 ?? ?? ?? ?? BA ?? ?? ?? ?? 6B C2 ?? 8B 4D ?? 0F
            B6 14 01 83 FA ?? 0F 85 ?? ?? ?? ?? B8 ?? ?? ?? ?? 66 89 85 ?? ?? ?? ?? B9 ?? ?? ??
            ?? 66 89 8D ?? ?? ?? ?? BA ?? ?? ?? ?? 66 89 95 ?? ?? ?? ?? B8 ?? ?? ?? ?? 66 89 85
            ?? ?? ?? ?? B9 ?? ?? ?? ?? 66 89 8D ?? ?? ?? ?? BA ?? ?? ?? ?? 66 89 95 ?? ?? ?? ??
            B8 ?? ?? ?? ?? 66 89 85 ?? ?? ?? ?? B9 ?? ?? ?? ?? 66 89 8D ?? ?? ?? ?? BA
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            all of ($collect_os_information_p*)
        ) and
        (
            all of ($send_data_to_c2_p*)
        ) and
        (
            all of ($find_files_p*)
        ) and
        (
            all of ($find_crypto_wallets_*)
        )
}