rule ByteCode_MSIL_Infostealer_GomorrahStealer : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "GOMORRAHSTEALER"
        description         = "Yara rule that detects GomorrahStealer infostealer."

        tc_detection_type   = "Infostealer"
        tc_detection_name   = "GomorrahStealer"
        tc_detection_factor = 5

    strings:

        $get_browser_autofill_data = {
            1F ?? 28 ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 0B 73 ?? ?? ?? ?? 0C 07 73 ?? ??
            ?? ?? 0D 09 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 26 09 6F ?? ?? ?? ?? 0A 16 06 17 DA 13 ??
            13 ?? 2B ?? 09 11 ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 13 ?? 09 11 ?? 72 ?? ?? ?? ?? 6F
            ?? ?? ?? ?? 13 ?? 08 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 26 08 72 ?? ?? ?? ?? 11 ?? 28 ??
            ?? ?? ?? 6F ?? ?? ?? ?? 26 08 72 ?? ?? ?? ?? 11 ?? 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 26
            08 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 26 08 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 26 7E ?? ?? ??
            ?? 17 D6 80 ?? ?? ?? ?? 00 11 ?? 17 D6 13 ?? 11 ?? 11 ?? 13 ?? 11 ?? 3E ?? ?? ?? ??
            17 8D ?? ?? ?? ?? 13 ?? 11 ?? 16 7E ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? A2 00
            11 ?? 28 ?? ?? ?? ?? 08 6F ?? ?? ?? ?? 28 ?? ?? ?? ?? 00 DE ?? 25 28 ?? ?? ?? ?? 13
            ?? 00 28 ?? ?? ?? ?? DE
        }

        $get_browser_cookies = {
            1F ?? 28 ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 0B 73 ?? ?? ?? ?? 0C 07 73 ?? ??
            ?? ?? 0D 09 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 26 09 6F ?? ?? ?? ?? 0A 16 06 17 DA 13 ??
            13 ?? 38 ?? ?? ?? ?? 09 11 ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 13 ?? 09 11 ?? 72 ?? ??
            ?? ?? 6F ?? ?? ?? ?? 13 ?? 09 11 ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 13 ?? 09 11 ?? 72
            ?? ?? ?? ?? 6F ?? ?? ?? ?? 13 ?? 09 11 ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 13 ?? 09 11
            ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 13 ?? 09 11 ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 13 ??
            11 ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 2D ?? 11 ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 2D ??
            16 2B ?? 17 00 13 ?? 11 ?? 2C ?? 7E ?? ?? ?? ?? 28 ?? ?? ?? ?? 14 (FE | 01) ?? 13 ??
            11 ?? 2C ?? 38 ?? ?? ?? ?? 28 ?? ?? ?? ?? 11 ?? 6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 7E ??
            ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 13 ?? 2B ?? 00 11 ?? 28 ?? ?? ?? ?? 13 ?? 00
            08 1F ?? 8D ?? ?? ?? ?? 13 ?? 11 ?? 16 11 ?? A2 00 11 ?? 17 72 ?? ?? ?? ?? A2 00 11
            ?? 18 11 ?? A2 00 11 ?? 19 72 ?? ?? ?? ?? A2 00 11 ?? 1A 11 ?? A2 00 11 ?? 1B 72 ??
            ?? ?? ?? A2 00 11 ?? 1C 11 ?? A2 00 11 ?? 1D 72 ?? ?? ?? ?? A2 00 11 ?? 1E 11 ?? A2
            00 11 ?? 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 26 7E ?? ?? ?? ?? 17 D6 80 ?? ?? ?? ?? 00 11
            ?? 17 D6 13 ?? 11 ?? 11 ?? 13 ?? 11 ?? 3E ?? ?? ?? ?? 17 8D ?? ?? ?? ?? 13 ?? 11 ??
            16 7E ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? A2 00 11 ?? 28 ?? ?? ?? ?? 08 6F ??
            ?? ?? ?? 28 ?? ?? ?? ?? 00 DE ?? 25 28 ?? ?? ?? ?? 13 ?? 00 28 ?? ?? ?? ?? DE
        }

        $take_screenshot = {
            12 ?? 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 13 ?? 12 ?? 28 ?? ?? ?? ?? 28 ??
            ?? ?? ?? 6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 13 ?? 12 ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 00
            28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 13 ?? 12 ?? 28 ?? ?? ?? ?? 28 ?? ?? ??
            ?? 6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 13 ?? 12 ?? 28 ?? ?? ?? ?? 73 ?? ?? ?? ?? 0B 07 28
            ?? ?? ?? ?? 0A 06 12 ?? 16 16 28 ?? ?? ?? ?? 00 11 ?? 12 ?? 16 16 28 ?? ?? ?? ?? 00
            11 ?? 08 6F ?? ?? ?? ?? 00 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 07 6F ?? ??
            ?? ?? 00 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 7E ?? ?? ?? ??
            28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 DE ?? 25 28 ?? ?? ?? ?? 0D 00 28 ?? ?? ?? ?? DE
        }

        $get_antivirus_information = {
            7E ?? ?? ?? ?? 0B 00 28 ?? ?? ?? ?? 0D 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 6F ?? ?? ?? ??
            1B (FE | 02) ?? 72 ?? ?? ?? ?? 09 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 72 ?? ?? ?? ?? 09 72
            ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 13 ?? 11 ?? 72 ?? ?? ?? ??
            73 ?? ?? ?? ?? 13 ?? 11 ?? 6F ?? ?? ?? ?? 13 ?? 72 ?? ?? ?? ?? 11 ?? 6F ?? ?? ?? ??
            13 ?? 12 ?? 28 ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 0C 00 11 ?? 6F ?? ?? ?? ??
            13 ?? 2B ?? 11 ?? 6F ?? ?? ?? ?? 74 ?? ?? ?? ?? 13 ?? 00 08 11 ?? 72 ?? ?? ?? ?? 6F
            ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 0C DE ?? 28
            ?? ?? ?? ?? 00 28 ?? ?? ?? ?? DE ?? 00 00 08 11 ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 72
            ?? ?? ?? ?? 28 ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ??
            ?? 0C DE ?? 28 ?? ?? ?? ?? 00 28 ?? ?? ?? ?? DE ?? 00 00 11 ?? 6F ?? ?? ?? ?? 13 ??
            11 ?? 3A ?? ?? ?? ?? 00 DE ?? 11 ?? 14 (FE | 01) ?? 16 (FE | 01) ?? 13 ?? 11 ?? 2C ??
            11 ?? 6F ?? ?? ?? ?? 00 00 DC 08 0B DE ?? 28 ?? ?? ?? ?? 00 28 ?? ?? ?? ?? DE ?? 00
            07 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 13 ?? 11 ?? 2C ?? 07 17 8D ?? ?? ?? ?? 13 ?? 11 ??
            16 1F ?? 9D 11 ?? 6F ?? ?? ?? ?? 17 9A 16 8D ?? ?? ?? ?? 6F ?? ?? ?? ?? 16 8D ?? ??
            ?? ?? 6F ?? ?? ?? ?? 0B 00 07 0A 2B ?? 06
        }

        $get_browser_history = {
            1F ?? 28 ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 0B 73 ?? ?? ?? ?? 0C 07 73 ?? ??
            ?? ?? 0D 09 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 26 09 6F ?? ?? ?? ?? 0A 16 06 17 DA 13 ??
            13 ?? 2B ?? 09 11 ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 13 ?? 09 11 ?? 72 ?? ?? ?? ?? 6F
            ?? ?? ?? ?? 13 ?? 08 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 26 08 72 ?? ?? ?? ?? 11 ?? 28 ??
            ?? ?? ?? 6F ?? ?? ?? ?? 26 08 72 ?? ?? ?? ?? 11 ?? 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 26
            08 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 26 7E ?? ?? ?? ?? 17 D6 80 ?? ?? ?? ?? 00 11 ?? 17
            D6 13 ?? 11 ?? 11 ?? 13 ?? 11 ?? 31 ?? 17 8D ?? ?? ?? ?? 13 ?? 11 ?? 16 7E ?? ?? ??
            ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? A2 00 11 ?? 28 ?? ?? ?? ?? 08 6F ?? ?? ?? ?? 28 ??
            ?? ?? ?? 00 DE ?? 25 28 ?? ?? ?? ?? 13 ?? 00 28 ?? ?? ?? ?? DE
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            $get_browser_autofill_data
        ) and
        (
            $get_browser_cookies
        ) and
        (
            $take_screenshot
        ) and
        (
            $get_antivirus_information
        ) and
        (
            $get_browser_history
        )
}