import "pe"

rule Win32_Exploit_CVE20200601 : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "EXPLOIT"
        exploit             = "CVE-2020-0601"
        description         = "Yara rule that detects CVE-2020-0601 exploit."

        tc_detection_type   = "Exploit"
        tc_detection_name   = "CVE-2020-0601"
        tc_detection_factor = 5

    strings:

        $oid_prime_explicit = {
            06 07 2A 86 48 CE 3D 01 01
        }

        $ecc_public_key_1 = {
            04 47 45 0E 96 FB 7D 5D BF E9 39 D1 21 F8 9F 0B
            B6 D5 7B 1E 92 3A 48 59 1C F0 62 31 2D C0 7A 28
            FE 1A A7 5C B3 B6 CC 97 E7 45 D4 58 FA D1 77 6D
            43 A2 C0 87 65 34 0A 1F 7A DD EB 3C 33 A1 C5 9D
            4D A4 6F 41 95 38 7F C9 1E 84 EB D1 9E 49 92 87
            94 87 0C 3A 85 4A 66 9F 9D 59 93 4D 97 61 06 86
            4A
        }

        $ecc_public_key_2 = {
            04 84 13 C9 D0 BA 6D 41 7B E2 6C D0 EB 55 5F 66
            02 1A 24 F4 5B 89 69 47 E3 B8 C2 7D F1 F2 02 C5
            9F A0 F6 5B D5 8B 06 19 86 4F 53 10 6D 07 24 27
            A1 A0 F8 D5 47 19 61 4C 7D CA 93 27 EA 74 0C EF
            6F 96 09 FE 63 EC 70 5D 36 AD 67 77 AE C9 9D 7C
            55 44 3A A2 63 51 1F F5 E3 62 D4 A9 47 07 3E CC
            20
        }

        $ecc_public_key_3 = {
            04 A7 56 7A 7C 52 DA 64 9B 0E 2D 5C D8 5E AC 92
            3D FE 01 E6 19 4A 3D 14 03 4B FA 60 27 20 D9 83
            89 69 FA 54 C6 9A 18 5E 55 2A 64 DE 06 F6 8D 4A
            3B AD 10 3C 65 3D 90 88 04 89 E0 30 61 B3 AE 5D
            01 A7 7B DE 7C B2 BE CA 65 61 00 86 AE DA 8F 7B
            D0 89 AD 4D 1D 59 9A 41 B1 BC 47 80 DC 9E 62 C3
            F9
        }

        $ecc_public_key_4 = {
            04 CD 0F 5B 56 82 DF F0 45 1A D6 AD F7 79 F0 1D
            C9 AC 96 D6 9E 4E 9C 1F B4 42 11 CA 86 BF 6D FB
            85 A3 C5 E5 19 5C D7 EE A6 3F 69 67 D8 78 E2 A6
            C9 C4 DB 2D 79 2E E7 8B 8D 02 6F 31 22 4D 06 E3
            60 72 45 9D 0E 42 77 9E CE CF E5 7F 85 9B 18 E4
            FC CC 2E 72 D3 16 93 4E CA 99 63 5C A1 05 2A 6C
            06
        }

        $ecc_public_key_5 = {
            04 57 CF EA B3 39 4D 3F A1 21 E0 6E 2F 38 72 C6
            87 97 F3 85 0B 47 E7 0F 51 C8 D1 F4 99 9B CA 59
            65 FF 4C F9 EA 0B B7 25 D5 D2 F6 EC 31 2D 32 62
            12 D7 76 86 A7 FA 38 C9 65 D4 FE 73 E2 84 39 F8
            4C 49 62 13 DD BA D5 88 A0 5F 3D C8 4F B0 3F 8F
            A1 50 11 E4 93 46 AD C3 5F CB F1 A4 6A 95 56 E8
            C0
        }

        $ecc_public_key_6 = {
            04 D1 D9 4A 8E 4C 0D 84 4A 51 BA 7C EF D3 CC FA
            3A 9A B5 A7 63 13 3D 01 E0 49 3E FA C1 47 C9 92
            B3 3A D7 FE 6F 9C F7 9A 3A 0F F5 0E 0A 0A C3 3F
            C8 E7 12 14 8E D5 D5 6D 98 2C B3 71 32 0A EB 2A
            BD F6 D7 6A 20 0B 67 45 9C D2 B2 BF 53 22 66 09
            5D DB 11 F3 F1 05 33 58 A3 E2 B8 CF 7C CD 82 9B
            BD
        }

        $ecc_public_key_7 = {
            04 4A EE 58 AE 4D CA 66 DE 06 3A A3 11 FC E0 18
            F0 6E 1C BA 2D 30 0C 89 D9 D6 EE 9B 73 83 A9 23
            15 8C 2F 59 8A 5A DD 14 EA 9D 59 2B 43 B7 06 EC
            32 B6 BA EE 41 B5 AD 5D A1 85 CC EA 1D 14 66 A3
            67 7E 46 E2 94 F3 E7 B6 56 A1 15 59 A1 4F 37 97
            B9 22 1E BD 11 EB F4 B2 1F 5E C3 14 9A E5 D9 97
            99
        }

        $ecc_public_key_8 = {
            04 DD A7 D9 BB 8A B8 0B FB 0B 7F 21 D2 F0 BE BE
            73 F3 33 5D 1A BC 34 EA DE C6 9B BC D0 95 F6 F0
            CC D0 0B BA 61 5B 51 46 7E 9E 2D 9F EE 8E 63 0C
            17 EC 07 70 F5 CF 84 2E 40 83 9C E8 3F 41 6D 3B
            AD D3 A4 14 59 36 78 9D 03 43 EE 10 13 6C 72 DE
            AE 88 A7 A1 6B B5 43 CE 67 DC 23 FF 03 1C A3 E2
            3E
        }

        $ecc_public_key_9 = {
            04 D7 66 B5 1B DB AE B3 60 EE 46 EA 88 63 75 3B
            2A 94 6D F3 5F 12 F6 E3 0F 9E B6 0A 14 53 48 52
            C8 DC 3A B3 CB 48 20 26 12 4E FA 89 84 D4 DF 91
            E4 29 7D 28 01 D9 DB 18 43 69 A1 1F B5 D3 86 16
            DC C7 7F 67 23 DF DF 31 31 83 03 35 70 B1 4B B7
            C8 17 BB 51 CB DC 94 17 DB EA 09 3B 76 12 DE AA
            B5
        }

        $ecc_public_key_10 = {
            04 15 B1 E8 FD 03 15 43 E5 AC EB 87 37 11 62 EF
            D2 83 36 52 7D 45 57 0B 4A 8D 7B 54 3B 3A 6E 5F
            15 02 C0 50 A6 CF 25 2F 7D CA 48 B8 C7 50 63 1C
            2A 21 08 7C 9A 36 D8 0B FE D1 26 C5 58 31 30 28
            25 F3 5D 5D A3 B8 B6 A5 B4 92 ED 6C 2C 9F EB DD
            43 89 A2 3C 4B 48 91 1D 50 EC 26 DF D6 60 2E BD
            21
        }

        $ecc_public_key_11 = {
            04 03 47 7B 2F 75 C9 82 15 85 FB 75 E4 91 16 D4
            AB 62 99 F5 3E 52 0B 06 CE 41 00 7F 97 E1 0A 24
            3C 1D 01 04 EE 3D D2 8D 09 97 0C E0 75 E4 FA FB
            77 8A 2A F5 03 60 4B 36 8B 16 23 16 AD 09 71 F4
            4A F4 28 50 B4 FE 88 1C 6E 3F 6C 2F 2F 09 59 5B
            A5 5B 0B 33 99 E2 C3 3D 89 F9 6A 2C EF B2 D3 06
            E9
        }

        $ecc_public_key_12 = {
            04 92 A0 41 E8 4B 82 84 5C E2 F8 31 11 99 86 64
            4E 09 25 2F 9D 41 2F 0A AE 35 4F 74 95 B2 51 64
            6B 8D 6B E6 3F 70 95 F0 05 44 47 A6 72 38 50 76
            95 02 5A 8E AE 28 9E F9 2D 4E 99 EF 2C 48 6F 4C
            25 29 E8 D1 71 5B DF 1D C1 75 37 B4 D7 FA 7B 7A
            42 9C 6A 0A 56 5A 7C 69 0B AA 80 09 24 6C 7E C1
            46
        }

        $ecc_public_key_13 = {
            04 A2 D5 9C 82 7B 95 9D F1 52 78 87 FE 8A 16 BF
            05 E6 DF A3 02 4F 0D 07 C6 00 51 BA 0C 02 52 2D
            22 A4 42 39 C4 FE 8F EA C9 C1 BE D4 4D FF 9F 7A
            9E E2 B1 7C 9A AD A7 86 09 73 87 D1 E7 9A E3 7A
            A5 AA 6E FB BA B3 70 C0 67 88 A2 35 D4 A3 9A B1
            FD AD C2 EF 31 FA A8 B9 F3 FB 08 C6 91 D1 FB 29
            95
        }

        $ecc_public_key_14 = {
            04 98 E9 2F 3D 40 72 A4 ED 93 22 72 81 13 1C DD
            10 95 F1 C5 A3 4E 71 DC 14 16 D9 0E E5 A6 05 2A
            77 64 7B 5F 4E 38 D3 BB 1C 44 B5 7F F5 1F B6 32
            62 5D C9 E9 84 5B 4F 30 4F 11 5A 00 FD 58 58 0C
            A5 F5 0F 2C 4D 07 47 13 75 DA 97 97 97 6F 31 5C
            ED 2B 9D 7B 20 3B D8 B9 54 D9 5E 99 A4 3A 51 0A
            31
        }

        $ecc_public_key_15 = {
            04 0D 30 5E 1B 15 9D 03 D0 A1 79 35 B7 3A 3C 92
            7A CA 15 1C CD 62 F3 9C 26 5C 07 3D E5 54 FA A3
            D6 CC 12 EA F4 14 5F E8 8E 19 AB 2F 2E 48 E6 AC
            18 43 78 AC D0 37 C3 BD B2 CD 2C E6 47 E2 1A E6
            63 B8 3D 2E 2F 78 C4 4F DB F4 0F A4 68 4C 55 72
            6B 95 1D 4E 18 42 95 78 CC 37 3C 91 E2 9B 65 2B
            29
        }

        $ecc_public_key_16 = {
            04 1A AC 54 5A A9 F9 68 23 E7 7A D5 24 6F 53 C6
            5A D8 4B AB C6 D5 B6 D1 E6 73 71 AE DD 9C D6 0C
            61 FD DB A0 89 03 B8 05 14 EC 57 CE EE 5D 3F E2
            21 B3 CE F7 D4 8A 79 E0 A3 83 7E 2D 97 D0 61 C4
            F1 99 DC 25 91 63 AB 7F 30 A3 B4 70 E2 C7 A1 33
            9C F3 BF 2E 5C 53 B1 5F B3 7D 32 7F 8A 34 E3 79
            79
        }

        $ecc_public_key_17 = {
            04 E1 FD 8E B8 43 24 AB 96 7B 85 C2 BA 0B AD 8D
            E0 3A E3 24 B9 D2 B1 BE 88 3A CA BF 4A B8 F9 EF
            2C 2F AF 51 50 3C 47 75 6C F8 94 B7 9B FC 28 1E
            C5 54 CC 63 9D 16 4B 53 C1 E7 20 AB CD AC 25 D2
            7F 8F C2 C1 5A 82 5E 30 8B 7A 54 CE 03 B5 91 7F
            AA 94 D0 D1 8A 48 CC 82 05 26 A1 D5 51 12 D6 7B
            36
        }

        $ecc_public_key_18 = {
            04 19 E7 BC AC 44 65 ED CD B8 3F 58 FB 8D B1 57
            A9 44 2D 05 15 F2 EF 0B FF 10 74 9F B5 62 52 5F
            66 7E 1F E5 DC 1B 45 79 0B CC C6 53 0A 9D 8D 5D
            02 D9 A9 59 DE 02 5A F6 95 2A 0E 8D 38 4A 8A 49
            C6 BC C6 03 38 07 5F 55 DA 7E 09 6E E2 7F 5E D0
            45 20 0F 59 76 10 D6 A0 24 F0 2D DE 36 F2 6C 29
            39
        }

        $ecc_public_key_19 = {
            04 B8 C6 79 D3 8F 6C 25 0E 9F 2E 39 19 1C 03 A4
            AE 9A E5 39 07 09 16 CA 63 B1 B9 86 F8 8A 57 C1
            57 CE 42 FA 73 A1 F7 65 42 FF 1E C1 00 B2 6E 73
            0E FF C7 21 E5 18 A4 AA D9 71 3F A8 D4 B9 CE 8C
            1D
        }

        $ecc_public_key_20 = {
            04 C7 11 16 2A 76 1D 56 8E BE B9 62 65 D4 C3 CE
            B4 F0 C3 30 EC 8F 6D D7 6E 39 BC C8 49 AB AB B8
            E3 43 78 D5 81 06 5D EF C7 7D 9F CE D6 B3 90 75
            DE 0C B0 90 DE 23 BA C8 D1 3E 67 E0 19 A9 1B 86
            31 1E 5F 34 2D EE 17 FD 15 FB 7E 27 8A 32 A1 EA
            C9 8F C9 7E 18 CB 2F 3B 2C 48 7A 7D A6 F4 01 07
            AC
        }

        $ecc_public_key_21 = {
            04 DE CD BB 70 20 F1 25 20 B4 94 E8 D7 B4 3B 0F
            6E 87 DD AB AC CF 4D 40 2F 81 33 6B 59 09 18 D6
            87 0D 26 23 9C B4 8D 95 9D 76 9F A5 B9 06 42 E6
            AD 36 B2 C4 B3 AE 7A 3C 08 D5 CB 9D 3A 5E 45 21
            6C 0B E3 20 F5 9B C2 DD 44 33 E3 42 B9 EA F2 28
            42 92 AA FE 0C 07 CA 8A 13 99 3B 62 00 ED DA F3
            35
        }

        $ecc_public_key_22 = {
            04 5C D1 EE 57 0D D1 EF 81 7C 26 91 62 C3 6B E7
            FC 73 A9 A0 C3 37 44 DC D6 F8 31 E2 77 93 5F 8F
            EB E3 ED 38 73 F5 FC 8B 55 B9 14 A5 8F 2C 44 28
            19 AF 5D FB DE 09 58 C9 29 B3 A9 99 D3 75 13 3C
            A9
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            $oid_prime_explicit
        ) and
        (
            any of ($ecc_public_key_*)
        ) and
        (
            pe.number_of_signatures > 0
        )
}