rule Win64_Backdoor_Voldemort : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "VOLDEMORT"
        description         = "Yara rule that detects Voldemort backdoor."

        tc_detection_type   = "Backdoor"
        tc_detection_name   = "Voldemort"
        tc_detection_factor = 5

    strings:

        $decrypt_configuration_p1 = {
            4C 8B DC 55 56 48 81 EC ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 ?? 49
            89 5B ?? 33 F6 49 89 7B ?? 4D 89 6B ?? 48 89 4C 24 ?? 66 C7 44 24 ?? ?? ?? C6 44 24
            ?? ?? E8 ?? ?? ?? ?? 4C 8B E8 8B FE E8 ?? ?? ?? ?? 48 89 44 24 ?? 48 8B E8 48 85 C0
            0F 84 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B
            D8 48 85 C0 75 ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B
            D8 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B D0 48 8B CB E8 ?? ?? ?? ?? 48 85 C0 0F
            84 ?? ?? ?? ?? 45 33 C9 48 89 74 24 ?? C7 44 24 ?? ?? ?? ?? ?? BA ?? ?? ?? ?? 48 8B
            CD C7 44 24 ?? ?? ?? ?? ?? 45 8D 41 ?? FF D0 48 89 44 24 ?? 48 8B F8 48 83 F8 ?? 0F
            84 ?? ?? ?? ?? 4C 89 A4 24 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 4C 89 B4 24 ?? ?? ?? ??
            E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 75 ?? 48 8D 0D ?? ?? ?? ??
            E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B D8 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ??
            48 8B D0 48 8B CB FF 15 ?? ?? ?? ?? 48 85 C0 74 ?? 33 D2 48 8B CF FF D0 44 8B E0 EB
            ?? 44 8B E6 89 74 24 ?? FF 15 ?? ?? ?? ?? 45 8B C4 BA ?? ?? ?? ?? 48 8B C8 FF 15 ??
            ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 4C 8B F0 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B
            D8 48 85 C0 75 ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B
            D8 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B D0 48 8B CB FF 15 ?? ?? ?? ?? 48 85 C0
            74 ?? 4C 8D 4C 24 ?? 48 89 74 24 ?? 45 8B C4 49 8B D6 48 8B CF FF D0 8B FE 45 85 E4
            0F 84 ?? ?? ?? ?? 0F 1F 40 ?? 66 66 0F 1F 84 00 ?? ?? 00 00 44 8B C6 48 8D 54 24
        }

        $decrypt_configuration_p2 = {
            0F 1F 84 00 ?? ?? ?? ?? 0F B6 0A 8B C7 FF C7 42 3A 0C 30 0F 85 ?? ?? ?? ?? 41 FF C0
            48 FF C2 41 83 F8 ?? 72 ?? 83 FF ?? 0F 84 ?? ?? ?? ?? 42 8B 2C 37 4C 89 BC 24 ?? ??
            ?? ?? 8D 5D ?? FF 15 ?? ?? ?? ?? 44 8B C3 BA ?? ?? ?? ?? 48 8B C8 FF 15 ?? ?? ?? ??
            48 8B D8 85 ED 74 ?? 8D 47 ?? 03 C5 41 3B C4 73 ?? 49 8D 56 ?? 44 8B C5 48 03 D7 48
            8B CB E8 ?? ?? ?? ?? 4C 8B BC 24 ?? ?? ?? ?? 49 C7 C0 ?? ?? ?? ?? 66 90 49 FF C0 43
            38 34 28 75 ?? 85 ED 7E ?? 4C 8B CB 8B C6 4D 8D 49 ?? 99 FF C6 41 F7 F8 48 63 C2 42
            0F B6 14 28 41 30 51 ?? 3B F5 7C ?? 48 8B 4C 24 ?? 4C 8B C5 48 8B D3 E8 ?? ?? ?? ??
            48 8B 6C 24 ?? BE ?? ?? ?? ?? EB ?? 41 3B FC 0F 82 ?? ?? ?? ?? 48 8B DE 4C 8B A4 24
            ?? ?? ?? ?? 4D 85 F6 74 ?? FF 15 ?? ?? ?? ?? 4D 8B C6 33 D2 48 8B C8 FF 15 ?? ?? ??
            ?? 4C 8B B4 24 ?? ?? ?? ?? 48 85 DB 74 ?? FF 15 ?? ?? ?? ?? 4C 8B C3 33 D2 48 8B C8
            FF 15 ?? ?? ?? ?? 48 8B 7C 24 ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B C8 E8 ??
            ?? ?? ?? 4C 8B AC 24 ?? ?? ?? ?? 48 8B D8 48 85 C0 75 ?? 48 8D 0D ?? ?? ?? ?? E8 ??
            ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B D8 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B
            D0 48 8B CB E8 ?? ?? ?? ?? 48 8B 9C 24 ?? ?? ?? ?? 48 85 C0 74 ?? 48 8B CF FF D0 48
            8B BC 24 ?? ?? ?? ?? 48 85 ED 74 ?? FF 15 ?? ?? ?? ?? 4C 8B C5 33 D2 48 8B C8 FF 15
            ?? ?? ?? ?? 8B C6 48 8B 4C 24 ?? 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 ?? ?? ?? ?? 5E 5D
            C3
        }

        $decryption_algorithm = {
            40 53 48 83 EC ?? 0F B6 01 48 8B D9 84 C0 0F 84 ?? ?? ?? ?? 48 FF C3 48 89 7C 24 ??
            4C 8B C9 8B F8 3C ?? 72 ?? 83 E7 ?? B9 ?? ?? ?? ?? 0F 1F 00 0F B6 13 48 FF C3 8B C2
            83 E0 ?? D3 E0 83 C1 ?? 0B F8 80 FA ?? 73 ?? 33 C0 4C 8B C3 4D 2B C1 4C 3B CB 4C 0F
            47 C0 4D 85 C0 74 ?? 33 D2 49 8B C9 E8 ?? ?? ?? ?? 8B C7 99 83 E2 ?? 03 C2 C1 F8 ??
            85 C0 7E ?? 48 89 74 24 ?? 48 8B FB 8B F0 66 90 48 8B D7 E8 ?? ?? ?? ?? 48 83 C7 ??
            48 83 EE ?? 75 ?? 48 8B 74 24 ?? 48 8B C3 48 8B 7C 24 ?? 48 83 C4 ?? 5B C3 48 8B 7C
            24 ?? 48 8B C3 48 83 C4 ?? 5B C3
        }

        $request_access_token_p1 = {
            40 53 55 56 57 41 54 41 55 41 56 41 57 48 81 EC ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48
            33 C4 48 89 84 24 ?? ?? ?? ?? 33 C0 4C 89 4C 24 ?? 33 FF 48 89 44 24 ?? 0F 57 C0 89
            7C 24 ?? 48 C7 C3 ?? ?? ?? ?? 8B F7 49 8B E8 4C 8B FA 4C 8B F1 48 8B C3 0F 11 44 24
            ?? 48 FF C0 42 38 34 00 75 ?? 48 8B CB 48 FF C1 40 38 34 0A 75 ?? 48 03 C1 48 8B CB
            48 FF C1 41 38 34 0E 75 ?? 48 03 C1 4C 8D 24 C5 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 4D 8B
            C4 BA ?? ?? ?? ?? 48 8B C8 FF 15 ?? ?? ?? ?? 4C 8B E8 48 85 C0 74 ?? 48 89 6C 24 ??
            4C 8D 05 ?? ?? ?? ?? 4D 8B CE 4C 89 7C 24 ?? 49 8B D4 48 8B C8 E8 ?? ?? ?? ?? 4C 8D
            0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 ?? E8 ?? ?? ??
            ?? 85 C0 0F 84 ?? ?? ?? ?? 33 D2 48 8D 4C 24 ?? 41 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48
            8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B E8 48 85 C0 75 ?? 48
            8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B E8 48 8D 0D ?? ?? ??
            ?? E8 ?? ?? ?? ?? 48 8B D0 48 8B CD FF 15 ?? ?? ?? ?? 48 85 C0 0F 84 ?? ?? ?? ?? 48
            8B 6C 24 ?? 48 8D 15 ?? ?? ?? ?? 48 8B CD 41 B9 ?? ?? ?? ?? 41 B8 ?? ?? ?? ?? FF D0
        }

        $request_access_token_p2 = {
            85 C0 0F 84 ?? ?? ?? ?? 49 8B D5 48 8B CD E8 ?? ?? ?? ?? 48 8B F0 48 85 C0 0F 84 ??
            ?? ?? ?? 48 8B D3 66 90 48 FF C2 40 38 3C 10 75 ?? 48 FF C2 48 8B C8 E8 ?? ?? ?? ??
            4C 8B F0 48 85 C0 74 ?? 48 8D 15 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B E8 48 85
            C0 74 ?? 83 78 ?? ?? 75 ?? 48 8B 48 ?? 48 8B FB 80 7C 39 ?? ?? 48 8D 7F ?? 75 ?? FF
            15 ?? ?? ?? ?? 4C 8D 47 ?? BA ?? ?? ?? ?? 48 8B C8 FF 15 ?? ?? ?? ?? 48 8B 55 ?? 4C
            8B C3 48 8B F8 0F 1F 00 49 FF C0 42 80 3C 02 ?? 75 ?? 49 FF C0 48 8B C8 E8 ?? ?? ??
            ?? 49 8B CE E8 ?? ?? ?? ?? 48 85 FF 74 ?? 80 7C 1F ?? ?? 48 8D 5B ?? 75 ?? 48 8D 53
            ?? 48 8B CF E8 ?? ?? ?? ?? 48 8B 4C 24 ?? BB ?? ?? ?? ?? 48 89 01 EB ?? 8B 5C 24 ??
            EB ?? 8B DF EB ?? 8B DE 48 8D 4C 24 ?? E8 ?? ?? ?? ?? 4D 85 ED 74 ?? FF 15 ?? ?? ??
            ?? 4D 8B C5 33 D2 48 8B C8 FF 15 ?? ?? ?? ?? 48 85 F6 74 ?? FF 15 ?? ?? ?? ?? 4C 8B
            C6 33 D2 48 8B C8 FF 15 ?? ?? ?? ?? 48 85 FF 74 ?? FF 15 ?? ?? ?? ?? 4C 8B C7 33 D2
            48 8B C8 FF 15 ?? ?? ?? ?? 8B C3 48 8B 8C 24 ?? ?? ?? ?? 48 33 CC E8 ?? ?? ?? ?? 48
            81 C4 ?? ?? ?? ?? 41 5F 41 5E 41 5D 41 5C 5F 5E 5D 5B C3
        }

        $network_communication_p1 = {
            40 53 56 57 41 54 41 56 41 57 48 83 EC ?? 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24
            ?? 8B 35 ?? ?? ?? ?? 48 8B F9 48 8D 0D ?? ?? ?? ?? 4D 8B E1 4D 8B F8 4C 8B F2 E8 ??
            ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 75 ?? 48 8D 0D ?? ?? ?? ?? E8 ??
            ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B D8 48 8D 0D ?? ?? ?? ?? 48 89 6C 24 ?? E8 ??
            ?? ?? ?? 48 8B D0 48 8B CB FF 15 ?? ?? ?? ?? 33 DB 48 85 C0 0F 84 ?? ?? ?? ?? 45 33
            C9 89 5C 24 ?? 45 33 C0 48 8D 0D ?? ?? ?? ?? 8B D6 FF D0 48 89 07 48 8B E8 48 85 C0
            0F 84 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B
            F0 48 85 C0 75 ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B
            F0 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B D0 48 8B CE FF 15 ?? ?? ?? ?? 48 85 C0
            0F 84 ?? ?? ?? ?? 41 B8 ?? ?? ?? ?? 45 33 C9 49 8B D6 48 8B CD FF D0 48 89 47 ?? 48
        }

        $network_communication_p2 = {
            8B E8 48 85 C0 0F 84 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B C8 E8 ??
            ?? ?? ?? 48 8B F0 48 85 C0 75 ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B C8 E8 ??
            ?? ?? ?? 48 8B F0 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B D0 48 8B CE FF 15 ?? ??
            ?? ?? 48 85 C0 74 ?? C7 44 24 ?? ?? ?? ?? ?? 45 33 C9 48 89 5C 24 ?? 4D 8B C7 49 8B
            D4 48 89 5C 24 ?? 48 8B CD FF D0 48 8B D8 48 8D 0D ?? ?? ?? ?? 48 89 5F ?? C7 44 24
            ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 75 ?? 48 8D
            0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B F8 48 8D 0D ?? ?? ?? ??
            E8 ?? ?? ?? ?? 48 8B D0 48 8B CF FF 15 ?? ?? ?? ?? 48 85 C0 74 ?? 41 B9 ?? ?? ?? ??
            4C 8D 44 24 ?? 48 8B CB 41 8D 51 ?? FF D0 B8 ?? ?? ?? ?? EB ?? 48 89 5F ?? EB ?? 48
            89 1F 33 C0 48 8B 6C 24 ?? 48 8B 4C 24 ?? 48 33 CC E8 ?? ?? ?? ?? 48 83 C4 ?? 41 5F
            41 5E 41 5C 5F 5E 5B C3
        }

        $download_data_from_c2_p1 = {
            4C 8B DC 55 56 57 49 8D AB ?? ?? ?? ?? 48 81 EC ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48
            33 C4 48 89 85 ?? ?? ?? ?? 49 89 5B ?? 33 FF 4D 89 63 ?? 48 8B D9 4D 89 6B ?? 48 8D
            0D ?? ?? ?? ?? 4D 8B E8 4D 89 73 ?? 0F 57 C0 4D 89 7B ?? 33 C0 4C 8D 67 ?? 4D 8B C1
            48 89 44 24 ?? 0F 11 44 24 ?? 8B F7 E8 ?? ?? ?? ?? 48 89 44 24 ?? 4C 8B F8 48 85 C0
            0F 84 ?? ?? ?? ?? 4C 8D 0D ?? ?? ?? ?? 4C 8B C0 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 ??
            E8 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 33 D2 48 8D 4D ?? 41 B8 ?? ?? ?? ?? E8 ?? ??
            ?? ?? 4C 8B CB 4C 8D 05 ?? ?? ?? ?? BA ?? ?? ?? ?? 48 8D 4D ?? E8 ?? ?? ?? ?? 48 8D
            45 ?? 49 8B DC 0F 1F 80 ?? ?? ?? ?? 48 FF C3 66 39 34 58 75 ?? 48 8D 0D ?? ?? ?? ??
            E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 4C 8B F0 48 85 C0 75 ?? 48 8D 0D ?? ?? ?? ??
            E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 4C 8B F0 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ??
            48 8B D0 49 8B CE FF 15 ?? ?? ?? ?? 48 85 C0 0F 84 ?? ?? ?? ?? 4C 8B 7C 24 ?? 48 8D
            55 ?? 49 8B CF 41 B9 ?? ?? ?? ?? 44 8B C3 FF D0 85 C0 0F 84 ?? ?? ?? ?? 48 8D 0D ??
            ?? ?? ?? E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 75 ?? 48 8D 0D ??
            ?? ?? ?? E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B D8 48 8D 0D ?? ?? ?? ?? E8 ??
            ?? ?? ?? 48 8B D0 48 8B CB E8 ?? ?? ?? ?? 48 85 C0 0F 84 ?? ?? ?? ?? 48 89 7C 24 ??
            45 33 C9 C7 44 24 ?? ?? ?? ?? ?? 45 33 C0 BA ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 49
            8B CD FF D0 4C 8B E0 48 83 F8 ?? 0F 84 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ??
            ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 75 ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ??
            ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B D8 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B D0 48
        }

        $download_data_from_c2_p2 = {
            8B CB FF 15 ?? ?? ?? ?? 48 85 C0 0F 84 ?? ?? ?? ?? 48 89 7C 24 ?? 45 33 C9 89 7C 24
            ?? 45 33 C0 33 D2 89 7C 24 ?? 49 8B CF FF D0 85 C0 0F 84 ?? ?? ?? ?? 48 8D 0D ?? ??
            ?? ?? 89 7C 24 ?? 89 7C 24 ?? 89 7C 24 ?? 89 7C 24 ?? C7 44 24 ?? ?? ?? ?? ?? 89 7C
            24 ?? E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 75 ?? 48 8D 0D ?? ??
            ?? ?? E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B D8 48 8D 0D ?? ?? ?? ?? E8 ?? ??
            ?? ?? 48 8B D0 48 8B CB FF 15 ?? ?? ?? ?? 48 85 C0 0F 84 ?? ?? ?? ?? 33 D2 49 8B CF
            FF D0 85 C0 0F 84 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ??
            ?? ?? 48 8B D8 48 85 C0 75 ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ??
            ?? ?? 48 8B D8 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B D0 48 8B CB FF 15 ?? ?? ??
            ?? 48 85 C0 0F 84 ?? ?? ?? ?? 48 8D 4C 24 ?? 45 33 C0 48 89 4C 24 ?? 4C 8D 4C 24 ??
            48 8D 4C 24 ?? BA ?? ?? ?? ?? 48 89 4C 24 ?? 49 8B CF FF D0 85 C0 0F 84 ?? ?? ?? ??
            8B 5C 24 ?? FF 15 ?? ?? ?? ?? 44 8B C3 BA ?? ?? ?? ?? 48 8B C8 FF 15 ?? ?? ?? ?? 48
            8B F0 48 85 C0 0F 84 ?? ?? ?? ?? 90 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B C8 E8
            ?? ?? ?? ?? 48 8B D8 48 85 C0 75 ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B C8 E8
            ?? ?? ?? ?? 48 8B D8 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B D0 48 8B CB FF 15 ??
            ?? ?? ?? 48 85 C0 0F 84 ?? ?? ?? ?? 48 8D 54 24 ?? 49 8B CF FF D0 85 C0 0F 84 ?? ??
            ?? ?? 44 8B 74 24 ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48
        }

        $download_data_from_c2_p3 = {
            8B D8 48 85 C0 75 ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48
            8B D8 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B D0 48 8B CB FF 15 ?? ?? ?? ?? 48 85
            C0 0F 84 ?? ?? ?? ?? 4C 8D 4C 24 ?? 45 8B C6 48 8B D6 49 8B CF FF D0 85 C0 74 ?? 44
            8B 74 24 ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B D8 48
            85 C0 75 ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B D8 48
            8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B D0 48 8B CB FF 15 ?? ?? ?? ?? 48 85 C0 74 ??
            4C 8D 4C 24 ?? 48 89 7C 24 ?? 45 8B C6 48 8B D6 49 8B CC FF D0 85 C0 74 ?? 39 7C 24
            ?? 0F 87 ?? ?? ?? ?? BF ?? ?? ?? ?? 4C 8B 7C 24 ?? 48 8D 4C 24 ?? 44 8B F7 E8 ?? ??
            ?? ?? 4D 85 E4 74 ?? 49 83 FC ?? 74 ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B C8
            E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 75 ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B C8
            E8 ?? ?? ?? ?? 48 8B F8 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B D0 48 8B CF E8 ??
            ?? ?? ?? 41 8B FE 48 85 C0 74 ?? 49 8B CC FF D0 4D 85 FF 74 ?? FF 15 ?? ?? ?? ?? 4D
            8B C7 33 D2 48 8B C8 FF 15 ?? ?? ?? ?? 4C 8B BC 24 ?? ?? ?? ?? 4C 8B B4 24 ?? ?? ??
            ?? 4C 8B AC 24 ?? ?? ?? ?? 4C 8B A4 24 ?? ?? ?? ?? 48 8B 9C 24 ?? ?? ?? ?? 48 85 F6
            74 ?? FF 15 ?? ?? ?? ?? 4C 8B C6 33 D2 48 8B C8 FF 15 ?? ?? ?? ?? 8B C7 48 8B 8D ??
            ?? ?? ?? 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 ?? ?? ?? ?? 5F 5E 5D C3
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            all of ($decrypt_configuration_p*)
        ) and
        (
            $decryption_algorithm
        ) and
        (
            all of ($request_access_token_p*)
        ) and
        (
            all of ($network_communication_p*)
        ) and
        (
            all of ($download_data_from_c2_p*)
        )
}