rule Win64_Backdoor_SideTwist : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "SIDETWIST"
        description         = "Yara rule that detects SideTwist backdoor."

        tc_detection_type   = "Backdoor"
        tc_detection_name   = "SideTwist"
        tc_detection_factor = 5

    strings:

        $anti_sandbox_detect_environment = {
            55 57 56 53 48 81 EC ?? ?? ?? ?? 48 8D AC 24 ?? ?? ?? ?? 89 4D ?? 48 89 55 ?? E8 ??
            ?? ?? ?? 48 C7 45 ?? ?? ?? ?? ?? 48 C7 45 ?? ?? ?? ?? ?? 48 8D 55 ?? 48 8D 45 ?? 4C
            8D 05 ?? ?? ?? ?? 48 89 C1 48 8B 05 ?? ?? ?? ?? FF D0 85 C0 75 ?? 48 8B 45 ?? 48 85
            C0 74 ?? B8 ?? ?? ?? ?? EB ?? B8 ?? ?? ?? ?? 84 C0 0F 84 ?? ?? ?? ?? 48 8D 45 ?? 48
            89 C1 E8 ?? ?? ?? ?? 48 8B 55 ?? 48 8D 4D ?? 48 8D 45 ?? 49 89 C8 48 89 C1 E8 ?? ??
            ?? ?? 48 8D 45 ?? 48 8D 55 ?? 4C 8D 05 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 45
            ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 45 ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8B 45 ?? 48 89 C1
            E8 ?? ?? ?? ?? 48 8D 45 ?? 48 89 C1 E8 ?? ?? ?? ?? 48 89 C1 48 8B 05 ?? ?? ?? ?? FF
            D0 85 C0 0F 94 C0 84 C0 74 ?? 48 8D 05 ?? ?? ?? ?? 48 89 C1 48 8B 05 ?? ?? ?? ?? FF
            D0 BB ?? ?? ?? ?? BE ?? ?? ?? ?? EB
        }

        $collect_host_information = {
            55 53 48 81 EC ?? ?? ?? ?? 48 8D AC 24 ?? ?? ?? ?? 48 89 4D ?? 48 89 55 ?? C7 45 ??
            ?? ?? ?? ?? 8B 45 ?? 89 C0 48 BA ?? ?? ?? ?? ?? ?? ?? ?? 48 39 C2 72 ?? 48 01 C0 48
            89 C1 E8 ?? ?? ?? ?? 48 89 45 ?? 48 8D 45 ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 55 ?? 48
            8B 45 ?? 49 89 D0 48 8D 15 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? EB ?? E8 ?? ?? ?? ??
            48 8D 45 ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 55 ?? 48 8B 45 ?? 49 89 D0 48 89 C2 B9 ??
            ?? ?? ?? 48 8B 05 ?? ?? ?? ?? FF D0 85 C0 0F 95 C0 84 C0 0F 84 ?? ?? ?? ?? 48 8D 45
            ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 4D ?? 48 8B 55 ?? 48 8D 45 ?? 49 89 C8 48 89 C1 E8
            ?? ?? ?? ?? 48 8D 45 ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 45 ?? 48 89 C1 E8 ?? ?? ?? ??
            48 8D 45 ?? 48 89 C1 E8 ?? ?? ?? ?? 48 89 C3 48 8D 45 ?? 48 89 C1 E8 ?? ?? ?? ?? 48
            89 C2 48 8D 4D ?? 48 8D 45 ?? 49 89 C9 49 89 D8 48 89 C1 E8 ?? ?? ?? ?? 48 8D 45 ??
            48 8D 55 ?? 41 B9 ?? ?? ?? ?? 41 B8 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 55 ??
            48 8B 45 ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 45 ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 45 ??
            48 89 C1 E8 ?? ?? ?? ?? 48 8D 45 ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 45 ?? 48 89 C1 E8
            ?? ?? ?? ?? 48 8B 45 ?? 48 89 C1 E8 ?? ?? ?? ?? 84 C0 74 ?? 48 8B 45 ?? 48 8D 15 ??
            ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 83 7D ?? ?? 0F 84 ?? ?? ?? ?? 48 8B 45 ?? 48 89
            C1 E8 ?? ?? ?? ?? EB ?? 48 89 C3 48 8D 45 ?? 48 89 C1 E8 ?? ?? ?? ?? 48 89 D8 48 89
            C1 E8 ?? ?? ?? ?? 48 89 C3 48 8D 45 ?? 48 89 C1 E8 ?? ?? ?? ?? EB ?? 48 89 C3 48 8D
            45 ?? 48 89 C1 E8 ?? ?? ?? ?? EB ?? 48 89 C3 48 8D 45 ?? 48 89 C1 E8 ?? ?? ?? ?? 48
            8D 45 ?? 48 89 C1 E8 ?? ?? ?? ?? EB ?? 48 89 C3 48 8B 45 ?? 48 89 C1 E8 ?? ?? ?? ??
            48 89 D8 48 89 C1 E8 ?? ?? ?? ?? 90 48 8B 45 ?? 48 81 C4 ?? ?? ?? ?? 5B 5D C3
        }

        $contact_c2_server = {
            55 53 48 81 EC ?? ?? ?? ?? 48 8D AC 24 ?? ?? ?? ?? 48 89 4D ?? 48 89 55 ?? 48 8D 45
            ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 55 ?? 48 8D 85 ?? ?? ?? ?? 49 89 D0 48 8D 15 ?? ??
            ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8B 45 ?? 48 8D 50 ?? 48 8D 45 ?? 48 89 C1 E8 ?? ??
            ?? ?? 48 8B 55 ?? 48 8D 45 ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 4C 8D 45
            ?? 48 8B 55 ?? 48 8D 8D ?? ?? ?? ?? 48 89 4C 24 ?? 48 8D 4D ?? 48 89 4C 24 ?? 4D 89
            C1 4C 8D 05 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 45 ?? 48 89 C1 E8 ?? ?? ?? ??
            48 8D 45 ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48
            8D 45 ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 89 C1
            E8 ?? ?? ?? ?? 85 C0 0F 95 C0 84 C0 74 ?? 48 8D 85 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ??
            ?? 48 8D 95 ?? ?? ?? ?? 48 8D 45 ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8B 4D ?? 48 8D 55 ??
            48 8B 45 ?? 49 89 C8 48 89 C1 E8 ?? ?? ?? ?? 48 8D 45 ?? 48 89 C1 E8 ?? ?? ?? ?? BB
            ?? ?? ?? ?? EB ?? BB ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 89 D8
            EB ?? 48 89 C3 48 8D 45 ?? 48 89 C1 E8 ?? ?? ?? ?? EB ?? 48 89 C3 48 8D 45 ?? 48 89
            C1 E8 ?? ?? ?? ?? EB ?? 48 89 C3 48 8D 85 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? EB ??
            48 89 C3 48 8D 45 ?? 48 89 C1 E8 ?? ?? ?? ?? 48 89 D8 48 89 C1 E8 ?? ?? ?? ?? 48 89
            C3 48 8D 45 ?? 48 89 C1 E8 ?? ?? ?? ?? EB ?? 48 89 C3 48 8D 85 ?? ?? ?? ?? 48 89 C1
            E8 ?? ?? ?? ?? 48 89 D8 48 89 C1 E8 ?? ?? ?? ?? 48 81 C4 ?? ?? ?? ?? 5B 5D C3
        }

        $parse_c2_response = {
            55 53 48 83 EC ?? 48 8D 6C 24 ?? 48 89 4D ?? 48 8D 45 ?? 48 89 C1 E8 ?? ?? ?? ?? 48
            8D 55 ?? 48 8D 45 ?? 49 89 D0 48 8D 15 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 45
            ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 55 ?? 48 8B 45 ?? 41 B8 ?? ?? ?? ?? 48 89 C1 E8 ??
            ?? ?? ?? 48 89 45 ?? 48 8B 45 ?? 41 B8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 89 C1 E8
            ?? ?? ?? ?? 48 89 45 ?? 48 8B 45 ?? 48 89 C1 E8 ?? ?? ?? ?? 48 89 C1 48 8B 55 ?? 48
            8B 45 ?? 49 89 C8 48 89 C1 E8 ?? ?? ?? ?? 48 8D 45 ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8B
            55 ?? 48 01 C2 48 8B 45 ?? 49 89 D0 BA ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 45
            ?? 48 89 C1 E8 ?? ?? ?? ?? EB ?? 48 89 C3 48 8D 45 ?? 48 89 C1 E8 ?? ?? ?? ?? 48 89
            D8 48 89 C1 E8 ?? ?? ?? ?? 48 89 C3 48 8D 45 ?? 48 89 C1 E8 ?? ?? ?? ?? 48 89 D8 48
            89 C1 E8 ?? ?? ?? ?? 90 48 83 C4 ?? 5B 5D C3
        }

        $download_file_from_c2_p1 = {
            55 53 48 81 EC ?? ?? ?? ?? 48 8D AC 24 ?? ?? ?? ?? 48 89 4D ?? 48 89 55 ?? 4C 89 45
            ?? 4C 89 4D ?? 48 8D 85 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8B 5D ?? 48 8B 55 ??
            48 8D 85 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 95 ?? ?? ?? ?? 48 8D 85 ?? ?? ??
            ?? 49 89 D0 48 89 C2 48 89 D9 E8 ?? ?? ?? ?? 85 C0 0F 95 C0 88 45 ?? 48 8D 85 ?? ??
            ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 0F B6 45 ?? 83 F0 ?? 84 C0 0F 84 ?? ?? ?? ?? 48 8D 85
            ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 89 45 ?? 48 8B 45 ?? 48 89 C1 E8 ?? ?? ?? ??
            48 89 C2 48 8D 85 ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 89 C1 48 8B 05 ?? ?? ?? ?? FF
            D0 89 45 ?? 83 7D ?? ?? 0F 95 C0 84 C0 74 ?? 48 8D 45 ?? 48 89 C1 E8 ?? ?? ?? ?? 48
            8D 55 ?? 48 8B 45 ?? 49 89 D0 48 8D 15 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 45
            ?? 48 89 C1 E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 48 8B 9D ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ??
            48 89 C1 E8 ?? ?? ?? ?? 48 89 C2 48 8B 45 ?? 49 89 D9 49 89 D0 BA ?? ?? ?? ?? 48 89
            C1 E8 ?? ?? ?? ?? 48 8B 85 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? EB ?? 48 8D 45 ?? 48
        }

        $download_file_from_c2_p2 = {
            89 C1 E8 ?? ?? ?? ?? 48 8D 55 ?? 48 8B 45 ?? 49 89 D0 48 8D 15 ?? ?? ?? ?? 48 89 C1
            E8 ?? ?? ?? ?? 48 8D 45 ?? 48 89 C1 E8 ?? ?? ?? ?? EB ?? 48 8D 45 ?? 48 8B 55 ?? 49
            89 D0 48 8D 15 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 45 ?? 48 8D 55 ?? 4C 8D 05
            ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8B 45 ?? 48 8B 4D ?? 48 8D 55 ?? 49 89 C8 48
            89 C1 E8 ?? ?? ?? ?? 90 48 8D 45 ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 45 ?? 48 89 C1 E8
            ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? EB ?? 48 89 C3 48 8D 85 ??
            ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? EB ?? 48 89 C3 48 8D 45 ?? 48 89 C1 E8 ?? ?? ?? ??
            EB ?? 48 89 C3 48 8D 45 ?? 48 89 C1 E8 ?? ?? ?? ?? EB ?? 48 89 C3 48 8D 45 ?? 48 89
            C1 E8 ?? ?? ?? ?? EB ?? 48 89 C3 48 8D 45 ?? 48 89 C1 E8 ?? ?? ?? ?? EB ?? 48 89 C3
            48 8D 85 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 89 D8 48 89 C1 E8 ?? ?? ?? ?? 48 8B
            45 ?? 48 81 C4 ?? ?? ?? ?? 5B 5D C3
        }

        $reply_to_c2_server = {
            55 53 48 81 EC ?? ?? ?? ?? 48 8D AC 24 ?? ?? ?? ?? 48 89 4D ?? 48 89 55 ?? 4C 89 45
            ?? 4C 89 4D ?? 48 8B 55 ?? 48 8B 45 ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ??
            48 8B 55 ?? 41 B8 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 45 ?? 48 8B 55 ?? 49 89
            D0 48 8D 15 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 45 ?? 48 8D 55 ?? 4C 8D 05 ??
            ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 45 ?? 48 8D 8D ?? ?? ?? ?? 48 8D 55 ?? 49 89
            C8 48 89 C1 E8 ?? ?? ?? ?? 48 8D 45 ?? 48 8D 55 ?? 4C 8D 05 ?? ?? ?? ?? 48 89 C1 E8
            ?? ?? ?? ?? 48 8D 55 ?? 48 8B 45 ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 45 ?? 48 89 C1 E8
            ?? ?? ?? ?? 48 8D 45 ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 45 ?? 48 89 C1 E8 ?? ?? ?? ??
            48 8D 45 ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? EB
            ?? 48 89 C3 48 8D 45 ?? 48 89 C1 E8 ?? ?? ?? ?? EB ?? 48 89 C3 48 8D 45 ?? 48 89 C1
            E8 ?? ?? ?? ?? EB ?? 48 89 C3 48 8D 45 ?? 48 89 C1 E8 ?? ?? ?? ?? EB ?? 48 89 C3 48
            8D 85 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 89 D8 48 89 C1 E8 ?? ?? ?? ?? 90 48 81
            C4 ?? ?? ?? ?? 5B 5D C3
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            $anti_sandbox_detect_environment
        ) and
        (
            $collect_host_information
        ) and
        (
            $contact_c2_server
        ) and
        (
            $parse_c2_response
        ) and
        (
            all of ($download_file_from_c2_p*)
        ) and
        (
            $reply_to_c2_server
        )
}