rule Linux_Trojan_ChinaZ : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "CHINAZ"
        description         = "Yara rule that detects ChinaZ trojan."

        tc_detection_type   = "Trojan"
        tc_detection_name   = "ChinaZ"
        tc_detection_factor = 5

    strings:

        $collect_system_information_32_p1 = {
            55 57 56 53 81 EC ?? ?? ?? ?? 8D 5C 24 ?? 89 1C 24 E8 ?? ?? ?? ?? 8D 84 24 ?? ?? ??
            ?? 89 44 24 ?? 89 5C 24 ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 04 24
            ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24
            ?? ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 31 31 C9 89 C6 8D 44 24 ?? 31
            FF C7 44 24 ?? ?? ?? ?? ?? 01 CE 89 04 24 11 D7 E8 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ??
            E8 ?? ?? ?? ?? 0F 31 89 C1 31 C0 31 DB 01 C1 8D 44 24 ?? 11 D3 C7 44 24 ?? ?? ?? ??
            ?? 89 04 24 89 4C 24 ?? E8 ?? ?? ?? ?? 8B 4C 24 ?? 8B 44 24 ?? C7 04 24 ?? ?? ?? ??
            29 F1 19 FB 31 ED 2B 44 24 ?? 89 4C 24 ?? 8D B4 24 ?? ?? ?? ?? 89 5C 24 ?? 89 F7 69
            C0 ?? ?? ?? ?? DF 6C 24 ?? 03 44 24 ?? 2B 44 24 ?? D9 7C 24 ?? 89 44 24 ?? DB 44 24
            ?? DE F9 0F B7 44 24 ?? B4 ?? 66 89 44 24 ?? D9 6C 24 ?? DB 5C 24 ?? D9 6C 24 ?? 8B
            5C 24 ?? E8 ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 89 5C 24 ??
            8D 9C 24 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? 89 44 24 ?? E8 ?? ?? ?? ?? A1
        }

        $collect_system_information_32_p2 = {
            C7 04 24 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? C7 44 24 ?? ?? ??
            ?? ?? C7 04 24 ?? ?? ?? ?? 89 44 24 ?? E8 ?? ?? ?? ?? 89 E8 B9 ?? ?? ?? ?? F3 AB 89
            DF B1 ?? F3 AB 89 DF 89 5C 24 ?? 89 74 24 ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D
            44 24 ?? 89 44 24 ?? C7 44 24 ?? ?? ?? ?? ?? 89 1C 24 C7 44 24 ?? ?? ?? ?? ?? E8 ??
            ?? ?? ?? 8B 54 24 ?? 89 E8 B9 ?? ?? ?? ?? F3 AB 89 F7 C7 44 24 ?? ?? ?? ?? ?? 89 D0
            C1 F8 ?? C1 E8 ?? 01 D0 C1 F8 ?? 89 44 24 ?? 89 1C 24 89 44 24 ?? E8 ?? ?? ?? ?? C7
            44 24 ?? ?? ?? ?? ?? 89 5C 24 ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 04 24 ?? ??
            ?? ?? E8 ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? 89 C2 A1 ?? ?? ??
            ?? 89 54 24 ?? 89 44 24 ?? E8 ?? ?? ?? ?? 89 E8 B9 ?? ?? ?? ?? F3 AB 89 DF B1 ?? F3
            AB 89 5C 24 ?? 89 74 24 ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 54 24 ?? 85 D2 0F
            85 ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 89 5C 24 ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ??
            ?? A1 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 04 24 ?? ?? ??
            ?? E8 ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 04
            24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 44 24 ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ??
            ?? ?? C7 44 24 ?? ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 81 C4 ?? ?? ?? ?? 5B 5E 5F 5D
            C3
        }

        $send_system_info_32 = {
            57 56 53 81 EC ?? ?? ?? ?? 8D 5C 24 ?? 89 1C 24 E8 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ??
            89 44 24 ?? 89 5C 24 ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 04 24 ??
            ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ??
            0F 31 31 C9 89 C6 8D 44 24 ?? 31 FF C7 44 24 ?? ?? ?? ?? ?? 01 CE 89 04 24 11 D7 E8
            ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 31 89 C1 31 C0 31 DB 01 C1 8D 44
            24 ?? 11 D3 C7 44 24 ?? ?? ?? ?? ?? 89 04 24 89 4C 24 ?? E8 ?? ?? ?? ?? 8B 4C 24 ??
            8B 44 24 ?? C7 04 24 ?? ?? ?? ?? 29 F1 19 FB 2B 44 24 ?? 89 4C 24 ?? 89 5C 24 ?? 69
            C0 ?? ?? ?? ?? DF 6C 24 ?? 03 44 24 ?? 2B 44 24 ?? D9 7C 24 ?? 89 44 24 ?? DB 44 24
            ?? DE F9 0F B7 44 24 ?? B4 ?? 66 89 44 24 ?? D9 6C 24 ?? DB 5C 24 ?? D9 6C 24 ?? 8B
            5C 24 ?? E8 ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 89 5C 24 ??
            C7 04 24 ?? ?? ?? ?? 89 44 24 ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? C7
            44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 89 54 24 ?? 89 44 24 ?? C7 04 24 ?? ??
            ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ??
            89 04 24 E8 ?? ?? ?? ?? 81 C4 ?? ?? ?? ?? B8 ?? ?? ?? ?? 5B 5E 5F C3
        }

        $parse_c2_commands_32 = {
            55 31 C0 57 B9 ?? ?? ?? ?? 56 53 81 EC ?? ?? ?? ?? 8D 9C 24 ?? ?? ?? ?? 0F B6 94 24
            ?? ?? ?? ?? 89 DF F3 AB C7 04 24 ?? ?? ?? ?? 88 94 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D
            84 24 ?? ?? ?? ?? 89 84 24 ?? ?? ?? ?? 83 E0 ?? 89 84 24 ?? ?? ?? ?? 90 A1 ?? ?? ??
            ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 89 5C 24 ?? 89 04 24 E8 ?? ?? ??
            ?? 85 C0 0F 84 ?? ?? ?? ?? 8B B4 24 ?? ?? ?? ?? 85 F6 0F 84 ?? ?? ?? ?? 89 74 24 ??
            C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 84 24 ?? ?? ?? ?? 83 F8 ?? 74 ?? 83 F8 ?? 0F
            84 ?? ?? ?? ?? 83 FE ?? 0F 84 ?? ?? ?? ?? 83 FE ?? 0F 84 ?? ?? ?? ?? 83 F8 ?? 0F 84
            ?? ?? ?? ?? 83 FE ?? 0F 84 ?? ?? ?? ?? 83 FE ?? 0F 84 ?? ?? ?? ?? 83 FE ?? 0F 84 ??
            ?? ?? ?? 83 FE ?? 0F 85 ?? ?? ?? ?? 31 C0 B9 ?? ?? ?? ?? 8D BC 24 ?? ?? ?? ?? F3 AB
            8D B4 24 ?? ?? ?? ?? B0 ?? 8D BC 24 ?? ?? ?? ?? 8D 94 24 ?? ?? ?? ?? B1 ?? F3 A5 89
            D6 8B BC 24 ?? ?? ?? ?? F7 C7 ?? ?? ?? ?? 0F 85 ?? ?? ?? ?? F7 C7 ?? ?? ?? ?? 0F 85
            ?? ?? ?? ?? 89 C1 C1 E9 ?? A8 ?? F3 A5 0F 85 ?? ?? ?? ?? A8 ?? 0F 85 ?? ?? ?? ?? 89
            54 24 ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ??
            81 C4 ?? ?? ?? ?? B8 ?? ?? ?? ?? 5B 5E 5F 5D C3
        }

        $dns_flood_32_p1 = {
            55 57 56 53 81 EC ?? ?? ?? ?? 83 3D ?? ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 8D 5C 24 ?? 8B
            B4 24 ?? ?? ?? ?? B8 ?? ?? ?? ?? F6 C3 ?? 89 DF 0F 85 ?? ?? ?? ?? 89 C1 C1 E9 ?? A8
            ?? F3 A5 0F 85 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8D B4 24 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ??
            89 F7 89 44 24 ?? E8 ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7
            44 24 ?? ?? ?? ?? ?? 66 C7 44 24 ?? ?? ?? 66 C7 44 24 ?? ?? ?? E8 ?? ?? ?? ?? 31 D2
            C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? F7 35 ?? ?? ??
            ?? 8B 04 95 ?? ?? ?? ?? 89 44 24 ?? E8 ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 89 C5 8D
            44 24 ?? 89 44 24 ?? 89 2C 24 E8 ?? ?? ?? ?? 31 C0 B9 ?? ?? ?? ?? F3 AB 8D 54 24 ??
            89 14 24 C7 44 24 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 44 24 ?? 89 5C 24 ?? 89 84 24 ??
            ?? ?? ?? 0F B7 44 24 ?? 66 89 84 24 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 89 04 24 E8 ??
            ?? ?? ?? 8D 94 24 ?? ?? ?? ?? 89 14 24 89 74 24 ?? 89 54 24 ?? C6 84 24 ?? ?? ?? ??
            ?? C6 84 24 ?? ?? ?? ?? ?? 66 C7 84 24 ?? ?? ?? ?? ?? ?? 66 C7 84 24 ?? ?? ?? ?? ??
            ?? 66 C7 84 24 ?? ?? ?? ?? ?? ?? 66 C7 84 24 ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 54
        }

        $dns_flood_32_p2 = {
            24 ?? 89 D1 8B 39 83 C1 ?? 8D 87 ?? ?? ?? ?? F7 D7 21 F8 25 ?? ?? ?? ?? 74 ?? A9 ??
            ?? ?? ?? 0F 84 ?? ?? ?? ?? 00 C0 89 D7 83 D9 ?? 29 D1 8D 84 0C ?? ?? ?? ?? 66 C7 00
            ?? ?? 66 C7 40 ?? ?? ?? 8B 0F 83 C7 ?? 8D 81 ?? ?? ?? ?? F7 D1 21 C8 25 ?? ?? ?? ??
            74 ?? A9 ?? ?? ?? ?? 75 ?? C1 E8 ?? 83 C7 ?? 00 C0 8D 44 24 ?? 83 DF ?? C7 44 24 ??
            ?? ?? ?? ?? 29 D7 89 04 24 89 54 24 ?? E8 ?? ?? ?? ?? 8B 44 24 ?? 8B 54 24 ?? 89 74
            24 ?? 89 84 24 ?? ?? ?? ?? 0F B7 44 24 ?? 89 14 24 66 89 84 24 ?? ?? ?? ?? E8 ?? ??
            ?? ?? 8D 94 24 ?? ?? ?? ?? 89 5C 24 ?? 89 14 24 E8 ?? ?? ?? ?? 8B 84 24 ?? ?? ?? ??
            83 B8 ?? ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? 83 C7 ?? 89 C2
            C1 FA ?? F7 F9 8D 42 ?? 66 C1 C8 ?? 66 89 84 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 31 D2 C7
            44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 89 7C 24 ?? 89 2C 24 F7 35 ?? ?? ?? ??
            8B 04 95 ?? ?? ?? ?? 8D 94 24 ?? ?? ?? ?? 89 54 24 ?? 89 44 24 ?? 8D 44 24 ?? 89 44
            24 ?? E8 ?? ?? ?? ?? 8B 84 24 ?? ?? ?? ?? 83 80 ?? ?? ?? ?? ?? 83 90 ?? ?? ?? ?? ??
            83 3D ?? ?? ?? ?? ?? 74 ?? C7 04 24 ?? ?? ?? ?? E8
        }

        $collect_system_information_64_p1 = {
            41 55 41 54 55 53 48 81 EC ?? ?? ?? ?? 48 8D 7C 24 ?? E8 ?? ?? ?? ?? 4C 8D 84 24 ??
            ?? ?? ?? 48 8D 4C 24 ?? BA ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? 31 C0 E8 ?? ??
            ?? ?? B9 ?? ?? ?? ?? BA ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? 31 C0 E8 ?? ?? ??
            ?? 0F 31 48 89 D3 48 8D 7C 24 ?? 31 F6 48 C1 E3 ?? 89 C0 48 01 C3 E8 ?? ?? ?? ?? BF
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 31 48 89 D5 48 8D 7C 24 ?? 31 F6 48 C1 E5 ?? 89 C0 45
            31 E4 48 01 C5 E8 ?? ?? ?? ?? 48 8B 44 24 ?? 48 2B 44 24 ?? 48 29 DD 48 8B 54 24 ??
            2B 54 24 ?? BF ?? ?? ?? ?? F2 48 0F 2A C5 48 8D AC 24 ?? ?? ?? ?? 69 C0 ?? ?? ?? ??
            01 D0 F2 0F 2A C8 F2 0F 5E C1 F2 0F 2C D8 E8 ?? ?? ?? ?? BA ?? ?? ?? ?? 89 C1 BE ??
            ?? ?? ?? BF ?? ?? ?? ?? 31 C0 41 89 D8 48 8D 9C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 05
            ?? ?? ?? ?? BF ?? ?? ?? ?? 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? BE
            ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 4C 89 E0 B9 ?? ?? ?? ?? 48 89 EF F3 48 AB
        }

        $collect_system_information_64_p2 = {
            48 89 DF 48 89 DA 48 89 EE B1 ?? F3 48 AB BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 54 24
            ?? BE ?? ?? ?? ?? 48 89 DF 31 C0 C7 44 24 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 4C 89 E0 B9
            ?? ?? ?? ?? 48 89 DF F3 48 AB 8B 44 24 ?? BE ?? ?? ?? ?? 48 89 DF 8D 90 ?? ?? ?? ??
            85 C0 0F 49 D0 31 C0 C1 FA ?? 89 54 24 ?? E8 ?? ?? ?? ?? BA ?? ?? ?? ?? 48 89 DE BF
            ?? ?? ?? ?? E8 ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? BE ??
            ?? ?? ?? BF ?? ?? ?? ?? 41 89 C5 E8 ?? ?? ?? ?? 4C 89 E0 B9 ?? ?? ?? ?? 48 89 EF F3
            48 AB 48 89 DF 48 89 DA 48 89 EE B1 ?? F3 48 AB BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 45 85
            ED 75 ?? BA ?? ?? ?? ?? 48 89 DE BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 3D ?? ?? ?? ??
            E8 ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? 31 C0 E8 ?? ?? ?? ?? BE ?? ?? ?? ?? BF
            ?? ?? ?? ?? 31 C0 E8 ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 7C 24 ?? 31 C9
            BA ?? ?? ?? ?? 31 F6 E8 ?? ?? ?? ?? 48 81 C4 ?? ?? ?? ?? 5B 5D 41 5C 41 5D C3
        }

        $send_system_info_64 = {
            55 53 48 81 EC ?? ?? ?? ?? 48 8D 7C 24 ?? E8 ?? ?? ?? ?? 4C 8D 84 24 ?? ?? ?? ?? 48
            8D 4C 24 ?? BA ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? 31 C0 E8 ?? ?? ?? ?? BE ??
            ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 31 48 89 D3 31 F6 48 89 E7 48 C1 E3 ?? 89
            C0 48 01 C3 E8 ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 31 48 89 D5 48 8D 7C 24
            ?? 31 F6 89 C0 48 C1 E5 ?? 48 01 C5 E8 ?? ?? ?? ?? 48 8B 44 24 ?? 48 2B 04 24 48 29
            DD 48 8B 54 24 ?? 2B 54 24 ?? BF ?? ?? ?? ?? F2 48 0F 2A C5 69 C0 ?? ?? ?? ?? 01 D0
            F2 0F 2A C8 F2 0F 5E C1 F2 0F 2C D8 E8 ?? ?? ?? ?? BA ?? ?? ?? ?? 89 C1 BE ?? ?? ??
            ?? BF ?? ?? ?? ?? 31 C0 41 89 D8 E8 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? BA ?? ?? ?? ??
            BE ?? ?? ?? ?? BF ?? ?? ?? ?? 31 C0 E8 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? BA ?? ?? ?? ??
            BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 81 C4 ?? ?? ?? ?? B8 ?? ?? ?? ?? 5B 5D C3
        }

        $parse_c2_commands_64 = {
            41 57 31 C0 49 89 FF B9 ?? ?? ?? ?? 41 56 41 55 41 54 55 53 48 81 EC ?? ?? ?? ?? 48
            8D 9C 24 ?? ?? ?? ?? 40 88 B4 24 ?? ?? ?? ?? 4C 8D AC 24 ?? ?? ?? ?? 4C 8D A4 24 ??
            ?? ?? ?? 48 8D AC 24 ?? ?? ?? ?? 48 89 DF F3 48 AB C7 07 ?? ?? ?? ?? BF ?? ?? ?? ??
            E8 ?? ?? ?? ?? 48 8D 43 ?? 48 89 84 24 ?? ?? ?? ?? 0F 1F 00 8B 3D ?? ?? ?? ?? 31 C9
            BA ?? ?? ?? ?? 48 89 DE E8 ?? ?? ?? ?? 48 85 C0 0F 84 ?? ?? ?? ?? 44 8B B4 24 ?? ??
            ?? ?? 45 85 F6 0F 84 ?? ?? ?? ?? 31 C0 44 89 F6 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 84
            24 ?? ?? ?? ?? 83 F8 ?? 74 ?? 83 F8 ?? 0F 84 ?? ?? ?? ?? 41 83 FE ?? 0F 84 ?? ?? ??
            ?? 41 83 FE ?? 0F 84 ?? ?? ?? ?? 83 F8 ?? 0F 84 ?? ?? ?? ?? 41 83 FE ?? 0F 84 ?? ??
            ?? ?? 41 83 FE ?? 0F 84 ?? ?? ?? ?? 41 83 FE ?? 0F 84 ?? ?? ?? ?? 41 83 FE ?? 0F 85
            ?? ?? ?? ?? 48 8D BC 24 ?? ?? ?? ?? 31 C0 B9 ?? ?? ?? ?? F3 48 AB 48 8B 84 24 ?? ??
            ?? ?? 4C 8B 9C 24 ?? ?? ?? ?? 4C 8B 94 24 ?? ?? ?? ?? 4C 8B 8C 24 ?? ?? ?? ?? 4C 8B
            84 24 ?? ?? ?? ?? 48 8B 8C 24 ?? ?? ?? ?? C7 07 ?? ?? ?? ?? 48 89 84 24 ?? ?? ?? ??
            48 8B 84 24 ?? ?? ?? ?? 48 8B BC 24 ?? ?? ?? ?? 48 8B B4 24 ?? ?? ?? ?? 48 8B 94 24
            ?? ?? ?? ?? 4C 8B B4 24 ?? ?? ?? ?? 4C 8B AC 24 ?? ?? ?? ?? 4C 8B A4 24 ?? ?? ?? ??
            48 8B AC 24 ?? ?? ?? ?? 48 8B 9C 24 ?? ?? ?? ?? 48 89 84 24 ?? ?? ?? ?? 48 8B 84 24
            ?? ?? ?? ?? 4C 89 9C 24 ?? ?? ?? ?? 4C 89 94 24 ?? ?? ?? ?? 4C 89 8C 24 ?? ?? ?? ??
            4C 89 84 24 ?? ?? ?? ?? 48 89 8C 24 ?? ?? ?? ?? 48 89 BC 24 ?? ?? ?? ?? 48 89 B4 24
            ?? ?? ?? ?? 48 89 94 24 ?? ?? ?? ?? 4C 89 B4 24 ?? ?? ?? ?? 4C 89 AC 24 ?? ?? ?? ??
            4C 89 A4 24 ?? ?? ?? ?? 48 89 AC 24 ?? ?? ?? ?? 48 89 9C 24 ?? ?? ?? ?? 48 89 84 24
            ?? ?? ?? ?? 49 89 57 ?? 48 8B 94 24 ?? ?? ?? ?? 49 89 77 ?? 48 8D B4 24
        }

        $dns_flood_64_p1 = {
            41 55 41 54 55 53 48 81 EC ?? ?? ?? ?? 83 3D ?? ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 49 89
            FC BB ?? ?? ?? ?? 48 8D 7C 24 ?? 48 89 D9 4C 89 E6 48 8D AC 24 ?? ?? ?? ?? F3 48 A5
            8B 06 48 89 CB 89 07 0F B7 46 ?? 8B 35 ?? ?? ?? ?? 66 89 47 ?? BF ?? ?? ?? ?? 31 C0
            E8 ?? ?? ?? ?? 48 C7 04 24 ?? ?? ?? ?? 48 C7 44 24 ?? ?? ?? ?? ?? 66 C7 04 24 ?? ??
            66 C7 44 24 ?? ?? ?? E8 ?? ?? ?? ?? 31 D2 BE ?? ?? ?? ?? BF ?? ?? ?? ?? F7 35 ?? ??
            ?? ?? 89 D2 8B 04 95 ?? ?? ?? ?? BA ?? ?? ?? ?? 89 44 24 ?? E8 ?? ?? ?? ?? BA ?? ??
            ?? ?? 48 89 E6 89 C7 41 89 C5 E8 ?? ?? ?? ?? 48 89 D8 B9 ?? ?? ?? ?? 48 89 EF F3 48
            AB 48 8D 7C 24 ?? BE ?? ?? ?? ?? 48 8D 9C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 44 24 ??
            48 8D 7D ?? 48 8D 74 24 ?? 89 84 24 ?? ?? ?? ?? 0F B7 44 24 ?? 66 89 84 24 ?? ?? 00
            00 E8 ?? ?? ?? ?? 48 89 EE 48 89 DF C6 84 24 ?? ?? ?? ?? ?? C6 84 24
        }

        $dns_flood_64_p2 = {
            66 C7 84 24 ?? ?? 00 00 ?? ?? 66 C7 84 24 ?? ?? 00 00 ?? ?? 66 C7 84 24 ?? ?? 00 00
            ?? ?? 66 C7 84 24 ?? ?? 00 00 ?? ?? E8 ?? ?? ?? ?? 48 89 D9 8B 01 48 83 C1 ?? 8D 90
            ?? ?? ?? ?? F7 D0 21 C2 81 E2 ?? ?? ?? ?? 74 ?? 89 D0 C1 E8 ?? F7 C2 ?? ?? ?? ?? 0F
            44 D0 48 8D 41 ?? 48 0F 44 C8 00 D2 48 83 D9 ?? 48 29 D9 48 8D 84 0C ?? ?? ?? ?? 48
            8D 8C 24 ?? ?? ?? ?? 66 C7 00 ?? ?? 66 C7 40 ?? ?? ?? 48 89 CB 8B 13 48 83 C3 ?? 8D
            82 ?? ?? ?? ?? F7 D2 21 D0 25 ?? ?? ?? ?? 74 ?? 89 C2 48 8D 7C 24 ?? BE ?? ?? ?? ??
            C1 EA ?? A9 ?? ?? ?? ?? 0F 44 C2 48 8D 53 ?? 48 0F 44 DA 00 C0 48 83 DB ?? 48 29 CB
            E8 ?? ?? ?? ?? 8B 44 24 ?? 48 8D BC 24 ?? ?? ?? ?? 48 89 EE 89 84 24 ?? ?? ?? ?? 0F
            B7 44 24 ?? 66 89 84 24 ?? ?? 00 00 E8 ?? ?? ?? ?? 48 8D 7D ?? 48 8D 74 24 ?? E8 ??
            ?? ?? ?? 41 83 BC 24 ?? ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 C2 B9 ?? ??
            ?? ?? 83 C3 ?? C1 FA ?? F7 F9 8D 42 ?? 66 C1 C8 ?? 66 89 84 24 ?? ?? 00 00 E8 ?? ??
            ?? ?? 31 D2 48 8D B4 24 ?? ?? ?? ?? 31 C9 F7 35 ?? ?? ?? ?? 41 B9 ?? ?? ?? ?? 49 89
            E0 44 89 EF 89 D2 8B 04 95 ?? ?? ?? ?? 48 63 D3 89 44 24 ?? E8 ?? ?? ?? ?? 49 83 84
            24 ?? ?? ?? ?? ?? 83 3D ?? ?? ?? ?? ?? 74 ?? BF ?? ?? ?? ?? E8
        }

    condition:
        uint32(0) == 0x464C457F and
        (
            (
                (
                    all of ($collect_system_information_32_p*)
                ) and
                (
                    $send_system_info_32
                ) and
                (
                    $parse_c2_commands_32
                ) and
                (
                    all of ($dns_flood_32_p*)
                )
            ) or
            (
                (
                    all of ($collect_system_information_64_p*)
                ) and
                (
                    $send_system_info_64
                ) and
                (
                    $parse_c2_commands_64
                ) and
                (
                    all of ($dns_flood_64_p*)
                )
            )
        )
}