rule Linux_Backdoor_Linodas : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "LINODAS"
        description         = "Yara rule that detects Linodas backdoor."

        tc_detection_type   = "Backdoor"
        tc_detection_name   = "Linodas"
        tc_detection_factor = 5

    strings:

        $persistence_mechanism_ubuntu = {
            41 54 BE ?? ?? ?? ?? 55 53 48 81 EC ?? ?? ?? ?? 48 8D 6C 24 ?? 48 8D 54 24 ?? 48 89
            EF E8 ?? ?? ?? ?? 48 8B 7C 24 ?? 31 F6 E8 ?? ?? ?? ?? 85 C0 74 ?? 48 8D 5C 24 ?? 48
            89 EE 48 89 DF E8 ?? ?? ?? ?? 48 89 DF E8 ?? ?? ?? ?? 48 8B 5C 24 ?? 48 83 EB ?? 48
            81 FB ?? ?? ?? ?? 0F 85 ?? ?? ?? ?? 48 8D 6C 24 ?? 48 8D 54 24 ?? BE ?? ?? ?? ?? 48
            89 EF E8 ?? ?? ?? ?? 48 8B 7C 24 ?? 31 F6 E8 ?? ?? ?? ?? 85 C0 74 ?? 48 8D 5C 24 ??
            48 89 EE 48 89 DF E8 ?? ?? ?? ?? 48 89 DF E8 ?? ?? ?? ?? 48 8B 5C 24 ?? 48 83 EB ??
            48 81 FB ?? ?? ?? ?? 0F 85 ?? ?? ?? ?? 48 8D 5C 24 ?? 48 89 EE 48 89 DF E8 ?? ?? ??
            ?? 48 89 DF E8 ?? ?? ?? ?? 48 8B 5C 24 ?? 41 BC ?? ?? ?? ?? 48 83 EB ?? 4C 39 E3 0F
            85 ?? ?? ?? ?? 4C 8B 44 24 ?? B9 ?? ?? ?? ?? BA ?? ?? ?? ?? BE ?? ?? ?? ?? 48 89 E7
            E8 ?? ?? ?? ?? 48 89 E7 E8 ?? ?? ?? ?? BE ?? ?? ?? ?? 48 89 E7 E8 ?? ?? ?? ?? 85 C0
            74 ?? 48 8B 4C 24 ?? BA ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48
            8D 5C 24 ?? 4C 8B 44 24 ?? B9 ?? ?? ?? ?? BA ?? ?? ?? ?? BE ?? ?? ?? ?? 48 89 DF E8
            ?? ?? ?? ?? 48 89 DE 48 89 E7 E8 ?? ?? ?? ?? 48 8B 5C 24 ?? 48 83 EB ?? 49 39 DC 0F
            85 ?? ?? ?? ?? BE ?? ?? ?? ?? 48 89 E7 E8 ?? ?? ?? ?? 85 C0 74 ?? 48 8B 4C 24 ?? BA
            ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 5C 24 ?? 4C 8B 44 24
            ?? B9 ?? ?? ?? ?? BA ?? ?? ?? ?? BE ?? ?? ?? ?? 48 89 DF E8 ?? ?? ?? ?? 48 89 DE 48
            89 E7 E8 ?? ?? ?? ?? 48 8B 5C 24 ?? 48 83 EB ?? 49 39 DC 0F 85 ?? ?? ?? ?? BE ?? ??
            ?? ?? 48 89 E7 E8 ?? ?? ?? ?? 85 C0 74 ?? 48 8B 4C 24 ?? BA ?? ?? ?? ?? BE ?? ?? ??
            ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 1C 24 48 83 EB ?? 49 39 DC 0F 85 ?? ?? ?? ??
            48 8B 5C 24 ?? 48 83 EB ?? 49 39 DC 0F 85 ?? ?? ?? ?? 48 8B 5C 24 ?? 48 83 EB ?? 49
            39 DC 0F 85 ?? ?? ?? ?? 48 81 C4 ?? ?? ?? ?? 5B 5D 41 5C C3
        }

        $network_communication_1 = {
            48 89 5C 24 ?? 48 89 6C 24 ?? 48 89 F3 4C 89 64 24 ?? 4C 89 6C 24 ?? 48 81 EC ?? ??
            ?? ?? 48 8B 06 48 89 FD 89 54 24 ?? 45 89 C4 48 83 78 ?? ?? 0F 84 ?? ?? ?? ?? 4C 8D
            6C 24 ?? 48 8B 33 4C 89 EF E8 ?? ?? ?? ?? 48 8B 44 24 ?? 48 83 78 ?? ?? 0F 84 ?? ??
            ?? ?? 45 84 E4 0F 85 ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 88 45
            ?? 80 7D ?? ?? 0F 84 ?? ?? ?? ?? C6 45 ?? ?? BA ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ??
            ?? ?? E8 ?? ?? ?? ?? 83 F8 ?? 89 C5 0F 84 ?? ?? ?? ?? 48 8D 4C 24 ?? 41 B8 ?? ?? ??
            ?? BA ?? ?? ?? ?? BE ?? ?? ?? ?? 89 C7 48 C7 44 24 ?? ?? ?? ?? ?? 48 C7 44 24 ?? ??
            ?? ?? ?? 48 8D 5C 24 ?? E8 ?? ?? ?? ?? 48 8D 4C 24 ?? BA ?? ?? ?? ?? BE ?? ?? ?? ??
            41 B8 ?? ?? ?? ?? 89 EF 48 C7 44 24 ?? ?? ?? ?? ?? 48 C7 44 24 ?? ?? ?? ?? ?? E8 ??
            ?? ?? ?? 48 8B 7C 24 ?? 48 C7 44 24 ?? ?? ?? ?? ?? 8B 44 24 ?? 48 C7 44 24 ?? ?? ??
            ?? ?? 66 C1 C8 ?? 66 C7 44 24 ?? ?? ?? 66 89 44 24 ?? E8 ?? ?? ?? ?? BA ?? ?? ?? ??
            89 44 24 ?? 48 89 DE 89 EF E8 ?? ?? ?? ?? 83 C0 ?? 0F 84 ?? ?? ?? ?? 0F 1F 44 00 ??
            48 8B 5C 24 ?? 48 83 EB ?? 48 81 FB ?? ?? ?? ?? 0F 85 ?? ?? ?? ?? 89 E8 48 8B 5C 24
            ?? 48 8B 6C 24 ?? 4C 8B 64 24 ?? 4C 8B AC 24 ?? ?? ?? ?? 48 81 C4 ?? ?? ?? ?? C3
        }

        $network_communication_2 = {
            48 89 5C 24 ?? 48 89 6C 24 ?? 48 89 FB 4C 89 64 24 ?? BE ?? ?? ?? ?? 48 83 EC ?? BF
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 ??
            ?? ?? ?? 48 8D 73 ?? 48 8D 53 ?? BF ?? ?? ?? ?? 48 8D 6C 24 ?? 45 31 E4 E8 ?? ?? ??
            ?? 48 89 DF E8 ?? ?? ?? ?? 48 8B 73 ?? 48 89 EF E8 ?? ?? ?? ?? 48 8B 44 24 ?? 48 83
            78 ?? ?? 74 ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 ?? ?? ?? ??
            4C 8D 64 24 ?? 48 89 EE 4C 89 E7 E8 ?? ?? ?? ?? 4C 89 E6 48 89 DF E8 ?? ?? ?? ?? 48
            8B 6C 24 ?? 41 89 C4 48 83 ED ?? 48 81 FD ?? ?? ?? ?? 0F 85 ?? ?? ?? ?? 45 84 E4 74
            ?? 80 7B ?? ?? 0F 84 ?? ?? ?? ?? 90 48 89 DF E8 ?? ?? ?? ?? 48 8B 5C 24 ?? 41 0F B6
            EC 48 83 EB ?? 48 81 FB ?? ?? ?? ?? 0F 85 ?? ?? ?? ?? 89 E8 48 8B 5C 24 ?? 48 8B 6C
            24 ?? 4C 8B 64 24 ?? 48 83 C4 ?? C3
        }

        $persistence_mechanism_redhat_v11 = {
            41 57 41 56 41 55 41 54 55 53 48 83 EC ?? 48 8D 7C 24 ?? E8 ?? ?? ?? ?? 48 8B 6C 24
            ?? 8B 7D ?? 4C 8D 7D ?? 81 C7 ?? ?? ?? ?? 48 63 FF E8 ?? ?? ?? ?? 48 89 C3 48 8D 7C
            24 ?? 48 89 EE E8 ?? ?? ?? ?? 4C 8B 6C 24 ?? BE ?? ?? ?? ?? 48 89 DF 31 C0 4C 8D 74
            24 ?? 4C 89 EA E8 ?? ?? ?? ?? 48 98 48 8D 54 24 ?? 48 89 DE C6 04 18 ?? 4C 89 F7 E8
            ?? ?? ?? ?? 48 8B 7C 24 ?? 31 F6 E8 ?? ?? ?? ?? 85 C0 74 ?? 4C 89 E9 4C 89 EA BE ??
            ?? ?? ?? 48 89 DF 49 89 E9 4D 89 E8 31 C0 E8 ?? ?? ?? ?? 48 8B 7C 24 ?? 41 89 C4 B9
            ?? ?? ?? ?? 89 C2 48 89 DE E8 ?? ?? ?? ?? 48 8B 7C 24 ?? 31 F6 E8 ?? ?? ?? ?? 85 C0
            0F 85 ?? ?? ?? ?? 48 8B 54 24 ?? 48 89 DF BE ?? ?? ?? ?? 31 C0 E8 ?? ?? ?? ?? 48 89
            DF E8 ?? ?? ?? ?? 4C 89 EA BE ?? ?? ?? ?? 48 89 DF 31 C0 48 8D 6C 24 ?? E8 ?? ?? ??
            ?? 48 98 48 8D 54 24 ?? 48 89 DE C6 04 18 ?? 48 89 EF E8 ?? ?? ?? ?? 48 89 E7 31 C9
            BA ?? ?? ?? ?? 48 89 EE E8 ?? ?? ?? ?? 48 8B 6C 24 ?? 41 BE ?? ?? ?? ?? 4C 8B 24 24
            48 83 ED ?? 4C 39 F5 0F 85 ?? ?? ?? ?? BE ?? ?? ?? ?? 4C 89 E7 E8 ?? ?? ?? ?? 48 85
            C0 0F 84 ?? ?? ?? ?? 48 89 DF 49 8D 5C 24 ?? E8 ?? ?? ?? ?? 49 39 DE 0F 85 ?? ?? ??
            ?? 48 8B 5C 24 ?? 48 83 EB ?? 49 39 DE 0F 85 ?? ?? ?? ?? 49 8D 5D ?? 49 39 DE 0F 85
            ?? ?? ?? ?? 49 81 FF ?? ?? ?? ?? 0F 85 ?? ?? ?? ?? 48 83 C4 ?? 5B 5D 41 5C 41 5D 41
            5E 41 5F C3
        }

        $change_timestamp_and_read_config_v11 = {
            55 53 48 83 EC ?? 48 8D 5C 24 ?? 48 89 E7 E8 ?? ?? ?? ?? 48 89 E6 48 89 DF E8 ?? ??
            ?? ?? 48 89 DF E8 ?? ?? ?? ?? 48 8B 5C 24 ?? 48 83 EB ?? 48 81 FB ?? ?? ?? ?? 0F 85
            ?? ?? ?? ?? 48 89 E6 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 1C 24 BE ?? ?? ?? ?? 48 89
            DF E8 ?? ?? ?? ?? 48 85 C0 74 ?? 48 83 C0 ?? 89 C5 29 DD 8D 7D ?? 48 63 FF E8 ?? ??
            ?? ?? 48 63 D5 48 89 C3 48 89 C7 C6 04 02 ?? 48 8B 34 24 E8 ?? ?? ?? ?? 48 89 DF E8
            ?? ?? ?? ?? 48 89 DE 48 89 C2 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 DF E8 ?? ?? ?? ??
            BA ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 1C 24 B8 ?? ?? ??
            ?? 48 83 EB ?? 48 39 D8 75 ?? 48 83 C4 ?? 5B 5D C3
        }

        $generate_machine_id_v11 = {
            41 57 BE ?? ?? ?? ?? 49 89 FF 41 56 41 55 41 54 55 53 48 81 EC ?? ?? ?? ?? 48 8D 9C
            24 ?? ?? ?? ?? 48 8D 94 24 ?? ?? ?? ?? 48 89 DF E8 ?? ?? ?? ?? 4C 8D AC 24 ?? ?? ??
            ?? 31 C9 BA ?? ?? ?? ?? 48 89 DE 4C 89 EF E8 ?? ?? ?? ?? 48 8B 9C 24 ?? ?? ?? ?? 41
            BE ?? ?? ?? ?? 48 83 EB ?? 4C 39 F3 0F 85 ?? ?? ?? ?? 4C 8D A4 24 ?? ?? ?? ?? 48 8B
            B4 24 ?? ?? ?? ?? B9 ?? ?? ?? ?? BA ?? ?? ?? ?? 4C 89 E7 E8 ?? ?? ?? ?? 48 8B 84 24
            ?? ?? ?? ?? 48 83 78 ?? ?? 0F 84 ?? ?? ?? ?? 48 8D 9C 24 ?? ?? ?? ?? 48 8D 94 24 ??
            ?? ?? ?? BE ?? ?? ?? ?? 48 89 DF E8 ?? ?? ?? ?? 48 8D AC 24 ?? ?? ?? ?? 31 C9 BA ??
            ?? ?? ?? 48 89 DE 48 89 EF E8 ?? ?? ?? ?? 48 8B 9C 24 ?? ?? ?? ?? 48 83 EB ?? 49 39
            DE 0F 85 ?? ?? ?? ?? 48 89 EE 4C 89 E7 E8 ?? ?? ?? ?? 48 8B B4 24 ?? ?? ?? ?? 48 8D
            BC 24 ?? ?? ?? ?? 48 8B 56 ?? E8 ?? ?? ?? ?? 31 FF 4C 8B AC 24 ?? ?? ?? ?? E8 ?? ??
            ?? ?? 89 C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? BA ?? ?? ?? ?? 89 C6 48 8D BC 24 ?? ?? ??
            ?? F7 EA 89 F1 89 F5 C1 F9 ?? C1 FA ?? 29 CA 69 D2 ?? ?? ?? ?? 29 D5 E8 ?? ?? ?? ??
            48 8B 9C 24 ?? ?? ?? ?? 41 89 E8 31 C0 4C 89 E9 BE ?? ?? ?? ?? 48 89 E7 48 89 DA 48
            83 EB ?? E8 ?? ?? ?? ?? 49 39 DE 89 C5 0F 85 ?? ?? ?? ?? 48 63 C5 48 8D 94 24 ?? ??
            ?? ?? 48 8D BC 24 ?? ?? ?? ?? C6 04 04 ?? 48 89 E6 E8 ?? ?? ?? ?? 48 8D 94 24 ?? ??
            ?? ?? 48 89 E6 4C 89 FF E8 ?? ?? ?? ?? 48 8B 9C 24 ?? ?? ?? ?? 48 83 EB ?? 49 39 DE
            0F 85 ?? ?? ?? ?? 49 8D 5D ?? 49 39 DE 0F 85 ?? ?? ?? ?? 48 8B 9C 24 ?? ?? ?? ?? 48
            83 EB ?? 49 39 DE 0F 85 ?? ?? ?? ?? 48 8B 9C 24 ?? ?? ?? ?? 48 83 EB ?? 49 39 DE 0F
            85 ?? ?? ?? ?? 48 8B 9C 24 ?? ?? ?? ?? 48 83 EB ?? 49 39 DE 0F 85 ?? ?? ?? ?? 48 81
            C4 ?? ?? ?? ?? 4C 89 F8 5B 5D 41 5C 41 5D 41 5E 41 5F C3
        }

        $persistence_mechanism_redhat_v7 = {
            48 89 6C 24 ?? 4C 89 7C 24 ?? 48 89 5C 24 ?? 4C 89 64 24 ?? 4C 89 6C 24 ?? 4C 89 74
            24 ?? 48 81 EC ?? ?? ?? ?? 48 8D 7C 24 ?? E8 ?? ?? ?? ?? 48 8B 6C 24 ?? 8B 7D ?? 4C
            8D 7D ?? 81 C7 ?? ?? ?? ?? 48 63 FF E8 ?? ?? ?? ?? 48 89 C3 48 8D 7C 24 ?? 48 89 EE
            E8 ?? ?? ?? ?? 4C 8B 64 24 ?? BE ?? ?? ?? ?? 48 89 DF 31 C0 4C 8D 74 24 ?? 4C 89 E2
            E8 ?? ?? ?? ?? 48 98 48 8D 54 24 ?? 48 89 DE C6 04 18 ?? 4C 89 F7 E8 ?? ?? ?? ?? 48
            8B 7C 24 ?? 31 F6 E8 ?? ?? ?? ?? 85 C0 74 ?? 4C 89 E1 4C 89 E2 BE ?? ?? ?? ?? 48 89
            DF 49 89 E9 4D 89 E0 31 C0 E8 ?? ?? ?? ?? 48 8B 7C 24 ?? 41 89 C5 B9 ?? ?? ?? ?? 89
            C2 48 89 DE E8 ?? ?? ?? ?? 48 8B 7C 24 ?? 31 F6 E8 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ??
            ?? 48 8B 54 24 ?? 48 89 DF BE ?? ?? ?? ?? 31 C0 E8 ?? ?? ?? ?? 48 89 DF E8 ?? ?? ??
            ?? 4C 89 E2 BE ?? ?? ?? ?? 48 89 DF 31 C0 E8 ?? ?? ?? ?? 48 98 48 89 E7 31 C9 C6 04
            18 ?? BA ?? ?? ?? ?? 48 89 DE E8 ?? ?? ?? ?? 48 8B 2C 24 BE ?? ?? ?? ?? 48 89 EF E8
            ?? ?? ?? ?? 48 85 C0 0F 84 ?? ?? ?? ?? 48 89 DF 48 8D 5D ?? BD ?? ?? ?? ?? E8 ?? ??
            ?? ?? 48 39 EB 0F 85 ?? ?? ?? ?? 48 8B 5C 24 ?? 48 83 EB ?? 48 39 DD 0F 85 ?? ?? ??
            ?? 49 8D 5C 24 ?? 48 39 DD 0F 85 ?? ?? ?? ?? 49 81 FF ?? ?? ?? ?? 0F 85 ?? ?? ?? ??
            48 8B 5C 24 ?? 48 8B 6C 24 ?? 4C 8B 64 24 ?? 4C 8B AC 24 ?? ?? ?? ?? 4C 8B B4 24 ??
            ?? ?? ?? 4C 8B BC 24 ?? ?? ?? ?? 48 81 C4 ?? ?? ?? ?? C3
        }

        $get_device_name_v7 = {
            48 89 5C 24 ?? 48 89 6C 24 ?? BE ?? ?? ?? ?? 4C 89 64 24 ?? 4C 89 6C 24 ?? B9 ?? ??
            ?? ?? 4C 89 74 24 ?? 48 81 EC ?? ?? ?? ?? 4C 8B 05 ?? ?? ?? ?? 48 8D 5C 24 ?? BA ??
            ?? ?? ?? 48 89 DF E8 ?? ?? ?? ?? 48 89 DE BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 5C 24
            ?? 41 BD ?? ?? ?? ?? 48 83 EB ?? 4C 39 EB 0F 85 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48
            83 78 ?? ?? 75 ?? 48 8D 5C 24 ?? 48 89 DF E8 ?? ?? ?? ?? 48 89 DE BF ?? ?? ?? ?? E8
            ?? ?? ?? ?? 48 8B 5C 24 ?? 48 83 EB ?? 49 39 DD 0F 85 ?? ?? ?? ?? 48 8B 0D ?? ?? ??
            ?? 48 8B 15 ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 7C 24 ??
            E8 ?? ?? ?? ?? 4C 8B 64 24 ?? 48 89 E7 E8 ?? ?? ?? ?? 48 8B 2C 24 48 8D 5C 24 ?? 41
            B8 ?? ?? ?? ?? 4C 89 E2 BE ?? ?? ?? ?? 31 C0 48 89 DF 48 89 E9 E8 ?? ?? ?? ?? 48 89
            DE BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 5C 24 ?? 48 83 EB ?? 49 39 DD 0F 85 ?? ?? ??
            ?? E8 ?? ?? ?? ?? 48 8D 5D ?? 49 39 DD 0F 85 ?? ?? ?? ?? 49 8D 5C 24 ?? 49 39 DD 0F
            85 ?? ?? ?? ?? 48 8B 5C 24 ?? 48 8B 6C 24 ?? 4C 8B 64 24 ?? 4C 8B 6C 24 ?? 4C 8B B4
            24 ?? ?? ?? ?? 48 81 C4 ?? ?? ?? ?? C3
        }

        $generate_machine_id_v7 = {
            41 57 31 C9 BA ?? ?? ?? ?? BE ?? ?? ?? ?? 49 89 FF 41 56 41 55 41 54 55 53 48 81 EC
            ?? ?? ?? ?? 4C 8D A4 24 ?? ?? ?? ?? 48 8D AC 24 ?? ?? ?? ?? 4C 89 E7 E8 ?? ?? ?? ??
            48 8B B4 24 ?? ?? ?? ?? B9 ?? ?? ?? ?? BA ?? ?? ?? ?? 48 89 EF E8 ?? ?? ?? ?? 48 8B
            84 24 ?? ?? ?? ?? 48 83 78 ?? ?? 0F 84 ?? ?? ?? ?? 48 8D 9C 24 ?? ?? ?? ?? 31 C9 BA
            ?? ?? ?? ?? BE ?? ?? ?? ?? 48 89 DF E8 ?? ?? ?? ?? 48 89 DE 48 89 EF E8 ?? ?? ?? ??
            48 8B B4 24 ?? ?? ?? ?? 48 8D BC 24 ?? ?? ?? ?? 48 8B 56 ?? E8 ?? ?? ?? ?? 31 FF 4C
            8B B4 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? BA ?? ?? ??
            ?? 89 C6 48 8D BC 24 ?? ?? ?? ?? F7 EA 89 F1 89 F5 C1 F9 ?? C1 FA ?? 29 CA 69 D2 ??
            ?? ?? ?? 29 D5 E8 ?? ?? ?? ?? 48 8B 9C 24 ?? ?? ?? ?? 41 89 E8 31 C0 4C 89 F1 BE ??
            ?? ?? ?? 48 89 E7 41 BD ?? ?? ?? ?? 48 89 DA 48 83 EB ?? E8 ?? ?? ?? ?? 4C 39 EB 89
            C5 0F 85 ?? ?? ?? ?? 48 63 C5 48 8D 94 24 ?? ?? ?? ?? 48 8D BC 24 ?? ?? ?? ?? C6 04
            04 ?? 48 89 E6 E8 ?? ?? ?? ?? 48 8D 94 24 ?? ?? ?? ?? 48 89 E6 4C 89 FF E8 ?? ?? ??
            ?? 48 8B 9C 24 ?? ?? ?? ?? 48 83 EB ?? 49 39 DD 0F 85 ?? ?? ?? ?? 49 8D 5E ?? 49 39
            DD 0F 85 ?? ?? ?? ?? 48 8B 9C 24 ?? ?? ?? ?? 48 83 EB ?? 49 39 DD 0F 85 ?? ?? ?? ??
            48 8B 9C 24 ?? ?? ?? ?? 48 83 EB ?? 49 39 DD 0F 85 ?? ?? ?? ?? 48 8B 9C 24 ?? ?? ??
            ?? 48 83 EB ?? 49 39 DD 0F 85 ?? ?? ?? ?? 48 81 C4 ?? ?? ?? ?? 4C 89 F8 5B 5D 41 5C
            41 5D 41 5E 41 5F C3
        }

    condition:
        uint32(0) == 0x464C457F and
        (
            (
                $persistence_mechanism_ubuntu
            ) and
            (
                all of ($network_communication_*)
            ) and
            (
                (
                    (
                        $change_timestamp_and_read_config_v11
                    ) and
                    (
                        $persistence_mechanism_redhat_v11
                    ) and
                    (
                        $generate_machine_id_v11
                    )
                ) or
                (
                    (
                        $persistence_mechanism_redhat_v7
                    ) and
                    (
                        $get_device_name_v7
                    ) and
                    (
                        $generate_machine_id_v7
                    )
                )
            )
        )
}