rule Linux_Backdoor_Krasue : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "KRASUE"
        description         = "Yara rule that detects Krasue backdoor."

        tc_detection_type   = "Backdoor"
        tc_detection_name   = "Krasue"
        tc_detection_factor = 5

    strings:

        $switch_server = {
            8B 05 ?? ?? ?? ?? FF C0 3B 05 ?? ?? ?? ?? 89 05 ?? ?? ?? ?? 7C ?? C7 05 ?? ?? ?? ??
            ?? ?? ?? ?? 48 63 05 ?? ?? ?? ?? 85 C0 75 ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? EB ?? 8B
            15 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C6 05 ?? ?? ?? ?? ?? C6 05 ?? ?? ?? ??
            ?? 89 15 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 66 89 15 ?? ?? 23 00 48 8B 04 C5 ?? ?? ?? ??
            66 C7 05 ?? ?? 23 00 ?? ?? 8B 10 89 15 ?? ?? ?? ?? 66 8B 40 ?? 66 89 05 ?? ?? 23 00
            C3
        }

        $get_hostname = {
            41 55 41 54 31 F6 55 53 31 C0 BF ?? ?? ?? ?? 48 81 EC ?? ?? ?? ?? E8 ?? ?? ?? ?? 85
            C0 0F 88 ?? ?? ?? ?? 48 89 E6 89 C7 89 C3 E8 ?? ?? ?? ?? 48 8B 6C 24 ?? 45 31 C9 31
            FF 41 89 D8 B9 ?? ?? ?? ?? BA ?? ?? ?? ?? 41 89 EC 48 63 ED 48 89 EE E8 ?? ?? ?? ??
            BE ?? ?? ?? ?? 48 89 C7 49 89 C5 E8 ?? ?? ?? ?? 83 F8 ?? 74 ?? 48 63 D0 49 8D 74 15
            ?? 8D 50 ?? 48 63 D2 44 39 E2 41 89 D0 7D ?? 48 FF C2 41 80 7C 15 ?? ?? 75 ?? 44 89
            C1 41 FF C8 BA ?? ?? ?? ?? 29 C1 4D 63 C0 48 89 D7 83 E9 ?? 48 63 C9 F3 A4 41 C6 80
            ?? ?? ?? ?? ?? 4C 89 EF 48 89 EE E8 ?? ?? ?? ?? 89 DF E8 ?? ?? ?? ?? 48 81 C4 ?? ??
            ?? ?? 5B 5D 41 5C 41 5D C3
        }

        $start_server_p1 = {
            41 57 41 56 31 D2 41 55 41 54 BE ?? ?? ?? ?? 55 53 89 FB BF ?? ?? ?? ?? 48 81 EC ??
            ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 89 05 ?? ?? ?? ?? 79 ?? 83 CF ?? E9 ?? ?? ?? ?? 48 8D
            4C 24 ?? 41 B8 ?? ?? ?? ?? BE ?? ?? ?? ?? BA ?? ?? ?? ?? 89 C7 C7 44 24 ?? ?? ?? ??
            ?? E8 ?? ?? ?? ?? BA ?? ?? ?? ?? 31 C0 B9 ?? ?? ?? ?? 48 89 D7 F3 AB 31 FF 66 C7 05
            ?? ?? 23 00 ?? ?? E8 ?? ?? ?? ?? 0F B7 FB 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 3D ??
            ?? ?? ?? BA ?? ?? ?? ?? BE ?? ?? ?? ?? 66 89 05 ?? ?? 23 00 E8 ?? ?? ?? ?? 85 C0 78
            ?? 4C 8D A4 24 ?? ?? ?? ?? 4C 8D AC 24 ?? ?? ?? ?? 4C 8D 74 24 ?? C7 05 ?? ?? ?? ??
            ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 31 C9 41 B9 ?? ?? ?? ?? 41 B8 ?? ?? ?? ?? BA ?? ?? ??
            ?? BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 48 89 C3 0F 88 ?? ?? ?? ?? 31 C0 B9 ?? ?? ??
            ?? 4C 89 E7 83 FB ?? F3 AB 7E ?? BA ?? ?? ?? ?? BE ?? ?? ?? ?? 4C 89 E7 E8 ?? ?? ??
            ?? 85 C0 75 ?? B8 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 41 B8 ?? ?? ?? ?? 44 8D 08 31 C9 BA
            ?? ?? ?? ?? BE ?? ?? ?? ?? E8 ?? ?? ?? ?? EB ?? 83 FB ?? 75 ?? BE ?? ?? ?? ?? 4C 89
            E7 E8 ?? ?? ?? ?? 85 C0 75 ?? 8B 05 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 89 05
            ?? ?? ?? ?? E9 ?? ?? ?? ?? 89 DA BE ?? ?? ?? ?? 4C 89 E7 E8 ?? ?? ?? ?? 4C 89 E6 89
            C2 8A 06 89 F5 44 29 E5 3C ?? 75 ?? 80 7E ?? ?? 75 ?? 48 83 C6 ?? EB ?? 3C ?? 75 ??
            80 7E ?? ?? 75 ?? 41 B8 ?? ?? ?? ?? 31 C0 B9 ?? ?? ?? ?? 4C 89 C7 4C 8B 05 ?? ?? ??
            ?? F3 AB 8B 7E ?? 66 8B 4E ?? 4C 89 06 C6 06 ?? 45 31 C0 C6 46 ?? ?? BE
        }

        $start_server_p2 = {
            66 C7 05 ?? ?? 23 00 ?? ?? 89 3D ?? ?? ?? ?? 66 89 0D ?? ?? 23 00 89 3D ?? ?? ?? ??
            66 89 0D ?? ?? 23 00 48 89 F7 B9 ?? ?? ?? ?? 4C 89 E6 F3 AB E9 ?? ?? ?? ?? 85 ED 75
            ?? 48 63 DD BA ?? ?? ?? ?? BE ?? ?? ?? ?? 4C 01 E3 48 89 DF E8 ?? ?? ?? ?? 85 C0 75
            ?? 48 8D 7B ?? E8 ?? ?? ?? ?? 6B C0 ?? B9 ?? ?? ?? ?? BE ?? ?? ?? ?? 4C 89 EF 99 F7
            F9 31 C0 E8 ?? ?? ?? ?? EB ?? 8D 45 ?? 48 8D 54 24 ?? 48 98 85 C0 78 ?? 49 8B 0C 04
            48 83 C2 ?? 48 83 E8 ?? 48 89 4A ?? C6 42 ?? ?? C6 42 ?? ?? EB ?? BA ?? ?? ?? ?? BE
            ?? ?? ?? ?? 48 89 DF E8 ?? ?? ?? ?? 85 C0 75 ?? 48 8B 05 ?? ?? ?? ?? 89 E9 4C 89 F6
            89 2D ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? B8 ?? ?? ?? ??
            48 89 C7 F3 A4 BE ?? ?? ?? ?? 4C 89 EF E8 ?? ?? ?? ?? 31 C0 48 83 C9 ?? 4C 89 EF F2
            AE 48 89 C8 48 F7 D0 48 8D 50 ?? E9 ?? ?? ?? ?? BA ?? ?? ?? ?? BE ?? ?? ?? ?? 48 89
            DF E8 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 44 8B 0D ?? ?? ?? ?? 44
            8B 3D ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? 89 4C 24 ?? 44 89 4C 24 ?? E8 ?? ?? ?? ?? 48 83
            EC ?? 41 89 C0 BA ?? ?? ?? ?? 8B 4C 24 ?? 4C 89 EF BE ?? ?? ?? ?? 31 C0 51 8B 0D ??
            ?? ?? ?? 41 57 53 44 8B 4C 24 ?? E8 ?? ?? ?? ?? 31 C0 48 83 C9 ?? 4C 89 EF F2 AE 48
            83 C4 ?? 48 89 C8 48 F7 D0 48 8D 50 ?? 41 89 E8 4C 89 F1 4C 89 EE 8B 3D ?? ?? ?? ??
            E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? BA ?? ?? ?? ?? BE ?? ?? ?? ?? 48 89 DF E8
        }

        $start_server_p3 = {
            85 C0 75 ?? 31 FF E8 ?? ?? ?? ?? BA ?? ?? ?? ?? BE ?? ?? ?? ?? 48 89 DF E8 ?? ?? ??
            ?? 85 C0 75 ?? BF ?? ?? ?? ?? EB ?? BA ?? ?? ?? ?? BE ?? ?? ?? ?? 48 89 DF E8 ?? ??
            ?? ?? 85 C0 75 ?? BF ?? ?? ?? ?? EB ?? BA ?? ?? ?? ?? BE ?? ?? ?? ?? 48 89 DF E8 ??
            ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 41 89 C7 E8 ?? ?? ?? ?? 45 85 FF 0F
            85 ?? ?? ?? ?? 48 8D 7C 24 ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 41 89 C4 75 ?? 8B
            7C 24 ?? E8 ?? ?? ?? ?? 8B 7C 24 ?? BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 7C 24 ?? BE ??
            ?? ?? ?? E8 ?? ?? ?? ?? 8B 7C 24 ?? E8 ?? ?? ?? ?? 48 8D 4B ?? 45 31 C0 BA ?? ?? ??
            ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? 31 C0 E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 8B 7C 24 ?? E8
            ?? ?? ?? ?? 8B 7C 24 ?? 48 8D B4 24 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0
            89 C3 7E ?? 4C 8D AC 24 ?? ?? ?? ?? 8D 04 2B 3D ?? ?? ?? ?? 7E ?? 8B 3D ?? ?? ?? ??
            BA ?? ?? ?? ?? 48 8D 4C 24 ?? 4C 89 EE 29 EA 41 89 E8 49 81 C5 ?? ?? ?? ?? 81 EB ??
            ?? ?? ?? E8 ?? ?? ?? ?? EB ?? 8B 3D ?? ?? ?? ?? 48 8D 4C 24 ?? 41 89 E8 89 DA 4C 89
            EE E8 ?? ?? ?? ?? EB ?? 31 F6 BA ?? ?? ?? ?? 44 89 E7 E8 ?? ?? ?? ?? 85 C0 0F 85
        }

        $send_encrypt = {
            E8 ?? ?? ?? ?? 41 8D 7E ?? 49 89 C5 48 63 FF E8 ?? ?? ?? ?? 48 63 54 24 ?? 48 89 C7
            4C 89 FE 48 8D 0C 13 C6 04 08 ?? 89 D1 48 01 C2 F3 A4 48 89 D7 48 89 EE 48 89 D9 44
            89 F2 F3 A4 48 89 C6 EB ?? 8D 7B ?? 48 63 FF E8 ?? ?? ?? ?? 89 DA 49 89 C5 48 89 EE
            4C 89 EF E8 ?? ?? ?? ?? 44 8B 0D ?? ?? ?? ?? 4C 89 EE 44 89 E7 48 63 D0 41 B8 ?? ??
            ?? ?? 31 C9 E8 ?? ?? ?? ?? 48 83 C4 ?? 5B 5D 41 5C 41 5D 41 5E 41 5F C3
        }

        $notify_server = {
            48 81 EC ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 48 89 E0 85 D2 7E ?? BE ?? ?? ?? ?? 89 D1 48
            89 E7 F3 A4 48 63 D2 BE ?? ?? ?? ?? B9 ?? ?? ?? ?? 4C 8D 04 10 41 B9 ?? ?? ?? ?? 48
            83 C2 ?? 4C 89 C7 41 B8 ?? ?? ?? ?? F3 A4 8B 3D ?? ?? ?? ?? 48 89 C6 E8 ?? ?? ?? ??
            8B 05 ?? ?? ?? ?? 89 05 ?? ?? ?? ?? 48 81 C4 ?? ?? ?? ?? C3
        }

    condition:
        uint32(0) == 0x464C457F and
        (
            $switch_server
        ) and
        (
            $get_hostname
        ) and
        (
            all of ($start_server_p*)
        ) and
        (
            $send_encrypt
        ) and
        (
            $notify_server
        )
}