rule Linux_Backdoor_GTPDOOR : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "GTPDOOR"
        description         = "Yara rule that detects GTPDOOR backdoor."

        tc_detection_type   = "Backdoor"
        tc_detection_name   = "GTPDOOR"
        tc_detection_factor = 5

    strings:

        $send_result_to_peer_v1_p1 = {
            55 89 E5 57 56 53 81 EC ?? ?? ?? ?? 8B 45 ?? 8B 55 ?? 66 89 85 ?? ?? ?? ?? 66 89 95
            ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? B8 ?? ?? ?? ?? 89 44 24 ?? C7 44 24 ?? ?? ?? ?? ?? 89
            14 24 E8 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 66 81 BD ?? ?? ?? ?? ?? ?? 77 ?? 0F B7 8D
            ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 8B 55 ?? 89 C7 89 D6 FC F3 A4 EB ?? 8D 85 ?? ?? ?? ??
            8B 55 ?? 89 C1 B8 ?? ?? ?? ?? 89 44 24 ?? 89 54 24 ?? 89 0C 24 E8 ?? ?? ?? ?? 8D 85
            ?? ?? ?? ?? 89 45 ?? 8B 45 ?? 8B 40 ?? 89 45 ?? 8B 45 ?? 8B 50 ?? 8B 45 ?? 89 50 ??
            8B 55 ?? 8B 45 ?? 89 42 ?? 8B 45 ?? 83 C0 ?? 89 45 ?? 8B 45 ?? 89 C2 8D 85 ?? ?? ??
            ?? 01 D0 89 45 ?? 8B 45 ?? 83 C0 ?? 89 45 ?? 8B 45 ?? 0F B7 40 ?? 66 89 45 ?? 8B 45
            ?? 0F B7 10 8B 45 ?? 66 89 50 ?? 8B 55 ?? 0F B7 45 ?? 66 89 02 8B 45 ?? 89 C2 8D 85
            ?? ?? ?? ?? 01 D0 89 45 ?? 8B 45 ?? C6 40 ?? ?? 8B 45 ?? 83 C0 ?? 89 45 ?? 8B 45 ??
            89 C2 8D 85 ?? ?? ?? ?? 01 D0 89 45 ?? 8B 45 ?? 66 C7 40 ?? ?? ?? 66 81 BD ?? ?? ??
            ?? ?? ?? 76 ?? 8B 45 ?? 83 C0 ?? BA ?? ?? ?? ?? 89 44 24 ?? C7 44 24 ?? ?? ?? ?? ??
            8B 45 ?? 89 44 24 ?? C7 44 24 ?? ?? ?? ?? ?? 89 14 24 E8 ?? ?? ?? ?? C7 04 24 ?? ??
            ?? ?? E8 ?? ?? ?? ?? 89 C2 8B 45 ?? 66 89 50 ?? 8B 45 ?? 66 C7 40 ?? ?? ?? EB ?? 8B
            45 ?? 83 C0 ?? 0F B7 95 ?? ?? ?? ?? B9 ?? ?? ?? ?? 89 44 24 ?? 89 54 24 ?? 8B 45 ??
            89 44 24 ?? C7 44 24 ?? ?? ?? ?? ?? 89 0C 24 E8 ?? ?? ?? ?? 0F B7 85 ?? ?? ?? ?? 83
        }

        $send_result_to_peer_v1_p2 = {
            C0 ?? 0F B7 C0 89 04 24 E8 ?? ?? ?? ?? 89 C2 8B 45 ?? 66 89 50 ?? 8B 55 ?? 0F B7 85
            ?? ?? ?? ?? 66 89 42 ?? 8B 45 ?? 0F B7 40 ?? 83 C0 ?? 0F B7 C0 89 04 24 E8 ?? ?? ??
            ?? 89 C2 8B 45 ?? 66 89 50 ?? 8B 45 ?? 0F B7 50 ?? 8B 45 ?? 0F B7 40 ?? 8D 04 02 8D
            50 ?? 8B 45 ?? 66 89 50 ?? 8B 45 ?? 0F B7 40 ?? 0F B7 C0 89 04 24 E8 ?? ?? ?? ?? 89
            C2 8B 45 ?? 66 89 50 ?? 8B 45 ?? 0F B7 40 ?? 0F B7 C0 89 04 24 E8 ?? ?? ?? ?? 66 89
            45 ?? 8B 45 ?? 66 C7 40 ?? ?? ?? 0F B7 4D ?? 8B 5D ?? 8B 45 ?? 8B 50 ?? 8B 45 ?? 8B
            40 ?? 89 4C 24 ?? 89 5C 24 ?? 89 54 24 ?? 89 44 24 ?? C7 04 24 ?? ?? ?? ?? E8 ?? ??
            ?? ?? 89 C2 8B 45 ?? 66 89 50 ?? 8B 55 ?? 0F B6 42 ?? 83 C8 ?? 88 42 ?? 0F B7 45 ??
            83 C0 ?? 0F B7 C0 89 04 24 E8 ?? ?? ?? ?? 89 C2 8B 45 ?? 66 89 50 ?? 8B 45 ?? 66 C7
            40 ?? ?? ?? 0F B7 45 ?? 83 C0 ?? 8D 95 ?? ?? ?? ?? 89 44 24 ?? 89 14 24 E8 ?? ?? ??
            ?? 89 C2 8B 45 ?? 66 89 50 ?? 8B 45 ?? 8B 40 ?? 89 85 ?? ?? ?? ?? 66 C7 85 ?? ?? ??
            ?? ?? ?? 8B 45 ?? 0F B7 40 ?? 66 89 85 ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? 0F B7 45 ?? 83
            C0 ?? C7 44 24 ?? ?? ?? ?? ?? 89 54 24 ?? C7 44 24 ?? ?? ?? ?? ?? 89 44 24 ?? 8D 85
            ?? ?? ?? ?? 89 44 24 ?? 8B 45 ?? 89 04 24 E8 ?? ?? ?? ?? 81 C4 ?? ?? ?? ?? 5B 5E 5F
            5D C3
        }

        $execute_remote_command_v1 = {
            55 89 E5 57 83 EC ?? 8B 45 ?? 89 44 24 ?? 8B 45 ?? 89 04 24 E8 ?? ?? ?? ?? 8B 45 ??
            B9 ?? ?? ?? ?? 89 45 ?? B8 ?? ?? ?? ?? FC 8B 7D ?? F2 AE 89 C8 F7 D0 83 E8 ?? 03 45
            ?? 66 C7 00 ?? ?? C6 40 ?? ?? 8B 45 ?? B9 ?? ?? ?? ?? 89 45 ?? B8 ?? ?? ?? ?? FC 8B
            7D ?? F2 AE 89 C8 F7 D0 83 E8 ?? 66 89 45 ?? C7 44 24 ?? ?? ?? ?? ?? 8B 45 ?? 89 04
            24 E8 ?? ?? ?? ?? 89 45 ?? 83 7D ?? ?? 0F 85 ?? ?? ?? ?? 8B 45 ?? 89 04 24 E8 ?? ??
            ?? ?? 8B 45 ?? 89 04 24 E8 ?? ?? ?? ?? 0F B7 45 ?? 89 C2 03 55 ?? 8B 45 ?? 89 44 24
            ?? C7 44 24 ?? ?? ?? ?? ?? 89 14 24 E8 ?? ?? ?? ?? 8B 45 ?? B9 ?? ?? ?? ?? 89 45 ??
            B8 ?? ?? ?? ?? FC 8B 7D ?? F2 AE 89 C8 F7 D0 83 E8 ?? 0F B7 C0 89 45 ?? EB ?? 8B 45
            ?? 89 04 24 E8 ?? ?? ?? ?? 88 45 ?? 80 7D ?? ?? 74 ?? 0F B7 45 ?? 89 C2 03 55 ?? 0F
            B6 45 ?? 88 02 66 83 45 ?? ?? 66 81 7D ?? ?? ?? 76 ?? 8B 45 ?? 89 04 24 E8 ?? ?? ??
            ?? 0F B7 45 ?? 89 45 ?? 8B 45 ?? 83 C4 ?? 5F 5D C3
        }

        $send_reply_v1_p1 = {
            55 89 E5 81 EC ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 89 45 ?? 8D 85 ?? ?? ?? ?? 83 C0 ?? 89
            45 ?? 8D 85 ?? ?? ?? ?? 89 C2 B8 ?? ?? ?? ?? 89 44 24 ?? C7 44 24 ?? ?? ?? ?? ?? 89
            14 24 E8 ?? ?? ?? ?? 8B 55 ?? 0F B6 02 83 E0 ?? 83 C8 ?? 88 02 8B 55 ?? 0F B6 02 83
            E0 ?? 83 C8 ?? 88 02 8B 45 ?? C6 40 ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 C2
            8B 45 ?? 66 89 50 ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 C2 8B 45 ?? 66 89 50 ??
            C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 E0 ?? 8B 55 ?? 89 C1 83 E1 ?? 0F B6 42 ?? 83
            E0 ?? 09 C8 88 42 ?? 8B 45 ?? 0F B6 50 ?? 8B 45 ?? 88 50 ?? 8B 45 ?? C6 40 ?? ?? 8B
            45 ?? 8B 50 ?? 8B 45 ?? 89 50 ?? 8B 45 ?? 8B 50 ?? 8B 45 ?? 89 50 ?? C7 44 24 ?? ??
            ?? ?? ?? 8D 85 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 89 C2 8B 45 ?? 66 89 50 ?? 8B 45
            ?? 8B 40 ?? 89 04 24 E8 ?? ?? ?? ?? 89 45 ?? 8B 45 ?? 8B 40 ?? 89 04 24 E8 ?? ?? ??
            ?? 89 45 ?? 8B 45 ?? 0F B7 50 ?? 8B 45 ?? 66 89 10 8B 45 ?? 0F B7 10 8B 45 ?? 66 89
            50 ?? 8B 45 ?? 0F B6 40 ?? 3C ?? 75 ?? 8B 45 ?? 0F B7 40 ?? 0F B7 C0 89 04 24 E8 ??
            ?? ?? ?? 66 89 45 ?? 0F B7 45 ?? 89 04 24 E8 ?? ?? ?? ?? 89 C2 8B 45 ?? 66 89 50 ??
            8B 45 ?? 89 04 24 E8 ?? ?? ?? ?? 89 C2 8B 45 ?? 89 50 ?? 8B 45 ?? 89 04 24 E8 ?? ??
            ?? ?? 89 C2 8B 45 ?? 89 50 ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 C2 8B 45 ?? 66
            89 50 ?? EB ?? 8B 45 ?? 0F B6 40 ?? 3C ?? 75 ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ??
            89 C2 8B 45 ?? 89 50 ?? 8B 45 ?? 83 C0 ?? 89 04 24 E8 ?? ?? ?? ?? 89 C2 8B 45 ?? 89
        }

        $send_reply_v1_p2 = {
            50 ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 C2 8B 45 ?? 66 89 50 ?? 8B 55 ?? 0F B6
            42 ?? 83 E0 ?? 88 42 ?? 8B 55 ?? 0F B6 42 ?? 83 E0 ?? 83 C8 ?? 88 42 ?? 8B 45 ?? C6
            40 ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 C2 8B 45 ?? 66 89 50 ?? 8B 45 ?? 8B
            40 ?? 89 85 ?? ?? ?? ?? 8B 45 ?? 8B 40 ?? 89 85 ?? ?? ?? ?? C6 85 ?? ?? ?? ?? ?? C6
            85 ?? ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 66 89 85 ?? ?? ?? ?? 8D 95 ??
            ?? ?? ?? B8 ?? ?? ?? ?? 89 44 24 ?? C7 44 24 ?? ?? ?? ?? ?? 89 14 24 E8 ?? ?? ?? ??
            8D 8D ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? 8B 02 89 01 8B 42 ?? 89 41 ?? 8B 42 ?? 89 41 ??
            8D 85 ?? ?? ?? ?? 8D 48 ?? 8B 55 ?? 8B 02 89 01 8B 42 ?? 89 41 ?? 8B 42 ?? 89 41 ??
            8B 42 ?? 89 41 ?? 8B 42 ?? 89 41 ?? C7 44 24 ?? ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 89 04
            24 E8 ?? ?? ?? ?? 89 C2 8B 45 ?? 66 89 50 ?? 8D 95 ?? ?? ?? ?? B8 ?? ?? ?? ?? 89 44
            24 ?? C7 44 24 ?? ?? ?? ?? ?? 89 14 24 E8 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 8B 45 ??
            89 44 24 ?? 8D 85 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 66 C7 85 ?? ?? ?? ?? ?? ?? 8B
            45 ?? 8B 40 ?? 89 85 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 8B 55 ?? 8B 02 89 01 8B 42 ?? 89
        }

        $send_reply_v1_p3 = {
            41 ?? 8B 42 ?? 89 41 ?? 8B 42 ?? 89 41 ?? 8B 42 ?? 89 41 ?? 8D 85 ?? ?? ?? ?? 8D 48
            ?? 8B 55 ?? 8B 02 89 01 8B 42 ?? 89 41 ?? 8B 42 ?? 89 41 ?? 8B 42 ?? 89 41 ?? 8B 42
            ?? 89 41 ?? C7 45 ?? ?? ?? ?? ?? 8B 45 ?? 8B 40 ?? 89 85 ?? ?? ?? ?? 8B 85 ?? ?? ??
            ?? 89 04 24 E8 ?? ?? ?? ?? 89 45 ?? 8B 45 ?? 89 04 24 E8 ?? ?? ?? ?? 89 45 ?? 8B 95
            ?? ?? ?? ?? A1 ?? ?? ?? ?? 39 C2 0F 85 ?? ?? ?? ?? 8B 45 ?? 0F B6 40 ?? 3C ?? 74 ??
            8B 45 ?? 0F B6 40 ?? 3C ?? 0F 85 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 04 24 ?? ?? ??
            ?? E8 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? EB ?? 8B 45 ?? 8B 04 C5 ?? ?? ?? ?? 85 C0 75
            ?? 83 7D ?? ?? 75 ?? C7 45 ?? ?? ?? ?? ?? EB ?? 8B 45 ?? 8B 14 C5 ?? ?? ?? ?? B8 ??
            ?? ?? ?? 29 D0 89 C1 B8 ?? ?? ?? ?? D3 E0 89 45 ?? 8B 45 ?? 8B 04 C5 ?? ?? ?? ?? 23
            45 ?? 89 45 ?? 8B 45 ?? 23 45 ?? 89 45 ?? 8B 45 ?? 3B 45 ?? 75 ?? C7 45 ?? ?? ?? ??
            ?? EB ?? 83 45 ?? ?? 83 7D ?? ?? 7E ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 7D ??
            ?? 75 ?? 8B 45 ?? 89 44 24 ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 95 ?? ?? ?? ??
            8B 0D ?? ?? ?? ?? 8B 45 ?? 89 44 24 ?? 89 54 24 ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24
        }

        $daemon_already_running_check_v1 = {
            55 89 E5 57 83 EC ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 04 24 ?? ??
            ?? ?? E8 ?? ?? ?? ?? 89 45 ?? 83 7D ?? ?? 79 ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ??
            8B 45 ?? 89 04 24 E8 ?? ?? ?? ?? 85 C0 74 ?? E8 ?? ?? ?? ?? 8B 00 83 F8 ?? 74 ?? E8
            ?? ?? ?? ?? 8B 00 83 F8 ?? 75 ?? 8B 45 ?? 89 04 24 E8 ?? ?? ?? ?? C7 45 ?? ?? ?? ??
            ?? EB ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 8B 45 ?? 89 04
            24 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 44 24 ?? C7 44 24 ?? ?? ?? ?? ?? 8D 45 ?? 89 04
            24 E8 ?? ?? ?? ?? 8D 45 ?? B9 ?? ?? ?? ?? 89 45 ?? B8 ?? ?? ?? ?? FC 8B 7D ?? F2 AE
            89 C8 F7 D0 83 E8 ?? 83 C0 ?? 89 44 24 ?? 8D 45 ?? 89 44 24 ?? 8B 45 ?? 89 04 24 E8
            ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 8B 45 ?? 83 C4 ?? 5F 5D C3
        }

        $send_result_to_peer_v2_p1 = {
            55 48 89 E5 48 81 EC ?? ?? ?? ?? 89 BD ?? ?? ?? ?? 48 89 B5 ?? ?? ?? ?? 48 89 8D ??
            ?? ?? ?? 44 89 C0 66 89 95 ?? ?? FF FF 66 89 85 ?? ?? FF FF 48 8D BD ?? ?? ?? ?? BA
            ?? ?? ?? ?? BE ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 66 81 BD ?? ?? FF FF
            ?? ?? 77 ?? 0F B7 8D ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 48 8B 95 ?? ?? ?? ?? 48 89 C7
            48 89 D6 FC F3 A4 EB ?? 48 8D 85 ?? ?? ?? ?? 48 8B 95 ?? ?? ?? ?? 48 89 C7 48 89 D6
            BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 48 89 45 ?? 48 8B 45 ?? 8B 40 ??
            89 45 ?? 48 8B 45 ?? 8B 50 ?? 48 8B 45 ?? 89 50 ?? 48 8B 55 ?? 8B 45 ?? 89 42 ?? 8B
            45 ?? 83 C0 ?? 89 45 ?? 8B 45 ?? 48 98 48 89 C2 48 8D 85 ?? ?? ?? ?? 48 01 D0 48 89
            45 ?? 8B 45 ?? 83 C0 ?? 89 45 ?? 48 8B 45 ?? 0F B7 40 ?? 66 89 45 ?? 48 8B 45 ?? 0F
            B7 10 48 8B 45 ?? 66 89 50 ?? 48 8B 55 ?? 0F B7 45 ?? 66 89 02 8B 45 ?? 48 98 48 89
            C2 48 8D 85 ?? ?? ?? ?? 48 01 D0 48 89 45 ?? 48 8B 45 ?? C6 40 ?? ?? 8B 45 ?? 83 C0
            ?? 89 45 ?? 8B 45 ?? 48 98 48 89 C2 48 8D 85 ?? ?? ?? ?? 48 01 D0 48 89 45 ?? 48 8B
            45 ?? 66 C7 40 ?? ?? ?? 66 81 BD ?? ?? FF FF ?? ?? 76 ?? 48 8B 45 ?? 48 83 C0 ?? BF
            ?? ?? ?? ?? 48 8B 95 ?? ?? ?? ?? 49 89 C0 B9 ?? ?? ?? ?? BE ?? ?? ?? ?? E8 ?? ?? ??
            ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 C2 48 8B 45 ?? 66 89 50 ?? 48 8B 45 ?? 66 C7 40
            ?? ?? ?? EB ?? 48 8B 45 ?? 48 83 C0 ?? 0F B7 8D ?? ?? ?? ?? BF ?? ?? ?? ?? 48 8B 95
            ?? ?? ?? ?? 49 89 C0 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F B7 85 ?? ?? ?? ?? 83 C0 ?? 0F
        }

        $send_result_to_peer_v2_p2 = {
            B7 F8 E8 ?? ?? ?? ?? 89 C2 48 8B 45 ?? 66 89 50 ?? 48 8B 55 ?? 0F B7 85 ?? ?? ?? ??
            66 89 42 ?? 48 8B 45 ?? 0F B7 40 ?? 83 C0 ?? 0F B7 F8 E8 ?? ?? ?? ?? 89 C2 48 8B 45
            ?? 66 89 50 ?? 48 8B 45 ?? 0F B7 50 ?? 48 8B 45 ?? 0F B7 40 ?? 8D 04 02 8D 50 ?? 48
            8B 45 ?? 66 89 50 ?? 48 8B 45 ?? 0F B7 40 ?? 0F B7 F8 E8 ?? ?? ?? ?? 89 C2 48 8B 45
            ?? 66 89 50 ?? 48 8B 45 ?? 0F B7 40 ?? 0F B7 F8 E8 ?? ?? ?? ?? 66 89 45 ?? 48 8B 45
            ?? 66 C7 40 ?? ?? ?? 0F B7 4D ?? 48 8B 7D ?? 48 8B 45 ?? 8B 50 ?? 48 8B 45 ?? 8B 70
            ?? 41 89 C8 48 89 F9 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 C2 48 8B 45 ?? 66 89 50 ?? 48
            8B 55 ?? 0F B6 42 ?? 83 C8 ?? 88 42 ?? 0F B7 45 ?? 83 C0 ?? 0F B7 F8 E8 ?? ?? ?? ??
            89 C2 48 8B 45 ?? 66 89 50 ?? 48 8B 45 ?? 66 C7 40 ?? ?? ?? 0F B7 45 ?? 83 C0 ?? 89
            C6 48 8D BD ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 C2 48 8B 45 ?? 66 89 50 ?? 48 8B 45 ?? 8B
            40 ?? 89 85 ?? ?? ?? ?? 66 C7 85 ?? ?? FF FF ?? ?? 48 8B 45 ?? 0F B7 40 ?? 66 89 85
            ?? ?? FF FF 48 8D 95 ?? ?? ?? ?? 0F B7 45 ?? 48 83 C0 ?? 48 8D B5 ?? ?? ?? ?? 8B BD
            ?? ?? ?? ?? 41 B9 ?? ?? ?? ?? 49 89 D0 B9 ?? ?? ?? ?? 48 89 C2 E8 ?? ?? ?? ?? C9 C3
        }

        $execute_remote_command_v2 = {
            55 48 89 E5 48 83 EC ?? 48 89 7D ?? 48 89 75 ?? 48 8B 75 ?? 48 8B 7D ?? E8 ?? ?? ??
            ?? 48 8B 45 ?? 48 C7 C1 ?? ?? ?? ?? 48 89 45 ?? B8 ?? ?? ?? ?? FC 48 8B 7D ?? F2 AE
            48 89 C8 48 F7 D0 48 83 E8 ?? 48 03 45 ?? 66 C7 00 ?? ?? C6 40 ?? ?? 48 8B 45 ?? 48
            C7 C1 ?? ?? ?? ?? 48 89 45 ?? B8 ?? ?? ?? ?? FC 48 8B 7D ?? F2 AE 48 89 C8 48 F7 D0
            48 83 E8 ?? 66 89 45 ?? 48 8B 7D ?? BE ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48
            98 48 89 45 ?? 48 83 7D ?? ?? 0F 85 ?? ?? ?? ?? 48 8B 7D ?? E8 ?? ?? ?? ?? 48 8B 7D
            ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F B7 45 ?? 48 89 C7 48 03 7D ?? 48 8B 55 ?? BE ??
            ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 45 ?? 48 C7 C1 ?? ?? ?? ?? 48 89 45 ??
            B8 ?? ?? ?? ?? FC 48 8B 7D ?? F2 AE 48 89 C8 48 F7 D0 48 83 E8 ?? 0F B7 C0 89 45 ??
            EB ?? 48 8B 7D ?? E8 ?? ?? ?? ?? 88 45 ?? 80 7D ?? ?? 74 ?? 0F B7 45 ?? 48 89 C2 48
            03 55 ?? 0F B6 45 ?? 88 02 66 83 45 ?? ?? 66 81 7D ?? ?? ?? 76 ?? 48 8B 7D ?? B8 ??
            ?? ?? ?? E8 ?? ?? ?? ?? 0F B7 45 ?? 89 45 ?? 8B 45 ?? C9 C3
        }

        $main_routine_v2_p1 = {
            55 48 89 E5 48 81 EC ?? ?? ?? ?? 89 BD ?? ?? ?? ?? 48 89 B5 ?? ?? ?? ?? C7 45 ?? ??
            ?? ?? ?? 48 8D BD ?? ?? ?? ?? BA ?? ?? ?? ?? BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 85
            ?? ?? ?? ?? 48 8B 00 48 C7 C1 ?? ?? ?? ?? 48 89 85 ?? ?? ?? ?? B8 ?? ?? ?? ?? FC 48
            8B BD ?? ?? ?? ?? F2 AE 48 89 C8 48 F7 D0 48 83 E8 ?? 48 83 F8 ?? 76 ?? 48 8B 85 ??
            ?? ?? ?? 48 8B 00 48 C7 C1 ?? ?? ?? ?? 48 89 85 ?? ?? ?? ?? B8 ?? ?? ?? ?? FC 48 8B
            BD ?? ?? ?? ?? F2 AE 48 89 C8 48 F7 D0 48 8D 50 ?? 48 8B 85 ?? ?? ?? ?? 48 8B 00 48
            89 C7 FC 48 89 D1 B8 ?? ?? ?? ?? F3 AA 48 8B 85 ?? ?? ?? ?? 48 8B 00 C7 00 ?? ?? ??
            ?? C7 40 ?? ?? ?? ?? ?? 66 C7 40 ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ??
            ?? BA ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 ?? 83 7D ?? ??
            75 ?? E8 ?? ?? ?? ?? 8B 38 E8 ?? ?? ?? ?? 48 89 C6 BF ?? ?? ?? ?? B8 ?? ?? ?? ?? E8
            ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 48 8D 8D ??
            ?? ?? ?? 8B 7D ?? 41 B8 ?? ?? ?? ?? BA ?? ?? ?? ?? BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 85
            C0 79 ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? EB ?? 48 8D 85 ?? ?? ?? ?? 48 89 C7 BA ?? ??
            ?? ?? BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D B5 ?? ?? ?? ?? 8B 7D ?? B9 ?? ?? ?? ?? BA
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 ?? 83 7D ?? ?? 7E ?? 48 8D 85 ?? ?? ?? ?? 48 89 45
            ?? C7 45 ?? ?? ?? ?? ?? 8B 45 ?? 48 98 48 89 C2 48 8D 85 ?? ?? ?? ?? 48 01 D0 48 89
        }

        $main_routine_v2_p2 = {
            45 ?? 48 8B 45 ?? 0F B7 40 ?? 0F B7 F8 E8 ?? ?? ?? ?? 66 3D ?? ?? 75 ?? 8B 45 ?? 83
            C0 ?? 89 45 ?? 8B 45 ?? 48 98 48 89 C2 48 8D 85 ?? ?? ?? ?? 48 01 D0 48 89 45 ?? 8B
            45 ?? 83 C0 ?? 89 45 ?? 48 8B 45 ?? 0F B6 40 ?? 3C ?? 0F 85 ?? ?? ?? ?? 8B 45 ?? 48
            98 48 89 C2 48 8D 85 ?? ?? ?? ?? 48 01 D0 48 89 45 ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ??
            48 8B 45 ?? 48 83 C0 ?? 48 8D 95 ?? ?? ?? ?? 8B 00 89 02 8B 95 ?? ?? ?? ?? 8B 05 ??
            ?? ?? ?? 39 C2 74 ?? 8B 15 ?? ?? ?? ?? 8B B5 ?? ?? ?? ?? BF ?? ?? ?? ?? B8 ?? ?? ??
            ?? E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 48 8B 45 ?? 0F B7 40 ?? 0F B7 C8 48 8B 45 ?? 0F B6
            40 ?? 0F B6 D0 8B 75 ?? BF ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 75 ?? 48
            83 C6 ?? 48 8B 45 ?? 0F B7 40 ?? 0F B7 C8 48 8B 55 ?? 48 83 C2 ?? BF ?? ?? ?? ?? 49
            89 F0 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 45 ?? 0F B6 40 ?? 84 C0 0F 84 ?? ?? ?? ??
            48 8B 45 ?? 0F B6 40 ?? 3C ?? 75 ?? 48 8B 45 ?? 48 83 C0 ?? 8B 00 89 05 ?? ?? ?? ??
            48 8D BD ?? ?? ?? ?? FC B9 ?? ?? ?? ?? B8 ?? ?? ?? ?? F3 AA 48 8D 85 ?? ?? ?? ?? 48
        }

        $main_routine_v2_p3 = {
            C7 C1 ?? ?? ?? ?? 48 89 85 ?? ?? ?? ?? B8 ?? ?? ?? ?? FC 48 8B BD ?? ?? ?? ?? F2 AE
            48 89 C8 48 F7 D0 48 83 E8 ?? 0F B7 C8 4C 8D 8D ?? ?? ?? ?? 8B 45 ?? 0F B7 D0 48 8D
            B5 ?? ?? ?? ?? 8B 7D ?? 41 89 C8 4C 89 C9 E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 48 8B 45 ??
            0F B6 40 ?? 3C ?? 0F 85 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 85 C0 75 ?? BE ?? ?? ??
            ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8B 3D ?? ?? ?? ?? BA ?? ??
            ?? ?? BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? 48 8B 45 ?? 0F B7 40 ?? 0F
            B7 D0 48 8B 7D ?? 48 83 C7 ?? BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 45 ?? 0F B7 40 ??
            0F B7 D0 8B 05 ?? ?? ?? ?? 8D 04 02 89 05 ?? ?? ?? ?? 48 8B 45 ?? 0F B7 50 ?? 0F B7
            05 ?? ?? ?? ?? 66 39 C2 0F 84 ?? ?? ?? ?? 48 8B 3D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 C7
            05 ?? ?? ?? ?? ?? ?? ?? ?? 48 8D BD ?? ?? ?? ?? FC B9 ?? ?? ?? ?? B8 ?? ?? ?? ?? F3
            AA 8B 15 ?? ?? ?? ?? 48 8D BD ?? ?? ?? ?? BE ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ??
            ?? 48 8D B5 ?? ?? ?? ?? BF ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 85
        }

    condition:
        uint32(0) == 0x464C457F and
        (
            (
                (
                    all of ($send_result_to_peer_v1_p*)
                ) and
                (
                    $execute_remote_command_v1
                ) and
                (
                    all of ($send_reply_v1_p*)
                ) and
                (
                    $daemon_already_running_check_v1
                )
            ) or
            (
                (
                    all of ($send_result_to_peer_v2_p*)
                ) and
                (
                    $execute_remote_command_v2
                ) and
                (
                    all of ($main_routine_v2_p*)
                )
            )
        )
}