rule ByteCode_MSIL_Backdoor_NjRAT : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "NJRAT"
        description         = "Yara rule that detects NjRAT backdoor."

        tc_detection_type   = "Backdoor"
        tc_detection_name   = "NjRAT"
        tc_detection_factor = 5

    strings:

    $persistence_mechanism_v1_p1 = {
        00 20 ?? ?? ?? ?? 28 ?? ?? ?? ?? 00 7E ?? ?? ?? ?? 2C ?? 7E ?? ?? ?? ?? 7E ?? ?? ??
        ?? 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 72 ?? ?? ?? ?? 7E ?? ?? ?? ?? 6F ?? ?? ?? ?? 28 ??
        ?? ?? ?? 73 ?? ?? ?? ?? 28 ?? ?? ?? ?? 2C ?? 16 2B ?? 17 13 ?? 11 ?? 39 ?? ?? ?? ??
        00 28 ?? ?? ?? ?? 18 28 ?? ?? ?? ?? 00 7E ?? ?? ?? ?? 28 ?? ?? ?? ?? 72 ?? ?? ?? ??
        7E ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 13 ?? 11 ?? 2C ?? 7E ?? ?? ?? ?? 28 ??
        ?? ?? ?? 72 ?? ?? ?? ?? 7E ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 00 7E ?? ?? ??
        ?? 6F ?? ?? ?? ?? 7E ?? ?? ?? ?? 28 ?? ?? ?? ?? 72 ?? ?? ?? ?? 7E ?? ?? ?? ?? 28 ??
        ?? ?? ?? 17 28 ?? ?? ?? ?? 00 7E ?? ?? ?? ?? 28 ?? ?? ?? ?? 72 ?? ?? ?? ?? 7E ?? ??
        ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 26 28 ?? ?? ?? ?? 00 DE ?? 25 28 ?? ?? ?? ?? 0A
        00 28 ?? ?? ?? ?? 00 28 ?? ?? ?? ?? DE ?? 00 00 00 1B 8D ?? ?? ?? ?? 13 ?? 11 ?? 16
        72 ?? ?? ?? ?? A2 00 11 ?? 17 7E ?? ?? ?? ?? 6F ?? ?? ?? ?? A2 00 11 ?? 18 72 ?? ??
        ?? ?? A2 00 11 ?? 19 7E ?? ?? ?? ?? 6F ?? ?? ?? ?? A2 00 11 ?? 1A 72 ?? ?? ?? ?? A2
        00 11 ?? 28 ?? ?? ?? ?? 16 16 15 28 ?? ?? ?? ?? 26 DE ?? 25 28 ?? ?? ?? ?? 0B 00 28
        ?? ?? ?? ?? DE ?? 00 7E ?? ?? ?? ?? 13 ?? 11 ?? 39 ?? ?? ?? ?? 00 7E ?? ?? ?? ?? 6F
        ?? ?? ?? ?? 6F ?? ?? ?? ?? 7E ?? ?? ?? ?? 17 6F ?? ?? ?? ?? 7E ?? ?? ?? ?? 72 ?? ??
        ?? ?? 7E ?? ?? ?? ?? 6F ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 00
        DE ?? 25 28 ?? ?? ?? ?? 0C 00 28 ?? ?? ?? ?? DE ?? 00 00 7E ?? ?? ?? ?? 6F ?? ?? ??
        ?? 6F ?? ?? ?? ?? 7E ?? ?? ?? ?? 17 6F ?? ?? ?? ?? 7E ?? ?? ?? ?? 72 ?? ?? ?? ?? 7E
        ?? ?? ?? ?? 6F ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 DE ?? 25
    }

    $persistence_mechanism_v1_p2 = {
        28 ?? ?? ?? ?? 0D 00 28 ?? ?? ?? ?? DE ?? 00 00 7E ?? ?? ?? ?? 13 ?? 11 ?? 2C ?? 00
        28 ?? ?? ?? ?? 18 28 ?? ?? ?? ?? 00 7E ?? ?? ?? ?? 6F ?? ?? ?? ?? 1D 28 ?? ?? ?? ??
        72 ?? ?? ?? ?? 7E ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 17 28 ?? ?? ?? ?? 00 1D
        28 ?? ?? ?? ?? 72 ?? ?? ?? ?? 7E ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 19 73 ??
        ?? ?? ?? 80 ?? ?? ?? ?? DE ?? 25 28 ?? ?? ?? ?? 13 ?? 00 28 ?? ?? ?? ?? DE ?? 00 00
        7E ?? ?? ?? ?? 13 ?? 11 ?? 2C ?? 72 ?? ?? ?? ?? 7E ?? ?? ?? ?? 28 ?? ?? ?? ?? 16 16
        15 28 ?? ?? ?? ?? 26 00 7E ?? ?? ?? ?? 13 ?? 11 ?? 2C ?? 00 28 ?? ?? ?? ?? 18 28 ??
        ?? ?? ?? 00 DE ?? 25 28 ?? ?? ?? ?? 13 ?? 00 28 ?? ?? ?? ?? DE ?? 00 00 7E ?? ?? ??
        ?? 13 ?? 11 ?? 39 ?? ?? ?? ?? 72 ?? ?? ?? ?? 13 ?? 7E ?? ?? ?? ?? 13 ?? 18 13 ?? 28
        ?? ?? ?? ?? 6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 13 ?? 28 ?? ?? ?? ?? 13 ??
        11 ?? 13 ?? 16 13 ?? 38 ?? ?? ?? ?? 11 ?? 11 ?? 9A 13 ?? 00 28 ?? ?? ?? ?? 11 ?? 11
        ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 00 11 ?? 11 ?? 28 ?? ?? ?? ?? 11 ?? 28 ?? ?? ?? ??
        00 DE ?? 25 28 ?? ?? ?? ?? 13 ?? 00 28 ?? ?? ?? ?? DE ?? 00 00 11 ?? 72 ?? ?? ?? ??
        11 ?? 28 ?? ?? ?? ?? 73 ?? ?? ?? ?? 13 ?? 11 ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 11
        ?? 72 ?? ?? ?? ?? 11 ?? 11 ?? 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 11 ?? 72 ?? ?? ?? ??
        11 ?? 28 ?? ?? ?? ?? 17 8C ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 11 ?? 6F ?? ?? ?? ?? 00 11
        ?? 11 ?? 28 ?? ?? ?? ?? 11 ?? 28 ?? ?? ?? ?? 00 DE ?? 25 28 ?? ?? ?? ?? 13 ?? 00 28
    }

    $connect_v1_p1 = {
        00 16 80 ?? ?? ?? ?? 20 D0 07 00 00 28 ?? ?? ?? ?? 00 7E ?? ?? ?? ?? 0B 00 07 13 ??
        11 ?? 28 ?? ?? ?? ?? 00 00 00 7E ?? ?? ?? ?? 14 (FE | 01) ?? 16 (FE | 01) ?? 13 ?? 11
        ?? 2C ?? 00 7E ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 14 80 ?? ?? ?? ?? DE ?? 25 28 ?? ?? ??
        ?? 0C 00 28 ?? ?? ?? ?? DE ?? 00 00 00 7E ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 DE ?? 25 28
        ?? ?? ?? ?? 0D 00 28 ?? ?? ?? ?? DE ?? 00 DE ?? 25 28 ?? ?? ?? ?? 13 ?? 00 28 ?? ??
        ?? ?? DE ?? 00 00 73 ?? ?? ?? ?? 80 ?? ?? ?? ?? 73 ?? ?? ?? ?? 80 ?? ?? ?? ?? 7E ??
        ?? ?? ?? 20 00 20 03 00 6F ?? ?? ?? ?? 00 7E ?? ?? ?? ?? 20 00 20 03 00 6F ?? ?? ??
        ?? 00 7E ?? ?? ?? ?? 6F ?? ?? ?? ?? 20 10 27 00 00 6F ?? ?? ?? ?? 00 7E ?? ?? ?? ??
        6F ?? ?? ?? ?? 20 10 27 00 00 6F ?? ?? ?? ?? 00 7E ?? ?? ?? ?? 14 72 ?? ?? ?? ?? 18
        8D ?? ?? ?? ?? 13 ?? 11 ?? 16 7E ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ??
        ?? ?? 28 ?? ?? ?? ?? A2 00 11 ?? 17 7E ?? ?? ?? ?? 28 ?? ?? ?? ?? 8C ?? ?? ?? ?? A2
        00 11 ?? 14 14 14 17 28 ?? ?? ?? ?? 26 7E ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ??
        28 ?? ?? ?? ?? 80 ?? ?? ?? ?? 17 80 ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 26 00
        72 ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 72 ?? ?? ?? ?? 16 28 ??
        ?? ?? ?? 13 ?? 11 ?? 2C ?? 11 ?? 7F ?? ?? ?? ?? 28 ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ??
        ?? ?? ?? 13 ?? 2B ?? 00 11 ?? 72 ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ??
        ?? ?? 28 ?? ?? ?? ?? 13 ?? 12 ?? 28 ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 13
    }

    $connect_v1_p2 = {
        00 1F ?? 8D ?? ?? ?? ?? 13 ?? 11 ?? 16 1B 8D ?? ?? ?? ?? 13 ?? 11 ?? 16 11 ?? A2 00
        11 ?? 17 7E ?? ?? ?? ?? A2 00 11 ?? 18 72 ?? ?? ?? ?? A2 00 11 ?? 19 7E ?? ?? ?? ??
        A2 00 11 ?? 1A 72 ?? ?? ?? ?? A2 00 11 ?? 28 ?? ?? ?? ?? A2 00 11 ?? 17 7E ?? ?? ??
        ?? A2 00 11 ?? 18 72 ?? ?? ?? ?? A2 00 11 ?? 19 7E ?? ?? ?? ?? A2 00 11 ?? 1A 72 ??
        ?? ?? ?? A2 00 11 ?? 1B 7E ?? ?? ?? ?? 28 ?? ?? ?? ?? A2 00 11 ?? 1C 72 ?? ?? ?? ??
        A2 00 11 ?? 1D 7E ?? ?? ?? ?? 28 ?? ?? ?? ?? A2 00 11 ?? 1E 72 ?? ?? ?? ?? A2 00 11
        ?? 1F ?? 7E ?? ?? ?? ?? 28 ?? ?? ?? ?? A2 00 11 ?? 1F ?? 72 ?? ?? ?? ?? A2 00 11 ??
        1F ?? 7E ?? ?? ?? ?? 28 ?? ?? ?? ?? A2 00 11 ?? 1F ?? 72 ?? ?? ?? ?? A2 00 11 ?? 1F
        ?? 7E ?? ?? ?? ?? 28 ?? ?? ?? ?? A2 00 11 ?? 1F ?? 72 ?? ?? ?? ?? A2 00 11 ?? 1F ??
        7E ?? ?? ?? ?? 28 ?? ?? ?? ?? A2 00 11 ?? 1F ?? 72 ?? ?? ?? ?? A2 00 11 ?? 1F ?? 7E
        ?? ?? ?? ?? 28 ?? ?? ?? ?? A2 00 11 ?? 1F ?? 72 ?? ?? ?? ?? A2 00 11 ?? 1F ?? 7E ??
        ?? ?? ?? 28 ?? ?? ?? ?? A2 00 11 ?? 28 ?? ?? ?? ?? 13 ?? 72 ?? ?? ?? ?? 7E ?? ?? ??
        ?? 12 ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 26 DE ?? 25 28 ?? ?? ?? ?? 13
        ?? 00 28 ?? ?? ?? ?? DE ?? 00 DE ?? 25 28 ?? ?? ?? ?? 13 ?? 00 16 80 ?? ?? ?? ?? 28
        ?? ?? ?? ?? DE ?? 00 00 DE ?? 11 ?? 28 ?? ?? ?? ?? 00 DC 7E ?? ?? ?? ?? 0A 2B ?? 06
    }

    $send_v1 = {
        00 7E ?? ?? ?? ?? 16 (FE | 01) ?? 13 ?? 11 ?? 2C ?? 16 0A 38 ?? ?? ?? ?? 00 00 7E ??
        ?? ?? ?? 0B 00 07 13 ?? 11 ?? 28 ?? ?? ?? ?? 00 00 7E ?? ?? ?? ?? 16 (FE | 01) ?? 13
        ?? 11 ?? 2C ?? 16 0A DD ?? ?? ?? ?? 00 73 ?? ?? ?? ?? 13 ?? 02 8E B7 0D 12 ?? 28 ??
        ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 13 ?? 12 ?? 28 ?? ?? ?? ?? 0C 11 ?? 08 16 08
        8E B7 6F ?? ?? ?? ?? 00 11 ?? 02 16 02 8E B7 6F ?? ?? ?? ?? 00 7E ?? ?? ?? ?? 6F ??
        ?? ?? ?? 11 ?? 6F ?? ?? ?? ?? 16 11 ?? 6F ?? ?? ?? ?? B7 16 6F ?? ?? ?? ?? 26 00 DE
        ?? 11 ?? 28 ?? ?? ?? ?? 00 DC DE ?? 25 28 ?? ?? ?? ?? 13 ?? 00 11 ?? 28 ?? ?? ?? ??
        00 11 ?? 13 ?? 00 7E ?? ?? ?? ?? 13 ?? 11 ?? 2C ?? 16 80 ?? ?? ?? ?? 7E ?? ?? ?? ??
        6F ?? ?? ?? ?? 00 00 DE ?? 25 28 ?? ?? ?? ?? 13 ?? 00 28 ?? ?? ?? ?? DE ?? 00 28 ??
        ?? ?? ?? DE ?? 00 7E ?? ?? ?? ?? 0A 2B ?? 06
    }

    $receive_v1_p1 = {
        00 00 00 72 ?? ?? ?? ?? 80 ?? ?? ?? ?? 7E ?? ?? ?? ?? 14 (FE | 01) ?? 16 (FE | 01) ??
        13 ?? 11 ?? 39 ?? ?? ?? ?? 15 6A 0A 16 0B 00 00 00 07 17 D6 0B 07 1F ?? (FE | 01) ??
        13 ?? 11 ?? 2C ?? 16 0B 17 28 ?? ?? ?? ?? 00 00 7E ?? ?? ?? ?? 16 (FE | 01) ?? 13 ??
        11 ?? 2C ?? 00 DD ?? ?? ?? ?? 00 7E ?? ?? ?? ?? 6F ?? ?? ?? ?? 17 (FE | 04) ?? 13 ??
        11 ?? 2C ?? 7E ?? ?? ?? ?? 6F ?? ?? ?? ?? 15 16 6F ?? ?? ?? ?? 26 00 00 00 7E ?? ??
        ?? ?? 6F ?? ?? ?? ?? 16 (FE | 02) ?? 13 ?? 11 ?? 39 ?? ?? ?? ?? 06 15 6A (FE | 01) ??
        13 ?? 11 ?? 39 ?? ?? ?? ?? 72 ?? ?? ?? ?? 13 ?? 38 ?? ?? ?? ?? 7E ?? ?? ?? ?? 6F ??
        ?? ?? ?? 6F ?? ?? ?? ?? 13 ?? 00 11 ?? 15 59 13 ?? 11 ?? 45 ?? ?? ?? ?? ?? ?? ?? ??
        ?? ?? ?? ?? 2B ?? 00 00 DD ?? ?? ?? ?? 2B ?? 00 11 ?? 28 ?? ?? ?? ?? 0A 72 ?? ?? ??
        ?? 13 ?? 06 16 6A (FE | 01) ?? 13 ?? 11 ?? 2C ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 26 15
        6A 0A 00 7E ?? ?? ?? ?? 6F ?? ?? ?? ?? 16 (FE | 02) ?? 16 (FE | 01) ?? 13 ?? 11 ?? 2C
        ?? 38 ?? ?? ?? ?? 00 38 ?? ?? ?? ?? 00 11 ?? 11 ?? 28 ?? ?? ?? ?? 13 ?? 12 ?? 28 ??
        ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 13 ?? 00 17 13 ?? 11 ?? 3A ??
        ?? ?? ?? 00 7E ?? ?? ?? ?? 6F ?? ?? ?? ?? 17 D6 17 DA 17 D6 8D ?? ?? ?? ?? 80 ?? ??
        ?? ?? 06 7E ?? ?? ?? ?? 6F ?? ?? ?? ?? DA 0D 7E ?? ?? ?? ?? 8E B7 6A 09 (FE | 02)
    }

    $receive_v1_p2 = {
        13 ?? 11 ?? 2C ?? 09 17 6A DA B7 17 D6 17 DA 17 D6 8D ?? ?? ?? ?? 80 ?? ?? ?? ?? 00
        7E ?? ?? ?? ?? 6F ?? ?? ?? ?? 7E ?? ?? ?? ?? 16 7E ?? ?? ?? ?? 8E B7 16 6F ?? ?? ??
        ?? 0C 7E ?? ?? ?? ?? 7E ?? ?? ?? ?? 16 08 6F ?? ?? ?? ?? 00 7E ?? ?? ?? ?? 6F ?? ??
        ?? ?? 06 (FE | 01) ?? 13 ?? 11 ?? 2C ?? 15 6A 0A 14 (FE | 06) ?? ?? ?? ?? ?? 73 ?? ??
        ?? ?? 17 73 ?? ?? ?? ?? 13 ?? 11 ?? 7E ?? ?? ?? ?? 6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 00
        11 ?? 1F ?? 6F ?? ?? ?? ?? 26 7E ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 73 ?? ?? ?? ?? 80 ??
        ?? ?? ?? 00 38 ?? ?? ?? ?? 00 DE ?? 25 28 ?? ?? ?? ?? 13 ?? 00 28 ?? ?? ?? ?? DE ??
        00 00 00 00 00 7E ?? ?? ?? ?? 14 (FE | 01) ?? 16 (FE | 01) ?? 13 ?? 11 ?? 2C ?? 7E ??
        ?? ?? ?? 28 ?? ?? ?? ?? 14 72 ?? ?? ?? ?? 16 8D ?? ?? ?? ?? 14 14 14 17 28 ?? ?? ??
        ?? 26 14 80 ?? ?? ?? ?? 00 DE ?? 25 28 ?? ?? ?? ?? 13 ?? 00 28 ?? ?? ?? ?? DE ?? 00
        16 80 ?? ?? ?? ?? 28 ?? ?? ?? ?? 16 (FE | 01) ?? 13 ?? 11 ?? 2C ?? 2B ?? 00 17 80 ??
        ?? ?? ?? 38 ?? ?? ?? ?? 00
    }

    $connect_v2 = {
        16 80 ?? ?? ?? ?? 20 D0 07 00 00 28 ?? ?? ?? ?? 7E ?? ?? ?? ?? 0A 06 25 13 ?? 28 ??
        ?? ?? ?? 7E ?? ?? ?? ?? 2C ?? 7E ?? ?? ?? ?? 6F ?? ?? ?? ?? 14 80 ?? ?? ?? ?? DE ??
        26 DE ?? 7E ?? ?? ?? ?? 6F ?? ?? ?? ?? DE ?? 26 DE ?? DE ?? 26 DE ?? 73 ?? ?? ?? ??
        80 ?? ?? ?? ?? 73 ?? ?? ?? ?? 80 ?? ?? ?? ?? 7E ?? ?? ?? ?? 20 00 20 03 00 6F ?? ??
        ?? ?? 7E ?? ?? ?? ?? 20 00 20 03 00 6F ?? ?? ?? ?? 7E ?? ?? ?? ?? 6F ?? ?? ?? ?? 20
        10 27 00 00 6F ?? ?? ?? ?? 7E ?? ?? ?? ?? 6F ?? ?? ?? ?? 20 10 27 00 00 6F ?? ?? ??
        ?? 7E ?? ?? ?? ?? 7E ?? ?? ?? ?? 7E ?? ?? ?? ?? 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 17 80
        ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 26 7E ?? ?? ?? ?? 0B 72 ?? ?? ?? ?? 72 ??
        ?? ?? ?? 28 ?? ?? ?? ?? 72 ?? ?? ?? ?? 16 28 ?? ?? ?? ?? 2C ?? 07 7F ?? ?? ?? ?? 28
        ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 0B 2B ?? 07 0C 72 ?? ?? ?? ?? 72 ?? ?? ??
        ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 0D 08 12 ?? 28 ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ??
        ?? ?? 0B 1B 8D ?? ?? ?? ?? 13 ?? 11 ?? 16 07 A2 11 ?? 17 7E ?? ?? ?? ?? A2 11 ?? 18
        72 ?? ?? ?? ?? A2 11 ?? 19 7E ?? ?? ?? ?? A2 11 ?? 1A 72 ?? ?? ?? ?? A2 11 ?? 28 ??
        ?? ?? ?? 0B 07 7E ?? ?? ?? ?? 6F ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 0B 07 7E
        ?? ?? ?? ?? 6F ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 0B 07 72 ?? ?? ?? ?? 28 ??
        ?? ?? ?? 0B 07 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 0B 07 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 0B
        07 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 0B 72 ?? ?? ?? ?? 7E ?? ?? ?? ?? 12 ?? 28 ?? ?? ??
        ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 26 DE ?? 26 DE ?? DE ?? 26 16 80 ?? ?? ?? ?? DE ??
        DE ?? 11 ?? 28 ?? ?? ?? ?? DC 7E
    }

    $receive_v2 = {
        72 ?? ?? ?? ?? 80 ?? ?? ?? ?? 7E ?? ?? ?? ?? 39 ?? ?? ?? ?? 15 6A 0A 16 0B 07 17 D6
        0B 07 1F ?? 33 ?? 16 0B 17 28 ?? ?? ?? ?? 7E ?? ?? ?? ?? 39 ?? ?? ?? ?? 7E ?? ?? ??
        ?? 6F ?? ?? ?? ?? 17 3C ?? ?? ?? ?? 7E ?? ?? ?? ?? 6F ?? ?? ?? ?? 15 16 6F ?? ?? ??
        ?? 26 38 ?? ?? ?? ?? 06 15 6A 3B ?? ?? ?? ?? 7E ?? ?? ?? ?? 6F ?? ?? ?? ?? 17 D6 8D
        ?? ?? ?? ?? 80 ?? ?? ?? ?? 06 7E ?? ?? ?? ?? 6F ?? ?? ?? ?? DA 0C 7E ?? ?? ?? ?? 8E
        69 6A 08 31 ?? 08 17 6A DA B7 17 D6 8D ?? ?? ?? ?? 80 ?? ?? ?? ?? 7E ?? ?? ?? ?? 6F
        ?? ?? ?? ?? 7E ?? ?? ?? ?? 16 7E ?? ?? ?? ?? 8E 69 16 6F ?? ?? ?? ?? 0D 7E ?? ?? ??
        ?? 7E ?? ?? ?? ?? 16 09 6F ?? ?? ?? ?? 7E ?? ?? ?? ?? 6F ?? ?? ?? ?? 06 40 ?? ?? ??
        ?? 15 6A 0A 7E ?? ?? ?? ?? 2D ?? 14 (FE | 06) ?? ?? ?? ?? ?? 73 ?? ?? ?? ?? 80 ?? ??
        ?? ?? 7E ?? ?? ?? ?? 17 73 ?? ?? ?? ?? 13 ?? 11 ?? 7E ?? ?? ?? ?? 6F ?? ?? ?? ?? 6F
        ?? ?? ?? ?? 11 ?? 1F ?? 6F ?? ?? ?? ?? 26 7E ?? ?? ?? ?? 6F ?? ?? ?? ?? 73 ?? ?? ??
        ?? 80 ?? ?? ?? ?? 38 ?? ?? ?? ?? 72 ?? ?? ?? ?? 13 ?? 7E ?? ?? ?? ?? 6F ?? ?? ?? ??
        6F ?? ?? ?? ?? 13 ?? 11 ?? 15 2E ?? 11 ?? 2C ?? 11 ?? 11 ?? 28 ?? ?? ?? ?? 13 ?? 12
        ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 13 ?? 2B ?? 11 ?? 28
        ?? ?? ?? ?? 0A 06 16 6A 33 ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 26 15 6A 0A 7E ?? ?? ??
        ?? 6F ?? ?? ?? ?? 16 3E ?? ?? ?? ?? 7E ?? ?? ?? ?? 6F ?? ?? ?? ?? 3A ?? ?? ?? ?? DE
        ?? 26 DE ?? 7E ?? ?? ?? ?? 2C ?? 7E ?? ?? ?? ?? 14 72 ?? ?? ?? ?? 16 8D ?? ?? ?? ??
        14 14 14 17 28 ?? ?? ?? ?? 26 14 80 ?? ?? ?? ?? DE ?? 26 DE ?? 16 80 ?? ?? ?? ?? 28
        ?? ?? ?? ?? 2C ?? 17 80
    }

    $get_system_information_v2_p1 = {
        72 ?? ?? ?? ?? 7E ?? ?? ?? ?? 28 ?? ?? ?? ?? 0A 72 ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ??
        ?? ?? ?? 72 ?? ?? ?? ?? 16 28 ?? ?? ?? ?? 2C ?? 06 0B 7F ?? ?? ?? ?? 28 ?? ?? ?? ??
        72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 0C 07 12 ?? 28 ?? ?? ?? ?? 7E ?? ?? ??
        ?? 28 ?? ?? ?? ?? 0A 2B ?? 06 0D 72 ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ??
        ?? ?? ?? 13 ?? 12 ?? 28 ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 13
        ?? 09 12 ?? 28 ?? ?? ?? ?? 7E ?? ?? ?? ?? 28 ?? ?? ?? ?? 0A DE ?? 26 06 13 ?? 28 ??
        ?? ?? ?? 13 ?? 11 ?? 12 ?? 28 ?? ?? ?? ?? 7E ?? ?? ?? ?? 28 ?? ?? ?? ?? 0A DE ?? 06
        28 ?? ?? ?? ?? 7E ?? ?? ?? ?? 28 ?? ?? ?? ?? 0A DE ?? 26 06 72 ?? ?? ?? ?? 7E ?? ??
        ?? ?? 28 ?? ?? ?? ?? 0A DE ?? 06 28 ?? ?? ?? ?? 7E ?? ?? ?? ?? 28 ?? ?? ?? ?? 0A DE
        ?? 26 06 72 ?? ?? ?? ?? 7E ?? ?? ?? ?? 28 ?? ?? ?? ?? 0A DE ?? 06 7E ?? ?? ?? ?? 6F
        ?? ?? ?? ?? 13 ?? 12 ?? 28 ?? ?? ?? ?? 13 ?? 12 ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 7E
        ?? ?? ?? ?? 28 ?? ?? ?? ?? 0A DE ?? 26 06 72 ?? ?? ?? ?? 7E ?? ?? ?? ?? 28 ?? ?? ??
        ?? 0A DE ?? 06 72 ?? ?? ?? ?? 7E ?? ?? ?? ?? 28 ?? ?? ?? ?? 0A 06 73 ?? ?? ?? ?? 28
        ?? ?? ?? ?? 6F ?? ?? ?? ?? 28 ?? ?? ?? ?? 0A DE ?? 26 06 72 ?? ?? ?? ?? 28 ?? ?? ??
        ?? 0A DE ?? 06 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 0A 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 72 ??
        ?? ?? ?? 15 16 28 ?? ?? ?? ?? 13 ?? 11 ?? 8E 69 17 33 ?? 06 72 ?? ?? ?? ?? 28 ?? ??
        ?? ?? 0A 06 11 ?? 11 ?? 8E 69 17 DA 9A 28 ?? ?? ?? ?? 0A DE ?? 26 06 72
    }

    $get_system_information_v2_p2 = {
        28 ?? ?? ?? ?? 0A DE ?? 1F ?? 28 ?? ?? ?? ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 2C ?? 06
        72 ?? ?? ?? ?? 7E ?? ?? ?? ?? 28 ?? ?? ?? ?? 0A 2B ?? 06 72 ?? ?? ?? ?? 7E ?? ?? ??
        ?? 28 ?? ?? ?? ?? 0A DE ?? 26 06 7E ?? ?? ?? ?? 28 ?? ?? ?? ?? 0A DE ?? 28 ?? ?? ??
        ?? 2C ?? 06 72 ?? ?? ?? ?? 7E ?? ?? ?? ?? 28 ?? ?? ?? ?? 0A 2B ?? 06 72 ?? ?? ?? ??
        7E ?? ?? ?? ?? 28 ?? ?? ?? ?? 0A 06 7E ?? ?? ?? ?? 7E ?? ?? ?? ?? 28 ?? ?? ?? ?? 0A
        06 72 ?? ?? ?? ?? 7E ?? ?? ?? ?? 28 ?? ?? ?? ?? 0A 06 28 ?? ?? ?? ?? 7E ?? ?? ?? ??
        28 ?? ?? ?? ?? 0A 72 ?? ?? ?? ?? 13 ?? 7E ?? ?? ?? ?? 72 ?? ?? ?? ?? 7E ?? ?? ?? ??
        28 ?? ?? ?? ?? 16 6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 13 ?? 16 13 ?? 2B ?? 11 ?? 11 ?? 9A
        13 ?? 11 ?? 6F ?? ?? ?? ?? 1F ?? 33 ?? 11 ?? 11 ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 13
        ?? 11 ?? 17 D6 13 ?? 11 ?? 11 ?? 8E 69 32 ?? DE ?? 26 DE ?? 06 11 ?? 28
    }

    $send_v2 = {
        7E ?? ?? ?? ?? 2D ?? 16 2A 7E ?? ?? ?? ?? 0A 06 25 13 ?? 28 ?? ?? ?? ?? 7E ?? ?? ??
        ?? 2D ?? 16 13 ?? DD ?? ?? ?? ?? 73 ?? ?? ?? ?? 0B 02 8E 69 13 ?? 12 ?? 28 ?? ?? ??
        ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 0C 12 ?? 28 ?? ?? ?? ?? 0D 07 09 16 09 8E 69 6F ??
        ?? ?? ?? 07 02 16 02 8E 69 6F ?? ?? ?? ?? 7E ?? ?? ?? ?? 6F ?? ?? ?? ?? 07 6F ?? ??
        ?? ?? 16 07 6F ?? ?? ?? ?? B7 16 6F ?? ?? ?? ?? 26 07 6F ?? ?? ?? ?? DE ?? 11 ?? 28
        ?? ?? ?? ?? DC DE ?? 13 ?? 11 ?? 28 ?? ?? ?? ?? 7E ?? ?? ?? ?? 2C ?? 16 80 ?? ?? ??
        ?? 7E ?? ?? ?? ?? 6F ?? ?? ?? ?? DE ?? 26 DE ?? 28 ?? ?? ?? ?? DE ?? 7E ?? ?? ?? ??
        2A 11
    }

    condition:
        uint16(0) == 0x5A4D and
        (
            (
                (
                    all of ($persistence_mechanism_v1_p*)
                ) and
                (
                    all of ($connect_v1_p*)
                ) and
                (
                    $send_v1
                ) and
                (
                    all of ($receive_v1_p*)
                )
            ) or
            (
                (
                    $connect_v2
                ) and
                (
                    $receive_v2
                ) and
                (
                    all of ($get_system_information_v2_p*)
                ) and
                (
                    $send_v2
                )
            )
        )
}