rule ByteCode_MSIL_Backdoor_Menorah : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "MENORAH"
        description         = "Yara rule that detects Menorah backdoor."

        tc_detection_type   = "Backdoor"
        tc_detection_name   = "Menorah"
        tc_detection_factor = 5

    strings:

        $send_fingerprint_to_c2_p1 = {
            28 ?? ?? ?? ?? 04 6F ?? ?? ?? ?? 02 7B ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 0A
            73 ?? ?? ?? ?? 19 1F 0E 6F ?? ?? ?? ?? 17 28 ?? ?? ?? ?? 1F 5B 13 ?? 12 ?? 28 ?? ??
            ?? ?? 1F 40 13 ?? 12 ?? 28 ?? ?? ?? ?? 1F 40 13 ?? 12 ?? 28 ?? ?? ?? ?? 1F 5D 13 ??
            12 ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 1B 8D ?? ?? ?? ?? 25 16 1F 5B 13 ?? 12 ?? 28 ??
            ?? ?? ?? A2 25 17 1F 40 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 18 06 A2 25 19 1F 40 13 ??
            12 ?? 28 ?? ?? ?? ?? A2 25 1A 1F 5D 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 28 ?? ?? ?? ?? 6F
            ?? ?? ?? ?? 0B 28 ?? ?? ?? ?? 07 6F ?? ?? ?? ?? 0C 72 ?? ?? ?? ?? 0D 1F 3F 13 ?? 12
            ?? 28 ?? ?? ?? ?? 17 16 28 ?? ?? ?? ?? 1F 3D 13 ?? 12 ?? 28 ?? ?? ?? ?? 17 16 28 ??
            ?? ?? ?? 28 ?? ?? ?? ?? 13 ?? 03 11 ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 74 ?? ?? ?? ??
            13 ?? 11 ?? 1F 50 13 ?? 12 ?? 28 ?? ?? ?? ?? 1F 4F 13 ?? 12 ?? 28 ?? ?? ?? ?? 1F 53
            13 ?? 12 ?? 28 ?? ?? ?? ?? 1F 54 13 ?? 12 ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 6F ?? ??
            ?? ?? 11 ?? 1F 21 8D ?? ?? ?? ?? 25 16 1F 61 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 17 1F
            70 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 18 1F 70 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 19 1F
            6C 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1A 1F 69 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1B 1F
            63 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1C 1F 61 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1D 1F
            74 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1E 1F 69 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 09
        }

        $send_fingerprint_to_c2_p2 = {
            1F 6F 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 0A 1F 6E 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25
            1F 0B 1F 2F 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 0C 1F 78 13 ?? 12 ?? 28 ?? ?? ?? ??
            A2 25 1F 0D 1F 2D 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 0E 1F 77 13 ?? 12 ?? 28 ?? ??
            ?? ?? A2 25 1F 0F 1F 77 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 10 1F 77 13 ?? 12 ?? 28
            ?? ?? ?? ?? A2 25 1F 11 1F 2D 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 12 1F 66 13 ?? 12
            ?? 28 ?? ?? ?? ?? A2 25 1F 13 1F 6F 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 14 1F 72 13
            ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 15 1F 6D 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 16 1F
            2D 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 17 1F 75 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F
            18 1F 72 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 19 1F 6C 13 ?? 12 ?? 28 ?? ?? ?? ?? A2
            25 1F 1A 1F 65 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 1B 1F 6E 13 ?? 12 ?? 28 ?? ?? ??
            ?? A2 25 1F 1C 1F 63 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 1D 1F 6F 13 ?? 12 ?? 28 ??
            ?? ?? ?? A2 25 1F 1E 1F 64 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 1F 1F 65 13 ?? 12 ??
            28 ?? ?? ?? ?? A2 25 1F 20 1F 64 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 28 ?? ?? ?? ?? 6F ??
            ?? ?? ?? 11 ?? 08 8E 69 6A 6F ?? ?? ?? ?? 11 ?? 6F ?? ?? ?? ?? 25 08 16 08 8E 69 6F
            ?? ?? ?? ?? 6F ?? ?? ?? ?? 11 ?? 6F ?? ?? ?? ?? 25 6F ?? ?? ?? ?? 73 ?? ?? ?? ?? 25
            6F ?? ?? ?? ?? 0D 6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 09 13 ?? DE ?? 26 7E ?? ?? ?? ?? 13
            ?? DE ?? 11
        }

        $get_files_and_directories_p1 = {
            11 ?? 28 ?? ?? ?? ?? 13 ?? 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 13 ?? 11 ?? 8E 69 17 31 ??
            11 ?? 17 9A 13 ?? 11 ?? 72 ?? ?? ?? ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 13 ?? 1F 0F 8D
            ?? ?? ?? ?? 25 16 1F 44 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 17 1F 69 13 ?? 12 ?? 28 ??
            ?? ?? ?? A2 25 18 1F 72 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 19 1F 65 13 ?? 12 ?? 28 ??
            ?? ?? ?? A2 25 1A 1F 63 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1B 1F 74 13 ?? 12 ?? 28 ??
            ?? ?? ?? A2 25 1C 1F 6F 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1D 1F 72 13 ?? 12 ?? 28 ??
            ?? ?? ?? A2 25 1E 1F 79 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 09 1F 20 13 ?? 12 ?? 28
            ?? ?? ?? ?? A2 25 1F 0A 1F 6F 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 0B 1F 66 13 ?? 12
            ?? 28 ?? ?? ?? ?? A2 25 1F 0C 1F 20 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 0D 11 ?? A2
            25 1F 0E 72 ?? ?? ?? ?? A2 28 ?? ?? ?? ?? 13 ?? 11 ?? 28 ?? ?? ?? ?? 13 ?? 11 ?? 28
            ?? ?? ?? ?? 13 ?? 11 ?? 13 ?? 16 13 ?? 38 ?? ?? ?? ?? 11 ?? 11 ?? 9A 73 ?? ?? ?? ??
            13 ?? 1F 0B 8D ?? ?? ?? ?? 25 16 11 ?? A2 25 17 11 ?? 6F ?? ?? ?? ?? 13 ?? 12 ?? 1F
            16 8D ?? ?? ?? ?? 25 16 1F 4D 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 17 1F 4D 13 ?? 12 ??
            28 ?? ?? ?? ?? A2 25 18 1F 2F 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 19 1F 64 13 ?? 12 ??
            28 ?? ?? ?? ?? A2 25 1A 1F 64 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1B 1F 2F 13 ?? 12 ??
            28 ?? ?? ?? ?? A2 25 1C 1F 79 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1D 1F 79 13 ?? 12
        }

        $get_files_and_directories_p2 = {
            28 ?? ?? ?? ?? A2 25 1E 1F 79 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F ?? 1F 79 13 ?? 12
            ?? 28 ?? ?? ?? ?? A2 25 1F 0A 1F 20 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 0B 1F 68 13
            ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 0C 1F 68 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 0D 1F
            3A 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 0E 1F 6D 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F
            0F 1F 6D 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 10 1F 3A 13 ?? 12 ?? 28 ?? ?? ?? ?? A2
            25 1F 11 1F 73 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 12 1F 73 13 ?? 12 ?? 28 ?? ?? ??
            ?? A2 25 1F 13 1F 20 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 14 1F 74 13 ?? 12 ?? 28 ??
            ?? ?? ?? A2 25 1F 15 1F 74 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 28 ?? ?? ?? ?? 28 ?? ?? ??
            ?? A2 25 18 72 ?? ?? ?? ?? A2 25 19 1F 3C 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1A 1F 44
            13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1B 1F 49 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1C 1F 52
            13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1D 1F 3E 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1E 72 ??
            ?? ?? ?? A2 25 1F 09 11 ?? 6F ?? ?? ?? ?? A2 25 1F 0A 72 ?? ?? ?? ?? A2 28 ?? ?? ??
            ?? 13 ?? 11 ?? 17 58 13 ?? 11 ?? 11 ?? 8E 69 3F ?? ?? ?? ?? 11 ?? 13 ?? 16 13 ?? 38
            ?? ?? ?? ?? 11 ?? 11 ?? 9A 73 ?? ?? ?? ?? 13 ?? 1F 0C 8D ?? ?? ?? ?? 25 16 11 ?? A2
            25 17 11 ?? 6F ?? ?? ?? ?? 13 ?? 12 ?? 1F 16 8D ?? ?? ?? ?? 25 16 1F 4D 13 ?? 12 ??
            28 ?? ?? ?? ?? A2 25 17 1F 4D 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 18 1F 2F 13 ?? 12 ??
            28 ?? ?? ?? ?? A2 25 19 1F 64 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1A 1F 64 13 ?? 12 ??
            28 ?? ?? ?? ?? A2 25 1B 1F 2F 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1C 1F 79 13 ?? 12 ??
            28 ?? ?? ?? ?? A2 25 1D 1F 79 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1E 1F 79 13 ?? 12 ??
            28 ?? ?? ?? ?? A2 25 1F 09 1F 79 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 0A 1F 20 13
        }

        $get_files_and_directories_p3 = {
            12 ?? 28 ?? ?? ?? ?? A2 25 1F 0B 1F 68 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 0C 1F 68
            13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 0D 1F 3A 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 0E
            1F 6D 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 0F 1F 6D 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25
            1F 10 1F 3A 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 11 1F 73 13 ?? 12 ?? 28 ?? ?? ?? ??
            A2 25 1F 12 1F 73 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 13 1F 20 13 ?? 12 ?? 28 ?? ??
            ?? ?? A2 25 1F 14 1F 74 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 15 1F 74 13 ?? 12 ?? 28
            ?? ?? ?? ?? A2 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? A2 25 18 72 ?? ?? ?? ?? A2 25 19 1F 46
            13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1A 1F 49 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1B 1F 4C
            13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1C 1F 45 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1D 72 ??
            ?? ?? ?? A2 25 1E 11 ?? 6F ?? ?? ?? ?? 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 09 72 ??
            ?? ?? ?? A2 25 1F 0A 11 ?? 6F ?? ?? ?? ?? A2 25 1F 0B 72 ?? ?? ?? ?? A2 28 ?? ?? ??
            ?? 13 ?? 11 ?? 17 58 13 ?? 11 ?? 11 ?? 8E 69 3F ?? ?? ?? ?? 1F 0B 8D ?? ?? ?? ?? 25
            16 11 ?? A2 25 17 72 ?? ?? ?? ?? A2 25 18 11 ?? 8E 69 13 ?? 12 ?? 28 ?? ?? ?? ?? A2
            25 19 1F 20 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1A 1F 44 13 ?? 12 ?? 28 ?? ?? ?? ?? A2
            25 1B 1F 69 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1C 1F 72 13 ?? 12 ?? 28 ?? ?? ?? ?? A2
            25 1D 1F 28 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1E 1F 73 13 ?? 12 ?? 28 ?? ?? ?? ?? A2
            25 1F 09 1F 29 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 0A 72 ?? ?? ?? ?? A2 28 ?? ?? ??
            ?? 13 ?? 1F 0B 8D ?? ?? ?? ?? 25 16 11 ?? A2 25 17 72 ?? ?? ?? ?? A2 25 18 11 ?? 8E
            69 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 19 1F 20 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1A 1F
        }

        $upload_file_to_c2_p1 = {
            11 ?? 28 ?? ?? ?? ?? 13 ?? 72 ?? ?? ?? ?? 13 ?? 11 ?? 8E 69 17 3E ?? ?? ?? ?? 11 ??
            17 9A 17 8D ?? ?? ?? ?? 25 16 1F 22 9D 6F ?? ?? ?? ?? 13 ?? 11 ?? 28 ?? ?? ?? ?? 39
            ?? ?? ?? ?? 11 ?? 28 ?? ?? ?? ?? 13 ?? 11 ?? 28 ?? ?? ?? ?? 13 ?? 02 28 ?? ?? ?? ??
            13 ?? 1F 0D 8D ?? ?? ?? ?? 25 16 1F 75 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 17 1F 40 13
            ?? 12 ?? 28 ?? ?? ?? ?? A2 25 18 11 ?? A2 25 19 1F 40 13 ?? 12 ?? 28 ?? ?? ?? ?? A2
            25 1A 28 ?? ?? ?? ?? A2 25 1B 1F 7C 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1C 28 ?? ?? ??
            ?? A2 25 1D 1F 40 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1E 11 ?? A2 25 1F 09 1F 40 13 ??
            12 ?? 28 ?? ?? ?? ?? A2 25 1F 0A 1F 32 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 0B 1F 40
            13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 0C 11 ?? 28 ?? ?? ?? ?? A2 28 ?? ?? ?? ?? 13 ??
            02 02 7B ?? ?? ?? ?? 11 ?? 28 ?? ?? ?? ?? 26 1F 1E 8D ?? ?? ?? ?? 25 16 1F 66 13 ??
            12 ?? 28 ?? ?? ?? ?? A2 25 17 1F 69 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 18 1F 6C 13 ??
            12 ?? 28 ?? ?? ?? ?? A2 25 19 1F 65 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1A 1F 5B 13 ??
            12 ?? 28 ?? ?? ?? ?? A2 25 1B 11 ?? A2 25 1C 1F 5D 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25
            1D 1F 20 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1E 1F 69 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25
            1F 09 1F 73 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 0A 1F 20 13 ?? 12 ?? 28
        }

        $upload_file_to_c2_p2 = {
            A2 25 1F 0B 1F 75 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 0C 1F 70 13 ?? 12 ?? 28 ?? ??
            ?? ?? A2 25 1F 0D 1F 6C 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 0E 1F 6F 13 ?? 12 ?? 28
            ?? ?? ?? ?? A2 25 1F 0F 1F 61 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 10 1F 64 13 ?? 12
            ?? 28 ?? ?? ?? ?? A2 25 1F 11 1F 65 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 12 1F 64 13
            ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 13 1F 20 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 14 1F
            74 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 15 1F 6F 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F
            16 1F 20 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 17 1F 73 13 ?? 12 ?? 28 ?? ?? ?? ?? A2
            25 1F 18 1F 65 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 19 1F 72 13 ?? 12 ?? 28 ?? ?? ??
            ?? A2 25 1F 1A 1F 76 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 1B 1F 65 13 ?? 12 ?? 28 ??
            ?? ?? ?? A2 25 1F 1C 1F 72 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1F 1D 1F 2E 13 ?? 12 ??
            28 ?? ?? ?? ?? A2 28 ?? ?? ?? ?? 13 ?? 38 ?? ?? ?? ?? 1F 0F 8D ?? ?? ?? ?? 25 16 1F
            66 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 17 1F 69 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 18 1F
            6C 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 19 1F 65 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1A 1F
            20 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1B 1F 6E 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 1C 1F
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            all of ($send_fingerprint_to_c2_p*)
        ) and
        (
            all of ($get_files_and_directories_p*)
        ) and
        (
            all of ($upload_file_to_c2_p*)
        )
}