rule ByteCode_MSIL_Backdoor_AsyncRAT : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "ASYNCRAT"
        description         = "Yara rule that detects AsyncRAT backdoor."

        tc_detection_type   = "Backdoor"
        tc_detection_name   = "AsyncRAT"
        tc_detection_factor = 5

    strings:

        $read_server_data_v1 = {
            28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 39 ?? ?? ?? ?? 28 ?? ?? ?? ?? 3A ?? ?? ?? ?? 16 28 ??
            ?? ?? ?? DD ?? ?? ?? ?? 28 ?? ?? ?? ?? 02 6F ?? ?? ?? ?? 0A 06 16 3E ?? ?? ?? ?? 28
            ?? ?? ?? ?? 06 6A 58 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 06 6A 59 28 ?? ?? ?? ?? 28 ?? ??
            ?? ?? 3A ?? ?? ?? ?? 28 ?? ?? ?? ?? 16 28 ?? ?? ?? ?? 6A 28 ?? ?? ?? ?? 28 ?? ?? ??
            ?? 16 6A 3E ?? ?? ?? ?? 16 6A 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? D4 8D ?? ?? ?? ?? 28 ??
            ?? ?? ?? 38 ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 69 28 ?? ?? ??
            ?? 69 6F ?? ?? ?? ?? 0B 07 16 3D ?? ?? ?? ?? 16 28 ?? ?? ?? ?? DD ?? ?? ?? ?? 28 ??
            ?? ?? ?? 07 6A 58 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 07 6A 59 28 ?? ?? ?? ?? 28 ?? ?? ??
            ?? 16 6A 3C ?? ?? ?? ?? 16 28 ?? ?? ?? ?? DD ?? ?? ?? ?? 28 ?? ?? ?? ?? 16 6A 30 ??
            14 (FE | 06) ?? ?? ?? ?? ?? 73 ?? ?? ?? ?? 73 ?? ?? ?? ?? 28 ?? ?? ?? ?? 6F ?? ?? ??
            ?? 16 6A 28 ?? ?? ?? ?? 1A 6A 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? D4 8D ?? ?? ?? ?? 28 ??
            ?? ?? ?? 38 ?? ?? ?? ?? 1A 6A 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? D4 8D ?? ?? ?? ?? 28 ??
            ?? ?? ?? 16 6A 28 ?? ?? ?? ?? 38 ?? ?? ?? ?? 28 ?? ?? ?? ?? 16 6A 3C ?? ?? ?? ?? 16
            28 ?? ?? ?? ?? DD ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 69 28 ??
            ?? ?? ?? 69 14 (FE | 06) ?? ?? ?? ?? ?? 73 ?? ?? ?? ?? 14 6F ?? ?? ?? ?? 26 38 ?? ??
            ?? ?? 16 28 ?? ?? ?? ?? DD ?? ?? ?? ?? 26 16 28 ?? ?? ?? ?? DD
        }

        $send_v1 = {
            28 ?? ?? ?? ?? 0A 16 0B 06 12 ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 3A ?? ?? ?? ?? DD ??
            ?? ?? ?? 02 8E 69 28 ?? ?? ?? ?? 0C 28 ?? ?? ?? ?? 15 17 6F ?? ?? ?? ?? 26 28 ?? ??
            ?? ?? 08 16 08 8E 69 6F ?? ?? ?? ?? 02 8E 69 20 ?? ?? ?? ?? 3E ?? ?? ?? ?? 02 73 ??
            ?? ?? ?? 0D 16 13 ?? 09 16 6A 6F ?? ?? ?? ?? 20 ?? ?? ?? ?? 8D ?? ?? ?? ?? 13 ?? 38
            ?? ?? ?? ?? 28 ?? ?? ?? ?? 15 17 6F ?? ?? ?? ?? 26 28 ?? ?? ?? ?? 11 ?? 16 11 ?? 6F
            ?? ?? ?? ?? 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 09 11 ?? 16 11 ?? 8E 69 6F ?? ?? ?? ?? 25
            13 ?? 16 30 ?? DD ?? ?? ?? ?? 09 39 ?? ?? ?? ?? 09 6F ?? ?? ?? ?? DC 28 ?? ?? ?? ??
            15 17 6F ?? ?? ?? ?? 26 28 ?? ?? ?? ?? 02 16 02 8E 69 6F ?? ?? ?? ?? 28 ?? ?? ?? ??
            6F ?? ?? ?? ?? DD ?? ?? ?? ?? 26 16 28 ?? ?? ?? ?? DD ?? ?? ?? ?? 07 39 ?? ?? ?? ??
            06 28 ?? ?? ?? ?? DC
        }

        $read_packet_v1_p1 = {
            73 ?? ?? ?? ?? 0A 06 73 ?? ?? ?? ?? 7D ?? ?? ?? ?? 06 7B ?? ?? ?? ?? 02 74 ?? ?? ??
            ?? 6F ?? ?? ?? ?? 06 7B ?? ?? ?? ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 0B
            07 28 ?? ?? ?? ?? 0C 08 20 4F 01 89 64 42 ?? ?? ?? ?? 08 20 7A 39 BA 13 42 ?? ?? ??
            ?? 08 20 D4 CA CD 0C 3B ?? ?? ?? ?? 08 20 7A 39 BA 13 3B ?? ?? ?? ?? 38 ?? ?? ?? ??
            08 20 2B C2 32 1B 3B ?? ?? ?? ?? 08 20 E2 A2 F4 57 3B ?? ?? ?? ?? 08 20 4F 01 89 64
            3B ?? ?? ?? ?? 38 ?? ?? ?? ?? 08 20 5A 15 79 D9 42 ?? ?? ?? ?? 08 20 B7 16 DB 7A 3B
            ?? ?? ?? ?? 08 20 39 20 3F B2 3B ?? ?? ?? ?? 08 20 5A 15 79 D9 3B ?? ?? ?? ?? 38 ??
            ?? ?? ?? 08 20 1E CA D2 DC 3B ?? ?? ?? ?? 08 20 45 FD B6 E0 3B ?? ?? ?? ?? 08 20 D0
            5E 9B FA 3B ?? ?? ?? ?? 38 ?? ?? ?? ?? 07 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 3A ?? ?? ??
            ?? 38 ?? ?? ?? ?? 07 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 3A ?? ?? ?? ?? 38 ?? ?? ?? ?? 07
            72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 3A ?? ?? ?? ?? 38 ?? ?? ?? ?? 07 72 ?? ?? ?? ?? 28 ??
            ?? ?? ?? 3A ?? ?? ?? ?? 38 ?? ?? ?? ?? 07 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 3A ?? ?? ??
            ?? 38 ?? ?? ?? ?? 07 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 3A ?? ?? ?? ?? 38 ?? ?? ?? ?? 07
            72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 3A ?? ?? ?? ?? 38 ?? ?? ?? ?? 07 72 ?? ?? ?? ?? 28 ??
            ?? ?? ?? 3A ?? ?? ?? ?? 38 ?? ?? ?? ?? 07 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 3A ?? ?? ??
            ?? 38 ?? ?? ?? ?? 07 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 3A ?? ?? ?? ?? 38 ?? ?? ?? ?? 07
        }

        $read_packet_v1_p2 = {
            72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 3A ?? ?? ?? ?? 38 ?? ?? ?? ?? 16 28 ?? ?? ?? ?? 73 ??
            ?? ?? ?? 25 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 25 72 ?? ??
            ?? ?? 6F ?? ?? ?? ?? 28 ?? ?? ?? ?? 6A 6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 28 ?? ?? ?? ??
            16 28 ?? ?? ?? ?? 38 ?? ?? ?? ?? 00 06 7B ?? ?? ?? ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ??
            6F ?? ?? ?? ?? 28 ?? ?? ?? ?? 3A ?? ?? ?? ?? 7E ?? ?? ?? ?? 06 7B ?? ?? ?? ?? 6F ??
            ?? ?? ?? 73 ?? ?? ?? ?? 25 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 72 ?? ?? ?? ?? 6F ?? ?? ??
            ?? 25 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 06 7B ?? ?? ?? ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ??
            6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 28 ?? ?? ?? ?? 38 ?? ?? ?? ?? 06 7B ??
            ?? ?? ?? 28 ?? ?? ?? ?? DD ?? ?? ?? ?? 6F ?? ?? ?? ?? 28 ?? ?? ?? ?? DD ?? ?? ?? ??
            06 7B ?? ?? ?? ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 06 7B ?? ?? ?? ?? 72
            ?? ?? ?? ?? 6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 28 ?? ?? ?? ?? 26 7E ?? ?? ?? ?? 28 ?? ??
            ?? ?? 6F ?? ?? ?? ?? 0D 38 ?? ?? ?? ?? 12 ?? 28 ?? ?? ?? ?? 13 ?? 11 ?? 72 ?? ?? ??
            ?? 6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 06 7B ?? ?? ?? ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 6F
            ?? ?? ?? ?? 28 ?? ?? ?? ?? 39 ?? ?? ?? ?? 11 ?? 28 ?? ?? ?? ?? 7E ?? ?? ?? ?? 11 ??
            6F ?? ?? ?? ?? 26 12 ?? 28 ?? ?? ?? ?? 2D ?? DD ?? ?? ?? ?? 12 ?? (FE | 16) ?? ?? ??
            ?? ?? 6F ?? ?? ?? ?? DC 73 ?? ?? ?? ?? 26 06 (FE | 06) ?? ?? ?? ?? ?? 73 ?? ?? ?? ??
            73 ?? ?? ?? ?? 25 16 6F ?? ?? ?? ?? 25 6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 38 ?? ?? ?? ??
            7E ?? ?? ?? ?? 25 3A ?? ?? ?? ?? 26 7E ?? ?? ?? ?? (FE | 06) ?? ?? ?? ?? ?? 73
        }

        $send_v2 = {
            7E ?? ?? ?? ?? 13 ?? 11 ?? 28 ?? ?? ?? ?? 16 13 ?? 11 ?? 12 ?? 28 ?? ?? ?? ?? 7E ??
            ?? ?? ?? 39 ?? ?? ?? ?? 73 ?? ?? ?? ?? 0A 02 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 0B 07 8E
            B7 28 ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 0C 06 08 16 08 8E B7
            6F ?? ?? ?? ?? 06 07 16 07 8E B7 6F ?? ?? ?? ?? 7E ?? ?? ?? ?? 15 17 6F ?? ?? ?? ??
            26 7E ?? ?? ?? ?? 06 6F ?? ?? ?? ?? 16 06 6F ?? ?? ?? ?? B7 16 14 (FE | 06) ?? ?? ??
            ?? ?? 73 ?? ?? ?? ?? 14 6F ?? ?? ?? ?? 26 DE ?? 06 2C ?? 06 6F ?? ?? ?? ?? DC DE ??
            25 28 ?? ?? ?? ?? 0D 16 80 ?? ?? ?? ?? 28 ?? ?? ?? ?? DE ?? DE ?? 11 ?? 2C ?? 11 ??
            28 ?? ?? ?? ?? DC
        }

        $open_url_v2 = {
            03 39 ?? ?? ?? ?? 17 28 ?? ?? ?? ?? 20 00 0C 00 00 28 ?? ?? ?? ?? 20 0F 27 00 00 28
            ?? ?? ?? ?? DE ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? DE ?? 02 28 ?? ?? ?? ?? 74 ?? ?? ??
            ?? 0A 06 7E ?? ?? ?? ?? 73 ?? ?? ?? ?? 7E ?? ?? ?? ?? 8E B7 6F ?? ?? ?? ?? 9A 6F ??
            ?? ?? ?? 06 17 6F ?? ?? ?? ?? 06 20 10 27 00 00 6F ?? ?? ?? ?? 06 72 ?? ?? ?? ?? 6F
            ?? ?? ?? ?? 06 6F ?? ?? ?? ?? 74 ?? ?? ?? ?? 0B DE ?? 07 2C ?? 07 6F ?? ?? ?? ?? DC
            2B ?? 02 28 ?? ?? ?? ?? 26
        }

        $monitoring_v2 = {
            73 ?? ?? ?? ?? 0C 02 72 ?? ?? ?? ?? 15 16 28 ?? ?? ?? ?? 13 ?? 16 13 ?? 2B ?? 11 ??
            11 ?? 9A 0B 08 07 14 72 ?? ?? ?? ?? 16 8D ?? ?? ?? ?? 14 14 14 28 ?? ?? ?? ?? 28 ??
            ?? ?? ?? 6F ?? ?? ?? ?? 11 ?? 17 D6 13 ?? 11 ?? 11 ?? 8E B7 32 ?? 1F ?? 0A 38 ?? ??
            ?? ?? 28 ?? ?? ?? ?? 13 ?? 16 13 ?? 2B ?? 11 ?? 11 ?? 9A 0D 09 6F ?? ?? ?? ?? 28 ??
            ?? ?? ?? 2C ?? 2B ?? 08 09 6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 25 (FE | 07) ?? ?? ?? ?? ??
            73 ?? ?? ?? ?? 28 ?? ?? ?? ?? 2C ?? 06 1F ?? 31 ?? 16 0A 72 ?? ?? ?? ?? 09 6F ?? ??
            ?? ?? 6F ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 11 ?? 17 D6 13 ??
            11 ?? 11 ?? 8E B7 32 ?? 06 17 D6 0A 20 ?? ?? ?? ?? 28 ?? ?? ?? ?? 7E ?? ?? ?? ?? 3A
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            (
                (
                    $read_server_data_v1
                ) and
                (
                    $send_v1
                ) and
                (
                    all of ($read_packet_v1_p*)
                )
            ) or
            (
                (
                    $send_v2
                ) and
                (
                    $open_url_v2
                ) and
                (
                    $monitoring_v2
                )
            )
        )
}