import React from 'react';
import PropTypes from 'prop-types';

const ShareIcon = (props) => {
    const { className } = props;
    return (
        <svg className={className} fill="#576574" width="13px" height="14px" viewBox="0 0 13 14" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlnsXlink="http://www.w3.org/1999/xlink">
            <path d="M9.625,8.75 C9.0068125,8.75 8.43863672,8.96380078 7.99011719,9.32134766 L5.18776562,7.56987109 C5.2707541,7.19447981 5.2707541,6.80549284 5.18776562,6.43010156 L7.99011719,4.678625 C8.43863672,5.03619922 9.0068125,5.25 9.625,5.25 C11.0747383,5.25 12.25,4.07473828 12.25,2.625 C12.25,1.17526172 11.0747383,0 9.625,0 C8.17526172,0 7,1.17526172 7,2.625 C7,2.82072656 7.02160156,3.01136719 7.06223438,3.19487109 L4.25988281,4.94634766 C3.81136328,4.58880078 3.2431875,4.375 2.625,4.375 C1.17526172,4.375 0,5.55026172 0,7 C0,8.44973828 1.17526172,9.625 2.625,9.625 C3.2431875,9.625 3.81136328,9.41119922 4.25988281,9.05365234 L7.06223438,10.8051289 C7.02081278,10.9922551 6.99994436,11.1833442 7,11.375 C7,12.8247383 8.17526172,14 9.625,14 C11.0747383,14 12.25,12.8247383 12.25,11.375 C12.25,9.92526172 11.0747383,8.75 9.625,8.75 Z" />
        </svg>
    );
};

ShareIcon.propTypes = {
    className: PropTypes.string,
};

ShareIcon.defaultProps = {
    className: undefined,
};

export default ShareIcon;
