/*
 * Copyright 2023 Redpanda Data, Inc.
 *
 * Licensed as a Redpanda Enterprise file under the Redpanda Community
 * License (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * https://github.com/vectorizedio/redpanda/blob/master/licenses/rcl.md
 */

#include "delta_for_characterization_data.h"

#include <cstdint>

// data produced from v23.2.1-rc7-80-g2b2cb3b60 -
// 2b2cb3b60c1387e3ba919626009375dea5a08a46
constexpr auto characterization_data = std::to_array<deltafor_datapoint>(
  {{(int64_t[]){0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    (uint8_t[]){0, 0, 25, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0,  0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0}},
   {(int64_t[]){0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0},
    (uint8_t[]){0, 0, 27, 0, 0, 0, 0, 0, 0, 0, 0,   0,  0, 0, 0, 0, 0,
                0, 0, 0,  0, 0, 3, 0, 0, 0, 1, 108, 24, 1, 0, 0, 0}},
   {(int64_t[]){0, 0, 3, 1, 1, 2, 1, 0, 1, 1, 1, 3, 0, 0, 1, 1},
    (uint8_t[]){0, 0, 29, 0, 0, 0, 0, 0, 0, 0,   0,   0,   0,  0, 1, 0, 0, 0,
                0, 0, 0,  0, 5, 0, 0, 0, 2, 176, 124, 129, 19, 1, 0, 0, 0}},
   {(int64_t[]){1, 2, 7, 3, 2, 5, 2, 2, 3, 0, 0, 6, 2, 0, 0, 3},
    (uint8_t[]){0, 0, 31, 0, 0, 0, 0, 0, 0,  0,   0,  0,  0,  0,  3, 0, 0, 0, 0,
                0, 0, 0,  7, 0, 0, 0, 3, 89, 153, 31, 25, 76, 97, 1, 0, 0, 0}},
   {(int64_t[]){0, 5, 14, 0, 6, 11, 7, 5, 7, 3, 7, 14, 6, 7, 4, 6},
    (uint8_t[]){0, 0,  33,  0,   0,  0,  0,   0,  0,  0, 0, 0, 0,
                0, 6,  0,   0,   0,  0,  0,   0,  0,  9, 0, 0, 0,
                4, 80, 235, 214, 44, 66, 148, 24, 35, 1, 0, 0, 0}},
   {(int64_t[]){6, 9, 26, 8, 11, 27, 8, 14, 2, 6, 6, 17, 9, 12, 2, 10},
    (uint8_t[]){0,  0,  35,  0,  0,   0,   0,   0,   0,  0, 0, 0, 0, 0,
                10, 0,  0,   0,  0,   0,   0,   0,   11, 0, 0, 0, 5, 230,
                77, 57, 224, 52, 140, 128, 139, 139, 67, 1, 0, 0, 0}},
   {(int64_t[]){5, 24, 58, 9, 18, 37, 12, 15, 19, 13, 14, 38, 17, 2, 19, 28},
    (uint8_t[]){0,   0,   37, 0,   0,  0,   0,   0,  0,  0, 0, 0, 0,  0,  28,
                0,   0,   0,  0,   0,  0,   0,   13, 0,  0, 0, 6, 69, 39, 206,
                219, 157, 14, 156, 55, 160, 247, 20, 61, 1, 0, 0, 0}},
   {(int64_t[]){
      12, 57, 116, 22, 55, 125, 47, 63, 24, 60, 0, 69, 46, 11, 12, 39},
    (uint8_t[]){0,  0,  39, 0,  0,  0,  0,   0,   0,  0,  0,  0, 0,   0,  39,
                0,  0,  0,  0,  0,  0,  0,   15,  0,  0,  0,  7, 140, 90, 83,
                28, 82, 74, 33, 39, 18, 175, 184, 46, 29, 86, 1, 0,   0,  0}},
   {(int64_t[]){
      24, 78, 203, 116, 3, 221, 27, 120, 115, 124, 82, 153, 48, 68, 14, 87},
    (uint8_t[]){0,  0,  41,  0,   0,   0,   0,   0,   0,   0,   0,  0,
                0,  0,  87,  0,   0,   0,   0,   0,   0,   0,   17, 0,
                0,  0,  8,   24,  86,  133, 191, 119, 222, 198, 99, 11,
                15, 46, 203, 169, 116, 74,  89,  1,   0,   0,   0}},
   {(int64_t[]){
      226,
      96,
      355,
      245,
      136,
      473,
      68,
      221,
      23,
      40,
      197,
      474,
      142,
      22,
      230,
      252},
    (uint8_t[]){0,  0,   43,  0,  0,   0,   0,  0,   0,   0,   0,  0,   0,
                0,  252, 0,   0,  0,   0,   0,  0,   0,   19,  0,  0,   0,
                9,  226, 130, 3,  150, 125, 81, 157, 153, 202, 63, 237, 31,
                84, 152, 240, 26, 108, 24,  1,  0,   0,   0}},
   {(int64_t[]){
      488,
      348,
      991,
      271,
      135,
      835,
      142,
      363,
      209,
      212,
      61,
      875,
      61,
      11,
      461,
      36},
    (uint8_t[]){0,  0,   45,  0,   0,   0,   0,   0,   0,   0,   0, 0,   0,
                0,  36,  0,   0,   0,   0,   0,   0,   0,   21,  0, 0,   0,
                10, 232, 180, 131, 208, 136, 196, 205, 229, 186, 5, 233, 86,
                86, 54,  198, 233, 161, 125, 193, 83,  1,   0,   0, 0}},
   {(int64_t[]){
      985,
      895,
      2025,
      615,
      229,
      1845,
      581,
      679,
      888,
      1015,
      867,
      1500,
      595,
      161,
      88,
      213},
    (uint8_t[]){0,   0,   47,  0,   0,   0,   0,   0,   0,   0,   0,
                0,   0,   0,   213, 0,   0,   0,   0,   0,   0,   0,
                23,  0,   0,   0,   11,  217, 166, 150, 142, 130, 208,
                112, 226, 223, 143, 148, 191, 143, 242, 249, 141, 3,
                171, 23,  1,   124, 1,   1,   0,   0,   0}},
   {(int64_t[]){
      1096,
      245,
      3743,
      1675,
      1020,
      3195,
      269,
      1973,
      1224,
      1448,
      2026,
      3000,
      1787,
      302,
      751,
      697},
    (uint8_t[]){0,   0,   49,  0,   0,   0,   0,   0,   0,   0,   0,
                0,   0,   0,   185, 2,   0,   0,   0,   0,   0,   0,
                25,  0,   0,   0,   12,  72,  189, 106, 20,  119, 135,
                118, 184, 125, 96,  66,  82,  67,  213, 193, 86,  68,
                142, 245, 109, 19,  194, 125, 3,   1,   0,   0,   0}},
   {(int64_t[]){
      741,
      754,
      6036,
      18,
      2153,
      5845,
      3363,
      1300,
      1424,
      3290,
      2321,
      7056,
      2769,
      3377,
      1849,
      3696},
    (uint8_t[]){0,  0,   51,  0,   0,   0,   0,   0,   0,   0,   0,   0,
                0,  0,   112, 14,  0,   0,   0,   0,   0,   0,   27,  0,
                0,  0,   13,  229, 23,  102, 134, 123, 188, 246, 55,  132,
                74, 203, 129, 65,  224, 8,   73,  2,   212, 139, 252, 70,
                32, 21,  25,  143, 74,  1,   0,   0,   0}},
   {(int64_t[]){
      2812,
      1278,
      12777,
      6617,
      3377,
      9180,
      2105,
      2128,
      1177,
      4468,
      3909,
      15134,
      5365,
      5892,
      1735,
      6876},
    (uint8_t[]){0,   0,  53,  0,   0,   0,   0,   0,   0,   0,   0,   0,
                0,   0,  220, 26,  0,   0,   0,   0,   0,   0,   29,  0,
                0,   0,  14,  252, 2,   23,  48,  232, 237, 229, 105, 201,
                237, 49, 91,  235, 241, 195, 27,  138, 83,  163, 148, 187,
                2,   76, 229, 209, 239, 16,  113, 1,   0,   0,   0}},
   {(int64_t[]){
      1024,
      3850,
      27102,
      1380,
      14531,
      23763,
      4053,
      7841,
      11167,
      2476,
      720,
      29328,
      2746,
      2750,
      1529,
      8264},
    (uint8_t[]){0,  0,   55, 0,   0,   0,   0,   0,   0,   0,  0,  0,   0,
                0,  72,  32, 0,   0,   0,   0,   0,   0,   31, 0,  0,   0,
                15, 0,   10, 212, 186, 167, 16,  6,   116, 62, 51, 124, 64,
                42, 4,   71, 177, 132, 133, 153, 221, 35,  79, 35, 53,  209,
                2,  142, 7,  60,  74,  1,   0,   0,   0}},
   {(int64_t[]){
      8043,
      23644,
      42862,
      3554,
      26981,
      52330,
      3384,
      32010,
      17896,
      17374,
      554,
      62200,
      16546,
      26706,
      8377,
      29790},
    (uint8_t[]){0,   0,   57,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                0,   94,  116, 0,   0,   0,   0,   0,   0,   33,  0,   0,   0,
                16,  107, 31,  55,  67,  50,  251, 140, 170, 135, 100, 15,  165,
                82,  193, 50,  112, 226, 56,  54,  6,   244, 65,  210, 240, 90,
                178, 240, 40,  235, 72,  231, 84,  1,   0,   0,   0}},
   {(int64_t[]){
      61610,
      21582,
      80850,
      28405,
      65311,
      115043,
      38547,
      52644,
      18196,
      40264,
      4974,
      74141,
      45123,
      35175,
      54873,
      63059},
    (uint8_t[]){0,   0,   59,  0,   0,   0,   0,   0,   0,  0,   0,   0,   0,
                0,   83,  246, 0,   0,   0,   0,   0,   0,  35,  0,   0,   0,
                17,  170, 240, 228, 164, 156, 111, 39,  85, 234, 145, 124, 62,
                240, 87,  55,  91,  176, 138, 92,  218, 38, 142, 243, 50,  222,
                145, 36,  57,  62,  95,  10,  32,  108, 24, 1,   0,   0,   0}},
   {(int64_t[]){
      18171,
      71611,
      259791,
      81811,
      86835,
      253498,
      15651,
      94044,
      25711,
      694,
      99746,
      261349,
      122820,
      82786,
      26158,
      127438},
    (uint8_t[]){0,   0,   61,  0,   0,   0,   0,   0,   0,   0,   0,   0,
                0,   0,   206, 241, 1,   0,   0,   0,   0,   0,   37,  0,
                0,   0,   18,  251, 70,  64,  81,  116, 225, 92,  201, 160,
                108, 9,   141, 25,  227, 127, 82,  51,  11,  217, 102, 20,
                135, 71,  121, 33,  35,  166, 156, 76,  37,  224, 151, 164,
                120, 145, 82,  1,   0,   0,   0}},
   {(int64_t[]){
      54994,
      134365,
      386457,
      220489,
      229539,
      329914,
      218424,
      157318,
      223192,
      35122,
      231846,
      425212,
      29208,
      41805,
      129925,
      180200},
    (uint8_t[]){0,   0,  63,  0,   0,   0,   0,   0,   0,   0,   0,   0,
                0,   0,  232, 191, 2,   0,   0,   0,   0,   0,   39,  0,
                0,   0,  19,  210, 214, 15,  218, 68,  233, 208, 184, 234,
                221, 25, 136, 130, 93,  190, 51,  94,  1,   234, 238, 148,
                0,   90, 245, 228, 14,  85,  209, 200, 88,  109, 68,  208,
                13,  59, 217, 106, 100, 1,   0,   0,   0}},
   {(int64_t[]){
      79942,
      260159,
      870773,
      277702,
      206363,
      586586,
      329266,
      90835,
      281942,
      471883,
      279560,
      815838,
      447151,
      423284,
      441217,
      16844},
    (uint8_t[]){0,   0,   65,  0,   0,   0,   0,   0,   0,   0,   0,   0,
                0,   0,   204, 65,  0,   0,   0,   0,   0,   0,   41,  0,
                0,   0,   20,  70,  56,  121, 192, 74,  177, 179, 117, 221,
                26,  65,  213, 104, 245, 225, 100, 133, 47,  29,  126, 67,
                119, 214, 54,  113, 160, 219, 167, 245, 206, 77,  250, 33,
                158, 183, 77,  53,  131, 10,  96,  1,   0,   0,   0}},
   {(int64_t[]){
      234257,
      938411,
      1946036,
      581743,
      459326,
      1410412,
      289967,
      1026893,
      596188,
      980,
      616847,
      1807396,
      307338,
      1036453,
      898089,
      28318},
    (uint8_t[]){0,   0,   67,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                0,   158, 110, 0,   0,   0,   0,   0,   0,   43,  0,   0,   0,
                21,  17,  147, 186, 194, 31,  224, 219, 81,  81,  226, 82,  135,
                195, 233, 226, 199, 145, 179, 8,   27,  91,  106, 171, 253, 174,
                36,  47,  96,  140, 100, 183, 218, 163, 205, 250, 100, 92,  38,
                37,  249, 151, 104, 1,   0,   0,   0}},
   {(int64_t[]){
      967471,
      941973,
      3808293,
      1309220,
      1471722,
      3994158,
      939756,
      48519,
      1529040,
      193930,
      1799583,
      2237522,
      997671,
      578469,
      300577,
      798275},
    (uint8_t[]){0,   0,   69,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                0,   67,  46,  12,  0,   0,   0,   0,   0,   45,  0,   0,   0,
                22,  47,  195, 186, 156, 176, 67,  1,   230, 206, 142, 196, 134,
                194, 164, 107, 235, 87,  233, 90,  161, 21,  128, 205, 81,  117,
                29,  130, 234, 132, 69,  98,  184, 14,  64,  167, 133, 42,  59,
                87,  149, 229, 237, 193, 32,  1,   0,   0,   0}},
   {(int64_t[]){
      799302,
      2782970,
      4715776,
      3477559,
      2569812,
      6945525,
      3731004,
      2441332,
      619178,
      3621086,
      131764,
      4660775,
      1061075,
      3941827,
      2709337,
      3761927},
    (uint8_t[]){0,   0,  71,  0,   0,   0,   0,   0,  0,   0,  0,   0,   0,
                0,   7,  103, 57,  0,   0,   0,   0,  0,   47, 0,   0,   0,
                23,  70, 50,  188, 68,  250, 131, 55, 229, 99, 38,  161, 204,
                201, 20, 72,  174, 222, 50,  116, 50, 106, 66, 147, 28,  244,
                46,  16, 21,  154, 114, 94,  48,  12, 83,  91, 46,  113, 70,
                59,  44, 95,  173, 120, 101, 85,  32, 1,   0,  0,   0}},
   {(int64_t[]){
      1714340,
      8181289,
      10984073,
      414425,
      3683655,
      9464711,
      8219560,
      1079660,
      5468700,
      1159062,
      1042453,
      8944443,
      6939969,
      2683786,
      4192419,
      3515840},
    (uint8_t[]){0,   0,   73,  0,   0,   0,   0,   0,   0,  0,   0,   0,
                0,   0,   192, 165, 53,  0,   0,   0,   0,  0,   49,  0,
                0,   0,   24,  164, 40,  141, 254, 160, 76, 80,  200, 158,
                103, 192, 94,  47,  0,   196, 18,  112, 11, 138, 221, 131,
                71,  46,  147, 122, 158, 203, 22,  41,  11, 99,  93,  26,
                102, 219, 161, 62,  168, 237, 109, 67,  66, 30,  135, 225,
                65,  23,  10,  1,   0,   0,   0}},
   {(int64_t[]){
      16640278,
      16017481,
      18609989,
      7488716,
      5893759,
      18456394,
      14356018,
      13676472,
      14249820,
      2710381,
      2521065,
      24119088,
      16146087,
      15245768,
      14569542,
      304692},
    (uint8_t[]){0,   0,   75,  0,   0,   0,   0,   0,   0,   0,   0,   0,
                0,   0,   52,  166, 4,   0,   0,   0,   0,   0,   51,  0,
                0,   0,   25,  22,  233, 95,  129, 12,  159, 137, 179, 179,
                170, 53,  113, 120, 145, 138, 161, 228, 192, 49,  52,  132,
                44,  217, 112, 151, 89,  111, 255, 142, 241, 114, 246, 253,
                9,   239, 105, 43,  64,  194, 11,  9,   240, 15,  86,  134,
                30,  54,  218, 108, 24,  1,   0,   0,   0}},
   {(int64_t[]){
      1902191,
      19847293,
      62730384,
      29264410,
      19098899,
      53893037,
      19616509,
      16899446,
      31726197,
      16729631,
      32691781,
      52814706,
      20820401,
      8096620,
      8878809,
      3069563},
    (uint8_t[]){0,   0,   77,  0,   0,  0,   0,   0,   0,   0,   0,   0,
                0,   0,   123, 214, 46, 0,   0,   0,   0,   0,   53,  0,
                0,   0,   26,  111, 6,  18,  222, 237, 232, 138, 186, 9,
                231, 190, 58,  80,  5,  139, 143, 3,   199, 106, 92,  90,
                144, 55,  53,  195, 82, 221, 58,  181, 241, 162, 172, 29,
                51,  147, 3,   157, 21, 29,  42,  229, 27,  13,  215, 24,
                70,  252, 169, 164, 40, 148, 6,   1,   0,   0,   0}},
   {(int64_t[]){
      16965399,
      32855795,
      80296196,
      56663178,
      43968197,
      67778021,
      63165030,
      24284596,
      44051776,
      67006197,
      12971213,
      113407202,
      39020025,
      39042760,
      40640484,
      36035471},
    (uint8_t[]){0,   0,   79,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                0,   143, 219, 37,  2,   0,   0,   0,   0,   55,  0,   0,   0,
                27,  23,  223, 228, 137, 247, 111, 142, 165, 79,  122, 32,  211,
                131, 231, 210, 95,  244, 160, 181, 67,  56,  130, 47,  152, 27,
                17,  49,  219, 44,  161, 107, 196, 2,   247, 60,  169, 254, 148,
                201, 177, 210, 94,  59,  7,   145, 0,   63,  73,  65,  31,  95,
                203, 76,  0,   1,   0,   0,   0}},
   {(int64_t[]){
      102442420,
      30592864,
      250223973,
      129862196,
      86809644,
      231585493,
      51296880,
      108826015,
      16352176,
      7895390,
      21548120,
      139147091,
      100800082,
      133868204,
      45178896,
      52653033},
    (uint8_t[]){0,   0,   81,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                0,   233, 107, 35,  3,   0,   0,   0,   0,   57,  0,   0,   0,
                28,  180, 37,  212, 234, 5,   210, 81,  151, 24,  22,  249, 42,
                165, 12,  239, 55,  47,  14,  238, 250, 6,   181, 11,  251, 1,
                33,  254, 188, 188, 202, 249, 11,  27,  201, 56,  87,  145, 225,
                195, 114, 133, 129, 48,  3,   73,  248, 75,  146, 118, 159, 130,
                94,  6,   145, 30,  21,  1,   0,   0,   0}},
   {(int64_t[]){
      77860752,
      197819841,
      440905075,
      52151376,
      247709733,
      535706744,
      127877815,
      267479071,
      213651519,
      191699585,
      183070024,
      410597239,
      199102359,
      122550432,
      26000867,
      102629423},
    (uint8_t[]){0,   0,   83,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                0,   47,  0,   30,  6,   0,   0,   0,   0,   59,  0,   0,   0,
                29,  144, 15,  81,  114, 178, 208, 35,  105, 117, 4,   93,  252,
                207, 126, 168, 42,  32,  120, 190, 10,  201, 119, 63,  90,  224,
                56,  55,  247, 67,  69,  204, 189, 164, 110, 141, 92,  216, 45,
                113, 110, 77,  209, 132, 144, 167, 147, 193, 146, 228, 197, 220,
                34,  70,  227, 4,   57,  153, 57,  1,   0,   0,   0}},
   {(int64_t[]){
      229625638,
      125420610,
      745431717,
      330752913,
      221591890,
      1066758242,
      448575885,
      323178884,
      347896407,
      480871896,
      35872731,
      1036423026,
      84312727,
      281679822,
      324316614,
      417943956},
    (uint8_t[]){0,   0,   85,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                0,   148, 81,  233, 24,  0,   0,   0,   0,   61,  0,   0,   0,
                30,  38,  207, 100, 11,  231, 166, 52,  129, 195, 218, 48,  73,
                239, 201, 9,   232, 211, 43,  143, 255, 3,   218, 169, 208, 229,
                13,  89,  149, 8,   186, 82,  252, 175, 214, 23,  216, 131, 160,
                41,  255, 255, 21,  138, 229, 192, 204, 158, 189, 141, 178, 254,
                158, 92,  38,  7,   226, 253, 120, 53,  44,  1,   0,   0,   0}},
   {(int64_t[]){
      150723252,
      553670284,
      1831051997,
      676363527,
      81554986,
      1621761333,
      1013824963,
      374117348,
      460915632,
      980558653,
      781682,
      1497337118,
      893716192,
      839165233,
      318384891,
      798535660},
    (uint8_t[]){0,   0,   87,  0,   0,   0,   0,   0,   0,   0,   0,   0,
                0,   0,   236, 175, 152, 47,  0,   0,   0,   0,   63,  0,
                0,   0,   31,  180, 218, 56,  140, 81,  244, 218, 223, 45,
                19,  31,  115, 246, 160, 39,  46,  84,  144, 141, 32,  79,
                206, 108, 96,  254, 139, 209, 163, 202, 143, 23,  133, 251,
                251, 35,  115, 140, 118, 199, 33,  53,  11,  121, 52,  122,
                65,  254, 98,  136, 20,  179, 200, 34,  115, 85,  141, 144,
                46,  203, 62,  128, 122, 1,   0,   0,   0}},
   {(int64_t[]){
      1437395529,
      1810915095,
      2444683124,
      231172817,
      1730867592,
      2661245525,
      130656835,
      1824358909,
      1314271322,
      436890754,
      1963989880,
      2248870955,
      2048237775,
      293924953,
      1501977033,
      863198049},
    (uint8_t[]){0,   0,   89,  0,   0,   0,   0,   0,   0,   0,   0,   0,
                0,   0,   97,  91,  115, 51,  0,   0,   0,   0,   65,  0,
                0,   0,   32,  73,  234, 172, 85,  94,  181, 92,  62,  99,
                184, 70,  250, 165, 141, 113, 156, 89,  155, 237, 106, 221,
                147, 181, 249, 22,  200, 86,  153, 190, 43,  116, 107, 167,
                177, 235, 34,  216, 92,  92,  84,  250, 119, 26,  111, 83,
                23,  27,  243, 228, 172, 30,  252, 150, 80,  145, 107, 144,
                169, 2,   72,  168, 2,   245, 106, 1,   0,   0,   0}},
   {(int64_t[]){
      4107230965,
      865897503,
      5740982696,
      3358210636,
      1866164386,
      5412156010,
      2103520962,
      23077397,
      3548939524,
      3549879496,
      1156794276,
      4423386678,
      1364741365,
      2022858531,
      102878683,
      3293448006},
    (uint8_t[]){0,   0,   91,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                0,   70,  7,   78,  196, 0,   0,   0,   0,   67,  0,   0,   0,
                33,  245, 94,  207, 244, 234, 210, 83,  199, 183, 253, 172, 101,
                228, 75,  26,  158, 238, 82,  17,  167, 200, 154, 173, 45,  168,
                220, 247, 63,  215, 12,  1,   124, 17,  167, 232, 210, 204, 89,
                30,  0,   108, 155, 101, 151, 146, 193, 84,  67,  195, 202, 255,
                86,  214, 19,  202, 41,  248, 146, 179, 126, 157, 202, 111, 194,
                108, 24,  1,   0,   0,   0}},
   {(int64_t[]){
      5106475292,
      3731743869,
      11259527076,
      7522253133,
      6648546398,
      11866449136,
      4993285,
      6600806462,
      1558378034,
      413279447,
      1506188585,
      10615179246,
      1208152905,
      381700225,
      8231458826,
      309044863},
    (uint8_t[]){0,   0,   93,  0,   0,   0,   0,   0,  0,   0,   0,   0,   0,
                0,   127, 166, 107, 18,  0,   0,   0,  0,   69,  0,   0,   0,
                34,  28,  161, 94,  48,  97,  69,  51, 238, 217, 91,  115, 65,
                233, 198, 66,  95,  19,  189, 20,  76, 174, 96,  3,   79,  245,
                149, 7,   195, 59,  97,  60,  137, 12, 166, 146, 213, 229, 210,
                64,  68,  254, 185, 100, 65,  199, 90, 112, 33,  167, 52,  180,
                48,  200, 187, 194, 94,  139, 80,  98, 252, 117, 190, 201, 248,
                229, 108, 129, 82,  1,   0,   0,   0}},
   {(int64_t[]){
      14326004019,
      9621935652,
      22369542588,
      14209962168,
      1179328451,
      29011283340,
      1999145703,
      14322971208,
      2474435909,
      1394581822,
      3575151755,
      23896737127,
      4728328191,
      1702353353,
      14940350198,
      3461811230},
    (uint8_t[]){0,   0,   95,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                0,   30,  12,  87,  206, 0,   0,   0,   0,   71,  0,   0,   0,
                35,  51,  121, 229, 85,  23,  111, 102, 104, 152, 55,  215, 8,
                4,   241, 174, 123, 123, 207, 177, 8,   79,  18,  126, 135, 107,
                135, 29,  182, 175, 184, 159, 34,  13,  215, 203, 198, 123, 68,
                99,  192, 181, 221, 7,   134, 236, 57,  67,  69,  152, 202, 143,
                137, 54,  86,  163, 124, 63,  127, 244, 31,  232, 170, 212, 180,
                203, 61,  123, 3,   202, 108, 1,   0,   0,   0}},
   {(int64_t[]){
      28717747025,
      4094285255,
      67564959388,
      25872418803,
      24358835349,
      34898556950,
      17317425704,
      29260908188,
      13368231036,
      13581246584,
      30504749432,
      67792600146,
      11140663561,
      8792744408,
      22782180242,
      13681017955},
    (uint8_t[]){0,   0,   97,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                0,   99,  196, 115, 47,  3,   0,   0,   0,   73,  0,   0,   0,
                36,  81,  11,  182, 175, 150, 222, 191, 91,  91,  163, 38,  79,
                111, 177, 50,  189, 102, 147, 251, 173, 131, 236, 251, 139, 62,
                74,  47,  40,  180, 244, 36,  216, 224, 2,   217, 204, 4,   100,
                78,  53,  0,   233, 184, 51,  42,  117, 249, 210, 91,  245, 201,
                80,  209, 168, 31,  148, 74,  218, 250, 65,  241, 191, 159, 98,
                102, 159, 211, 44,  5,   132, 13,  103, 1,   0,   0,   0}},
   {(int64_t[]){
      6856208266,
      47592292802,
      83645650744,
      52895006431,
      36568395573,
      97583377469,
      55304559297,
      23259319903,
      50507821394,
      29448687079,
      48211030624,
      102486050381,
      37738823512,
      46438660106,
      16583060540,
      27438625556},
    (uint8_t[]){
      0,   0,   99,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,
      51,  120, 99,  6,   0,   0,   0,   75,  0,   0,   0,   37,  138, 111, 169,
      152, 72,  174, 17,  140, 250, 150, 19,  109, 231, 233, 98,  41,  234, 209,
      108, 211, 8,   67,  201, 59,  252, 182, 4,   88,  158, 148, 53,  138, 13,
      63,  221, 168, 181, 124, 199, 25,  135, 191, 222, 226, 45,  244, 60,  229,
      21,  185, 205, 21,  82,  7,   157, 6,   54,  212, 152, 19,  40,  95,  21,
      191, 65,  225, 79,  188, 78,  174, 53,  254, 69,  42,  1,   0,   0,   0}},
   {(int64_t[]){
      103922992986,
      117534993405,
      168595309150,
      57938126861,
      3204725300,
      215186188794,
      2224035811,
      123788064582,
      117688011961,
      47023852172,
      47122008510,
      191800629194,
      74507041886,
      77577427213,
      133647368617,
      37459463904},
    (uint8_t[]){0,   0,   101, 0,   0,   0,   0,   0,   0,   0,   0,   0,
                0,   0,   224, 14,  194, 184, 8,   0,   0,   0,   77,  0,
                0,   0,   38,  90,  7,   75,  50,  167, 172, 234, 111, 163,
                233, 177, 28,  83,  234, 113, 60,  57,  146, 101, 194, 206,
                147, 28,  165, 25,  190, 136, 158, 165, 224, 199, 86,  255,
                123, 151, 180, 53,  134, 23,  148, 50,  195, 103, 10,  116,
                158, 133, 80,  148, 107, 194, 240, 83,  165, 14,  87,  164,
                152, 248, 17,  73,  15,  195, 166, 216, 192, 171, 141, 44,
                115, 71,  4,   152, 253, 208, 92,  1,   0,   0,   0}},
   {(int64_t[]){
      30415122219,
      173058392077,
      457967257296,
      143739576198,
      71358866503,
      353610082721,
      73446963774,
      208268659236,
      173224226806,
      73117314960,
      194866642810,
      420618168128,
      118253590932,
      2766434597,
      41345493975,
      256637717973},
    (uint8_t[]){0,   0,   103, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                0,   213, 205, 204, 192, 59,  0,   0,   0,   79,  0,   0,   0,
                39,  43,  239, 225, 20,  38,  111, 244, 95,  221, 70,  236, 235,
                86,  25,  114, 215, 193, 59,  218, 234, 230, 77,  156, 201, 159,
                19,  10,  77,  26,  48,  0,   100, 210, 101, 48,  41,  102, 64,
                214, 82,  234, 80,  213, 88,  58,  24,  63,  176, 212, 126, 189,
                102, 177, 232, 146, 44,  242, 90,  134, 4,   2,   230, 174, 96,
                135, 151, 112, 25,  19,  14,  67,  152, 28,  143, 169, 223, 36,
                100, 1,   0,   0,   0}},
   {(int64_t[]){
      301560714550,
      370093378270,
      859762378972,
      373771784870,
      406380797535,
      1083475799822,
      140413569246,
      135604745946,
      218846486006,
      336619672822,
      378919346521,
      677801909339,
      405882323937,
      531086451429,
      331756829613,
      434558272197},
    (uint8_t[]){0,   0,   105, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                0,   197, 2,   177, 45,  101, 0,   0,   0,   81,  0,   0,   0,
                40,  54,  85,  107, 54,  232, 159, 35,  29,  2,   2,   156, 6,
                122, 26,  92,  43,  249, 12,  166, 152, 81,  113, 30,  218, 208,
                167, 125, 245, 4,   62,  225, 35,  44,  107, 232, 102, 0,   201,
                92,  148, 175, 245, 66,  89,  2,   61,  126, 233, 186, 159, 92,
                80,  4,   225, 64,  39,  72,  89,  7,   153, 104, 121, 142, 19,
                70,  16,  158, 159, 9,   162, 220, 63,  45,  124, 22,  197, 195,
                37,  54,  40,  1,   0,   0,   0}},
   {(int64_t[]){
      58020701168,
      984010824016,
      1582865466882,
      517358559910,
      1018567488125,
      1291050839538,
      1054999324239,
      759924946662,
      849308727999,
      304650132035,
      331702230207,
      2181693288359,
      596963028511,
      184405199320,
      400773093453,
      49539747430},
    (uint8_t[]){0,   0,   107, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                0,   102, 142, 204, 136, 11,  0,   0,   0,   83,  0,   0,   0,
                41,  240, 163, 77,  130, 160, 58,  208, 153, 82,  223, 191, 145,
                164, 100, 219, 254, 219, 80,  163, 83,  143, 31,  250, 191, 189,
                75,  124, 58,  169, 80,  210, 77,  89,  204, 176, 81,  252, 160,
                46,  80,  252, 70,  110, 212, 24,  243, 243, 205, 184, 65,  201,
                10,  199, 231, 172, 18,  149, 17,  152, 160, 43,  150, 60,  199,
                13,  232, 149, 8,   149, 193, 217, 69,  117, 131, 11,  182, 113,
                160, 119, 86,  108, 24,  1,   0,   0,   0}},
   {(int64_t[]){
      615368423135,
      572552553252,
      3807264006823,
      969555224680,
      1288433371567,
      3088865888712,
      2176144299574,
      1100746697211,
      299244650771,
      2144148368554,
      888850293441,
      2466233797596,
      1415849963838,
      1499605268424,
      12969229571,
      1601327070416},
    (uint8_t[]){0,   0,   109, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                0,   208, 252, 135, 214, 116, 1,   0,   0,   85,  0,   0,   0,
                42,  223, 246, 208, 70,  251, 85,  26,  8,   131, 193, 84,  60,
                207, 202, 96,  207, 199, 161, 99,  65,  103, 0,   92,  210, 254,
                223, 143, 130, 205, 127, 211, 229, 232, 168, 194, 229, 185, 173,
                108, 149, 107, 142, 168, 202, 29,  105, 102, 197, 226, 186, 198,
                145, 246, 134, 75,  128, 203, 202, 118, 34,  211, 65,  129, 211,
                143, 10,  243, 151, 202, 228, 53,  250, 69,  182, 61,  240, 119,
                20,  94,  119, 240, 61,  149, 83,  1,   0,   0,   0}},
   {(int64_t[]){
      1588842673900,
      2226953252148,
      4935397456819,
      1265918778974,
      2150870598228,
      7797045395587,
      1574593209114,
      269307678143,
      131261529464,
      3548527012842,
      4245597005513,
      7237813723685,
      2232743086837,
      2881657603866,
      2179709093036,
      53376570264},
    (uint8_t[]){0,   0,   111, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                0,   152, 211, 125, 109, 12,  0,   0,   0,   87,  0,   0,   0,
                43,  236, 54,  103, 238, 216, 219, 166, 110, 135, 86,  93,  156,
                237, 37,  63,  162, 10,  92,  67,  119, 215, 194, 255, 173, 153,
                163, 14,  249, 165, 174, 236, 46,  199, 240, 54,  60,  146, 214,
                122, 187, 35,  13,  252, 181, 236, 196, 29,  174, 208, 40,  139,
                246, 239, 77,  246, 41,  182, 195, 228, 112, 52,  151, 180, 237,
                113, 119, 123, 91,  210, 227, 121, 80,  32,  36,  230, 73,  146,
                153, 101, 247, 153, 11,  59,  24,  74,  44,  1,   0,   0,   0}},
   {(int64_t[]){
      8175981964460,
      7755627098980,
      14766379900322,
      168637185600,
      4879981034031,
      16816453654652,
      3283318246302,
      2680769463433,
      1251941898383,
      6832205873307,
      7766453441067,
      14020415204245,
      814425670192,
      6915995133012,
      1856665246679,
      5608145737720},
    (uint8_t[]){
      0,   0,   113, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   248,
      215, 136, 191, 25,  5,   0,   0,   89,  0,   0,   0,   44,  172, 44,  128,
      158, 200, 223, 229, 33,  198, 238, 177, 175, 226, 35,  91,  83,  111, 4,
      6,   118, 83,  34,  54,  87,  226, 147, 187, 23,  23,  79,  75,  95,  6,
      156, 194, 87,  20,  24,  185, 194, 176, 146, 134, 251, 190, 249, 108, 37,
      165, 169, 83,  254, 100, 102, 227, 222, 131, 191, 177, 8,   47,  140, 87,
      246, 111, 98,  99,  73,  87,  59,  183, 140, 83,  21,  38,  208, 125, 247,
      250, 169, 7,   218, 180, 13,  115, 177, 108, 71,  1,   0,   0,   0}},
   {(int64_t[]){
      2582326550354,
      10319521387693,
      29279315032783,
      8260042707482,
      11117356324482,
      29064627201608,
      5991831382988,
      13307882176218,
      9943305741570,
      16372035963479,
      6356406009012,
      31305930646536,
      15909007942247,
      101273108932,
      342194210650,
      8429348138667},
    (uint8_t[]){0,   0,   115, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                0,   171, 46,  77,  156, 170, 7,   0,   0,   91,  0,   0,   0,
                45,  82,  31,  168, 62,  255, 11,  192, 141, 98,  238, 67,  172,
                213, 168, 194, 47,  152, 68,  250, 70,  202, 176, 212, 84,  132,
                141, 60,  54,  22,  213, 109, 111, 216, 27,  162, 96,  85,  175,
                87,  242, 227, 54,  49,  30,  188, 88,  178, 13,  111, 70,  36,
                224, 163, 99,  157, 142, 158, 70,  4,   56,  241, 105, 16,  48,
                89,  59,  195, 34,  159, 115, 28,  105, 17,  232, 36,  191, 0,
                111, 88,  229, 98,  205, 222, 224, 79,  229, 172, 44,  29,  56,
                1,   0,   0,   0}},
   {(int64_t[]){
      30920337637175,
      21366522199271,
      59533376191504,
      20023314805027,
      12961801336482,
      58939835611468,
      4463981726010,
      10410731869610,
      23259901200332,
      26065463378996,
      9072516460463,
      66606286752497,
      10685615036017,
      3578912171694,
      13216661100544,
      1019744684467},
    (uint8_t[]){0,   0,   117, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                0,   179, 9,   133, 109, 237, 0,   0,   0,   93,  0,   0,   0,
                46,  55,  191, 189, 51,  208, 131, 74,  244, 247, 64,  74,  246,
                51,  141, 45,  59,  129, 135, 0,   237, 238, 143, 102, 24,  118,
                112, 253, 165, 144, 28,  242, 181, 102, 146, 223, 113, 248, 131,
                137, 72,  155, 107, 177, 138, 94,  37,  17,  160, 128, 28,  70,
                12,  223, 48,  128, 183, 174, 62,  170, 121, 179, 209, 230, 83,
                31,  113, 75,  19,  255, 83,  149, 120, 80,  147, 244, 211, 36,
                246, 68,  232, 220, 83,  146, 153, 31,  55,  156, 240, 209, 181,
                242, 48,  1,   0,   0,   0}},
   {(int64_t[]){
      37451787874274,
      5603874980097,
      118199739454207,
      10459298860048,
      56109130715409,
      88008003662070,
      23604987045688,
      40662315059066,
      6484219870195,
      65660014196563,
      23771029475673,
      140108173900470,
      20645004332601,
      55344398611895,
      12675344983376,
      37879935247948},
    (uint8_t[]){0,   0,   119, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                0,   76,  166, 21,  156, 115, 34,  0,   0,   95,  0,   0,   0,
                47,  226, 47,  131, 236, 227, 110, 121, 44,  254, 211, 129, 69,
                239, 158, 176, 187, 1,   29,  5,   210, 231, 161, 5,   25,  206,
                151, 21,  3,   66,  96,  6,   152, 137, 124, 71,  215, 160, 76,
                77,  16,  10,  230, 22,  54,  239, 235, 43,  230, 143, 52,  201,
                179, 142, 123, 30,  21,  231, 80,  87,  234, 28,  195, 122, 169,
                15,  23,  152, 3,   132, 13,  125, 140, 30,  82,  41,  243, 171,
                147, 210, 244, 162, 147, 91,  172, 27,  23,  99,  33,  159, 75,
                221, 6,   229, 82,  1,   0,   0,   0}},
   {(int64_t[]){
      26052562096902,
      82790797240993,
      281234560648175,
      44528650857970,
      76373044028255,
      163553167012471,
      25733079373886,
      81993770624624,
      130229875117606,
      137660747320713,
      95871735156676,
      267583347171538,
      11342618096633,
      130067057534968,
      81503654351835,
      49350409636136},
    (uint8_t[]){0,   0,   121, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                0,   40,  201, 162, 73,  226, 44,  0,   0,   97,  0,   0,   0,
                48,  6,   147, 181, 213, 167, 249, 186, 233, 78,  105, 25,  58,
                29,  174, 124, 164, 173, 78,  66,  94,  40,  17,  67,  204, 73,
                234, 101, 67,  78,  126, 156, 218, 86,  104, 224, 40,  175, 131,
                131, 34,  77,  66,  70,  67,  22,  239, 236, 122, 43,  211, 227,
                114, 1,   20,  122, 112, 35,  116, 159, 20,  243, 90,  255, 197,
                177, 23,  253, 92,  132, 180, 183, 215, 10,  109, 181, 209, 167,
                131, 245, 93,  227, 60,  66,  11,  2,   42,  108, 164, 13,  249,
                27,  124, 107, 60,  194, 102, 1,   0,   0,   0}},
   {(int64_t[]){
      162178734363907,
      13939927116659,
      549087671555769,
      80212896296921,
      139483416496393,
      317782825444686,
      249508192427960,
      194160993402331,
      165993575456123,
      194898758276898,
      221311751475707,
      450884162885727,
      238937594047948,
      43340880169955,
      106689564215367,
      123025883508126},
    (uint8_t[]){0,   0,   123, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                0,   158, 173, 21,  50,  228, 111, 0,   0,   99,  0,   0,   0,
                49,  3,   21,  218, 45,  112, 126, 189, 137, 202, 125, 250, 203,
                96,  185, 173, 106, 208, 166, 78,  6,   71,  44,  19,  151, 246,
                186, 64,  179, 99,  226, 39,  134, 160, 224, 19,  197, 89,  138,
                88,  3,   217, 198, 21,  79,  164, 201, 9,   142, 147, 181, 55,
                88,  47,  230, 174, 235, 164, 195, 87,  140, 217, 37,  134, 171,
                128, 147, 45,  159, 201, 255, 144, 187, 40,  54,  217, 95,  232,
                195, 123, 82,  110, 38,  186, 39,  10,  120, 91,  83,  92,  67,
                36,  254, 99,  70,  236, 14,  108, 24,  1,   0,   0,   0}},
   {(int64_t[]){
      532127403171150,
      497536448663317,
      590990484641764,
      464925114837294,
      302654005319637,
      794000862664298,
      539111850686878,
      454012031651032,
      327413100139546,
      334814138826219,
      29391077148321,
      829678329715482,
      76832041176152,
      353918822847287,
      313548312657906,
      150627311502043},
    (uint8_t[]){
      0,   0,   125, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   219,
      66,  101, 167, 254, 136, 0,   0,   101, 0,   0,   0,   50,  78,  93,  215,
      144, 91,  82,  158, 43,  241, 24,  174, 10,  202, 62,  182, 97,  251, 62,
      43,  240, 191, 193, 36,  155, 244, 111, 4,   121, 70,  117, 132, 43,  194,
      152, 89,  36,  241, 41,  72,  48,  74,  251, 121, 217, 187, 93,  168, 174,
      66,  87,  155, 80,  111, 159, 50,  255, 197, 172, 124, 130, 41,  253, 174,
      0,   247, 227, 118, 39,  1,   221, 88,  191, 155, 181, 96,  193, 114, 56,
      186, 118, 44,  181, 69,  25,  57,  42,  45,  232, 118, 183, 3,   4,   200,
      92,  213, 149, 241, 60,  144, 70,  1,   0,   0,   0}},
   {(int64_t[]){
      746319334067081,
      1010503393791721,
      1832888496515251,
      217935587012465,
      667757688467554,
      2021465547017884,
      840202991866983,
      224951187651290,
      93708240236434,
      906701986630537,
      2098704422047,
      2207588685315653,
      712241975171348,
      815436766542175,
      92913246105756,
      1058578889227702},
    (uint8_t[]){
      0,   0,   127, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   182,
      189, 168, 154, 197, 194, 3,   0,   103, 0,   0,   0,   51,  137, 203, 203,
      2,   96,  5,   31,  37,  90,  166, 107, 188, 194, 7,   128, 142, 19,  95,
      238, 102, 254, 62,  10,  108, 251, 154, 5,   31,  189, 46,  127, 135, 72,
      149, 254, 161, 27,  164, 139, 39,  22,  159, 92,  165, 218, 234, 237, 239,
      81,  103, 137, 138, 75,  224, 34,  107, 195, 9,   201, 167, 42,  205, 175,
      151, 198, 166, 202, 49,  12,  20,  54,  69,  100, 153, 209, 113, 170, 210,
      190, 48,  173, 153, 158, 109, 76,  57,  34,  214, 13,  80,  101, 98,  35,
      177, 68,  150, 74,  173, 86,  216, 94,  104, 1,   0,   0,   0}},
   {(int64_t[]){
      448401915037397,
      128698060246657,
      2939964211914634,
      1897859862222057,
      875588764485253,
      4436225965162666,
      1387963726244942,
      82898449889164,
      1917649199797129,
      783916595665599,
      912093564720454,
      3828737692909555,
      817048445740928,
      2063001992817623,
      2067747360247657,
      2003284818803249},
    (uint8_t[]){
      0,   0,   129, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   49,
      58,  2,   24,  250, 29,  7,   0,   105, 0,   0,   0,   52,  213, 198, 220,
      180, 84,  200, 246, 110, 11,  233, 170, 24,  99,  51,  107, 44,  108, 18,
      173, 11,  47,  198, 138, 189, 228, 44,  17,  36,  194, 91,  117, 48,  5,
      228, 243, 51,  54,  73,  108, 177, 249, 143, 218, 154, 181, 234, 242, 34,
      115, 216, 64,  156, 87,  140, 172, 254, 190, 100, 23,  230, 88,  181, 230,
      234, 209, 151, 221, 226, 237, 4,   246, 207, 64,  162, 238, 222, 225, 44,
      61,  165, 114, 155, 224, 24,  124, 245, 188, 167, 46,  125, 83,  179, 208,
      12,  96,  69,  17,  202, 197, 75,  70,  225, 95,  0,   1,   0,   0,   0}},
   {(int64_t[]){
      3096202159762956,
      3996629495048663,
      8349025654488764,
      4294302186916588,
      2772573679104974,
      6624134198141124,
      746610201112453,
      904415536224443,
      3086414445636236,
      2941120543063172,
      4249527359861254,
      4822652466162779,
      1642945071051333,
      3605530292495829,
      1274112463948774,
      3340941278320163},
    (uint8_t[]){0,   0,   131, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                0,   35,  22,  28,  130, 145, 222, 11,  0,   107, 0,   0,   0,
                53,  12,  174, 226, 189, 219, 71,  187, 108, 107, 215, 2,   213,
                80,  244, 51,  32,  34,  121, 41,  57,  10,  147, 146, 112, 65,
                143, 1,   214, 62,  183, 22,  29,  55,  114, 109, 122, 8,   150,
                156, 33,  130, 142, 138, 205, 93,  158, 161, 119, 30,  158, 70,
                178, 144, 215, 23,  5,   51,  238, 158, 156, 197, 93,  205, 238,
                250, 255, 19,  205, 140, 155, 192, 232, 1,   152, 57,  81,  148,
                47,  134, 145, 156, 193, 253, 133, 2,   106, 193, 58,  18,  244,
                10,  25,  249, 73,  93,  88,  138, 76,  105, 124, 13,  9,   20,
                79,  19,  122, 1,   0,   0,   0}},
   {(int64_t[]){
      606166732443574,
      5787543333697401,
      12592825275806522,
      1662855603189549,
      153043173349073,
      13200870434320653,
      6752590811118330,
      4773724870345081,
      1338047778657862,
      8440102197171047,
      4380499037192495,
      15221471070861005,
      1520538435267439,
      7462056191949066,
      7925487378829978,
      3529660535424507},
    (uint8_t[]){0,   0,   133, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                0,   251, 69,  100, 34,  53,  138, 12,  0,   109, 0,   0,   0,
                54,  182, 15,  195, 48,  207, 248, 69,  64,  67,  132, 206, 237,
                23,  4,   194, 32,  252, 225, 113, 158, 220, 39,  13,  11,  247,
                139, 106, 56,  131, 59,  187, 127, 63,  23,  173, 233, 33,  133,
                222, 235, 72,  146, 89,  4,   226, 55,  46,  129, 162, 29,  110,
                25,  101, 82,  208, 169, 144, 107, 126, 11,  97,  87,  135, 113,
                78,  39,  243, 168, 166, 50,  64,  85,  106, 99,  46,  109, 109,
                27,  223, 8,   95,  53,  200, 60,  48,  108, 210, 131, 51,  117,
                88,  228, 131, 170, 5,   162, 130, 133, 167, 133, 155, 31,  84,
                38,  229, 243, 103, 64,  1,   0,   0,   0}},
   {(int64_t[]){
      393888903978941,
      14708959516137856,
      33320579936666472,
      17156589272001781,
      8509820343233852,
      26204716485471868,
      11183123309553438,
      15632985751690035,
      10896273517236500,
      11853678275426336,
      6044055277700748,
      24335719642010256,
      7849143033320026,
      779434852201838,
      1184664973983859,
      3785968248814094},
    (uint8_t[]){0,   0,   135, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                0,   14,  250, 153, 108, 81,  115, 13,  0,   111, 0,   0,   0,
                55,  189, 223, 51,  104, 61,  70,  202, 234, 232, 90,  44,  144,
                157, 175, 200, 171, 201, 65,  180, 75,  64,  67,  39,  243, 98,
                9,   214, 205, 45,  124, 218, 238, 39,  202, 220, 66,  52,  169,
                189, 234, 172, 254, 55,  205, 28,  20,  73,  3,   202, 64,  215,
                66,  52,  103, 55,  87,  29,  117, 142, 31,  125, 58,  106, 34,
                61,  102, 133, 39,  92,  33,  55,  147, 113, 200, 175, 34,  240,
                163, 227, 48,  4,   60,  193, 170, 210, 101, 60,  12,  244, 151,
                37,  38,  150, 241, 35,  70,  129, 154, 80,  41,  26,  234, 33,
                17,  198, 111, 216, 204, 24,  18,  1,   0,   0,   0}},
   {(int64_t[]){
      32226742933938709,
      15047216742066320,
      38293366856897615,
      23628345285443031,
      35850516424136220,
      58188973593235759,
      6357567232971336,
      20893345460794104,
      33107664604492738,
      22343607327582016,
      11589154285207679,
      48120795316738370,
      5908973890968835,
      7016100059311793,
      27168573830851978,
      4515712056626343},
    (uint8_t[]){0,   0,   137, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                0,   167, 12,  11,  37,  4,   11,  16,  0,   113, 0,   0,   0,
                56,  21,  98,  216, 76,  133, 138, 28,  100, 223, 188, 6,   104,
                152, 41,  156, 151, 203, 235, 39,  7,   51,  7,   167, 252, 103,
                3,   80,  84,  176, 160, 210, 106, 58,  193, 75,  206, 130, 20,
                213, 165, 63,  39,  168, 57,  61,  25,  67,  255, 65,  196, 235,
                142, 178, 115, 124, 38,  59,  131, 131, 159, 45,  225, 54,  173,
                13,  126, 80,  11,  192, 126, 71,  250, 0,   172, 74,  231, 188,
                44,  79,  172, 93,  165, 90,  254, 34,  77,  221, 217, 181, 11,
                53,  19,  183, 104, 168, 142, 114, 71,  189, 219, 44,  177, 216,
                92,  63,  58,  102, 131, 190, 12,  120, 112, 1,   0,   0,   0}},
   {(int64_t[]){
      67958388451934185,
      69542300251369327,
      96440975117296458,
      64481734034764286,
      69872923369414776,
      107125423192353366,
      14499230264304894,
      61537863868925735,
      18987908633095434,
      42456045470018251,
      17161404927004218,
      141220641352397074,
      59428327065906206,
      63163453892182867,
      69413574330726987,
      44465991426181588},
    (uint8_t[]){
      0,   0,   139, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   212,
      9,   139, 103, 149, 249, 157, 0,   115, 0,   0,   0,   57,  233, 127, 47,
      83,  134, 208, 119, 212, 37,  12,  240, 200, 180, 18,  12,  236, 134, 145,
      126, 27,  46,  10,  17,  131, 168, 142, 160, 38,  217, 99,  79,  105, 45,
      170, 62,  137, 193, 135, 212, 153, 241, 164, 75,  144, 40,  127, 70,  38,
      12,  221, 152, 118, 77,  47,  92,  4,   24,  121, 149, 144, 159, 179, 25,
      87,  203, 111, 145, 127, 212, 176, 69,  181, 198, 40,  12,  171, 248, 20,
      165, 34,  58,  213, 234, 160, 184, 45,  88,  79,  211, 150, 108, 71,  148,
      253, 210, 98,  241, 6,   161, 179, 29,  132, 79,  233, 153, 213, 170, 201,
      38,  51,  22,  107, 108, 24,  1,   0,   0,   0}},
   {(int64_t[]){
      134829830950735039,
      19303618130248839,
      202063470571127858,
      63218591959691171,
      13682256147772220,
      196583190592248261,
      115606211028952607,
      134409832478168109,
      125325568766646209,
      46852407173526221,
      138931388749515935,
      196367363532459589,
      56741775271329760,
      135996642620278114,
      88533169181058445,
      63224395883763749},
    (uint8_t[]){
      0,   0,   141, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   37,
      88,  202, 201, 64,  158, 224, 0,   117, 0,   0,   0,   58,  191, 204, 241,
      82,  56,  72,  121, 135, 181, 0,   241, 60,  145, 171, 140, 157, 159, 220,
      156, 245, 249, 170, 121, 77,  218, 255, 37,  74,  50,  242, 27,  73,  236,
      67,  178, 24,  12,  37,  239, 201, 82,  62,  226, 180, 218, 2,   68,  14,
      165, 241, 45,  170, 130, 250, 255, 216, 239, 96,  231, 21,  168, 61,  42,
      10,  4,   3,   141, 151, 46,  75,  94,  71,  9,   3,   174, 252, 98,  208,
      59,  50,  247, 187, 244, 74,  88,  225, 79,  54,  75,  53,  97,  190, 75,
      160, 50,  22,  223, 155, 137, 45,  208, 138, 32,  71,  96,  27,  75,  84,
      112, 42,  217, 218, 165, 56,  212, 70,  1,   0,   0,   0}},
   {(int64_t[]){
      129095674260466087,
      215098284548825098,
      488426801098669669,
      168645357732463164,
      182800104026665655,
      407617650339733520,
      77915888430930989,
      50430909056657773,
      165846288910985125,
      29958306399559658,
      250603942983120349,
      439917547484516958,
      249846625287385317,
      108735886756767357,
      2375720358395613,
      143316759156118997},
    (uint8_t[]){
      0,   0,   143, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   213,
      85,  220, 71,  213, 41,  253, 1,   119, 0,   0,   0,   59,  167, 169, 85,
      238, 173, 137, 1,   228, 111, 30,  16,  112, 89,  188, 237, 74,  139, 112,
      192, 209, 167, 18,  196, 5,   61,  60,  229, 144, 64,  117, 77,  112, 200,
      142, 222, 53,  79,  184, 223, 242, 55,  170, 214, 155, 131, 167, 148, 228,
      187, 34,  211, 40,  152, 214, 236, 20,  160, 88,  117, 0,   8,   107, 208,
      199, 212, 163, 20,  141, 86,  19,  153, 27,  182, 73,  174, 73,  1,   246,
      179, 250, 247, 30,  185, 90,  30,  60,  88,  180, 131, 68,  152, 236, 2,
      62,  97,  89,  202, 54,  59,  144, 222, 33,  188, 167, 254, 39,  16,  96,
      109, 245, 138, 245, 25,  137, 51,  210, 90,  37,  1,   0,   0,   0}},
   {(int64_t[]){
      103246588535421389,
      97650624617561049,
      619649655899535544,
      385717930010879244,
      284649838772202448,
      585704177187261994,
      111492437162388323,
      315828741203787388,
      17085238663784301,
      253145175431097153,
      92592572372610387,
      882820819660918486,
      204178531554538318,
      352290990068215541,
      226987335078166850,
      403983703372679110},
    (uint8_t[]){0,   0,   145, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                0,   198, 71,  147, 174, 9,   61,  155, 5,   121, 0,   0,   0,
                60,  205, 185, 236, 169, 20,  2,   128, 97,  97,  3,   121, 241,
                180, 157, 217, 208, 220, 142, 175, 196, 250, 37,  214, 189, 73,
                101, 129, 120, 31,  149, 123, 241, 17,  89,  58,  4,   44,  140,
                89,  63,  18,  70,  55,  27,  133, 163, 46,  149, 152, 253, 36,
                64,  187, 157, 135, 20,  183, 239, 78,  171, 132, 134, 75,  253,
                57,  206, 128, 34,  173, 156, 125, 40,  236, 31,  93,  145, 31,
                207, 86,  21,  126, 190, 221, 232, 70,  174, 175, 156, 145, 11,
                131, 245, 14,  253, 206, 86,  110, 52,  195, 195, 169, 211, 172,
                238, 94,  191, 203, 8,   149, 54,  197, 189, 1,   217, 182, 89,
                52,  210, 110, 103, 1,   0,   0,   0}},
   {(int64_t[]){
      826606420854077179,
      1103208735678912134,
      1436619803826393846,
      601761691662387042,
      1108692877812044182,
      1574037234715774100,
      158748990384981920,
      1075917931894406804,
      381423321579871921,
      433501855921479168,
      24224046617378857,
      1319167003234892501,
      663685419731729606,
      762835162703283542,
      31221534362001611,
      906821430603466125},
    (uint8_t[]){0,   0,   147, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                0,   141, 197, 212, 93,  73,  173, 149, 12,  123, 0,   0,   0,
                61,  251, 118, 16,  4,   125, 160, 47,  7,   112, 196, 98,  159,
                148, 149, 164, 98,  244, 150, 7,   164, 2,   221, 134, 36,  52,
                139, 33,  226, 52,  185, 80,  6,   37,  160, 216, 237, 177, 64,
                125, 84,  41,  222, 10,  126, 252, 186, 157, 46,  19,  70,  140,
                6,   144, 121, 172, 154, 157, 37,  230, 31,  70,  165, 41,  173,
                41,  178, 169, 208, 153, 132, 8,   5,   93,  61,  202, 196, 219,
                231, 245, 144, 213, 123, 217, 13,  0,   20,  194, 144, 57,  125,
                214, 192, 88,  201, 152, 70,  120, 55,  160, 182, 59,  186, 235,
                221, 165, 79,  82,  24,  123, 163, 248, 251, 139, 240, 125, 244,
                101, 107, 24,  185, 135, 98,  1,   0,   0,   0}},
   {(int64_t[]){
      1620694653785509264,
      2119167209011035646,
      2459185627469068824,
      678229761989093935,
      1364135750465171450,
      2479759156413371230,
      1574258850729829484,
      417957143403466634,
      279934891509624015,
      1901141416713099360,
      1029858192695381269,
      3265146544670814473,
      469617159558805376,
      67951752497499837,
      995180505067583400,
      669816135511478885},
    (uint8_t[]){0,   0,   149, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                0,   101, 146, 252, 245, 57,  170, 75,  9,   125, 0,   0,   0,
                62,  144, 141, 66,  104, 110, 176, 128, 32,  230, 7,   200, 202,
                55,  16,  127, 133, 213, 5,   150, 200, 164, 188, 105, 177, 50,
                183, 206, 0,   230, 171, 162, 201, 69,  163, 77,  79,  175, 180,
                92,  66,  117, 213, 85,  90,  28,  252, 16,  126, 137, 134, 92,
                25,  61,  185, 148, 194, 21,  249, 136, 206, 205, 229, 14,  126,
                51,  221, 106, 22,  21,  3,   44,  70,  92,  236, 236, 189, 197,
                59,  219, 5,   130, 102, 71,  177, 154, 252, 234, 235, 42,  75,
                147, 3,   167, 254, 92,  61,  125, 21,  72,  73,  135, 135, 177,
                20,  46,  128, 40,  26,  212, 117, 62,  132, 214, 242, 175, 27,
                124, 67,  70,  70,  141, 171, 209, 16,  1,   0,   0,   0}},
   {(int64_t[]){
      641912699247250919,
      330816142352198338,
      5328062771455722980,
      3555100966782922642,
      196592342183757589,
      8862521306957083324,
      849628305972929458,
      1029870346762473522,
      3848557667444747495,
      939789790605676216,
      735099286463971794,
      7308065287375585189,
      1971881630098377277,
      3358979147684682506,
      1555396835424294325,
      4087370760997042358},
    (uint8_t[]){
      0,   0,   151, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   182,
      248, 139, 34,  13,  66,  185, 56,  127, 0,   0,   0,   63,  231, 205, 113,
      239, 37,  231, 175, 181, 38,  47,  68,  219, 118, 106, 36,  216, 135, 168,
      210, 200, 169, 53,  237, 218, 14,  209, 35,  19,  128, 115, 222, 239, 213,
      60,  218, 110, 95,  98,  49,  1,   106, 15,  195, 220, 119, 126, 54,  189,
      152, 181, 67,  156, 55,  81,  145, 220, 191, 206, 139, 173, 3,   173, 176,
      118, 50,  136, 181, 195, 91,  95,  162, 85,  207, 46,  157, 111, 93,  124,
      238, 169, 81,  7,   27,  31,  61,  85,  64,  238, 77,  241, 89,  250, 146,
      156, 35,  163, 232, 127, 102, 167, 236, 68,  52,  128, 34,  98,  57,  88,
      54,  192, 8,   44,  8,   70,  19,  63,  195, 199, 11,  59,  220, 225, 237,
      175, 237, 90,  1,   0,   0,   0}},
   {(int64_t[]){
      3865483708979890129,
      5114695391196063892,
      -3039221123712681087,
      1845281588273351478,
      5041106666034794027,
      -1721989444070104933,
      1352016156537680365,
      4011207186118550183,
      254830279912529815,
      1592112561916722182,
      2018100333717495484,
      -8833253210837203789,
      1653281056192502105,
      4568238498274423615,
      3903365306964489640,
      6489795940629541451},
    (uint8_t[]){
      0,   0,   153, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   75,
      242, 254, 9,   6,   99,  16,  90,  129, 0,   0,   0,   64,  209, 71,  206,
      254, 243, 244, 164, 53,  69,  239, 95,  248, 175, 248, 95,  115, 21,  83,
      172, 137, 33,  136, 41,  147, 183, 240, 167, 100, 174, 69,  73,  204, 29,
      133, 65,  44,  30,  90,  110, 92,  176, 46,  225, 152, 116, 216, 239, 173,
      118, 209, 62,  170, 62,  16,  217, 250, 74,  83,  19,  12,  41,  248, 105,
      37,  48,  61,  36,  225, 100, 253, 35,  52,  145, 163, 72,  151, 58,  7,
      145, 21,  186, 162, 47,  39,  127, 234, 25,  10,  15,  90,  172, 244, 142,
      64,  104, 153, 234, 221, 196, 40,  93,  89,  152, 147, 102, 170, 213, 158,
      233, 6,   148, 41,  151, 134, 218, 60,  165, 46,  78,  9,   227, 71,  205,
      223, 22,  233, 59,  108, 1,   0,   0,   0}}});

auto get_characterization_data() -> std::span<const deltafor_datapoint> {
    return characterization_data;
}
