/*
 * Copyright 2021 Redpanda Data, Inc.
 *
 * Use of this software is governed by the Business Source License
 * included in the file licenses/BSL.md
 *
 * As of the Change Date specified in that file, in accordance with
 * the Business Source License, use of this software will be governed
 * by the Apache License, Version 2.0
 */

#pragma once

#include "base/seastarx.h"
#include "kafka/client/fwd.h"
#include "model/metadata.h"
#include "pandaproxy/schema_registry/fwd.h"
#include "security/fwd.h"

#include <seastar/core/sharded.hh>

namespace YAML {
class Node;
}

namespace cluster {
class controller;
}

namespace schema {
class registry;
}

namespace pandaproxy::schema_registry {

class api {
public:
    api(
      model::node_id node_id,
      ss::smp_service_group sg,
      size_t max_memory,
      kafka::client::configuration& client_cfg,
      configuration& cfg,
      std::unique_ptr<cluster::controller>&,
      ss::sharded<security::audit::audit_log_manager>&) noexcept;
    ~api() noexcept;

    ss::future<> start();
    ss::future<> stop();
    ss::future<> restart();

private:
    friend class schema_id_validator;
    friend class schema::registry;
    model::node_id _node_id;
    ss::smp_service_group _sg;
    size_t _max_memory;
    kafka::client::configuration& _client_cfg;
    configuration& _cfg;
    std::unique_ptr<cluster::controller>& _controller;

    ss::sharded<kafka::client::client> _client;
    std::unique_ptr<pandaproxy::schema_registry::sharded_store> _store;
    ss::sharded<schema_id_validation_probe> _schema_id_validation_probe;
    ss::sharded<schema_id_cache> _schema_id_cache;
    ss::sharded<pandaproxy::schema_registry::service> _service;
    ss::sharded<pandaproxy::schema_registry::seq_writer> _sequencer;
    ss::sharded<security::audit::audit_log_manager>& _audit_mgr;
};

} // namespace pandaproxy::schema_registry

namespace google::protobuf {

class FileDescriptor;

}
