// Copyright 2024 Redpanda Data, Inc.
//
// Use of this software is governed by the Business Source License
// included in the file licenses/BSL.md
//
// As of the Change Date specified in that file, in accordance with
// the Business Source License, use of this software will be governed
// by the Apache License, Version 2.0
#pragma once

#include "iceberg/manifest_entry.h"
#include "iceberg/partition_key_type.h"
#include "iceberg/values.h"

namespace iceberg {

// Converts the given manifest_entry to an struct_value.
//
// This can be helpful e.g. to convert a manifest into an Avro datum using Avro
// serialization code.
//
// The resulting value will have a type that could be generated by
// manifest_entry_type().
struct_value manifest_entry_to_value(const manifest_entry& entry);

// Converts the given struct_value to a manifest_entry.
//
// It is expected that the input value was constructed with a type generated by
// manifest_entry_type(). For instance, in reading entries from an Avro file,
// the Avro reader should use a manifest_entry_type() translated into a schema
// as its reader schema to ensure the resulting values abide by that schema.
//
// Throws if the above is not true and there is a type mismatch.
manifest_entry manifest_entry_from_value(struct_value v);

} // namespace iceberg
