// Code generated by github.com/actgardner/gogen-avro/v10. DO NOT EDIT.
/*
 * SOURCE:
 *     schema.avsc
 */
package avro

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/actgardner/gogen-avro/v10/compiler"
	"github.com/actgardner/gogen-avro/v10/vm"
	"github.com/actgardner/gogen-avro/v10/vm/types"
)

var _ = fmt.Printf

type Example struct {
	A int64 `json:"a"`

	B string `json:"b"`
}

const ExampleAvroCRC64Fingerprint = "\x81\xb6A0\x7fV\x1a\xdc"

func NewExample() Example {
	r := Example{}
	r.A = 0
	r.B = ""
	return r
}

func DeserializeExample(r io.Reader) (Example, error) {
	t := NewExample()
	deser, err := compiler.CompileSchemaBytes([]byte(t.Schema()), []byte(t.Schema()))
	if err != nil {
		return t, err
	}

	err = vm.Eval(r, deser, &t)
	return t, err
}

func DeserializeExampleFromSchema(r io.Reader, schema string) (Example, error) {
	t := NewExample()

	deser, err := compiler.CompileSchemaBytes([]byte(schema), []byte(t.Schema()))
	if err != nil {
		return t, err
	}

	err = vm.Eval(r, deser, &t)
	return t, err
}

func writeExample(r Example, w io.Writer) error {
	var err error
	err = vm.WriteLong(r.A, w)
	if err != nil {
		return err
	}
	err = vm.WriteString(r.B, w)
	if err != nil {
		return err
	}
	return err
}

func (r Example) Serialize(w io.Writer) error {
	return writeExample(r, w)
}

func (r Example) Schema() string {
	return "{\"fields\":[{\"default\":0,\"name\":\"a\",\"type\":\"long\"},{\"default\":\"\",\"name\":\"b\",\"type\":\"string\"}],\"name\":\"Example\",\"type\":\"record\"}"
}

func (r Example) SchemaName() string {
	return "Example"
}

func (_ Example) SetBoolean(v bool)    { panic("Unsupported operation") }
func (_ Example) SetInt(v int32)       { panic("Unsupported operation") }
func (_ Example) SetLong(v int64)      { panic("Unsupported operation") }
func (_ Example) SetFloat(v float32)   { panic("Unsupported operation") }
func (_ Example) SetDouble(v float64)  { panic("Unsupported operation") }
func (_ Example) SetBytes(v []byte)    { panic("Unsupported operation") }
func (_ Example) SetString(v string)   { panic("Unsupported operation") }
func (_ Example) SetUnionElem(v int64) { panic("Unsupported operation") }

func (r *Example) Get(i int) types.Field {
	switch i {
	case 0:
		w := types.Long{Target: &r.A}

		return w

	case 1:
		w := types.String{Target: &r.B}

		return w

	}
	panic("Unknown field index")
}

func (r *Example) SetDefault(i int) {
	switch i {
	case 0:
		r.A = 0
		return
	case 1:
		r.B = ""
		return
	}
	panic("Unknown field index")
}

func (r *Example) NullField(i int) {
	switch i {
	}
	panic("Not a nullable field index")
}

func (_ Example) AppendMap(key string) types.Field { panic("Unsupported operation") }
func (_ Example) AppendArray() types.Field         { panic("Unsupported operation") }
func (_ Example) HintSize(int)                     { panic("Unsupported operation") }
func (_ Example) Finalize()                        {}

func (_ Example) AvroCRC64Fingerprint() []byte {
	return []byte(ExampleAvroCRC64Fingerprint)
}

func (r Example) MarshalJSON() ([]byte, error) {
	var err error
	output := make(map[string]json.RawMessage)
	output["a"], err = json.Marshal(r.A)
	if err != nil {
		return nil, err
	}
	output["b"], err = json.Marshal(r.B)
	if err != nil {
		return nil, err
	}
	return json.Marshal(output)
}

func (r *Example) UnmarshalJSON(data []byte) error {
	var fields map[string]json.RawMessage
	if err := json.Unmarshal(data, &fields); err != nil {
		return err
	}

	var val json.RawMessage
	val = func() json.RawMessage {
		if v, ok := fields["a"]; ok {
			return v
		}
		return nil
	}()

	if val != nil {
		if err := json.Unmarshal([]byte(val), &r.A); err != nil {
			return err
		}
	} else {
		r.A = 0
	}
	val = func() json.RawMessage {
		if v, ok := fields["b"]; ok {
			return v
		}
		return nil
	}()

	if val != nil {
		if err := json.Unmarshal([]byte(val), &r.B); err != nil {
			return err
		}
	} else {
		r.B = ""
	}
	return nil
}
