package main

import (
	"context"
{{- if .IsTLS }}
	"crypto/tls"
{{- end }}
	"fmt"
	"os"
	"sync"

	"github.com/twmb/franz-go/pkg/kgo"
{{- if and (ne .Username "") (ne .Password "") }}
	"github.com/twmb/franz-go/pkg/sasl/scram"
{{- end }}
)

func main() {
	topic := "demo-topic"
	hostname, _ := os.Hostname()
	ctx := context.Background()

	seeds := []string{ {{ range $index, $element := .SeedServer }}{{ if $index }},{{ end }}"{{ $element }}"{{ end }} }
	opts := []kgo.Opt{}
	opts = append(opts,
		kgo.SeedBrokers(seeds...),
	)

	// Initialize public CAs for TLS
{{- if .IsTLS }}
	opts = append(opts, kgo.DialTLSConfig(new(tls.Config)))
{{- else }}
	//opts = append(opts, kgo.DialTLSConfig(new(tls.Config)))
{{- end }}

    // Initializes SASL/SCRAM
{{- if and (ne .Username "") (ne .Password "") }}
	opts = append(opts, kgo.SASL(scram.Auth{
		User: "{{.Username}}",
		Pass: "{{.Password}}",
	}.AsSha{{.ScramBits}}Mechanism()))
{{- else }}
	//opts = append(opts, kgo.SASL(scram.Auth{
	//	User: "{{.Username}}",
	//	Pass: "{{.Password}}",
	//}.AsSha256Mechanism()))
{{- end }}

	client, err := kgo.NewClient(opts...)
	if err != nil {
		panic(err)
	}
	defer client.Close()

	// Produce 100 messages asynchronously
	var wg sync.WaitGroup
	for i := 1; i < 100; i++ {
		wg.Add(1)
		record := &kgo.Record{
			Topic: topic,
			Key:   []byte(hostname),
			Value: []byte(fmt.Sprintf("Message %d", i)),
		}
		client.Produce(ctx, record, func(record *kgo.Record, err error) {
			defer wg.Done()
			if err != nil {
				fmt.Printf("Error sending message: %v \n", err)
			} else {
				fmt.Printf("Message sent: topic: %s, offset: %d, value: %s \n",
					topic, record.Offset, record.Value)
			}
		})
	}
	wg.Wait()

}
