package main

import (
	"context"
{{- if .IsTLS }}
	"crypto/tls"
{{- end }}
	"fmt"

	"github.com/twmb/franz-go/pkg/kgo"
{{- if and (ne .Username "") (ne .Password "") }}
	"github.com/twmb/franz-go/pkg/sasl/scram"
{{- end }}
)

func main() {
	topic := "demo-topic"
	ctx := context.Background()

	seeds := []string{ {{ range $index, $element := .SeedServer }}{{ if $index }},{{ end }}"{{ $element }}"{{ end }} }
	opts := []kgo.Opt{}
	opts = append(opts,
		kgo.SeedBrokers(seeds...),
		kgo.ConsumeTopics(topic),
		kgo.ConsumeResetOffset(kgo.NewOffset().AtStart()),
	)

	// Initialize public CAs for TLS
{{- if .IsTLS }}
	opts = append(opts, kgo.DialTLSConfig(new(tls.Config)))
{{- else }}
	//opts = append(opts, kgo.DialTLSConfig(new(tls.Config)))
{{- end }}

    // Initializes SASL/SCRAM
{{- if and (ne .Username "") (ne .Password "") }}
	opts = append(opts, kgo.SASL(scram.Auth{
		User: "{{.Username}}",
		Pass: "{{.Password}}",
	}.AsSha{{.ScramBits}}Mechanism()))
{{- else }}
	//opts = append(opts, kgo.SASL(scram.Auth{
	//	User: "{{.Username}}",
	//	Pass: "{{.Password}}",
	//}.AsSha256Mechanism()))
{{- end }}

	client, err := kgo.NewClient(opts...)
	if err != nil {
		panic(err)
	}
	defer client.Close()

	for {
		fetches := client.PollFetches(ctx)
		if errs := fetches.Errors(); len(errs) > 0 {
			// All errors are retried internally when fetching, but non-retriable
			// errors are returned from polls so that users can notice and take
			// action.
			panic(fmt.Sprint(errs))
		}
		iter := fetches.RecordIter()
		for !iter.Done() {
			record := iter.Next()
			topicInfo := fmt.Sprintf("topic: %s (%d|%d)",
				record.Topic, record.Partition, record.Offset)
			messageInfo := fmt.Sprintf("key: %s, Value: %s",
				record.Key, record.Value)
			fmt.Printf("Message consumed: %s, %s \n", topicInfo, messageInfo)
		}
	}
}
