package main

import (
	"context"
{{- if .IsTLS }}
	"crypto/tls"
{{- end }}
	"fmt"
	"github.com/twmb/franz-go/pkg/kadm"
	"github.com/twmb/franz-go/pkg/kgo"
{{- if and (ne .Username "") (ne .Password "") }}
	"github.com/twmb/franz-go/pkg/sasl/scram"
{{- end }}
)

func main() {
	topic := "demo-topic"
	seeds := []string{ {{ range $index, $element := .SeedServer }}{{ if $index }},{{ end }}"{{ $element }}"{{ end }} }
	opts := []kgo.Opt{}
	opts = append(opts,
		kgo.SeedBrokers(seeds...),
	)

	// Initialize public CAs for TLS
{{- if .IsTLS }}
	opts = append(opts, kgo.DialTLSConfig(new(tls.Config)))
{{- else }}
	//opts = append(opts, kgo.DialTLSConfig(new(tls.Config)))
{{- end }}

    // Initializes SASL/SCRAM
{{- if and (ne .Username "") (ne .Password "") }}
	opts = append(opts, kgo.SASL(scram.Auth{
		User: "{{.Username}}",
		Pass: "{{.Password}}",
	}.AsSha{{.ScramBits}}Mechanism()))
{{- else }}
	//opts = append(opts, kgo.SASL(scram.Auth{
	//	User: "{{.Username}}",
	//	Pass: "{{.Password}}",
	//}.AsSha256Mechanism()))
{{- end }}

	client, err := kgo.NewClient(opts...)
	if err != nil {
		panic(err)
	}
	defer client.Close()

	admin := kadm.NewClient(client)
	defer admin.Close()

	ctx := context.Background()
	// Create a topic with a single partition and cluster-default replicas
	resp, err := admin.CreateTopics(ctx, 1, -1, nil, topic)
	if err != nil {
		panic(err)
	}

	for _, ctr := range resp {
		if ctr.Err != nil {
			fmt.Printf("Unable to create topic '%s': %s\n", ctr.Topic, ctr.Err)
		} else {
			fmt.Printf("Created topic '%s'\n", ctr.Topic)
		}
	}
}
