---
id: 5900f3a91000cf542c50febc
title: 'Problem 61: Cyclical figurate numbers'
challengeType: 5
forumTopicId: 302173
dashedName: problem-61-cyclical-figurate-numbers
---

# --description--

Triangle, square, pentagonal, hexagonal, heptagonal, and octagonal numbers are all figurate (polygonal) numbers and are generated by the following formulae:

| Type of Number | Formula                                                               | Sequence              |
| -------------- | --------------------------------------------------------------------- | --------------------- |
| Triangle       | P<sub>3</sub>,<var><sub>n</sub></var>=<var>n</var>(<var>n</var>+1)/2  | 1, 3, 6, 10, 15, ...  |
| Square         | P<sub>4</sub>,<var><sub>n</sub></var>=<var>n</var><sup>2</sup>        | 1, 4, 9, 16, 25, ...  |
| Pentagonal     | P<sub>5</sub>,<var><sub>n</sub></var>=<var>n</var>(3<var>n</var>−1)/2 | 1, 5, 12, 22, 35, ... |
| Hexagonal      | P<sub>6</sub>,<var><sub>n</sub></var>=<var>n</var>(2<var>n</var>−1)   | 1, 6, 15, 28, 45, ... |
| Heptagonal     | P<sub>7</sub>,<var><sub>n</sub></var>=<var>n</var>(5<var>n</var>−3)/2 | 1, 7, 18, 34, 55, ... |
| Octagonal      | P<sub>8</sub>,<var><sub>n</sub></var>=<var>n</var>(3<var>n</var>−2)   | 1, 8, 21, 40, 65, ... |

The ordered set of three 4-digit numbers: 8128, 2882, 8281, has three interesting properties.

<ol>
  <li>The set is cyclic, in that the last two digits of each number is the first two digits of the next number (including the last number with the first).</li>
  <li>Each polygonal type: triangle (P<sub>3,127</sub> = 8128), square (P<sub>4,91</sub> = 8281), and pentagonal (P<sub>5,44</sub> = 2882), is represented by a different number in the set.</li>
  <li>This is the only set of 4-digit numbers with this property.</li>
</ol>

Find the sum of the only ordered set of six cyclic 4-digit numbers for which each polygonal type: triangle, square, pentagonal, hexagonal, heptagonal, and octagonal, is represented by a different number in the set.

# --hints--

`cyclicalFigurateNums()` should return a number.

```js
assert(typeof cyclicalFigurateNums() === 'number');
```

`cyclicalFigurateNums()` should return 28684.

```js
assert.strictEqual(cyclicalFigurateNums(), 28684);
```

# --seed--

## --seed-contents--

```js
function cyclicalFigurateNums() {

  return true;
}

cyclicalFigurateNums();
```

# --solutions--

```js
// solution required
```
