---
id: 587d7faa367417b2b2512bd2
title: Add Labels to D3 Elements
challengeType: 6
forumTopicId: 301476
dashedName: add-labels-to-d3-elements
---

# --description--

D3 lets you label a graph element, such as a bar, using the SVG `text` element.

Like the `rect` element, a `text` element needs to have `x` and `y` attributes, to place it on the SVG canvas. It also needs to access the data to display those values.

D3 gives you a high level of control over how you label your bars.

# --instructions--

The code in the editor already binds the data to each new `text` element. First, append `text` nodes to the `svg`. Next, add attributes for the `x` and `y` coordinates. They should be calculated the same way as the `rect` ones, except the `y` value for the `text` should make the label sit 3 units higher than the bar. Finally, use the D3 `text()` method to set the label equal to the data point value.

**Note**  
For the label to sit higher than the bar, decide if the `y` value for the `text` should be 3 greater or 3 less than the `y` value for the bar.

# --hints--

The first `text` element should have a label of 12 and a `y` value of 61.

```js
assert($('text').eq(0).text() == '12' && $('text').eq(0).attr('y') == '61');
```

The second `text` element should have a label of 31 and a `y` value of 4.

```js
assert($('text').eq(1).text() == '31' && $('text').eq(1).attr('y') == '4');
```

The third `text` element should have a label of 22 and a `y` value of 31.

```js
assert($('text').eq(2).text() == '22' && $('text').eq(2).attr('y') == '31');
```

The fourth `text` element should have a label of 17 and a `y` value of 46.

```js
assert($('text').eq(3).text() == '17' && $('text').eq(3).attr('y') == '46');
```

The fifth `text` element should have a label of 25 and a `y` value of 22.

```js
assert($('text').eq(4).text() == '25' && $('text').eq(4).attr('y') == '22');
```

The sixth `text` element should have a label of 18 and a `y` value of 43.

```js
assert($('text').eq(5).text() == '18' && $('text').eq(5).attr('y') == '43');
```

The seventh `text` element should have a label of 29 and a `y` value of 10.

```js
assert($('text').eq(6).text() == '29' && $('text').eq(6).attr('y') == '10');
```

The eighth `text` element should have a label of 14 and a `y` value of 55.

```js
assert($('text').eq(7).text() == '14' && $('text').eq(7).attr('y') == '55');
```

The ninth `text` element should have a label of 9 and a `y` value of 70.

```js
assert($('text').eq(8).text() == '9' && $('text').eq(8).attr('y') == '70');
```

# --seed--

## --seed-contents--

```html
<body>
  <script>
    const dataset = [12, 31, 22, 17, 25, 18, 29, 14, 9];

    const w = 500;
    const h = 100;

    const svg = d3.select("body")
                  .append("svg")
                  .attr("width", w)
                  .attr("height", h);

    svg.selectAll("rect")
       .data(dataset)
       .enter()
       .append("rect")
       .attr("x", (d, i) => i * 30)
       .attr("y", (d, i) => h - 3 * d)
       .attr("width", 25)
       .attr("height", (d, i) => 3 * d)
       .attr("fill", "navy");

    svg.selectAll("text")
       .data(dataset)
       .enter()
       // Add your code below this line




       // Add your code above this line
  </script>
<body>
```

# --solutions--

```html
<body>
  <script>
    const dataset = [12, 31, 22, 17, 25, 18, 29, 14, 9];

    const w = 500;
    const h = 100;

    const svg = d3.select("body")
                  .append("svg")
                  .attr("width", w)
                  .attr("height", h);

    svg.selectAll("rect")
       .data(dataset)
       .enter()
       .append("rect")
       .attr("x", (d, i) => i * 30)
       .attr("y", (d, i) => h - 3 * d)
       .attr("width", 25)
       .attr("height", (d, i) => 3 * d)
       .attr("fill", "navy");

    svg.selectAll("text")
       .data(dataset)
       .enter()
       .append("text")
       .attr("x", (d, i) => i * 30)
       .attr("y", (d, i) => h - (3 * d) - 3)
       .text((d) => d)
  </script>
<body>
```
