---
id: 587d7fa6367417b2b2512bbf
title: Visualize Data with a Choropleth Map
challengeType: 3
forumTopicId: 301465
dashedName: visualize-data-with-a-choropleth-map
---

# --description--

**Objective:** Build a [CodePen.io](https://codepen.io) app that is functionally similar to this: <https://codepen.io/freeCodeCamp/full/EZKqza>.

Fulfill the below [user stories](https://en.wikipedia.org/wiki/User_story) and get all of the tests to pass. Give it your own personal style.

You can use HTML, JavaScript, CSS, and the D3 svg-based visualization library. Required (non-virtual) DOM elements are queried on the moment of each test. If you use a frontend framework (like Vue for example), the test results may be inaccurate for dynamic content. We hope to accommodate them eventually, but these frameworks are not currently supported for D3 projects.

**User Story #1:** My choropleth should have a title with a corresponding `id="title"`.

**User Story #2:** My choropleth should have a description element with a corresponding `id="description"`.

**User Story #3:** My choropleth should have counties with a corresponding `class="county"` that represent the data.

**User Story #4:** There should be at least 4 different fill colors used for the counties.

**User Story #5:** My counties should each have `data-fips` and `data-education` properties containing their corresponding fips and education values.

**User Story #6:** My choropleth should have a county for each provided data point.

**User Story #7:** The counties should have data-fips and data-education values that match the sample data.

**User Story #8:** My choropleth should have a legend with a corresponding `id="legend"`.

**User Story #9:** There should be at least 4 different fill colors used for the legend.

**User Story #10:** I can mouse over an area and see a tooltip with a corresponding `id="tooltip"` which displays more information about the area.

**User Story #11:** My tooltip should have a `data-education` property that corresponds to the `data-education` of the active area.

Here are the datasets you will need to complete this project:  

-   **US Education Data:**`https://cdn.freecodecamp.org/testable-projects-fcc/data/choropleth_map/for_user_education.json`
-   **US County Data:**`https://cdn.freecodecamp.org/testable-projects-fcc/data/choropleth_map/counties.json`

You can build your project by forking [this CodePen pen](https://codepen.io/freeCodeCamp/pen/MJjpwO). Or you can use this CDN link to run the tests in any environment you like: `https://cdn.freecodecamp.org/testable-projects-fcc/v1/bundle.js`

Once you're done, submit the URL to your working project with all its tests passing.

# --solutions--

```js
// solution required
```
