---
id: 587d7db9367417b2b2512ba4
title: Match Non-Whitespace Characters
challengeType: 1
forumTopicId: 18210
dashedName: match-non-whitespace-characters
---

# --description--

You learned about searching for whitespace using `\s`, with a lowercase `s`. You can also search for everything except whitespace.

Search for non-whitespace using `\S`, which is an uppercase `s`. This pattern will not match whitespace, carriage return, tab, form feed, and new line characters. You can think of it being similar to the character class `[^ \r\t\f\n\v]`.

```js
let whiteSpace = "Whitespace. Whitespace everywhere!"
let nonSpaceRegex = /\S/g;
whiteSpace.match(nonSpaceRegex).length; // Returns 32
```

# --instructions--

Change the regex `countNonWhiteSpace` to look for multiple non-whitespace characters in a string.

# --hints--

Your regex should use the global flag.

```js
assert(countNonWhiteSpace.global);
```

Your regex should use the shorthand character `\S` to match all non-whitespace characters.

```js
assert(/\\S/.test(countNonWhiteSpace.source));
```

Your regex should find 35 non-spaces in `"Men are from Mars and women are from Venus."`

```js
assert(
  'Men are from Mars and women are from Venus.'.match(countNonWhiteSpace)
    .length == 35
);
```

Your regex should find 23 non-spaces in `"Space: the final frontier."`

```js
assert('Space: the final frontier.'.match(countNonWhiteSpace).length == 23);
```

Your regex should find 21 non-spaces in `"MindYourPersonalSpace"`

```js
assert('MindYourPersonalSpace'.match(countNonWhiteSpace).length == 21);
```

# --seed--

## --seed-contents--

```js
let sample = "Whitespace is important in separating words";
let countNonWhiteSpace = /change/; // Change this line
let result = sample.match(countNonWhiteSpace);
```

# --solutions--

```js
let sample = "Whitespace is important in separating words";
let countNonWhiteSpace = /\S/g; // Change this line
let result = sample.match(countNonWhiteSpace);
```
