file(STRINGS "${RealmCore_SOURCE_DIR}/dependencies.yml" DEPENDENCIES)
set(VALID_DEPENDENCIES "")
foreach(LINE IN LISTS DEPENDENCIES)
    string(REGEX MATCHALL "([^:]+)" KEY_VALUE ${LINE})
    list(LENGTH KEY_VALUE MATCH_SIZE)
    if (MATCH_SIZE GREATER_EQUAL 2)
        list(GET KEY_VALUE 0 KEY)
        if ("${KEY}" MATCHES "^#")
            continue()
        endif()
        list(GET KEY_VALUE 1 VALUE)
        string(STRIP "${VALUE}" STRIPPED_VALUE)
        set(DEP_${KEY} ${STRIPPED_VALUE})
        set(VALID_DEPENDENCIES "${VALID_DEPENDENCIES} ${KEY}=\"${STRIPPED_VALUE}\"")
    endif()
endforeach()

message("Dependencies: ${VALID_DEPENDENCIES}")

#check version format
string(REGEX MATCH "^[0-9]+\.[0-9]+\.[0-9]+$" CONFIG_VERSION ${DEP_VERSION})
if (NOT CONFIG_VERSION)
    string(REGEX MATCH "^[0-9]+\.[0-9]+\.[0-9]+-.+$" CONFIG_VERSION ${DEP_VERSION})
    if (NOT CONFIG_VERSION)
        message(FATAL_ERROR "Wrong version number format: ${DEP_VERSION}.")
    endif()
    set(extended_version 1)
endif()

# Split "x.y.z-t" into a list x;y;z;t
string(REGEX MATCHALL "[^.-]+" VERSION_LIST ${CONFIG_VERSION})
list(GET VERSION_LIST 0 CONFIG_VERSION_MAJOR)
list(GET VERSION_LIST 1 CONFIG_VERSION_MINOR)
list(GET VERSION_LIST 2 CONFIG_VERSION_PATCH)
if (extended_version)
    list(GET VERSION_LIST 3 CONFIG_VERSION_TWEAK)
endif()
