<p align="right">
<a href='https://github.com/realm/realm-core/releases'><img src='https://img.shields.io/github/v/release/realm/realm-core' alt='Latest Release' /></a>
<a href='https://coveralls.io/github/realm/realm-core'><img src='https://coveralls.io/repos/github/realm/realm-core/badge.svg' alt='Coverage Status' /></a>
<a href='https://github.com/realm/realm-core'><img src='https://img.shields.io/github/license/realm/realm-core' alt='Source License' /></a>
</p>

![Realm](doc/logo.png)

Realm is a mobile database that runs directly inside phones, tablets or wearables - check out [realm.io](https://realm.io).

This repository holds the source code for the core database component used by all the Realm Mobile Database products:

* [Realm C++](https://github.com/realm/realm-cpp)
* [Realm Dart/Flutter](https://github.com/realm/realm-dart)
* [Realm Java](https://github.com/realm/realm-java)
* [Realm Kotlin](https://github.com/realm/realm-kotlin)
* [Realm Swift/Objective-C](https://github.com/realm/realm-swift)
* [Realm .NET](https://github.com/realm/realm-dotnet)
* [Realm Node.js/React Native/Web](https://github.com/realm/realm-js)

Realm Core is not in itself an "end-user" product with a publicly stable and supported API.

Refer to the [Atlas Device SDK documentation](https://www.mongodb.com/docs/atlas/device-sdks/) for information about Realm and using the SDKs.

## Building Realm

How to build Realm Core is described [here](how-to-build.md).

## Contributing

See [CONTRIBUTING.md](CONTRIBUTING.md) for more details!

## Code of Conduct

This project adheres to the [MongoDB Code of Conduct](https://www.mongodb.com/community-code-of-conduct).
By participating, you are expected to uphold this code. Please report
unacceptable behavior to [community-conduct@mongodb.com](mailto:community-conduct@mongodb.com).

## License

Realm Core is published under the Apache 2.0 license.

See the THIRD-PARTY-NOTICES file for licenses related to included third party libraries.

## Feedback

Feedback to the Realm SDK's should be given in the respective SDK's github mentioned in the top of this readme.
For anything specifically about Realm Core, please create an [issue here](https://github.com/realm/realm-core/issues/new).

<img style="width: 0px; height: 0px;" src="https://3eaz4mshcd.execute-api.us-east-1.amazonaws.com/prod?s=https://github.com/realm/realm-core#README.md">
