# Перевод на русский язык сайта reactjs.org

Текущий прогресс: https://github.com/reactjs/ru.reactjs.org/issues/843

Пожалуйста, используйте этот ишью, если вы хотите что-то перевести и узнать.

## Оглавление

* [Перевод на русский язык сайта reactjs.org](#Перевод-на-русский-язык-сайта-reactjsorg)
  * [Оглавление](#Оглавление)
  * [Общие правила](#Общие-правила)
    * [Слово живое и мёртвое](#Слово-живое-и-мёртвое)
  * [Универсальное руководство по стилю](#Универсальное-руководство-по-стилю)
    * [Идентификаторы заголовков](#Идентификаторы-заголовков)
    * [Текст в блоках кода](#Текст-в-блоках-кода)
    * [Внешние ссылки](#Внешние-ссылки)
  * [Соглашение по переводу (глоссарий)](#Соглашение-по-переводу-глоссарий)

## Общие правила

- _Вы_ и его производные пишите с маленькой буквы
- Всегда используйте букву `ё` (это легко соблюдать с помощью [данного npm-пакета](https://github.com/hcodes/eyo))
- Используйте тире вместо дефиса (оно должно быть намного длиннее, чем дефис). Тире: `—`, дефис: `-`
- Переводите комментарии в примерах кода, но не содержимое
- Используйте терминологию [словаря «Веб-стандартов»](https://github.com/web-standards-ru/dictionary), если нет исходного варианта в таблице ниже
- Ссылки на ресурсы (MDN, Wikipedia) должны вести на русскую версию, если есть соответствующий перевод.
- Иностранные имена переводите с указанием оригинального имени в скобках: _Дэн Абрамов (Dan Abramov)_. При этом обязательно проверьте уже существующий перевод имени в [словаре имён «Веб-стандартов»](https://github.com/web-standards-ru/dictionary/blob/master/names.md)
- Не переводите наименования компаний (Facebook, Airbnb), библиотек (Jest, Enzyme) и т.д.
- Не переводите аббревиатуры (API, DOM, HOC, UI).
- Исключайте отсылки на пол читателя (см. секцию 3 на [этой странице](http://www.un.org/ru/gender-inclusive-language/guidelines.shtml))
- Названия статей и заголовки пишутся с одной заглавной буквы («Компоненты и пропсы», не «Компоненты и Пропсы»).

### Слово живое и мёртвое

Прежде чем переводить, почитайте пару страниц из «Слова живого и мёртвого» Норы Галь. Хотя бы эти две:

* [Берегись канцелярита!](http://www.vavilon.ru/noragal/slovo2.html)
* [Словесная алгебра](http://www.vavilon.ru/noragal/slovo4.html)

**По мере возможности, избегайте отглагольных существительных!**

* **Деревянно:** *для открытия*
* **Живо:** *чтобы открыть*

**Также избегайте пассивного залога:**

* **Деревянно:** *будет рассказано*
* **Живо:** *мы узнаем*

**Предпочитайте простые слова (за исключением терминологии ниже):**

* **Деревянно:** *демонстрирует*
* **Живо:** *показывает*

Чтобы избежать кальки, можно брать смысл предложения, а потом перефразировать так, как объясняли бы старшему коллеге. Если предложение звучит нелепо вслух, то его надо переписать. Например:

**Оригинал:** *React has been designed from the start for gradual adoption, and you can use as little or as much React as you need.*

**Мёртвая калька:** *React был спроектирован с самого начала для постепенного внедрения, и вы можете использовать столько React, сколько вам нужно.*

**Нормальный перевод:** *Чтобы внедрить React, не надо ничего переписывать. Его можно использовать как для маленькой кнопки, так и для целого приложения.*

Небольшие вольности в переводе допускаются, но только если они помогают передать смысл. Перевод не должен быть ни деревянным, ни фамильярным. Истина где-то посередине.

## Универсальное руководство по стилю

Описанные ниже правила пришли [из репозитория](https://github.com/reactjs/reactjs.org-translation/blob/master/style-guide.md), предписывающего стиль общий для **всех** языков, на которые переводится документация.

### Идентификаторы заголовков

Каждый заголовок имеет явный идентификатор:

```md
## Try React {#try-react}
```

**НЕ** переводите такие идентификаторы! Они используются для навигации. Изменение идентификатора неизбежно приведёт к поломке, если на документ ссылкаются извне, например так:

```md
Прочтите [главу для начинающих](/getting-started#try-react), чтобы узнать больше.
```

✅ Можно:

```md
## Попробуйте React {#try-react}
```

❌ НЕЛЬЗЯ:

```md
## Попробуйте React {#попробуйте-react}
```

Это сломает ссылку, приведённую в примере выше.

### Текст в блоках кода

Не переводите текст в блоках кода, кроме комментариев. А вот комментарии и текст в строках следует переводить, если они не относятся к коду.

Пример:
```js
// Example
const element = <h1>Hello, world</h1>;
ReactDOM.render(element, document.getElementById('root'));
```

✅ МОЖНО:

```js
// Пример
const element = <h1>Hello, world</h1>;
ReactDOM.render(element, document.getElementById('root'));
```

✅ ТОЖЕ МОЖНО:

```js
// Пример
const element = <h1>Здравствуй, мир!</h1>;
ReactDOM.render(element, document.getElementById('root'));
```

❌ НЕЛЬЗЯ:

```js
// Пример
const element = <h1>Здравствуй, мир!</h1>;
// "root" ссылается на идентификатор элемента.
// Не переводите его!
ReactDOM.render(element, document.getElementById('корень'));
```

❌ СОВСЕМ НЕЛЬЗЯ:

```js
// Пример
пост элемент = <з1>Здравствуй, мир!</з1>;
РеактДОМ.отрендери(элемент, документ.получиЭлементПоАйди('корень'));
```

### Внешние ссылки

Если внешняя ссылка ведёт к статье на [MDN] или [Wikipedia], и там существует статья на русском языке, исправьте ссылку, чтобы она указывала на русский вариант, даже если он неполный или требует улучшения.

[MDN]: https://developer.mozilla.org/en-US/
[Wikipedia]: https://en.wikipedia.org/wiki/Main_Page

Пример:

```md
React elements are [immutable](https://en.wikipedia.org/wiki/Immutable_object).
```

✅ OK:

```md
Элементы React [иммутабельны](https://ru.wikipedia.org/wiki/%D0%9D%D0%B5%D0%B8%D0%B7%D0%BC%D0%B5%D0%BD%D1%8F%D0%B5%D0%BC%D1%8B%D0%B9_%D0%BE%D0%B1%D1%8A%D0%B5%D0%BA%D1%82).
```

Для ссылок, у которых нету языковых эквивалентов (Stack Overflow, видео на YouTube, и т. д.), просто оставьте оригинальный вариант как есть.

## Соглашение по переводу (глоссарий)

**Пожалуйста, поддерживайте глоссарий в алфавитном порядке.**

| Оригинальный термин | Перевод |
| ------------------ | ---------- |
| API reference | справочник API |
| array | массив |
| arrow function | стрелочная функция |
| attribute | атрибут |
| batch | группа обновлений |
| batching | группировка |
| bind | привязка |
| bug | баг, дефект |
| bundler | бандлер |
| cache | кеш |
| callback | колбэк |
| camelCase | *camelCase* |
| child | дочерний |
| child component | дочерний компонент |
| class component | классовый компонент |
| cleanup | сброс (*напр., сбрасываемый эффект, сбросить эффект, сбрасывающая функция*) |
| code splitting | разделение кода |
| codemod | codemod-скрипт |
| commit | фиксация |
| concurrent mode | конкурентный режим |
| context | контекст |
| (un)controlled component | (не)управляемый компонент |
| cross-cutting concerns | cквозная функциональность |
| custom | пользовательский (*напр., пользовательские хуки*) |
| debugging | отладка |
| destructuring | деструктуризация |
| development | разработка |
| development mode | режим разработки |
| developer tools | инструменты разработки |
| display name | отображаемое имя |
| DOM container | DOM-контейнер |
| effect | эффект |
| error | ошибка |
| error boundary | предохранитель |
| escape hatch | лазейка (*напр., императивные лазейки*) |
| fallback | запасной |
| feature | возможность (*менее предпочтительный синоним: функциональность*) |
| folder | папка |
| framework | фреймворк |
| function component | функциональный компонент |
| helper | вспомогательный(ая); *напр., helper function — вспомогательная функция* |
| Higher-Order Component(s) | Компонент(ы) высшего порядка |
| hook | хук *(с маленькой буквы)* *(напр., хук эффекта, хук контекста)* |
| incapsulation | инкапсуляция |
| incapsulated | инкапсулированный |
| key | ключ |
| lazy initialization | ленивая инициализация |
| library | библиотека |
| lifecycle | жизненный цикл |
| lifecycle method | метод жизненного цикла |
| lifting state up | подъём состояния, поднимать состояние |
| local state | внутреннее состояние |
| lowercase | нижний регистр |
| mixin | примесь |
| mock | фиктивный |
| (im)mutable | (им)мутабельный |
| (im)mutability | (им)мутабельность |
| (un)mount | (раз)монтирование |
| mutate | мутировать |
| native | нативный |
| Note | Примечание |
| online | онлайн |
| online playground | онлайн-песочница |
| paint | отрисовка, перерисовка |
| persistent | персистентность, персистентный |
| phase | этап (*напр., этап рендеринга, этап фиксации*) |
| prop | проп *(ед. ч.)* |
| props | пропсы *(мн. ч.)* |
| production | продакшен |
| production mode | продакшен-режим |
| profiling | профилирование |
| Profiler | Profiler *(если имеется в виду компонент Profiler)*; профилировщик *(если имеется в виду инструмент для профилирования)*
| React | React |
| React element | React-элемент, элемент React |
| reconciliation | согласование |
| reducer | редюсер |
| ref | реф *(ед. ч.)* |
| refs | рефы *(мн. ч.)* |
| ref forwarding | перенаправление рефа |
| render(ing) | рендер, рендерить, отрендерить |
| renderer | рендерер (*напр., поверхностный рендерер*) |
| re-render(ing) | (по контексту) рендер, повторный рендер, последующий рендер, отрендерить снова |
| render prop | рендер-проп *(ед. ч.)* |
| render props | рендер-пропсы *(мн. ч.)* |
| reuse | повторное использование |
| (previous/next) section | (предыдущая/следующая) глава *(только в разделе Основные понятия)* |
| Set of interactions | Множество «взаимодействий»
| shallow | поверхностное (сравнение, равенство), поверхностный (рендеринг) |
| side effect | побочный эффект |
| snapshot | снимок |
| state | состояние |
| stateful component | компонент с состоянием |
| stateless component | компонент без состояния |
| suspense | задержка |
| tag | тег |
| template literals | шаблонные строки |
| Tip | Совет |
| TLDR | Вкратце |
| Try it on CodePen | Посмотреть на CodePen |
| tutorial | введение |
| unidirectional data flow | однонаправленный поток данных |
| UI | UI |
| update | обновление |
| user interface | интерфейс (добавляйте «пользовательский» только если по контексту непонятно) |
| Warning | Предупреждение |
