# React UI

> React components for your design system.

React UI is a themeable, performant, responsive UI library for React apps.
Use it simply with no configuration or have full control over your design by
tweaking some of the hundreds theming options available.

---

## Key Concepts

Why another UI library? Because we couldn't find any library that would meet
these requirements:

- **🎨 Full control over design, from design tokens to components.** Hundreds of
  CSS custom properties allow you to customize the design of your app without
  touching JS.

- **📦 Zero configuration needed.** Create rapid prototypes that look great with
  smart defaults and no additional effort.

- **🚀 Small bundle size.** Because performance matters.

## What's Included

React UI consists of four building blocks:

1. **Foundation CSS:** basic themeable CSS layer. **Mandatory ground zero for
   components.**
   [Learn how to get started quickly.](/docs/getting-started/installation)

2. **Components:** reusable and themeable React components and layouts:
   [alerts](/components/Alert), [buttons](/components/Button/),
   [cards](/components/Card), and more.

3. **Theme:** a collection of CSS custom properties that define the visual
   appearance of the UI.
   [Learn how to create a theme.](/docs/customize/theming/overview)

4. **Helper CSS classes (optional):** tiny CSS classes with notation
   **inspired by Bootstrap.** They can handle details like
   [typography](/docs/css-helpers/typography), [spacing](/docs/css-helpers/spacing),
   [colors](/docs/css-helpers/colors), etc.

## Sponsors

<a href="https://www.racom.eu" target="_blank" rel="noopener noreferrer">
  <img
    src="/docs/_assets/racom.svg"
    width="190"
    height="30"
    className="mt-5 mb-6"
    alt="RACOM"
  />
</a>

Development of React UI is largely supported by
[RACOM](https://www.racom.eu)—one of the leading global players in wireless
Critical Infrastructure.
