# Typography

With the typography helper classes you can set the desired `font-size` or align
text with the `text-align` property.

## Font Size

The full scale of font sizes is available through the following helper classes:

```docoff-react-preview
<h4 className="font-size-1">Font size 1 (base font size)</h4>
<h4 className="font-size-2">Font size 2</h4>
<h4 className="font-size-3">Font size 3</h4>
<h4 className="font-size-4">Font size 4</h4>
<h4 className="font-size-5">Font size 5</h4>
<h4 className="font-size-6">Font size 6</h4>
```

## Text Alignment

📐 Try resizing your browser to see how the alignment below changes.

```docoff-react-preview
<div>
  <p className="text-left">
    <code>.text-left</code>
    {' '}
    Left aligned text on all viewport sizes.
  </p>
  <p className="text-center">
    <code>.text-center</code>
    {' '}
    Center aligned text on all viewport sizes.
  </p>
  <p className="text-right">
    <code>.text-right</code>
    {' '}
    Right aligned text on all viewport sizes.
  </p>
  <p className="text-sm-right">
    <code>.text-sm-right</code>
    {' '}
    Right aligned text on viewports sized <code>sm</code> (small) or wider.
  </p>
  <p className="text-md-right">
    <code>.text-md-right</code>
    {' '}
    Right aligned text on viewports sized <code>md</code> (medium) or wider.
  </p>
  <p className="text-lg-right">
    <code>.text-lg-right</code>
    {' '}
    Right aligned text on viewports sized <code>lg</code> (large) or wider.
  </p>
  <p className="text-xl-right">
    <code>.text-xl-right</code>
    {' '}
    Right aligned text on viewports sized <code>xl</code> (extra-large) or
    wider.
  </p>
  <p className="text-x2l-right">
    <code>.text-x2l-right</code>
    {' '}
    Right aligned text on viewports sized <code>x2l</code> (XX-large) or
    wider.
  </p>
  <p className="text-x3l-right">
    <code>.text-x3l-right</code>
    {' '}
    Right aligned text on viewports sized <code>x3l</code> (XXX-large) or
    wider.
  </p>
</div>
```
