import Snack from './snack/index.md'

<!-- Added examples of platform specifc searchbar to be shown in the documentation. -->

<Snack />

### Default SearchBar

<img src="../../../img/searchbar.png" width="300" />

### Platform specific SearchBar

**iOS**

<img src="https://user-images.githubusercontent.com/17592779/31585176-b124cdae-b1bd-11e7-809f-ba966cebc663.gif" width="300"/>

**Android**

<img src="https://user-images.githubusercontent.com/17592779/31586716-f6e8ff9c-b1d4-11e7-918f-2a7e11d51b08.gif" width="300"/>

### Interaction methods

| method | description                                                                                                                                                                                      |
| ------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| focus  | call focus on the textinput ([example](#calling))                                                                                                                                                |
| blur   | call blur on the textinput ([example](#calling))                                                                                                                                                 |
| clear  | call clear on the textinput ([example](#calling))                                                                                                                                                |
| cancel | **(Android and iOS SearchBars only)** call cancel on the SearchBar (left arrow on Android, Cancel button on iOS). This will basically blur the input and hide the keyboard ([example](#calling)) |

#### <a name="calling"></a> Calling methods on SearchBar

Store a reference to the SearchBar in your component by using the ref prop
provided by React
([see docs](https://reactjs.org/docs/refs-and-the-dom.html)):

```js
<SearchBar
  ref={search => this.search = search}
  ...
/>
```

You can then access SearchBar methods like so:

```
this.search.focus();
this.search.blur();
this.search.clear();
this.search.cancel(); // Only available if `platform` props is "ios" | "android"
```
