---
id: pricingcard

title: PricingCard

slug: /pricingcard
---

import Usage from './usage/PricingCard/PricingCard.md'

Pricing is a convenience component used to display features and pricing tables in a beautiful and engaging way.

## Usage

<Usage />

---

## Props

### PricingCard

- [button](#button)
- [color](#color)
- [containerStyle](#containerstyle)
- [info](#info)
- [infoStyle](#infostyle)
- [onButtonPress](#onbuttonpress)
- [price](#price)
- [pricingStyle](#pricingstyle)
- [title](#title)
- [titleStyle](#titlestyle)
- [wrapperStyle](#wrapperstyle)

## Reference

### PricingCard

#### button

Button information.

| Type                             | Default |
| -------------------------------- | ------- |
| ButtonProps or ButtonInformation | None    |

---

#### color

Color scheme for button & title.

| Type   | Default        |
| ------ | -------------- |
| string | Color(Primary) |

---

#### containerStyle

Outer component styling.

| Type               | Default |
| ------------------ | ------- |
| View style(Object) | None    |

---

#### info

Pricing information.

| Type     | Default |
| -------- | ------- |
| string[] | []      |

---

#### infoStyle

Specify pricing information style.

| Type               | Default |
| ------------------ | ------- |
| Text Style(Object) | None    |

---

#### onButtonPress

Function to be run when button is pressed.

| Type     | Default |
| -------- | ------- |
| Function | None    |

---

#### price

Price mentioned in the pricing card.

| Type             | Default |
| ---------------- | ------- |
| string or number | None    |

---

#### pricingStyle

Specify pricing text style.

| Type               | Default |
| ------------------ | ------- |
| Text Style(Object) | None    |

---

#### title

Add title in the pricing card.

| Type   | Default |
| ------ | ------- |
| string | None    |

---

#### titleStyle

Specify title text style.

| Type               | Default |
| ------------------ | ------- |
| Text Style(Object) | None    |

---

#### wrapperStyle

Inner wrapper component styling.

| Type               | Default |
| ------------------ | ------- |
| View style(Object) | None    |

---
