---
id: fab

title: FAB

slug: /fab
---

import Usage from './usage/FAB/FAB.md'

A floating action button (FAB) performs the primary, or most common, action on a screen.

It appears in front of all screen content, typically as a circular shape with an icon in its center.

Also receives all [Button](https://reactnativeelements.com/docs/button#props) props.

## Usage

<Usage />

---

## Props

### FAB

- [color](#color)
- [placement](#placement)
- [size](#size)
- [style](#style)
- [upperCase](#uppercase)
- [visible](#visible)

## Reference

### FAB

#### color

Change the color of the FAB.

| Type   | Default |
| ------ | ------- |
| string | None    |

---

#### placement

FAB placement at bottom, (optional) use [`style`](#style) in case of custom placement.

| Type              | Default |
| ----------------- | ------- |
| "left" or "right" | None    |

---

#### size

Change Size of FAB.

| Type               | Default |
| ------------------ | ------- |
| "small" or "large" | large   |

---

#### style

//FIXME: not in doc but available in examples

Style for FAB

| Type               | Default |
| ------------------ | ------- |
| View style(Object) | None    |

---

#### upperCase

Transform Extended Label text to uppercase.

| Type    | Default |
| ------- | ------- |
| boolean | None    |

---

#### visible

Decide the visibility of the FAB.

| Type    | Default |
| ------- | ------- |
| boolean | true    |

---
