---
id: card

title: Card

slug: /card
---

import Usage from './usage/Card/Card.md'

Cards are a great way to display information, usually containing content and actions about a single subject.

Cards can contain images, buttons, text and more.

Cards are mainly used for informative purpose.

## Components

- [Card.Divider](#carddivider)
  Add divider to the card which acts as a separator between elements.
  This, Receives all [Divider](divider#props) props.
- [Card.FeaturedSubtitle](#cardfeaturedsubtitle)
  Add a featured subtitle to the Card.
  This, Receives all [Text](text#props) props.
- [Card.FeaturedTitle](#cardfeaturedtitle)
  Add a featured title to the Card.
  This, Receives all [Text](text#props) props.
- [Card.Image](#cardimage)
  Add information in the form of image to the card.
  This, Receives all [Image](Image.md#props) props.
- [Card.Title](#cardtitle)
  Add a general title to the Card.
  This, Receives all [Text](text#props) props.

## Usage

<Usage />

---

## Props

### Card

- [containerStyle](#containerstyle)
- [wrapperStyle](#wrapperstyle)

### Card.Divider

None

### Card.FeaturedSubtitle

None

### Card.FeaturedTitle

None

### Card.Image

- [pressableProps](#pressableprops)

### Card.Title

None

## Reference

### Card

#### containerStyle

Outer container style.

| Type               | Default |
| ------------------ | ------- |
| View style(Object) | None    |

---

#### wrapperStyle

Inner container style.

| Type               | Default |
| ------------------ | ------- |
| View style(Object) | None    |

---

### Card.Divider

None

### Card.FeaturedSubtitle

None

### Card.FeaturedTitle

None

### Card.Image

#### pressableProps

| Type                                                                            | Default |
| ------------------------------------------------------------------------------- | ------- |
| Omit<PressableProps, "onPress" or "onLongPress" or "onPressIn" or "onPressOut"> | None    |

---

### Card.Title

None
