## Props

> Also receives all
> [React Native Image](https://reactnative.dev/docs/image#props) props
>
> Contains all
> [React Native Image](https://reactnative.dev/docs/image#methods) methods.

- [`containerStyle`](#containerstyle)
- [`childrenContainerStyle`](#childrencontainerstyle)
- [`ImageComponent`](#imagecomponent)
- [`onLongPress`](#onlongpress)
- [`onPress`](#onpress)
- [`PlaceholderContent`](#placeholdercontent)
- [`placeholderStyle`](#placeholderstyle)
- [`transition`](#transition)

---

## Reference

### `containerStyle`

Additional styling for the container (optional)

|        Type         | Default |
| :-----------------: | :-----: |
| View style (object) |  none   |

---

### `childrenContainerStyle`

Additional styling for the children container (optional)

|        Type         | Default |
| :-----------------: | :-----: |
| View style (object) |  none   |

---

### `ImageComponent`

Specify a different component as the Image component.

|          Type          | Default |
| :--------------------: | :-----: |
| React Native Component |  Image  |

---

### `onLongPress`

Callback function when long pressing component

|   Type   | Default |
| :------: | :-----: |
| function |  none   |

---

### `onPress`

Callback function when pressing component

|   Type   | Default |
| :------: | :-----: |
| function |  none   |

---

### `PlaceholderContent`

Content to render when image is loading.

|   Type    | Default |
| :-------: | :-----: |
| component |  none   |

---

### `placeholderStyle`

Additional styling for the placeholder container (optional)

|        Type         | Default |
| :-----------------: | :-----: |
| View style (object) |  none   |

---

### `transition`

Perform fade transition on image load

|  Type   | Default |
| :-----: | :-----: |
| boolean |  true   |

---

### `transitionDuration`

Perform fade transition on image load

|  Type  | Default |
| :----: | :-----: |
| number |   360   |
