---
title: Version 2.3 Upgrade Guide
author: Core Team
authorURL: https://opencollective.com/react-native-elements#team
---

There have been a lot of changes and improvements coming through the pipeline recently with `react-native-elements`. So in preparing for a version 3, there are some planned deprecations that will be added into version 2.3 and then removed in version 3.

The reason for these changes is that `react-native-elements` regularly gets requests for new features and enhancements quite frequently. The fast and easy method of adding these new features is usually to add another prop into the component that then injects some change into a child component. Unfortunately, this ends up leading to the components having a lot of props, lots of conditional code, and additional code complexity. The solution going forward and into version 3 will be to break down large components into smaller pieces so that it is easier to inject your own code without having to wait for an additional prop to be added.

As we continue to build up to version 3, this post will continue to be updated with new step-by-step directions on how to upgrade your code to work around these changes. The RNE team thanks you for your patience, and we hope that you see the value in the upcoming changes.

## Avatar

`accessory`, `showAccessory`, and `accessoryProps` are all being dprecated. There is now a child component `Avatar.Accessory` that you insert as a child component instead.

```js
<Avatar>
  <Avatar.Accessory {...accessoryProps} />
</Avatar>
```

## ListItem

`ListItem` has a large number of deprecated props. `ListItem` has been somewhat of a kitchen sink. All the props can be replaced by inserting them as children in the order of left to right as they appear on the screen.

### leftElement, leftIcon, leftAvatar, rightElement, rightIcon, rightAvatar

These can be replaced by using `Text`, `Icon`, and `Avatar` components respectively.

### title, titleStyle, titleProps, subtitle, subtitleProps, subtitleStyle

These props can be replaced by `ListItem.Content`, `ListItem.Title` and `ListItem.Subtitle`

```js
<ListItem>
  <ListItem.Content>
    <ListItem.Title style={titleStyle} {...titleProps}>
      {title}
    </ListItem.Title>
  </ListItem.Content>
</ListItem>
```

### contentContainerStyle, rightContentContainerStyle

These props should be placed in the `style` prop of `ListItem.Content`.

### rightTitle, rightTitleStyle, rightTitleProps, rightSubtitle, rightSubtitleStyle, rightSubtitleProps

These props also use `ListItem.Content`, `ListItem.Title`, and `ListItem.Subtitle`. Simply add the prop `right` to each one.

```js
<ListItem>
  <ListItem.Content right>
    <ListItem.Title right style={titleStyle} {...titleProps}>
      {title}
    </ListItem.Title>
  </ListItem.Content>
</ListItem>
```

### input, buttonGroup, switchProps, checkBox, badge, chevron, checkmark

The `input` prop can be replaced with `ListItem.Input`.

The `buttonGroup` prop can be replaced with `ListItem.ButtonGroup`.

The `switchProps` prop can be replaced with `react-native`'s `Switch`.

The `checkBox` prop can be replaced with `ListItem.CheckBox`.

The `badge` prop can be replaced with `Badge`.

The `chevron` prop can be replaced with `ListItem.Chevron`.

The `checkmark` prop can be replaced with :

```js
<Icon name="check" size={20} />
```

## Card

For `Card` the following props have all been deprecated: `title`, `titleStyle`, `titleNumberOfLines`, `dividerStyle`, `image`, `imageStyle`, `imageProps`, `imageWrapperStyle`, `featuredTitle`, `featuredTitleStyle`, `featuredSubtitle`, `featuredSubtitleStyle`

### title, titleStyle, titleNumberOfLines

Move these props into `Card.Title`

```js
<Card>
  <Card.Title style={titleStyle} numberOfLines={titleNumberOfLines}>
    {title}
  </Card.Title>
</Card>
```

### dividerStyle

The divider and the `dividerStyle` itself were moved into `Card.Divider`

### image, imageStyle, imageProps, imageWrapperStyle

These can be replaced with `Card.Image` which accepts all `Image` props. `imageWrapperStyle` can be attached to a `View` that wraps the `Image`

### featuredTitle, featuredTitleStyle, featuredSubtitle, featuredSubtitleStyle

These were both replaced with `Card.FeaturedTitle` and `Card.FeaturedSubtitle`

## BottomSheet

`BottomSheet` was added in version 2.2, and it was noted that it had some strict dependencies that weren't so well liked. So `BottomSheet` has changed completely and it is encouraged that you checkout the docs page on it again.

## Dark Mode

Make sure to checkout the customization page. We added a dark mode configuration to the `ThemeProvider` that should help out in bootstrapping your app's dark mode.
