---
title: React Native Elements 1.0
author: Core Team
authorURL: https://opencollective.com/react-native-elements#team
---

> React Native Elements has UI elements that are easy to use & really customizable. It also has theming, platform specific search bars, [React Native Web](https://github.com/necolas/react-native-web) support, and much more.

It's finally here! Let's put our hands together and welcome React Native Elements 1.0 🎉

This release is centered around making RNE components that everyone loves more intuitive to use & stable. This is not to say that all the work is done, but this is definitely a giant leap in the right direction and one that we have been working on for over a year.

I want like to say thank you to our users for using RNE and giving us feedback through issues on the repo and also the contributors who have the taken time to contribute and help improve RNE together. Finally, I'd like to say a big thanks to [Kyle Roach](https://twitter.com/roach_iam) and [Xavier Villelégier](https://twitter.com/xaviervllgr) without whom this project would not have been as awesome as it is today!!

This blog post is meant to serve as a migration guide for upgrading to `react-native-elements: "^1.0.0"` from `0.19.1` and also a way to document and share all the breaking changes, new features and other improvements in this release. For those updating from `1.0.0-beta7` you can view those release notes [here](https://github.com/react-native-elements/react-native-elements/releases/tag/v1.0.0).

The wait is over!! Get excited, cause we certainly are. 14K 🌟 and counting...

## Installation

First, install the library using your favorite package manager: `yarn add react-native-elements`

Also if you are using an older version, just update the `react-native-elements` version in `package.json` to `^1.0.0`

## Breaking changes

- Updated all components that have the `component` prop to `Component` prop as per convention ([#1479](https://github.com/react-native-elements/react-native-elements/pull/1479))

- Some colors have been removed from the colors file and some changed. Here's the list of colors from 0.19.1.

```js
{
  primary: '#9E9E9E',
  primary1: '#4d86f7',
  primary2: '#6296f9',
  secondary: '#8F0CE8',
  secondary2: '#00B233',
  secondary3: '#00FF48',
  grey0: '#393e42',
  grey1: '#43484d',
  grey2: '#5e6977',
  grey3: '#86939e',
  grey4: '#bdc6cf',
  grey5: '#e1e8ee',
  dkGreyBg: '#232323',
  greyOutline: '#bbb',
  searchBg: '#303337',
  disabled: '#dadee0',
  white: '#ffffff',
  error: '#ff190c',
};
```

### `Avatar`

- Props `small`, `medium`, `large`, `xlarge` have been removed. Usage is now `size="small"` etc. [#1098](https://github.com/react-native-elements/react-native-elements/pull/1098)

### `Badge`

- `wrapperStyle` prop has been removed - use `containerStyle` prop instead ([#1545](https://github.com/react-native-elements/react-native-elements/pull/1545))
- `badgeStyle` prop replaces previous behaviour of `containerStyle` prop ([#1545](https://github.com/react-native-elements/react-native-elements/pull/1545))
- `element` prop which was undocumented is removed - use `value` prop instead ([#1545](https://github.com/react-native-elements/react-native-elements/pull/1545))
- can no longer render children - instead use `value` prop which now supports rendering react components ([#1545](https://github.com/react-native-elements/react-native-elements/pull/1545))

### `Button`

- By default on Android there's no more elevation ([#1538](https://github.com/react-native-elements/react-native-elements/pull/1538)). To get elevation, use the `raised` prop.
- Renamed `textStyle` to `titleStyle`
- Renamed `containerViewStyle` to `containerStyle`
- Removed props `transparent` and `outline` ([#1540](https://github.com/react-native-elements/react-native-elements/pull/1540)). Instead use the `type` prop.

```jsx
// Transparent
<Button type="clear" />

// Outline
<Button type="outline" />
```

- Removed props `secondary`, `secondary2`, `secondary3`, `primary1`, `primary2`, `backgroundColor`. Use the `buttonStyle` prop to set the background color.
- Removed `iconComponent` prop. If you want to use a different Icon component - the `icon` prop supports custom elements.
- Removed `loadingRight` prop. Loading indicator **displays without title**. May re-add in future.
- Removed `borderRadius` prop. To control the border radius use the `buttonStyle` prop.
- Removed props `color`, `fontSize`, `fontWeight`, and `fontFamily`. Instead use the `titleStyle` prop to set attributes for the title.
- Removed `large` prop. May re-add in future.

### `ButtonGroup`

- `disableSelected` prop has been removed ([#1587](https://github.com/react-native-elements/react-native-elements/pull/1587))

### `Card`

- `fontFamily` prop is deprecated - instead use `titleStyle` prop ([#1659](https://github.com/react-native-elements/react-native-elements/pull/1587))
- `flexDirection` prop is deprecated - instead use `wrapperStyle` prop ([#1659](https://github.com/react-native-elements/react-native-elements/pull/1587))

### `Form`

- `FormInput` been renamed to `Input` ([#497](https://github.com/react-native-elements/react-native-elements/pull/497))

  - `clearText` method renamed to `clear`
  - `textInputRef` and `containerRef` props removed
  - `normalizeFontSize` prop removed. You can use the `normalize` helper along with the `inputStyle` prop to normalize font sizes.

- `FormLabel` has been removed. This is now built into the `Input` component by use of `label` prop. Props `labelStyle` and `labelProps` can be used to customize it.
- `FormValidationMessage` has been removed. This is now built into the `Input` component by use of `errorMessage` prop. Props `errorStyle` and `errorProps` can be used to customize it.

### `Header`

- Props `innerContainerStyles`, `outerContainerStyles` removed [#1221](https://github.com/react-native-elements/react-native-elements/pull/1221). Instead use the `containerStyle` prop for main styling, along with props `leftContainerStyle`, `centerContainerStyle`, and `rightContainerStyle` when needed.

### `SearchBar`

SearchBar now supports different platform styles! To get an iOS or Android themed SearchBar, use the `platform` prop. `platform="ios"` or `platform="android"`

- `noIcon` prop removed. Instead to remove the search icon use the `searchIcon` prop. E.g `searchIcon={null}`
- `showLoadingIcon` prop renamed to `showLoading` [#837](https://github.com/react-native-elements/react-native-elements/pull/837)
- `containerRef` prop removed

### `List`

- **`List` component has been removed!** `List` was just a regular React Native View with some small margin styles. It wasn't actually needed to use the `ListItem` component. Instead we recommend using the [`FlatList`](https://reactnative.dev/docs/flatlist) or [`SectionList`](https://reactnative.dev/docs/sectionlist) components from React Native which function both as Views and also displaying items, pull to refresh and more.
- If you want to apply the same styles that the `List` component provided prior to 1.0, [see this comment](https://github.com/react-native-elements/react-native-elements/issues/1565#issuecomment-436982251).

### `ListItem`

- `leftIconOnPress`, `leftIconOnLongPress`, `leftIconUnderlayColor`, and `leftIconContainerStyle`, removed. The `leftIcon` prop can accept props.

```jsx
<ListItem
  title="Yea"
  leftIcon={{ name: 'home', onPress: () => alert('hello') }}
/>
```

- `avatar`, `avatarStyle`, `avatarContainerStyle`, `roundAvatar`, and `avatarOverlayContainerStyle` removed. Avatars can now be customized using the `rightAvatar` and `leftAvatar` props which can either render a custom element or an object that describes the props from Avatar.

```jsx
<ListItem
  leftAvatar={{
    title: 'MD',
    rounded: false,
    containerStyle: { margin: 5 },
    onPress: () => alert('hey'),
  }}
  rightAvatar={{ title: 'DW', onLongPress: () => alert('hey') }}
/>
```

- `wrapperStyle` prop removed. Use the `containerStyle` prop instead.
- `titleNumberOfLines`, `subtitleNumberOfLines`, and `rightTitleNumberOfLines` props removed. Use the `titleProps`, `rightTitleProps`, and `subtitleProps` props to pass props for each..

```jsx
<ListItem titleProps={{ numberOfLines: 4 }} />
```

- `hideChevron` removed. Use the `chevron` prop instead. However, the behaviour is swapped `hideChevron={true}` behaves like `chevron={false}`
- `chevronColor` removed. The `chevron` prop now can accept an object describing it's appearance.

```jsx
<ListItem chevron={{ color: 'pink' }} />
```

- `fontFamily` removed. Use the `titleStyle` and `subTitleStyle` props to set change the text styling
- `titleContainerStyle` removed. Use the `titleStyle` prop instead.
- `rightTitleContainerStyle` removed. Use the `rightTitleStyle` prop instead.
- `subtitleContainerStyle` removed. Use the `subtitleStyle` prop instead.
- `label` prop removed.
- `switchButton`, `onSwitch`, `switchDisabled`, `switchOnTintColor`, `switchThumbTintColor`, `switchTintColor`, and `switched` removed. Instead use the `switch` prop wich accepts an object describing its props.
- `textInput`,`textInputAutoCapitalize`,`textInputAutoCorrect`,`textInputAutoFocus`,`textInputEditable`,`textInputKeyboardType`,`textInputMaxLength`,`textInputMultiline`,`textInputOnChangeText`,`textInputOnFocus`,`textInputOnBlur`,`textInputSelectTextOnFocus`,`textInputReturnKeyType`,`textInputValue`,`textInputSecure`,`textInputStyle`,`textInputContainerStyle`,`textInputPlaceholder` removed. We now expose a single `input` prop which accepts an object describing its props.
- `onPressRightIcon` removed. Use the `rightIcon` prop which can accept an object now describing its props.

```jsx
<ListItem rightIcon={{ name: 'home', onPress: () => console.log('clicked') }} />
```

### `PricingCard`

- `titleFont` removed. Use the `titleStyle` prop instead to customize the title. [#1231](https://github.com/react-native-elements/react-native-elements/pull/1231)
- `pricingFont` removed. Use the `pricingStyle` prop instead to customize the price. [#1231](https://github.com/react-native-elements/react-native-elements/pull/1231)
- `infoFont` removed. Use the `infoStyle` prop instead to customize the info. [#1231](https://github.com/react-native-elements/react-native-elements/pull/1231)
- `buttonFont` removed. Use the `button` prop with a `buttonStyle` key to set this.

```jsx
<PricingCard button={{ buttonStyle: { fontFamily: 'Arial' } }} />
```

### `Text`

- `fontFamily` prop is removed - instead use `style` prop ([#1659](https://github.com/react-native-elements/react-native-elements/pull/1587))

## New features

- Support for React Native Web - read more on it [here](/blog/2018/12/13/react-native-web) ([#1664](https://github.com/react-native-elements/react-native-elements/pull/1664))
- Theming support across components - easily build light & dark modes and theme your components from one place ([#1454](https://github.com/react-native-elements/react-native-elements/pull/1454))
- New `<Image />` Component - displays images with a placeholder and smooth image load transitioning ([#1582](https://github.com/react-native-elements/react-native-elements/pull/1582))
- New `<Input />` Component - a branch new and improved replacement for `<FormInput />` ([#497](https://github.com/react-native-elements/react-native-elements/pull/497))
- New `withBadge` HOC allows you to easily add badges to icons and other components ([#1604](https://github.com/react-native-elements/react-native-elements/pull/1604))
- New "mini badge" with the `<Badge />` component - Perfect for status indicators and notifications [#1545](https://github.com/react-native-elements/react-native-elements/pull/1545)
- New Tap Rating `<AirbnbRating />` component - powered by `react-native-ratings` ([#1671](https://github.com/react-native-elements/react-native-elements/pull/1671))
- Platform-specific `<SearchBar />` component - drop-in usage with native look and feel ([#837](https://github.com/react-native-elements/react-native-elements/pull/837))
- `<Slider />` Component - supports `vertical` orientation ([#1698](https://github.com/react-native-elements/react-native-elements/pull/1698))
- Button types! Easily have solid, clear, and outline buttons with one prop. ([#1540](https://github.com/react-native-elements/react-native-elements/pull/1540))
- Background image support in the `<Header />` ([#1556](https://github.com/react-native-elements/react-native-elements/pull/1556))
- Add support for `AntDesign` icons ([#1529](https://github.com/react-native-elements/react-native-elements/pull/1529))

## Assorted fixes & improvements

- Updated `react-native-vector-icons` peerDependency to `>4.2.0`
- Expose `helpers` methods that are used internally
- Close to 100% types coverage
- Docs
  - Add descriptions for every Component ([#1527](https://github.com/react-native-elements/react-native-elements/pull/1527))
  - Add central place to show supported icon sets ([#1532](https://github.com/react-native-elements/react-native-elements/pull/1532))
  - Added Showcase section to display apps using RNE ([#1704](https://github.com/react-native-elements/react-native-elements/pull/1704))

## Ecosystem and web support

### Independent Projects

- Mock iOS Settings Screen - Check it out on the [RNE-App here](https://github.com/Monte9/react-native-elements-app)

### Web Support

- Follow [this detailed Blog Post](/blog/2018/12/13/react-native-web) to use RNElements with RNWeb

> Lastly, here is the RNE v1 release in numbers:
>
> - 470 commits (with over 272 PR's)
> - 371 files changes (52,920 additions and 32,737 deletions)
> - Over 80 contributors
> - Over \$1500 awarded to contributors

---

Thanks for reading! Feel free to share this post if you enjoyed reading it.

If you run into any trouble using RNE, please open a new issue [here](https://github.com/react-native-elements/react-native-elements/issues). Also if you want to support us, you can contribute to our Open Collective [here](https://opencollective.com/react-native-elements).
