 /*
  cxproc - Configurable Xml PROCessor

  Copyright (C) 2006..2020 by Alexander Tenbusch

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

*/

/* https://www.iana.org/assignments/media-types/media-types.xhtml */

typedef enum {
  MIME_UNDEFINED,
  MIME_UNKNOWN,
  /*
    Microsoft Office
  */
  MIME_APPLICATION_MSACCESS,
  MIME_APPLICATION_MSEXCEL,
  MIME_APPLICATION_MSGFILE,
  MIME_APPLICATION_MSPOWERPOINT,
  MIME_APPLICATION_MSPROJECT,
  MIME_APPLICATION_MSWORD,
  MIME_APPLICATION_VISIO,
  MIME_APPLICATION_MSSHORTCUT,
  /*
    Microsoft Office XML formats
  */
  MIME_APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_PRESENTATION,
  MIME_APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_SHEET,
  MIME_APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_DOCUMENT,
  MIME_APPLICATION_VND_MS_VISIO_DRAWING_MAIN_XML_2013,
  MIME_APPLICATION_VND_MICROSOFT_PORTABLE_EXECUTABLE,
  /*
    Open Office
  */
  MIME_APPLICATION_VND_OASIS_OPENDOCUMENT_TEXT, 
  MIME_APPLICATION_VND_OASIS_OPENDOCUMENT_SPREADSHEET, 
  MIME_APPLICATION_VND_OASIS_OPENDOCUMENT_PRESENTATION,
  MIME_APPLICATION_VND_SUN_XML_WRITER, 
  MIME_APPLICATION_VND_SUN_XML_CALC, 
  MIME_APPLICATION_VND_SUN_XML_IMPRESS, 
  MIME_APPLICATION_VND_STARDIVISION_WRITER, 
  MIME_APPLICATION_VND_STARDIVISION_CALC, 
  MIME_APPLICATION_VND_STARDIVISION_IMPRESS,
  /*
    DASSAULT CAD formats
  */
  MIME_APPLICATION_VND_DASSAULT_CATIA_V4_2D,
  MIME_APPLICATION_VND_DASSAULT_CATIA_V4_3D,
  MIME_APPLICATION_VND_DASSAULT_CATIA_V5_2D,
  MIME_APPLICATION_VND_DASSAULT_CATIA_V5_3D,
  /*
    PTC CAD formats
  */
  MIME_APPLICATION_VND_PTC_CAD_3D,
  MIME_APPLICATION_VND_PTC_CAD_2D,
  MIME_APPLICATION_VND_PTC_CAD_CONFIGURATION,
  MIME_APPLICATION_VND_PTC_CAD_XYZ,
  /*
    Application formats
  */
  MIME_APPLICATION_CAD_2D,
  MIME_APPLICATION_CAD_3D,
  MIME_APPLICATION_SLA,
  MIME_APPLICATION_COMMAND,
  MIME_APPLICATION_CXP_XML,
  MIME_APPLICATION_MMAP_XML,
  MIME_APPLICATION_MM_XML,
  MIME_APPLICATION_X_BYTECODE_ELISP,
  MIME_APPLICATION_JSON,
  MIME_APPLICATION_X_JAVASCRIPT,
  MIME_APPLICATION_X_JAVA_VM,
  MIME_APPLICATION_XMIND_XML,
  MIME_APPLICATION_XMMAP_XML,
  MIME_APPLICATION_RDF_XML,
#ifdef HAVE_PIE
  MIME_APPLICATION_PIE_XML,
  MIME_APPLICATION_PIE_XML_INDEX,
#endif
  MIME_APPLICATION_X_SH,
  MIME_APPLICATION_XSPF_XML,
  MIME_APPLICATION_X_SQLITE3,
  MIME_APPLICATION_X_BAT,
  MIME_APPLICATION_ZIP,
  MIME_APPLICATION_GZIP,
  MIME_APPLICATION_X_BZIP,
  MIME_APPLICATION_X_TAR,
  MIME_APPLICATION_X_ISO9660_IMAGE,
  MIME_APPLICATION_PDF,
  MIME_APPLICATION_POSTSCRIPT,
  /*
    Audio formats
  */
  MIME_AUDIO_MP3,
  MIME_AUDIO_OGG,
  MIME_AUDIO_WAV,
  /*
    Binary formats
  */
  MIME_BINARY_DLL,
  MIME_BINARY_EXE,
  MIME_BINARY_OBJECT,
  /*
    Image formats
  */
  MIME_IMAGE_GIF,
  MIME_IMAGE_JPEG,
  MIME_IMAGE_PNG,
  MIME_IMAGE_TIFF,
  MIME_IMAGE_WMF,
  /*
    Filesystem elements
  */
  MIME_INODE_DIRECTORY,
  MIME_INODE_SYMLINK,
  /*
    Text formats
  */
  MIME_TEXT_C,
  MIME_TEXT_CALENDAR,
  MIME_TEXT_CSS,
  MIME_TEXT_CSV,
  MIME_TEXT_HTML,
  MIME_TEXT_PLAIN,
  MIME_TEXT_PLAIN_CALENDAR,
  MIME_TEXT_MARKDOWN,
  MIME_TEXT_VCARD,
  MIME_TEXT_XML,
  MIME_TEXT_X_SCRIPT_ELISP,
  MIME_TEXT_X_SCRIPT_PERL,
  MIME_TEXT_X_SCRIPT_TCL,
  MIME_TEXT_XSL,
  /*
    Video formats
  */
  MIME_VIDEO_AVI,
  MIME_VIDEO_MP4,
  /*
    symbolic types only
  */
  MIME_APPLICATION_X_BACKUP_EDITOR,
  MIME_END,
  MIME_PIPE_STDOUT,
  /*
    pseudo types for error markup
  */
  MIME_ERROR_FOPEN,
  MIME_ERROR_PARSE,
  MIME_ERROR_UNKNOWN
} RN_MIME_TYPE;



extern RN_MIME_TYPE
resMimeGetTypeFromExt(const xmlChar *pucArg);

extern RN_MIME_TYPE
resMimeGetType(const char *pchArg);

extern char *
resMimeGetTypeStr(int iArg);

extern BOOL_T
resMimeIsDatabase(int iMimeType);

extern BOOL_T
resMimeIsPicture(int iMimeType);

extern BOOL_T
resMimeIsArchive(int iMimeType);

extern BOOL_T
resMimeIsXml(int iMimeType);

extern BOOL_T
resMimeIsPlain(int iMimeType);

#ifdef TESTCODE
extern int
resNodeTestMime(void);
#endif

