# Contributing Guidelines

**First of all, thank you for considering contributing to the project.**

These are some of the many ways to contribute:

* :bug: Submitting bug reports and feature requests
* :memo: Writing tutorials or examples
* :mag: Fixing typos and improving the documentation
* :bulb: Writing code for everyone to use

If you get stuck at any point you can create an issue on GitHub (look for the *Issues*
tab in the repository).

For more general information on how to contribute to open source projects,
[GitHub's own guide](https://guides.github.com/activities/contributing-to-open-source/)
is a great starting point if you are new to version control and it's concepts.

## Ground Rules

The goal is to maintain a diverse community that's pleasant for everyone.
**Please be considerate and respectful of others**.
Everyone must abide by our [Code of Conduct](CODE_OF_CONDUCT.md) and we encourage all to read it carefully.

## What Can I Do?

* Tackle any [issue](/issues) that you wish!
  * Please leave a comment on the issue indicating that you want to work on it
  * Some issues are labeled as "good first issue" to indicate that they are beginner friendly, meaning that they don't require extensive knowledge of the project
* Report a bug you found through the [Github issues](/issues).
* Make a tutorial or example of how to do something cool with the application or library.
* Provide feedback about how we can improve the project or about your particular use case.
* Contribute code you already have. It doesn't need to be perfect! We will help you clean things up, test it, etc.

## How I contact or discuss about the project?

Discussion often happens in the issues and pull requests.

## Reporting a Bug

1. Find the [Issues](/issues) tab on the top of the GitHub repository 
1. Click ***New Issue***
1. You'll be prompted to choose between different types of issue, like bug reports and feature requests.
1. Choose the one that best matches your need.
1. The Issue will be populated with one of our templates.
   * Please try to fill out the template with as much detail as you can.
*Remember*: **the more information we have, the easier it will be for us to solve your
problem**.

## Contributing Code

**Is this your first contribution?**

* Please take a look at these resources to learn about git and pull requests:
  * [How to Contribute to Open Source](https://opensource.guide/how-to-contribute/).
  * Aaron Meurer's [tutorial on the git workflow](http://www.asmeurer.com/git-workflow/)
  * [How to Contribute to an Open Source Project on GitHub](https://egghead.io/courses/how-to-contribute-to-an-open-source-project-on-github)

### General guidelines

General guidelines for pull requests (PRs):

* **Open an issue first** describing what you want to do. If there is already an issue
  that matches your PR, leave a comment there instead to let us know what you plan to do.
* Each pull request should consist of a **small** and logical collection of changes.
* Larger changes should be broken down into smaller components and integrated
  separately.
* Bug fixes should be submitted in separate PRs.
* Describe what your PR changes and *why* this is a good thing. Be as specific as you
  can. The PR description is how we keep track of the changes made to the project over time.
* Do not commit changes to files that are irrelevant to your feature or bug fix (eg:
  `.gitignore`, IDE project files, etc).
* Write descriptive commit messages. Chris Beams has written a
  [guide](https://chris.beams.io/posts/git-commit/) on how to write good commit messages.
* Be willing to accept criticism and work on improving your code; we don't want to break
  other users' code, so care must be taken not to introduce bugs.
* Be aware that the pull request review process is not immediate, and is generally
  proportional to the size of the pull request. Be patient.

### Code Review

After you've submitted a pull request, you should expect to hear at least a comment within a couple of days. Be patient.
We may suggest some changes or improvements or alternatives.

Some things that will increase the chance that your pull request is accepted quickly:

* Write a good and detailed description of what the PR does.
* Write tests for the code you wrote/modified.
* Readable code is better than clever code (even with comments).
* Write documentation for your code and leave comments explaining the *reason* behind
  non-obvious things.
* Include an example of new features in the gallery or tutorials.
