##  Chapter 18: Graph Neural Networks for Capturing Dependencies in Graph Structured Data


### Chapter Outline

- Introduction to graph data
  - Undirected graphs
  - Directed graphs
  - Labeled graphs
  - Representing molecules as graphs
- Understanding graph convolutions
  - The motivation behind using graph convolutions
  - Implementing a basic graph convolution
- Implementing a GNN in PyTorch from scratch
  - Defining the NodeNetwork model
  - Coding the NodeNetwork’s graph convolution layer
  - Adding a global pooling layer to deal with varying graph sizes
  - Preparing the DataLoader
  - Using the NodeNetwork to make predictions
- Implementing a GNN using the PyTorch Geometric library
- Other GNN layers and recent developments
  - Spectral graph convolutions
  - Pooling
  - Normalization
  - Pointers to advanced graph neural network literature
- Summary



**Please refer to the [README.md](../ch01/README.md) file in [`../ch01`](../ch01) for more information about running the code examples.**

