
##  Chapter 17: Generative Adversarial Networks for Synthesizing New Data


### Chapter Outline

- Introducing generative adversarial networks
  - Starting with autoencoders
  - Generative models for synthesizing new data
  - Generating new samples with GANs
  - Understanding the loss functions for the generator and discriminator networks in a GAN model
  
- Implementing a GAN from scratch
  - Training GAN models on Google Colab
  - Implementing the generator and the discriminator networks
  - Defining the training dataset
  - Training the GAN model
  
- Improving the quality of synthesized images using a convolutional and Wasserstein GAN
  - Transposed convolution
  - Batch normalization
  - Implementing the generator and discriminator
  - Dissimilarity measures between two distributions
  - Using EM distance in practice for GANs
  - Gradient penalty
  - Implementing WGAN-GP to train the DCGAN model
  - Mode collapse
  - Other GAN applications
  
- Summary

  

**Please refer to the [README.md](../ch01/README.md) file in [`../ch01`](../ch01) for more information about running the code examples.**

