


##  Chapter 15: Modeling Sequential Data Using Recurrent Neural Networks


### Chapter Outline

- Introducing sequential data
  - Modeling sequential data—order matters
  - Representing sequences
  - The different categories of sequence modeling
- RNNs for modeling sequences
  - Understanding the RNN looping mechanism
  - Computing activations in an RNN
  - Hidden-recurrence versus output-recurrence
  - The challenges of learning long-range interactions
  - Long short-term memory cells
- Implementing RNNs for sequence modeling in PyTorch
  - Project one: predicting the sentiment of IMDb movie reviews
    - Preparing the movie review data
    - Embedding layers for sentence encoding
    - Building an RNN model
    - Building an RNN model for the sentiment analysis task
      - More on the bidirectional RNN
  - Project two: character-level language modeling in PyTorch
    - Preprocessing the dataset
    - Building a character-level RNN model
    - Evaluation phase: generating new text passages
- Summary

**Please refer to the [README.md](../ch01/README.md) file in [`../ch01`](../ch01) for more information about running the code examples.**

