##  Chapter 3: A Tour of Machine Learning Classifiers Using scikit-learn

### Chapter Outline

- Choosing a classification algorithm
- First steps with scikit-learn -- training a perceptron
- Modeling class probabilities via logistic regression
  - Logistic regression intuition and conditional probabilities
  - Learning the weights of the logistic cost function
  - Converting an Adaline implementation into an algorithm for logistic regression
  - Training a logistic regression model with scikit-learn
  - Tackling overfitting via regularization
- Maximum margin classification with support vector machines
  - Maximum margin intuition
  - Dealing with a nonlinearly separable case using slack variables
  - Alternative implementations in scikit-learn
- Solving nonlinear problems using a kernel SVM
  - Kernel methods for linearly inseparable data
  - Using the kernel trick to find separating hyperplanes in high-dimensional space 
- Decision tree learning
  - Maximizing information gain – getting the most bang for your buck
  - Building a decision tree
  - Combining multiple decision trees via random forests
- K-nearest neighbors – a lazy learning algorithm
- Summary

**Please refer to the [README.md](../ch01/README.md) file in [`../ch01`](../ch01) for more information about running the code examples.**

