import React from "react";

interface LogoProps extends React.SVGProps<SVGSVGElement> {
  textcolor?: string;
}

export const Logo = (
  props: LogoProps = {
    textcolor: "#000000",
  },
) => {
  return (
    <svg
      height="100%"
      strokeMiterlimit="10"
      //   style="fillRule:nonzero;clip-rule:evenodd;stroke-linecap:round;stroke-linejoin:round;"
      version="1.1"
      viewBox="0 0 2027.53 395.539"
      width="100%"
      xmlSpace="preserve"
      xmlns="http://www.w3.org/2000/svg"
      xmlnsXlink="http://www.w3.org/1999/xlink"
      {...props}
    >
      <defs />
      <g id="Untitled">
        <path
          d="M149.009 386.083C139.83 383.731 131.003 380.806 122.403 377.243C111.872 372.88 101.778 367.698 92.1665 361.664C85.6736 357.587 79.493 353.072 73.4603 348.375C66.8204 343.206 60.6427 337.533 54.8205 331.525C48.9059 325.422 43.3341 319.013 38.2967 312.193C32.9348 304.933 27.9731 297.435 23.6127 289.551C16.2289 276.201 10.6323 262.191 6.57534 247.575C4.27179 239.276 2.59445 230.857 1.44734 222.346C0.970608 218.81 0.682886 215.239 0.422856 211.669C-0.276162 202.073 0.0844989 192.475 0.161307 182.878C0.183866 180.058 0.626736 177.235 0.976404 174.425C1.48454 170.341 1.97779 166.251 2.6692 162.195C3.54299 157.068 4.68858 151.984 6.07367 146.965C7.58675 141.483 9.13393 136.002 11.0989 130.65C14.4475 121.53 18.4253 112.672 23.0378 104.085C26.7435 97.1866 30.822 90.5001 35.3983 84.1146C40.7689 76.6209 46.5882 69.4734 52.8239 62.624C56.0062 59.1285 59.4104 55.8686 62.896 52.7024C70.0114 46.239 77.4839 40.1694 85.5166 34.7828C93.3708 29.5159 101.49 24.6682 110.013 20.4887C120.411 15.3892 131.194 11.1634 142.364 7.96978C151.375 5.39301 160.525 3.2867 169.868 2.12221C175.723 1.3925 181.584 0.781175 187.482 0.375384C194.308-0.0942835 201.127-0.0733632 207.932 0.165858C217.232 0.492851 226.488 1.47315 235.662 3.0986C245.677 4.87288 255.535 7.22069 265.106 10.5985C270.994 12.6766 276.79 14.9844 282.503 17.5014C290.769 21.1425 298.688 25.3973 306.373 30.0435C313.292 34.2269 319.855 38.9328 326.196 43.9153C330.362 47.1887 334.276 50.7332 338.195 54.2813C348.171 63.3139 356.749 73.4903 364.552 84.3067C370.917 93.1295 376.502 102.401 381.183 112.175C388.262 126.956 393.467 142.328 396.515 158.365C397.537 163.742 398.19 169.175 398.807 174.612C399.411 179.925 399.626 185.243 399.698 190.584C399.725 192.593 400.117 194.616 399.983 196.64C399.676 201.284 399.647 205.938 399.296 210.584C399.051 213.817 398.768 217.04 398.41 220.261C397.657 227.055 396.383 233.762 394.839 240.42C392.155 251.995 388.296 263.203 383.523 274.119C383.36 274.492 383.23 274.878 383.025 275.419C382.863 275.875 382.848 276.201 382.558 276.548C382 278.863 380.494 280.619 379.554 282.637C377.227 287.632 374.441 292.403 371.529 297.088C368.115 302.579 364.371 307.865 360.467 313.05C357.34 317.203 354.002 321.184 350.518 325.039C346.024 330.013 341.364 334.842 336.287 339.292C333.658 341.596 331.091 343.976 328.367 346.172C321.622 351.61 314.54 356.607 307.21 361.286C302.549 364.261 297.769 367.045 292.852 369.563C284.667 373.756 276.291 377.569 267.541 380.574C261.037 382.807 254.456 384.772 247.789 386.477C240.315 388.389 232.718 389.723 225.061 390.664C221.074 391.154 217.042 391.389 213.024 391.679C204.392 392.303 195.76 392.065 187.136 391.885C183.138 391.802 179.119 391.335 175.116 390.896C168.887 390.212 162.729 389.208 156.61 387.929C154.366 387.46 152.139 386.916 149.758 386.373C149.406 386.369 149.249 386.302 149.009 386.083Z"
          fill="#2a3d59"
          fillRule="nonzero"
          opacity="1"
          stroke="none"
        />
        <path
          d="M382.454 276.459C382.323 276.135 382.263 275.77 382.72 275.484C383.152 275.842 383.31 276.225 382.454 276.459Z"
          fill="#d04d49"
          fillRule="nonzero"
          opacity="1"
          stroke="none"
        />
        <path
          d="M148.729 386.002C148.882 385.933 149.055 385.981 149.338 386.106C149.187 386.468 148.938 386.611 148.729 386.002Z"
          fill="#9e2c2f"
          fillRule="nonzero"
          opacity="1"
          stroke="none"
        />
        <path
          d="M118.912 307.477C112.025 303.756 106.4 298.697 100.893 293.516C88.3945 281.76 78.5231 268.175 71.2556 252.833C65.9897 241.717 62.3388 230.093 60.2805 218.022C58.6254 208.316 58.027 198.521 58.5807 188.702C59.5689 171.175 63.5829 154.331 71.1717 138.345C79.7784 120.215 91.7831 104.532 107.144 91.2626C119.877 80.2634 134.194 71.7888 150.107 65.8693C160.955 61.8338 172.151 59.1908 183.705 57.9026C193.721 56.7859 203.748 56.7051 213.746 57.6859C229.955 59.2762 245.517 63.2651 260.128 70.4233C261.064 70.8823 262.03 71.2588 263.194 71.5643C263.682 72.5748 262.987 73.1185 262.369 73.6463C253.644 81.1037 244.97 88.6188 236.271 96.1052C228.508 102.786 220.703 109.422 212.936 116.1C206.37 121.745 199.699 127.28 193.222 133.02C187.204 138.352 181.086 143.575 175.009 148.839C168.309 154.642 161.586 160.424 154.857 166.196C150.527 169.911 146.218 173.652 141.96 177.444C136.83 182.013 131.518 186.388 126.478 191.16C126.448 191.235 126.506 191.384 126.601 191.42C129.452 191.606 132.213 191.434 135.143 191.579C136.673 191.831 138.029 192.117 139.572 191.607C141.579 191.489 143.407 191.517 145.414 191.565C146.3 191.6 147.006 191.615 147.896 191.568C152.845 191.549 157.612 191.328 162.54 191.746C164.101 192.913 163.553 193.979 162.518 194.867C158.029 198.714 153.811 202.85 149.31 206.677C145.592 209.838 142.003 213.132 138.306 216.313C136.329 218.015 134.354 219.719 132.352 221.394C131.847 221.816 131.181 222.138 131.119 222.889C131.384 223.241 131.757 223.211 132.092 223.211C140.037 223.228 147.983 223.243 155.929 223.211C156.704 223.208 157.437 222.952 158.203 222.914C159.272 222.863 160.286 223.033 161.319 223.716C162.15 225.041 161.397 226.055 160.888 227.052C158.203 232.315 155.408 237.527 152.798 242.825C147.698 253.176 142.27 263.369 137.124 273.697C131.828 284.327 126.337 294.863 120.945 305.447C120.52 306.28 120.178 307.223 118.912 307.477Z"
          fill="#dd3a35"
          fillRule="nonzero"
          opacity="1"
          stroke="none"
        />
        <path
          d="M301.904 100.523C306.816 105.074 310.882 110.142 314.745 115.367C326.219 130.883 333.707 148.107 337.736 166.743C340.615 180.061 341.463 193.543 340.371 207.122C339.244 221.124 335.936 234.642 330.454 247.626C324.512 261.7 316.327 274.451 306.092 285.984C297.614 295.536 287.945 303.758 277.166 310.748C269.028 316.025 260.371 320.37 251.287 323.924C242.262 327.454 232.936 329.918 223.367 331.545C212.606 333.374 201.748 333.85 190.865 333.236C183.14 332.801 175.476 331.738 167.826 329.738C166.988 328.717 167.752 328.137 168.351 327.633C174.821 322.188 180.788 316.216 187.242 310.752C191.438 307.201 195.42 303.415 199.509 299.746C208.656 291.538 217.859 283.391 227.108 275.291C231.342 271.584 235.475 267.754 239.694 264.024C247.359 257.247 254.892 250.329 262.661 243.662C265.425 241.291 268 238.718 270.687 236.262C277.985 229.591 285.393 223.036 292.682 216.355C295.102 214.136 297.38 211.737 300.081 209.799C300.677 209.371 301.286 208.887 301.627 208.143C300.928 207.659 300.148 207.901 299.427 207.899C291.274 207.878 283.12 207.893 274.967 207.878C273.868 207.876 272.716 208.049 271.646 207.188C270.704 204.781 272.898 203.956 273.892 202.565C274.368 201.899 275.762 201.582 275.305 200.634C274.906 199.808 273.668 200.185 272.811 200.253C271.51 200.357 270.228 200.672 268.904 200.54C266.244 200.274 265.287 199.231 265.366 196.495C266.387 194.166 268.499 192.952 270.195 191.433C272.585 189.294 274.827 186.985 277.591 184.904C276.762 184.674 276.045 184.786 275.351 184.766C270.088 184.621 264.814 185.061 259.413 184.447C258.021 183.418 257.914 182.491 258.861 181.105C261.515 177.217 263.411 172.911 265.578 168.764C276.719 147.444 287.628 126.009 298.691 104.65C299.478 103.13 299.977 101.339 301.904 100.523Z"
          fill="#de3935"
          fillRule="nonzero"
          opacity="1"
          stroke="none"
        />
        <path
          d="M259.108 183.636C265.62 183.755 271.945 183.795 278.271 183.843C278.669 183.846 279.091 183.666 279.668 184.1C275.131 188.171 270.624 192.214 266.056 196.381C264.114 200.077 260.479 202.021 257.77 204.825C257.162 205.455 256.296 205.809 255.595 206.57C249.696 211.925 243.75 217.019 237.868 222.181C232.913 226.528 227.932 230.847 222.963 235.179C216.597 240.729 210.166 246.211 203.872 251.837C199.009 256.183 194.064 260.438 189.163 264.741C182.458 270.629 175.786 276.55 169.015 282.367C164.381 286.349 159.84 290.434 155.225 294.439C148.951 299.884 142.732 305.387 136.41 310.78C134.478 312.428 132.752 314.303 130.513 315.829C123.606 321.76 116.916 327.711 110.061 333.483C108.773 334.567 107.318 335.267 105.663 335.979C105.18 336.027 104.913 335.914 104.823 335.456C107.731 329.318 110.806 323.43 113.832 317.518C115.5 314.26 117.089 310.964 118.734 307.58C119.82 306.359 120.288 304.911 120.961 303.592C127.506 290.763 133.998 277.909 140.521 265.07C147.259 251.806 154.015 238.551 160.762 225.291C160.916 224.989 161.058 224.68 161.237 224.24C160.712 222.627 161.675 221.495 162.255 220.314C166.646 211.364 171.331 202.555 175.795 193.549C175.796 193.459 175.644 193.334 175.524 193.317C172.241 193.339 169.078 193.348 165.915 193.308C165.038 193.297 164.106 193.418 163.217 192.648C158.037 192.307 153.005 192.449 147.78 192.449C147.151 192.694 146.687 192.605 146.072 192.538C143.949 192.452 141.986 192.43 139.83 192.436C138.372 192.789 137.086 192.562 135.632 192.527C132.103 192.428 128.752 192.399 125.208 192.35C124.746 192.094 124.705 191.808 124.911 191.364C133.546 183.765 142.064 176.266 150.634 168.823C161.907 159.033 173.221 149.287 184.517 139.522C194.668 130.747 204.797 121.947 214.975 113.202C227.398 102.529 239.868 91.9062 252.306 81.2498C255.964 78.1163 259.585 74.9431 263.286 71.692C266.747 68.7148 270.142 65.829 273.546 62.9542C277.58 59.5472 281.623 56.1497 285.785 52.6887C286.913 52.2948 287.461 52.6241 287.445 53.8573C286.521 55.7997 285.664 57.5586 284.798 59.4648C284.793 59.8554 284.723 60.0745 284.477 60.3475C284.254 60.623 284.115 60.8141 283.978 61.1252C283.932 63.6948 282.581 65.7076 281.559 67.8082C279.731 71.5656 277.751 75.2524 275.815 79.1263C275.397 80.2924 274.898 81.2576 274.399 82.2259C257.61 114.821 240.814 147.412 224.034 180.011C222.504 182.983 222.505 182.997 225.813 183.023C226.65 183.03 227.477 183.206 228.492 183.104C237.949 182.853 247.231 183.008 256.512 182.996C257.37 182.995 258.129 183.328 259.108 183.636Z"
          fill="#faf7f2"
          fillRule="nonzero"
          opacity="1"
          stroke="none"
        />
        <path
          d="M271.717 206.916C282.416 207.024 292.983 207.024 303.922 207.024C302.714 208.766 301.414 209.854 300.107 210.909C299.41 211.471 298.727 212.041 298.069 212.644C292.959 217.33 287.895 222.064 282.713 226.673C278.968 230.004 275.227 233.337 271.545 236.733C267.51 240.454 263.469 244.173 259.319 247.771C255.894 250.741 252.567 253.81 249.188 256.826C244.171 261.306 239.199 265.836 234.083 270.208C230.896 272.932 227.966 275.921 224.711 278.568C220.872 281.69 217.382 285.188 213.523 288.292C211.651 289.797 210.003 291.55 208.154 293.1C205.261 295.527 202.634 298.252 199.765 300.709C195.33 304.506 191.219 308.643 186.671 312.321C184.589 314.005 182.584 315.798 180.701 317.689C177.646 320.754 174.2 323.407 171.146 326.471C170.092 327.529 168.652 328.186 167.709 329.546C167.49 329.688 167.301 329.697 166.97 329.716C165.379 330.565 163.934 329.894 162.587 329.545C156.278 327.91 150.184 325.649 144.125 323.305C143.295 322.984 142.434 322.648 141.885 321.68C141.547 320.184 142.5 319.401 143.336 318.608C147.469 314.689 151.881 311.069 156.227 307.381C161.36 303.024 166.289 298.45 171.441 294.112C177.693 288.847 183.466 283.074 189.645 277.73C197.435 270.994 205.148 264.174 212.918 257.415C218.148 252.866 223.34 248.269 228.529 243.673C238.6 234.753 248.458 225.61 258.582 216.742C262.334 213.455 266.063 210.122 269.835 206.621C270.56 206.368 271.101 206.42 271.717 206.916Z"
          fill="#b63131"
          fillRule="nonzero"
          opacity="1"
          stroke="none"
        />
        <path
          d="M259.245 183.608C258.535 183.755 257.775 183.832 257.015 183.833C247.442 183.841 237.869 183.838 228.102 183.802C226.905 182.83 227.455 181.878 227.951 180.996C231.816 174.119 235.07 166.949 238.706 159.962C242.846 152.006 246.962 144.038 251.111 136.086C259.06 120.85 266.676 105.451 274.926 90.3617C275.999 88.3982 276.926 86.3485 277.948 84.352C278.381 83.5063 278.791 82.6353 279.792 82.0196C281.062 81.6237 281.98 82.0971 282.803 82.7449C288.768 87.4395 294.867 91.9845 300.153 97.4367C300.875 98.1813 301.568 98.908 301.882 100.059C301.994 100.238 302.009 100.305 302.038 100.472C299.32 104.98 297.133 109.662 294.747 114.243C290.722 121.972 286.765 129.735 282.774 137.481C277.166 148.364 271.617 159.276 265.908 170.108C264.166 173.413 262.531 176.775 260.657 180.016C260.215 180.78 259.904 181.626 259.113 182.148C258.36 182.646 258.959 183.064 259.245 183.608Z"
          fill="#b43130"
          fillRule="nonzero"
          opacity="1"
          stroke="none"
        />
        <path
          d="M141.987 321.213C142.68 321.866 143.497 322.072 144.265 322.373C151.537 325.222 158.903 327.8 166.683 329.66C166.694 330.503 166.216 331.105 165.645 331.592C162.919 333.915 160.494 336.533 157.89 338.974C157.14 339.677 156.459 340.457 155.484 340.896C155.298 340.98 155.1 341.094 154.977 341.247C152.142 344.783 148.427 347.426 145.083 350.446C143.509 351.869 141.91 353.269 140.4 354.754C138.878 356.252 137.263 357.622 135.455 358.782C134.874 359.155 134.312 359.557 133.927 360.143C132.817 361.831 131.219 362.952 129.518 364.053C127.394 365.426 125.263 366.831 123.595 368.796C122.791 369.743 121.434 369.916 120.249 370.232C119.741 370.367 119.339 370.029 119.118 369.533C118.685 368.561 118.648 367.592 118.954 366.568C120.178 362.466 121.859 358.517 123.751 354.694C124.569 353.04 125.33 351.442 125.747 349.666C126.121 348.072 126.955 346.646 127.585 345.146C129.365 340.912 131.17 336.689 132.97 332.464C133.166 332.005 133.342 331.534 132.84 331.185C132.279 330.795 131.745 331.039 131.353 331.465C129.625 333.346 127.455 334.717 125.484 336.316C123.886 337.613 122.304 338.928 120.684 340.197C118.357 342.019 116.115 343.93 113.923 345.902C111.776 347.832 109.328 349.393 106.977 351.071C106.696 351.271 106.364 351.493 106.035 351.253C105.737 351.034 105.722 350.643 105.806 350.315C105.923 349.86 106.075 349.406 106.279 348.982C107.613 346.205 108.41 343.269 108.976 340.273C109.244 338.854 108.568 337.486 108.565 336.065C108.564 335.597 108.1 335.42 107.628 335.588C107.111 335.773 106.677 336.166 105.931 336.176C105.716 336.113 105.657 336.038 105.721 335.886C108.467 333.621 111.113 331.457 113.71 329.238C119.066 324.662 124.396 320.057 129.87 315.408C130.63 315.234 131.246 315.263 131.799 315.592C134.619 317.266 137.649 318.527 140.64 319.865C141.219 320.123 141.697 320.482 141.987 321.213Z"
          fill="#263851"
          fillRule="nonzero"
          opacity="1"
          stroke="none"
        />
        <path
          d="M302.006 100.026C301.068 99.6547 300.393 98.8729 299.677 98.1535C294.705 93.1626 289.223 88.7398 283.593 84.4806C282.615 83.7404 281.791 82.794 280.46 82.2978C278.13 82.0376 276.383 81.0531 275.075 79.2148C275.854 76.6701 277.223 74.5473 278.294 72.2954C280.033 68.6372 281.934 65.052 283.873 61.3405C284.112 61.5507 284.338 61.8496 284.362 62.1631C284.447 63.2739 285.095 63.6024 286.155 63.6974C288 63.8626 288.081 64.0221 288.154 65.8066C288.238 67.8514 287.996 69.8198 287.19 71.7511C286.438 73.5509 286.443 75.5979 285.365 77.3149C285.006 77.8873 284.725 78.5066 284.413 79.1068C284.128 79.6555 283.809 80.235 284.225 80.8204C284.666 81.4398 285.35 81.5689 286.085 81.4398C287.383 81.2121 288.694 81.0352 289.972 80.7309C292.405 80.152 294.93 80.328 297.378 79.672C299.641 79.0655 301.976 78.6656 304.189 77.8893C305.897 77.2901 307.618 77.7003 309.324 77.6125C310.484 77.5528 311.006 78.5067 310.631 79.8501C310.178 81.4698 309.843 83.1384 308.957 84.627C307.775 86.6142 306.834 88.6778 306.273 90.945C305.789 92.9013 304.597 94.6331 303.573 96.3787C302.911 97.5065 302.312 98.6146 302.006 100.026Z"
          fill="#263851"
          fillRule="nonzero"
          opacity="1"
          stroke="none"
        />
        <path
          d="M287.494 53.9559C287.24 53.3923 286.944 52.8741 286.062 52.6701C287.031 51.3964 288.241 50.2596 289.89 49.5037C289.13 50.9594 288.369 52.4152 287.494 53.9559Z"
          fill="#f3d9d7"
          fillRule="nonzero"
          opacity="1"
          stroke="none"
        />
        <path
          d="M105.708 335.776C105.844 335.81 105.815 336 105.795 336.094C105.775 336.188 105.753 336.182 105.755 336.193C105.241 336.689 105.36 337.727 104.18 337.743C103.585 337.604 103.608 337.314 103.782 336.993C104.061 336.48 104.356 335.975 104.762 335.389C105.11 335.456 105.342 335.599 105.708 335.776Z"
          fill="#f3d9d7"
          fillRule="nonzero"
          opacity="1"
          stroke="none"
        />
        <path
          d="M104.137 337.82C104.528 337.25 105.019 336.771 105.634 336.248C105.535 337.012 105.815 338.241 104.137 337.82Z"
          fill="#263851"
          fillRule="nonzero"
          opacity="1"
          stroke="none"
        />
        <path
          d="M284.499 60.4074C284.46 60.207 284.527 59.9821 284.692 59.6846C285.102 59.953 285.055 60.2132 284.499 60.4074Z"
          fill="#263851"
          fillRule="nonzero"
          opacity="1"
          stroke="none"
        />
        <path
          d="M163.059 192.678C167.541 192.491 172.014 192.444 176.681 192.435C176.929 192.544 176.985 192.616 177.002 192.817C176.213 195.426 174.805 197.619 173.652 199.916C169.634 207.923 165.523 215.886 161.358 223.985C159.347 223.54 157.423 224.063 155.498 224.071C147.359 224.102 139.22 224.087 131.081 224.069C130.419 224.068 129.495 224.384 129.163 223.717C128.799 222.987 129.704 222.568 130.178 222.154C133.429 219.317 136.718 216.522 139.991 213.71C141.967 212.012 143.834 210.202 145.801 208.491C150.197 204.668 154.648 200.899 158.796 196.812C159.814 195.809 161.002 194.964 162.151 194.097C162.613 193.748 163.008 193.416 163.059 192.678Z"
          fill="#b73231"
          fillRule="nonzero"
          opacity="1"
          stroke="none"
        />
        <path
          d="M135.593 192.541C136.723 192.433 137.993 192.411 139.45 192.426C138.359 193.049 137.048 192.875 135.593 192.541Z"
          fill="#d04d49"
          fillRule="nonzero"
          opacity="1"
          stroke="none"
        />
        <path
          d="M124.875 191.288C125.009 191.512 125.012 191.784 125.014 192.193C124.759 192.406 124.422 192.502 124.291 192.261C124.054 191.825 124.49 191.601 124.875 191.288Z"
          fill="#f3d9d7"
          fillRule="nonzero"
          opacity="1"
          stroke="none"
        />
        <path
          d="M146.018 192.55C146.36 192.45 146.808 192.426 147.421 192.44C147.131 192.835 146.643 192.88 146.018 192.55Z"
          fill="#d04d49"
          fillRule="nonzero"
          opacity="1"
          stroke="none"
        />
        <path
          d="M271.854 206.877C271.263 207.03 270.677 207.035 269.914 207.043C269.058 207.898 268.078 207.885 267.104 207.932C263.71 208.094 260.36 207.398 256.971 207.461C256.245 207.474 255.618 207.207 255.158 206.378C258.643 202.991 262.188 199.795 265.864 196.551C266.015 198.883 266.394 199.336 268.755 199.665C269.655 199.791 270.554 199.741 271.45 199.525C272.89 199.176 274.367 199.228 275.811 199.411C277.269 199.596 277.527 200.416 276.498 201.47C275.357 202.64 274.042 203.637 272.918 204.836C272.381 205.409 271.9 205.931 271.854 206.877Z"
          fill="#cb3533"
          fillRule="nonzero"
          opacity="1"
          stroke="none"
        />
        <path
          d="M254.963 206.234C255.657 206.486 256.256 206.648 256.893 206.625C261.056 206.477 265.184 207.274 269.544 207.044C269.736 207.603 269.629 208.1 269.15 208.495C264.162 212.602 259.569 217.126 254.72 221.379C250.798 224.82 246.934 228.315 243.098 231.846C238.864 235.745 234.429 239.437 230.152 243.294C228.216 245.039 226.262 246.767 224.337 248.522C220.383 252.125 216.249 255.529 212.237 259.067C210.334 260.745 208.32 262.301 206.527 264.109C203.294 267.371 199.552 270.091 196.093 273.115C194.233 274.741 192.468 276.462 190.592 278.078C187.839 280.45 184.999 282.756 182.434 285.308C180.441 287.29 178.242 289.041 176.262 291.032C173.221 294.091 169.722 296.675 166.437 299.481C164.505 301.131 162.705 302.914 160.772 304.571C156.033 308.632 151.322 312.725 146.546 316.748C144.974 318.072 143.469 319.494 142.088 321.231C137.957 319.655 133.846 318.065 130.118 315.44C138.074 308.3 146.144 301.248 154.214 294.196C165.806 284.064 177.398 273.932 188.988 263.798C209.27 246.063 229.55 228.326 249.834 210.592C251.489 209.145 253.163 207.718 254.963 206.234Z"
          fill="#a42d2e"
          fillRule="nonzero"
          opacity="1"
          stroke="none"
        />
        <path
          d="M274.999 79.1555C276.939 79.8127 278.562 80.8919 280.225 82.1609C278.607 84.4266 277.688 87.007 276.395 89.3915C274.389 93.0911 272.453 96.8264 270.495 100.55C269.072 103.256 267.654 105.965 266.249 108.679C264.19 112.656 262.135 116.635 260.093 120.621C255.35 129.875 250.61 139.131 245.885 148.393C245.145 149.844 244.304 151.245 243.505 152.658C241.297 156.564 239.634 160.731 237.3 164.575C236.457 165.964 235.867 167.5 235.176 168.975C233.078 173.455 230.785 177.839 228.286 182.121C228.035 182.551 227.915 182.988 227.91 183.618C225.762 183.956 223.615 183.892 221.219 183.872C222.031 182.19 222.727 180.666 223.492 179.175C228.798 168.832 234.107 158.491 239.437 148.159C249.473 128.704 259.529 109.259 269.565 89.8032C271.372 86.2997 273.117 82.7661 274.999 79.1555Z"
          fill="#9e2c2f"
          fillRule="nonzero"
          opacity="1"
          stroke="none"
        />
        <path
          d="M177.044 192.885C176.942 192.868 176.92 192.791 176.886 192.593C177.151 192.46 177.242 192.572 177.044 192.885Z"
          fill="#d04d49"
          fillRule="nonzero"
          opacity="1"
          stroke="none"
        />
        <g fill="#2a3d59" opacity="1" stroke="none">
          <path d="M559.693 210.477L516.372 210.477L516.372 289.218L475.366 289.218L475.366 88.4146L573.861 88.4146C587.938 88.6871 598.768 90.4127 606.352 93.5914C613.935 96.7701 620.361 101.447 625.629 107.623C629.988 112.709 633.439 118.34 635.982 124.516C638.525 130.691 639.797 137.73 639.797 145.631C639.797 155.168 637.39 164.545 632.576 173.763C627.763 182.981 619.816 189.498 608.736 193.312C618 197.036 624.561 202.326 628.421 209.183C632.281 216.04 634.211 226.507 634.211 240.584L634.211 254.071C634.211 263.244 634.574 269.465 635.301 272.734C636.391 277.911 638.934 281.726 642.93 284.178L642.93 289.218L596.748 289.218C595.476 284.768 594.568 281.181 594.023 278.456C592.933 272.825 592.343 267.058 592.252 261.155L591.98 242.491C591.798 229.686 589.459 221.148 584.964 216.88C580.468 212.611 572.045 210.477 559.693 210.477ZM585.168 173.967C593.524 170.153 597.701 162.615 597.701 151.353C597.701 139.183 593.66 131.009 585.577 126.832C581.036 124.47 574.224 123.29 565.142 123.29L516.372 123.29L516.372 177.237L563.916 177.237C573.361 177.237 580.445 176.147 585.168 173.967Z" />
          <path d="M678.35 156.802C688.612 143.724 706.232 137.185 731.207 137.185C747.464 137.185 761.904 140.409 774.528 146.857C787.153 153.306 793.465 165.476 793.465 183.367L793.465 251.482C793.465 256.205 793.555 261.927 793.737 268.648C794.009 273.733 794.781 277.185 796.053 279.001C797.324 280.817 799.232 282.316 801.775 283.497L801.775 289.218L759.543 289.218C758.362 286.221 757.545 283.406 757.091 280.772C756.637 278.138 756.274 275.141 756.001 271.781C750.643 277.593 744.467 282.543 737.474 286.63C729.118 291.443 719.673 293.85 709.138 293.85C695.696 293.85 684.594 290.013 675.83 282.339C667.065 274.664 662.683 263.789 662.683 249.711C662.683 231.457 669.722 218.242 683.799 210.068C691.519 205.618 702.871 202.44 717.857 200.532L731.071 198.898C738.246 197.989 743.377 196.854 746.465 195.492C752.005 193.13 754.775 189.452 754.775 184.457C754.775 178.372 752.664 174.172 748.44 171.856C744.217 169.54 738.019 168.382 729.845 168.382C720.672 168.382 714.178 170.652 710.364 175.193C707.639 178.554 705.823 183.095 704.915 188.816L667.451 188.816C668.269 175.829 671.902 165.158 678.35 156.802ZM707.231 261.155C710.863 264.152 715.314 265.65 720.581 265.65C728.937 265.65 736.634 263.198 743.672 258.294C750.711 253.39 754.366 244.444 754.639 231.457L754.639 217.016C752.187 218.56 749.712 219.809 747.214 220.763C744.717 221.716 741.288 222.602 736.929 223.419L728.21 225.054C720.036 226.507 714.178 228.278 710.636 230.367C704.642 233.909 701.645 239.403 701.645 246.851C701.645 253.481 703.507 258.249 707.231 261.155Z" />
          <path d="M952.309 156.666C964.298 169.472 970.292 188.272 970.292 213.065C970.292 239.222 964.411 259.157 952.65 272.871C940.889 286.585 925.744 293.441 907.217 293.441C895.41 293.441 885.602 290.49 877.791 284.586C873.523 281.317 869.345 276.549 865.258 270.282L865.258 347.661L826.841 347.661L826.841 140.727L864.032 140.727L864.032 162.66C868.21 156.212 872.66 151.126 877.382 147.402C886.01 140.773 896.273 137.458 908.171 137.458C925.517 137.458 940.23 143.86 952.309 156.666ZM930.24 214.973C930.24 203.529 927.629 193.403 922.407 184.593C917.184 175.784 908.716 171.379 897 171.379C882.923 171.379 873.25 178.054 867.983 191.405C865.258 198.489 863.896 207.48 863.896 218.378C863.896 235.634 868.482 247.759 877.655 254.752C883.104 258.839 889.552 260.882 897 260.882C907.807 260.882 916.049 256.705 921.726 248.349C927.402 239.994 930.24 228.868 930.24 214.973Z" />
          <path d="M1038.27 140.727L1038.27 289.218L998.9 289.218L998.9 140.727L1038.27 140.727ZM1038.27 87.1885L1038.27 123.017L998.9 123.017L998.9 87.1885L1038.27 87.1885Z" />
          <path d="M1211.01 88.6871L1211.01 289.218L1173.28 289.218L1173.28 268.648C1167.74 277.457 1161.42 283.86 1154.34 287.856C1147.26 291.852 1138.45 293.85 1127.91 293.85C1110.56 293.85 1095.96 286.834 1084.11 272.803C1072.26 258.771 1066.33 240.766 1066.33 218.787C1066.33 193.448 1072.17 173.513 1083.84 158.982C1095.51 144.451 1111.11 137.185 1130.63 137.185C1139.63 137.185 1147.62 139.16 1154.61 143.111C1161.6 147.062 1167.28 152.534 1171.64 159.527L1171.64 88.6871L1211.01 88.6871ZM1106.39 215.926C1106.39 229.64 1109.11 240.584 1114.56 248.758C1119.92 257.023 1128.09 261.155 1139.08 261.155C1150.07 261.155 1158.43 257.068 1164.15 248.894C1169.87 240.72 1172.73 230.14 1172.73 217.152C1172.73 198.988 1168.14 186.001 1158.97 178.19C1153.34 173.468 1146.8 171.107 1139.35 171.107C1128 171.107 1119.67 175.398 1114.36 183.98C1109.04 192.563 1106.39 203.211 1106.39 215.926Z" />
          <path d="M1370.67 156.666C1382.66 169.472 1388.66 188.272 1388.66 213.065C1388.66 239.222 1382.77 259.157 1371.01 272.871C1359.25 286.585 1344.11 293.441 1325.58 293.441C1313.77 293.441 1303.97 290.49 1296.15 284.586C1291.89 281.317 1287.71 276.549 1283.62 270.282L1283.62 347.661L1245.2 347.661L1245.2 140.727L1282.4 140.727L1282.4 162.66C1286.57 156.212 1291.02 151.126 1295.75 147.402C1304.37 140.773 1314.64 137.458 1326.53 137.458C1343.88 137.458 1358.59 143.86 1370.67 156.666ZM1348.6 214.973C1348.6 203.529 1345.99 193.403 1340.77 184.593C1335.55 175.784 1327.08 171.379 1315.36 171.379C1301.29 171.379 1291.61 178.054 1286.35 191.405C1283.62 198.489 1282.26 207.48 1282.26 218.378C1282.26 235.634 1286.85 247.759 1296.02 254.752C1301.47 258.839 1307.92 260.882 1315.36 260.882C1326.17 260.882 1334.41 256.705 1340.09 248.349C1345.77 239.994 1348.6 228.868 1348.6 214.973Z" />
          <path d="M1422.3 156.802C1432.57 143.724 1450.19 137.185 1475.16 137.185C1491.42 137.185 1505.86 140.409 1518.48 146.857C1531.11 153.306 1537.42 165.476 1537.42 183.367L1537.42 251.482C1537.42 256.205 1537.51 261.927 1537.69 268.648C1537.96 273.733 1538.74 277.185 1540.01 279.001C1541.28 280.817 1543.19 282.316 1545.73 283.497L1545.73 289.218L1503.5 289.218C1502.32 286.221 1501.5 283.406 1501.05 280.772C1500.59 278.138 1500.23 275.141 1499.96 271.781C1494.6 277.593 1488.42 282.543 1481.43 286.63C1473.07 291.443 1463.63 293.85 1453.09 293.85C1439.65 293.85 1428.55 290.013 1419.78 282.339C1411.02 274.664 1406.64 263.789 1406.64 249.711C1406.64 231.457 1413.68 218.242 1427.75 210.068C1435.47 205.618 1446.83 202.44 1461.81 200.532L1475.03 198.898C1482.2 197.989 1487.33 196.854 1490.42 195.492C1495.96 193.13 1498.73 189.452 1498.73 184.457C1498.73 178.372 1496.62 174.172 1492.39 171.856C1488.17 169.54 1481.97 168.382 1473.8 168.382C1464.63 168.382 1458.13 170.652 1454.32 175.193C1451.59 178.554 1449.78 183.095 1448.87 188.816L1411.41 188.816C1412.22 175.829 1415.86 165.158 1422.3 156.802ZM1451.19 261.155C1454.82 264.152 1459.27 265.65 1464.54 265.65C1472.89 265.65 1480.59 263.198 1487.63 258.294C1494.67 253.39 1498.32 244.444 1498.59 231.457L1498.59 217.016C1496.14 218.56 1493.67 219.809 1491.17 220.763C1488.67 221.716 1485.24 222.602 1480.88 223.419L1472.16 225.054C1463.99 226.507 1458.13 228.278 1454.59 230.367C1448.6 233.909 1445.6 239.403 1445.6 246.851C1445.6 253.481 1447.46 258.249 1451.19 261.155Z" />
          <path d="M1613.84 315.238C1618.02 318.78 1625.06 320.551 1634.96 320.551C1648.95 320.551 1658.3 315.874 1663.02 306.52C1666.11 300.525 1667.66 290.444 1667.66 276.276L1667.66 266.74C1663.93 273.098 1659.94 277.866 1655.67 281.044C1647.95 286.948 1637.91 289.899 1625.56 289.899C1606.49 289.899 1591.25 283.201 1579.85 269.805C1568.46 256.409 1562.76 238.268 1562.76 215.381C1562.76 193.312 1568.25 174.762 1579.24 159.731C1590.23 144.7 1605.81 137.185 1625.97 137.185C1633.42 137.185 1639.91 138.32 1645.45 140.591C1654.9 144.496 1662.52 151.671 1668.34 162.115L1668.34 140.727L1706.07 140.727L1706.07 281.589C1706.07 300.753 1702.85 315.193 1696.4 324.911C1685.32 341.622 1664.07 349.977 1632.64 349.977C1613.66 349.977 1598.18 346.253 1586.19 338.806C1574.2 331.359 1567.57 320.233 1566.3 305.43L1608.53 305.43C1609.62 309.971 1611.39 313.24 1613.84 315.238ZM1607.31 238.541C1612.57 251.074 1622.02 257.34 1635.64 257.34C1644.72 257.34 1652.4 253.912 1658.66 247.055C1664.93 240.198 1668.06 229.277 1668.06 214.292C1668.06 200.214 1665.09 189.498 1659.14 182.141C1653.19 174.785 1645.22 171.107 1635.23 171.107C1621.61 171.107 1612.21 177.509 1607.03 190.315C1604.31 197.127 1602.95 205.527 1602.95 215.518C1602.95 224.146 1604.4 231.82 1607.31 238.541Z" />
          <path d="M1869.41 245.625C1868.41 254.434 1863.83 263.38 1855.65 272.462C1842.94 286.902 1825.14 294.123 1802.25 294.123C1783.36 294.123 1766.69 288.038 1752.25 275.868C1737.81 263.698 1730.59 243.899 1730.59 216.471C1730.59 190.769 1737.11 171.061 1750.14 157.347C1763.18 143.633 1780.09 136.776 1800.89 136.776C1813.24 136.776 1824.37 139.092 1834.27 143.724C1844.16 148.356 1852.34 155.667 1858.79 165.657C1864.6 174.467 1868.37 184.684 1870.09 196.309C1871.09 203.121 1871.5 212.929 1871.32 225.735L1769.69 225.735C1770.24 240.629 1774.91 251.074 1783.72 257.068C1789.08 260.792 1795.53 262.653 1803.07 262.653C1811.06 262.653 1817.55 260.383 1822.55 255.842C1825.27 253.39 1827.68 249.984 1829.77 245.625L1869.41 245.625ZM1831 200.124C1830.36 189.861 1827.25 182.073 1821.66 176.76C1816.08 171.447 1809.15 168.791 1800.89 168.791C1791.9 168.791 1784.93 171.606 1779.98 177.237C1775.03 182.868 1771.92 190.497 1770.65 200.124L1831 200.124Z" />
          <path d="M1999.79 147.539C2011.41 154.986 2018.09 167.792 2019.81 185.956L1980.99 185.956C1980.44 180.961 1979.03 177.01 1976.76 174.104C1972.49 168.836 1965.23 166.202 1954.97 166.202C1946.52 166.202 1940.5 167.519 1936.91 170.153C1933.33 172.787 1931.53 175.875 1931.53 179.417C1931.53 183.867 1933.44 187.091 1937.26 189.089C1941.07 191.178 1954.56 194.765 1977.72 199.851C1993.16 203.484 2004.74 208.979 2012.45 216.335C2020.08 223.782 2023.9 233.091 2023.9 244.262C2023.9 258.975 2018.43 270.986 2007.48 280.295C1996.54 289.604 1979.62 294.259 1956.74 294.259C1933.4 294.259 1916.16 289.332 1905.04 279.478C1893.91 269.624 1888.35 257.068 1888.35 241.81L1927.72 241.81C1928.54 248.712 1930.31 253.617 1933.03 256.523C1937.85 261.7 1946.75 264.288 1959.73 264.288C1967.36 264.288 1973.42 263.153 1977.92 260.882C1982.42 258.612 1984.66 255.206 1984.66 250.665C1984.66 246.306 1982.85 242.991 1979.21 240.72C1975.58 238.45 1962.09 234.544 1938.75 229.004C1921.95 224.827 1910.1 219.605 1903.2 213.338C1896.3 207.162 1892.84 198.262 1892.84 186.637C1892.84 172.923 1898.23 161.139 1908.99 151.285C1919.75 141.431 1934.89 136.504 1954.42 136.504C1972.95 136.504 1988.07 140.182 1999.79 147.539Z" />
        </g>
      </g>
    </svg>
  );
};
