[![author](https://img.shields.io/badge/Author-Rafael_Marques-blue.svg)](https://www.linkedin.com/in/rafamarquesrmb/) [![github](https://img.shields.io/badge/Github-rafamarquesrmb-ligh.svg)](https://github.com/rafamarquesrmb/) 

# Data Driven REST API with ASP.NET Core & EF Core
:brazil: [**PT-BR**] :brazil:
Esse "Readme" está escrito em dois idiomas, Português do Brasil (PT-BR) e Inglês (EN).

:us: [**EN**] :us:
This "Readme" is written in two languages, Brazilian Portuguese (PT-BR) and English (EN). 

## Apresentação / Introduction
:brazil: [**PT-BR**] :brazil:

Este é um Projeto base do curso Criando APIs Data Driven com ASP.NET Core 3 e EF Core 3 (curso 7194) do [Balta.IO](https://balta.io/cursos/criando-apis-data-driven-com-aspnet-core-3-e-ef-core-3) , ministrado pelo instrutor [André Baltieri](https://balta.io/contribuidores/andre-baltieri) .


Neste curso o objetivo é criar um CRUD em formato de API de forma simples e rápida, seguindo a metodologia Data Driven Design.

  
O foco é cobrir o essencial para a construção de uma boa API de forma produtiva, aplicando boas práticas e organização no código, além de implementar o Entity Framework Core para integração com o banco de dados, e autenticação usando  JWT.

Durante o curso, e também após finaliza-lo, resolvi aprimorar um pouco as funcionalidades desta API, incluindo mais validações e concluindo os métodos referente a usuário.
Mas, se tiver interesse, você pode ver o repositório original contendo o que foi produzido no curso através do repositório do Professor André Baltieri [clicando aqui](https://github.com/balta-io/7194).

:us: [**EN**] :us:

This is a Base Project of the course "Criando APIs Data Driven com ASP.NET Core 3 e EF Core 3" (Creating Data Driven APIs with ASP.NET Core 3 and EF Core 3) from [Balta.IO](https://balta.io/cursos/criando-apis-data-driven-com-aspnet-core-3-e-ef-core-3), taught by the instructor [André Baltieri](https://balta.io/contribuidores/andre-baltieri) .


In this course, the objective is learn how to create a CRUD in API format in a simple and fast way, using the Data Driven Design methodology.

  
The focus is on covering the essentials of building a good API productively, applying best practices and organization in the code, as well as implementing the Entity Framework Core for database integration, and authentication using JWT.

During the course, and also after finishing it, I decided to improve the functionalities of this API. So, I added more validations and completing user-related methods. But, if you are interested, you can see the original repository containing what was produced in the course through Professor André Baltieri's repository [by clicking here](https://github.com/balta-io/7194).


 ## Objetivo / Main goal
:brazil: [**PT-BR**] :brazil:
Criar Uma API Data-Driven REST que contempla Usuários, produtos e categorias de produtos, utilizando .NET Core 3 e Entity Framework Core com SQL Server, além de utilizar recursos de autenticação e permissões de usuários conforme suas "Roles" e geração de Token JWT.

:us: [**EN**] :us:
Create a Data-Driven REST API that includes Users, products and product categories, using .NET Core 3 and Entity Framework Core with SQL Server, in addition to using user authentication and permissions resources according to their "Roles" and JWT Token generation.

###  Planejamento & Execução (metas) / Planning & Execution (goals)

   :brazil: :brazil: [**PT-BR**] :brazil: :brazil:

* Construção de uma API Data Driven

* Implementar um CRUD com agilidade (create, read, update e delete)

* Implementar as características dos verbos HTTP:  GET POST, PUT e DELETE

* Criar modelos de dados, validar modelos e definir relacionamento entre eles

* Utilizar Data Annotations

* Utilizar Injeção de Dependência

* Implementar conexão com banco de dados e manipulação de Data Context

* Implementar tratamento básico de erros

* Escrever Controllers aplicando boas práticas

* Utilizar o Entity Framework Core

* Conceitos de segurança em APIs web

* Implementar Autenticação e Autorização na API

* Gerar tokens JWT

* Criar endpoints públicos e restritos na API

* Realizar criação de rotas e organização de endpoints da API

* Configurar a conexão ao SQL Server (connection string)

* Melhorar a API com versionamento, cache e compressão de dados

---
   :us: :us: [**EN**] :us: :us:
* Building a Data Driven API

* Implement a CRUD quickly (create, read, update and delete)

* Implement the features of HTTP verbs: GET POST, PUT and DELETE

* Create data models, validate models and define relationships between them

* Use Data Annotations

* Use Dependency Injection

* Implement database connection and Data Context manipulation

* Implement basic error handling

* Write Controllers applying best practices

* Using the Entity Framework Core

* Security concepts in web APIs

* Implement Authentication and Authorization in API

* Generate JWT tokens

* Create public and restricted endpoints in API

* Perform route creation and organization of API endpoints

* Configure connection to SQL Server (connection string)

* Improve API with versioning, caching and data compression

## Tecnologias utilizadas / Technologies used

* [ASP.NET Core 3](https://dotnet.microsoft.com/download/dotnet/3.1)

* [Entity Framework Core](https://docs.microsoft.com/ef/)

* [Visual Studio Code](https://code.visualstudio.com/)

* [Azure Data Studio](https://docs.microsoft.com/sql/azure-data-studio/download-azure-data-studio?view=sql-server-ver15)

* [Docker](https://www.docker.com/)

* [SQL Server](https://www.microsoft.com/sql-server/sql-server-downloads)




 ## Encontre-me/Find me :globe_with_meridians: 🚩

:brazil: [**PT-BR**] :brazil:
Olá! Meu nome é Rafael Marques! Sou Brasileiro e Nordestino! Atuo como desenvolvedor Full Stack. Você pode conhecer mais sobre mim acessando os links nos botões abaixo!

:us: [**EN**] :us:
Hi!! My name is Rafael Marques, I'm a Brazilian Developer. You can find me on the links below:

  

[<img src="https://img.shields.io/badge/linkedin-%230077B5.svg?&style=for-the-badge&logo=linkedin&logoColor=white" />](https://www.linkedin.com/in/rafamarquesrmb/) [<img src = "https://img.shields.io/badge/instagram-%23E4405F.svg?&style=for-the-badge&logo=instagram&logoColor=white">](https://www.instagram.com/rafamarquesrmb/) [<img src="https://img.shields.io/badge/GitHub-100000?style=for-the-badge&logo=github&logoColor=white" />](https://github.com/rafamarquesrmb)
