# Clean Architecture Book - Notes

## Chapter 1 - What is Design and Architecture ?

- Intro
  - There is no difference between design and architecture
  - We see all the "low-level details and high-level decisions are part of the whole design of the house"
  - the low-level details and the high-level structure are part of the same whole
- The goal
  - "The goal of software aarchitecture is to minimize the human resources required to build and maintain the required system"
  - We can measure the design quality by measuring the effort to meet the needs of the customer. Or in other words, by how easy it's to change the software
- What went wrong?
  - Developers tend to think that mess code can be cleaned up later, that going to the market first is more important. But code never gets cleaned up, because one the code is in the market the pressure to keep it running and expand it to beat competition will win over that clean up.
  - "Developers are overconfident in their aability to remain productive"
  - Writing messy code makes developers go faster in the short term and just slows them down in the long term. That's lie. Messy code will kill productivity and the product.
  - "Making messes is always slower than staying clean, no matter which time scale you are using"
  - "The only way to go fast, is to go well"
  - "Their overconfidence will drive the redesign into the same mess as the original project"
- Conclusion
  - How do we solve this problem? The organization has to recognize its own overconfidence and take software architecture seriously. In order to do that, we need to know what is a good architecture. And to know that, we need to understand what are the attributes of a *good* architecture.